#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine v3dbc_tile (Istr,Iend,Jstr,Jend,grad)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine sets lateral boundary conditions for total 3D     !
!  V-velocity.                                                       !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "boundary.h"
# include "mask.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        Ce, Cx, cff, dVde, dVdt, dVdx, eps, tau
      REAL_TYPE
     &        grad(PRIVATE_2D_SCRATCH_ARRAY)
      parameter (eps=1.0_e8-20)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
      Ce=0.0_r8
      Cx=0.0_r8
      cff=0.0_r8
      dVdx=0.0_r8
      dVde=0.0_r8
      dVdt=0.0_r8
      tau=0.0_r8
!
# ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the western edge.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE) then
!
#  if defined WEST_M3RADIATION
!
!  Western edge, implicit upstream radiation condition.
!
        do k=1,N
          do j=JstrV-1,Jend
            grad(0,j)=(v(0,j+1,k,nstp)-v(0,j,k,nstp))
            grad(1,j)=(v(1,j+1,k,nstp)-v(1,j,k,nstp))
          enddo
          do j=JstrV,Jend
            dVdt=v(1,j,k,nstp)-v(1,j,k,nnew)
            dVdx=v(1,j,k,nstp)-v(2,j,k,nstp)
#   ifdef WEST_M3NUDGING
            tau=M3obc_out(iwest)
            if ((dVdt*dVdx).lt.0.0_r8) tau=M3obc_in(iwest)
            tau=tau*dt
#   endif
            if ((dVdt*dVdx).lt.0.0_r8) dVdt=0.0_r8
            if ((dVdt*(grad(1,j-1)+grad(1,j))).gt.0.0_r8) then
              dVde=grad(1,j-1)
            else
              dVde=grad(1,j  )
            endif
            cff=dVdt/MAX(dVdx*dVdx+dVde*dVde,eps)
            Cx=MIN(1.0_r8,cff*dVdx)
#   ifdef RADIATION_2D
            Ce=MIN(1.0_r8,MAX(cff*dVde,-1.0_r8))
#   else
            Ce=0.0_r8
#   endif
            v(0,j,k,nnew)=((1.0_r8-Cx)*v(0,j,k,nstp)+
     &                     Cx*v(1,j,k,nstp)-
     &                     MAX(Ce,0.0_r8)*grad(0,j-1)-
     &                     MIN(Ce,0.0_r8)*grad(0,j  ))
#   ifdef WEST_M3NUDGING
     &                   +tau*(v_west(j,k)-v(0,j,k,nstp))
#    endif
#   ifdef MASKING
            v(0,j,k,nnew)=v(0,j,k,nnew)*vmask(0,j)
#   endif
          enddo
        enddo
#  elif defined WEST_M3GRADIENT
!
!  Western edge, gradient boundary condition.
!
        do k=1,N
          do j=JstrV,Jend
            v(0,j,k,nnew)=v(1,j,k,nnew)
#   ifdef MASKING
     &                   *vmask(0,j)
#   endif
          enddo
        enddo
#  elif defined WEST_M3CLAMPED
!
!  Western edge, clamped boundary condition.
!
        do k=1,N
          do j=JstrV,Jend
            v(0,j,k,nnew)=v_west(j,k)
#   ifdef MASKING
     &                   *vmask(0,j)
#   endif
          enddo
        enddo
#  else
!
!  Western edge, closed boundary condition: free slip (gamma2=1)  or
!                                           no   slip (gamma2=-1).
!
#   ifdef NS_PERIODIC
#    define J_RANGE JstrV,Jend
#   else
#    define J_RANGE Jstr,JendR
#   endif
        do k=1,N
          do j=J_RANGE
            v(0,j,k,nnew)=gamma2*v(1,j,k,nnew)
#   ifdef MASKING
     &                   *vmask(0,j)
#   endif
          enddo
        enddo
#   undef J_RANGE
#  endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the eastern edge.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
!
#  if defined EAST_M3RADIATION
!
!  Eastern edge, implicit upstream radiation condition.
!
        do k=1,N
          do j=JstrV-1,Jend
            grad(Lm,j)=(v(Lm,j+1,k,nstp)-v(Lm,j,k,nstp))
            grad(L ,j)=(v(L ,j+1,k,nstp)-v(L ,j,k,nstp))
          enddo
          do j=JstrV,Jend
            dVdt=v(Lm,j,k,nstp)-v(Lm,j,k,nnew)
            dVdx=v(Lm,j,k,nstp)-v(Lm-1,j,k,nstp)
#   ifdef EAST_M3NUDGING
            tau=M3obc_out(ieast)
            if ((dVdt*dVdx).lt.0.0_r8) tau=M3obc_in(ieast)
            tau=tau*dt
#   endif
            if ((dVdt*dVdx).lt.0.0_r8) dVdt=0.0_r8
            if ((dVdt*(grad(Lm,j-1)+grad(Lm,j))).gt.0.0_r8) then
              dVde=grad(Lm,j-1)
            else
              dVde=grad(Lm,j  )
            endif
            cff=dVdt/MAX(dVdx*dVdx+dVde*dVde,eps)
            Cx=MIN(1.0_r8,cff*dVdx)
#   ifdef RADIATION_2D
            Ce=MIN(1.0_r8,MAX(cff*dVde,-1.0_r8))
#   else
            Ce=0.0_r8
#   endif
            v(L,j,k,nnew)=((1.0_r8-Cx)*v(Lm+1,j,k,nstp)+
     &                     Cx*v(Lm,j,k,nstp)-
     &                     MAX(Ce,0.0_r8)*grad(L,j-1)-
     &                     MIN(Ce,0.0_r8)*grad(L,j  ))
#   ifdef EAST_M3NUDGING
     &                   +tau*(v_east(j,k)-v(L,j,k,nstp))
#   endif
#   ifdef MASKING
            v(L,j,k,nnew)=v(L,j,k,nnew)*vmask(L,j)
#   endif
          enddo
        enddo
#  elif defined EAST_M3CLAMPED
!
!  Eastern edge, clamped boundary condition.
!
        do k=1,N
          do j=JstrV,Jend
            v(L,j,k,nnew)=v_east(j,k)
#   ifdef MASKING
     &                   *vmask(L,j)
#   endif
          enddo
        enddo
#  elif defined EAST_M3GRADIENT
!
!  Eastern edge, gradient boundary condition.
!
        do k=1,N
          do j=JstrV,Jend
            v(L,j,k,nnew)=v(Lm,j,k,nnew)
#   ifdef MASKING
     &                   *vmask(L,j)
#   endif
          enddo
        enddo
#  else
!
!  Eastern edge, closed boundary condition: free slip (gamma2=1)  or
!                                           no   slip (gamma2=-1).
!
#   ifdef NS_PERIODIC
#    define J_RANGE JstrV,Jend
#   else
#    define J_RANGE Jstr,JendR
#   endif
        do k=1,N
          do j=J_RANGE
            v(L,j,k,nnew)=gamma2*v(Lm,j,k,nnew)
#   ifdef MASKING
     &                   *vmask(L,j)
#   endif
          enddo
        enddo
#   undef J_RANGE
#  endif
      endif
# endif	/* !EW_PERIODIC */
# ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the southern edge.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE) then
!
#  if defined SOUTH_M3RADIATION
!
!  Southern edge, implicit upstream radiation condition.
!
        do k=1,N
          do i=Istr,Iend+1
            grad(i,1)=(v(i,1,k,nstp)-v(i-1,1,k,nstp))
            grad(i,2)=(v(i,2,k,nstp)-v(i-1,2,k,nstp))
          enddo
          do i=Istr,Iend
            dVdt=v(i,2,k,nstp)-v(i,2,k,nnew)
            dVde=v(i,2,k,nstp)-v(i,3,k,nstp)
#   ifdef SOUTH_M3NUDGING
            tau=M3obc_out(isouth)
            if ((dVdt*dVde).lt.0.0_r8) tau=M3obc_in(isouth)
            tau=tau*dt
#   endif
            if ((dVdt*dVde).lt.0.0_r8) dVdt=0.0_r8
            if ((dVdt*(grad(i,2)+grad(i+1,2))).gt.0.0_r8) then
              dVdx=grad(i  ,2)
            else
              dVdx=grad(i+1,2)
            endif
            cff=dVdt/MAX(dVdx*dVdx+dVde*dVde,eps)
#   ifdef RADIATION_2D
            Cx=MIN(1.0_r8,MAX(cff*dVdx,-1.0_r8))
#   else
            Cx=0.0_r8
#   endif
            Ce=MIN(1.0_r8,cff*dVde)
            v(i,1,k,nnew)=((1.0_r8-Ce)*v(i,1,k,nstp)+
     &                     Ce*v(i,2,k,nstp)-
     &                     MAX(Cx,0.0_r8)*grad(i  ,1)-
     &                     MIN(Cx,0.0_r8)*grad(i+1,1))
#   ifdef SOUTH_M3NUDGING
     &                   +tau*(v_south(i,k)-v(i,1,k,nstp))
#   endif
#   ifdef MASKING
            v(i,1,k,nnew)=v(i,1,k,nnew)*vmask(i,1)
#   endif
          enddo
        enddo

#  elif defined SOUTH_M3CLAMPED
!
!  Southern edge, clamped boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            v(i,1,k,nnew)=v_south(i,k)
#   ifdef MASKING
     &                   *vmask(i,1)
#   endif
          enddo
        enddo
#  elif defined SOUTH_M3GRADIENT
!
!  Southern edge, gradient boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            v(i,1,k,nnew)=v(i,2,k,nnew)
#   ifdef MASKING
     &                   *vmask(i,1)
#   endif
          enddo
        enddo
#  else
!
!  Southern edge, closed boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            v(i,1,k,nnew)=0.0_r8
          enddo
        enddo
#  endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the northern edge.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
!
#  if defined NORTH_M3RADIATION
!
!  Northern edge, implicit upstream radiation condition.
!
        do k=1,N
          do i=Istr,Iend+1
            grad(i,Mm)=(v(i,Mm,k,nstp)-v(i-1,Mm,k,nstp))
            grad(i,M )=(v(i,M ,k,nstp)-v(i-1,M ,k,nstp))
          enddo
          do i=Istr,Iend
            dVdt=v(i,Mm,k,nstp)-v(i,Mm,k,nnew)
            dVde=v(i,Mm,k,nstp)-v(i,Mm-1,k,nstp)
#   ifdef NORTH_M3NUDGING
            tau=M3obc_out(inorth)
            if ((dVdt*dVde).lt.0.0_r8) tau=M3obc_in(inorth)
            tau=tau*dt
#   endif
            if ((dVdt*dVde).lt.0.0_r8) dVdt=0.0_r8
            if ((dVdt*(grad(i,Mm)+grad(i+1,Mm))).gt.0.0_r8) then
              dVdx=grad(i  ,Mm)
            else
              dVdx=grad(i+1,Mm)
            endif
            cff=dVdt/MAX(dVdx*dVdx+dVde*dVde,eps)
#   ifdef RADIATION_2D
            Cx=MIN(1.0_r8,MAX(cff*dVdx,-1.0_r8))
#   else
            Cx=0.0_r8
#   endif
            Ce=MIN(1.0_r8,cff*dVde)
            v(i,M,k,nnew)=((1.0_r8-Ce)*v(i,M,k,nstp)+
     &                     Ce*v(i,Mm,k,nstp)-
     &                     MAX(Cx,0.0_r8)*grad(i  ,M)-
     &                     MIN(Cx,0.0_r8)*grad(i+1,M))
#   ifdef NORTH_M3NUDGING
     &                   +tau*(v_north(i,k)-v(i,M,k,nstp))
#   endif
#   ifdef MASKING
            v(i,M,k,nnew)=v(i,M,k,nnew)*vmask(i,M)
#   endif
          enddo
        enddo
#  elif defined NORTH_M3CLAMPED
!
!  Northern edge, clamped boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            v(i,M,k,nnew)=v_north(i,k)
#   ifdef MASKING
     &                   *vmask(i,M)
#   endif
          enddo
        enddo
#  elif defined NORTH_M3GRADIENT
!
!  Northern edge, gradient boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            v(i,M,k,nnew)=v(i,Mm,k,nnew)
#   ifdef MASKING
     &                   *vmask(i,M)
#   endif
          enddo
        enddo
#  else
!
!  Northern edge, closed boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            v(i,M,k,nnew)=0.0_r8
          enddo
        enddo
#  endif
      endif
# endif	/* !NS_PERIODIC */
# if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          v(0,1,k,nnew)=0.5_r8*(v(0,2,k,nnew)+v(1,1,k,nnew))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          v(L,1,k,nnew)=0.5_r8*(v(Lm,1,k,nnew)+v(L,2,k,nnew))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          v(0,M,k,nnew)=0.5_r8*(v(0,Mm,k,nnew)+v(1,M,k,nnew))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          v(L,M,k,nnew)=0.5_r8*(v(L,Mm,k,nnew)+v(Lm,M,k,nnew))
        enddo
      endif
# endif
#else
      subroutine v3dbc
#endif /* SOLVE3D */
      return
      end
