#include "cppdefs.h"
      subroutine v2dbc (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine sets lateral boundary conditions for vertically   !
!  integrated V-velocity.                                            !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
#include "param.h"
#include "scratch.h"
#include "tile.h"
!
      call v2dbc_tile (Istr,Iend,Jstr,Jend,
     &                 A2d(1,1))
      return
      end
!
!*********************************************************************
      subroutine v2dbc_tile (Istr,Iend,Jstr,Jend,grad)
!*********************************************************************
!
      implicit none
#include "param.h"
#include "boundary.h"
#include "grid.h"
#include "mask.h"
#include "ocean.h"
#include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, know
      REAL_TYPE
     &        Ce, Cx, cff, dt2d, dVde, dVdt, dVdx, eps, tau
      REAL_TYPE
     &        grad(PRIVATE_2D_SCRATCH_ARRAY)
      parameter (eps=1.0_e8-20)
!
#include "set_bounds.h"
!
      i=0
      j=0
      Ce=0.0_r8
      Cx=0.0_r8
      cff=0.0_r8
      dVdx=0.0_r8
      dVde=0.0_r8
      dVdt=0.0_r8
      tau=0.0_r8
!
!---------------------------------------------------------------------
!  Set time-indices
!---------------------------------------------------------------------
!
      if (FIRST_2D_STEP) then
        know=krhs
        dt2d=dtfast
      elseif (PREDICTOR_2D_STEP) then
        know=krhs
        dt2d=2.0_r8*dtfast
      else
        know=kstp
        dt2d=dtfast
      endif
!
#ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the western edge.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE) then
!
# if defined WEST_M2RADIATION
!
!  Western edge, implicit upstream radiation condition.
!
        do j=JstrV-1,Jend
          grad(0,j)=(vbar(0,j+1,know)-vbar(0,j,know))
          grad(1,j)=(vbar(1,j+1,know)-vbar(1,j,know))
        enddo
        do j=JstrV,Jend
          dVdt=vbar(1,j,know)-vbar(1,j,knew)
          dVdx=vbar(1,j,knew)-vbar(2,j,knew)
#  ifdef WEST_M2NUDGING
          tau=M2obc_out(iwest)
          if ((dVdt*dVdx).lt.0.0_r8) tau=M2obc_in(iwest)
          tau=tau*dt2d
#  endif
          if ((dVdt*dVdx).lt.0.0_r8) dVdt=0.0_r8
          if ((dVdt*(grad(1,j-1)+grad(1,j))).gt.0.0_r8) then
            dVde=grad(1,j-1)
          else
            dVde=grad(1,j  )
          endif
          cff=MAX(dVdx*dVdx+dVde*dVde,eps)
          Cx=dVdt*dVdx
#  ifdef RADIATION_2D
          Ce=MIN(cff,MAX(dVdt*dVde,-cff))
#  else
          Ce=0.0_r8
#  endif
          vbar(0,j,knew)=(cff*vbar(0,j,know)+
     &                    Cx*vbar(1,j,knew)-
     &                    MAX(Ce,0.0_r8)*grad(0,j-1)-
     &                    MIN(Ce,0.0_r8)*grad(0,j  ))/(cff+Cx)
#  ifdef WEST_M2NUDGING
     &                  +tau*(vbar_west(j)-vbar(0,j,know))
#   endif
#  ifdef MASKING
          vbar(0,j,knew)=vbar(0,j,knew)*vmask(0,j)
#  endif
        enddo
# elif defined WEST_M2FLATHER
!
!  Western edge, Chapman boundary condition.
!
        do j=JstrV,Jend
          Cx=dt2d*0.5_r8*(pm(1,j-1)+pm(1,j))*
     &       SQRT(g*0.5_r8*(h(1,j-1)+h(1,j)))
          vbar(0,j,knew)=(vbar(0,j,know)+Cx*vbar(1,j,knew))/
     &                   (1.0_r8+Cx)
#  ifdef MASKING
     &                  *vmask(0,j)
#  endif
        enddo
# elif defined WEST_M2CLAMPED
!
!  Western edge, clamped boundary condition.
!
        do j=JstrV,Jend
          vbar(0,j,knew)=vbar_west(j)
#  ifdef MASKING
     &                  *vmask(0,j)
#  endif
        enddo
# elif defined WEST_M2GRADIENT
!
!  Western edge, gradient boundary condition.
!
        do j=JstrV,Jend
          vbar(0,j,knew)=vbar(1,j,knew)
#  ifdef MASKING
     &                  *vmask(0,j)
#  endif
        enddo
# else
!
!  Western edge, closed boundary condition: free slip (gamma2=1)  or
!                                           no   slip (gamma2=-1).
!
#  ifdef NS_PERIODIC
#   define J_RANGE JstrV,Jend
#  else
#   define J_RANGE Jstr,JendR
#  endif
        do j=J_RANGE
          vbar(0,j,knew)=gamma2*vbar(1,j,knew)
#  ifdef MASKING
     &                  *vmask(0,j)
#  endif
        enddo
#  undef J_RANGE
# endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the eastern edge.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
!
# if defined EAST_M2RADIATION
!
!  Eastern edge, implicit upstream radiation condition.
!
        do j=JstrV-1,Jend
          grad(Lm,j)=(vbar(Lm,j+1,know)-vbar(Lm,j,know))
          grad(L ,j)=(vbar(L ,j+1,know)-vbar(L ,j,know))
        enddo
        do j=JstrV,Jend
          dVdt=vbar(Lm,j,know)-vbar(Lm,j,knew)
          dVdx=vbar(Lm,j,knew)-vbar(Lm-1,j,knew)
#  ifdef EAST_M2NUDGING
          tau=M2obc_out(ieast)
          if ((dVdt*dVdx).lt.0.0_r8) tau=M2obc_in(ieast)
          tau=tau*dt2d
#  endif
          if ((dVdt*dVdx).lt.0.0_r8) dVdt=0.0_r8
          if ((dVdt*(grad(Lm,j-1)+grad(Lm,j))).gt.0.0_r8) then
            dVde=grad(Lm,j-1)
          else
            dVde=grad(Lm,j  )
          endif
          cff=MAX(dVdx*dVdx+dVde*dVde,eps)
          Cx=dVdt*dVdx
#  ifdef RADIATION_2D
          Ce=MIN(cff,MAX(dVdt*dVde,-cff))
#  else
          Ce=0.0_r8
#  endif
          vbar(L,j,knew)=(cff*vbar(L,j,know)+
     &                    Cx*vbar(Lm,j,knew)-
     &                    MAX(Ce,0.0_r8)*grad(L,j-1)-
     &                    MIN(Ce,0.0_r8)*grad(L,j  ))/(cff+Cx)
#  ifdef EAST_M2NUDGING
     &                  +tau*(vbar_east(j)-vbar(L,j,know))
#  endif
#  ifdef MASKING
          vbar(L,j,knew)=vbar(L,j,knew)*vmask(L,j)
#  endif
        enddo
# elif defined EAST_M2FLATHER
!
!  Eastern edge, Chapman boundary condition.
!
        do j=JstrV,Jend
          Cx=dt2d*0.5_r8*(pm(Lm,j-1)+pm(Lm,j))*
     &       SQRT(g*0.5_r8*(h(Lm,j-1)+h(Lm,j)))
          vbar(L,j,knew)=(vbar(L,j,know)+Cx*vbar(Lm,j,knew))/
     &                   (1.0_r8+Cx)
#  ifdef MASKING
     &                  *vmask(L,j)
#  endif
        enddo
# elif defined EAST_M2CLAMPED
!
!  Eastern edge, clamped boundary condition.
!
        do j=JstrV,Jend
          vbar(L,j,knew)=vbar_east(j)
#  ifdef MASKING
     &                  *vmask(L,j)
#  endif
        enddo
# elif defined EAST_M2GRADIENT
!
!  Eastern edge, gradient boundary condition.
!
        do j=JstrV,Jend
          vbar(L,j,knew)=vbar(Lm,j,knew)
#  ifdef MASKING
     &                  *vmask(L,j)
#  endif
        enddo
# else
!
!  Eastern edge, closed boundary condition: free slip (gamma2=1)  or
!                                           no   slip (gamma2=-1).
!
#  ifdef NS_PERIODIC
#   define J_RANGE JstrV,Jend
#  else
#   define J_RANGE Jstr,JendR
#  endif
        do j=J_RANGE
          vbar(L,j,knew)=gamma2*vbar(Lm,j,knew)
#  ifdef MASKING
     &                  *vmask(L,j)
#  endif
        enddo
#  undef J_RANGE
# endif
      endif
#endif /* !EW_PERIODIC */
#ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the southern edge.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE) then
!
# if defined SOUTH_M2RADIATION
!
!  Southern edge, implicit upstream radiation condition.
!
        do i=Istr,Iend+1
          grad(i,1)=(vbar(i,1,know)-vbar(i-1,1,know))
          grad(i,2)=(vbar(i,2,know)-vbar(i-1,2,know))
        enddo
        do i=Istr,Iend
          dVdt=vbar(i,2,know)-vbar(i,2,knew)
          dVde=vbar(i,2,knew)-vbar(i,3,knew)
#  ifdef SOUTH_M2NUDGING
          tau=M2obc_out(isouth)
          if ((dVdt*dVde).lt.0.0_r8) tau=M2obc_in(isouth)
          tau=tau*dt2d
#  endif
          if ((dVdt*dVde).lt.0.0_r8) dVdt=0.0_r8
          if ((dVdt*(grad(i,2)+grad(i+1,2))).gt.0.0_r8) then
            dVdx=grad(i  ,2)
          else
            dVdx=grad(i+1,2)
          endif
          cff=MAX(dVdx*dVdx+dVde*dVde,eps)
#  ifdef RADIATION_2D
          Cx=MIN(cff,MAX(dVdt*dVdx,-cff))
#  else
          Cx=0.0_r8
#  endif
          Ce=dVdt*dVde
          vbar(i,1,knew)=(cff*vbar(i,1,know)+
     &                    Ce*vbar(i,2,knew)-
     &                    MAX(Cx,0.0_r8)*grad(i  ,1)-
     &                    MIN(Cx,0.0_r8)*grad(i+1,1))/(cff+Ce)
#  ifdef SOUTH_M2NUDGING
     &                  +tau*(vbar_south(i)-vbar(i,1,know))
#  endif
#  ifdef MASKING
          vbar(i,1,knew)=vbar(i,1,knew)*vmask(i,1)
#  endif
        enddo
# elif defined SOUTH_M2FLATHER
!
!  Southern edge, Flather boundary condition.
!
        do i=Istr,Iend
          vbar(i,1,knew)=(vbar_south(i)-
     &                    SQRT(g/(0.5_r8*(h(i,0)+h(i,1))))*
     &                    (0.5_r8*(zeta(i,0,know)+zeta(i,1,know))-
     &                     zeta_south(i)))
#  ifdef MASKING
     &                  *vmask(i,1)
#  endif
        enddo
# elif defined SOUTH_M2CLAMPED
!
!  Southern edge, clamped boundary condition.
!
        do i=Istr,Iend
          vbar(i,1,knew)=vbar_south(i)
#  ifdef MASKING
     &                  *vmask(i,1)
#  endif
        enddo
# elif defined SOUTH_M2GRADIENT
!
!  Southern edge, gradient boundary condition.
!
        do i=Istr,Iend
          vbar(i,1,knew)=vbar(i,2,knew)
#  ifdef MASKING
     &                  *vmask(i,1)
#  endif
        enddo
# else
!
!  Southern edge, closed boundary condition.
!
        do i=Istr,Iend
          vbar(i,1,knew)=0.0_r8
        enddo
# endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the northern edge.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
!
# if defined NORTH_M2RADIATION
!
!  Northern edge, implicit upstream radiation condition.
!
        do i=Istr,Iend+1
          grad(i,Mm)=(vbar(i,Mm,know)-vbar(i-1,Mm,know))
          grad(i,M )=(vbar(i,M ,know)-vbar(i-1,M ,know))
        enddo
        do i=Istr,Iend
          dVdt=vbar(i,Mm,know)-vbar(i,Mm,knew)
          dVde=vbar(i,Mm,knew)-vbar(i,Mm-1,knew)
#  ifdef NORTH_M2NUDGING
          tau=M2obc_out(inorth)
          if ((dVdt*dVde).lt.0.0_r8) tau=M2obc_in(inorth)
          tau=tau*dt2d
#  endif
          if ((dVdt*dVde).lt.0.0_r8) dVdt=0.0_r8
          if ((dVdt*(grad(i,Mm)+grad(i,M))).gt.0.0_r8) then
            dVdx=grad(i  ,Mm)
          else
            dVdx=grad(i+1,Mm)
          endif
          cff=MAX(dVdx*dVdx+dVde*dVde,eps)
#  ifdef RADIATION_2D
          Cx=MIN(cff,MAX(dVdt*dVdx,-cff))
#  else
          Cx=0.0_r8
#  endif
          Ce=dVdt*dVde
          vbar(i,M,knew)=(cff*vbar(i,M,know)+
     &                    Ce*vbar(i,Mm,knew)-
     &                    MAX(Cx,0.0_r8)*grad(i  ,M)-
     &                    MIN(Cx,0.0_r8)*grad(i+1,M))/(cff+Ce)
#  ifdef NORTH_M2NUDGING
     &                  +tau*(vbar_north(i)-vbar(i,M,know))
#  endif
#  ifdef MASKING
          vbar(i,M,knew)=vbar(i,M,knew)*vmask(i,M)
#  endif
        enddo
# elif defined NORTH_M2FLATHER
!
!  Northern edge, Flather boundary condition.
!
        do i=Istr,Iend
          vbar(i,M,knew)=(vbar_north(i)+
     &                    SQRT(g/(0.5_r8*(h(i,Mm)+h(i,M))))*
     &                    (0.5_r8*(zeta(i,Mm,know)+zeta(i,M,know))-
     &                     zeta_north(i)))
#  ifdef MASKING
     &                  *vmask(i,M)
#  endif
        enddo
# elif defined NORTH_M2CLAMPED
!
!  Northern edge, clamped boundary condition.
!
        do i=Istr,Iend
          vbar(i,M,knew)=vbar_north(i)
#  ifdef MASKING
     &                  *vmask(i,M)
#  endif
        enddo
# elif defined NORTH_M2GRADIENT
!
!  Northern edge, gradient boundary condition.
!
        do i=Istr,Iend
          vbar(i,M,knew)=vbar(i,Mm,knew)
#  ifdef MASKING
     &                  *vmask(i,M)
#  endif
        enddo
# else
!
!  Northern edge, closed boundary condition.
!
        do i=Istr,Iend
          vbar(i,M,knew)=0.0_r8
        enddo
# endif
      endif
#endif /* !NS_PERIODIC */
#if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        vbar(0,1,knew)=0.5_r8*(vbar(0,2,knew)+vbar(1,1,knew))
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        vbar(L,1,knew)=0.5_r8*(vbar(Lm,1,knew)+vbar(L,2,knew))
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        vbar(0,M,knew)=0.5_r8*(vbar(0,Mm,knew)+vbar(1,M,knew))
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        vbar(L,M,knew)=0.5_r8*(vbar(L,Mm,knew)+vbar(Lm,M,knew))
      endif
#endif
      return
      end
