#include "cppdefs.h"
#if defined SOLVE3D && defined UV_VIS4 && defined MIX_S_UV
      subroutine uv3dmix4_s (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine computes biharmonic mixing of momentum, along     !
!  constant  S-surfaces, from the  horizontal divergence  of the     !
!  stress tensor. A transverse isotropy is assumed so the stress     !
!  tensor is splitted into vertical and horizontal subtensors.       !
!                                                                    !
!  Reference:                                                        !
!                                                                    !
!      Wajsowicz, R.C, 1993: A consistent formulation of the         !
!         anisotropic stress tensor for use in models of the         !
!         large-scale ocean circulation, JCP, 105, 333-338.          !
!                                                                    !
!      Sadourny, R. and K. Maynard, 1997: Formulations of            !
!         lateral diffusion in geophysical fluid dynamics            !
!         models, In "Numerical Methods of Atmospheric and           !
!         Oceanic Modelling". Lin, Laprise, and Ritchie,             !
!         Eds., NRC Research Press, 547-556.                         !
!                                                                    !
!      Griffies, S.M. and R.W. Hallberg, 2000: Biharmonic            !
!         friction with a Smagorinsky-like viscosity for             !
!         use in large-scale eddy-permitting ocean models,           !
!         Monthly Weather Rev., 128, 8, 2935-2946.                   !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (32)
# endif
      call uv3dmix4_s_tile (Istr,Iend,Jstr,Jend,
     &                      A2d(1, 1),A2d(1, 3),A2d(1, 5),A2d(1, 7),
     &                      A2d(1, 9),A2d(1,11))
# ifdef PROFILE
      call wclock_off (32)
# endif
      return
      end
!
!*********************************************************************
      subroutine uv3dmix4_s_tile (Istr,Iend,Jstr,Jend,UFx,UFe,LapU,
     &                            VFx,VFe,LapV)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mask.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        cff
      REAL_TYPE
     &         LapU(PRIVATE_2D_SCRATCH_ARRAY),
     &         LapV(PRIVATE_2D_SCRATCH_ARRAY),
     &          UFe(PRIVATE_2D_SCRATCH_ARRAY),
     &          UFx(PRIVATE_2D_SCRATCH_ARRAY),
     &          VFe(PRIVATE_2D_SCRATCH_ARRAY),
     &          VFx(PRIVATE_2D_SCRATCH_ARRAY)
!
# include "set_bounds.h"
# ifdef EW_PERIODIC
#  define IV_RANGE Istr-1,Iend+1
#  define IU_RANGE Istr-1,Iend+1
# else
#  define IV_RANGE MAX(1,Istr-1),MIN(Iend+1,Lm)
#  define IU_RANGE MAX(2,IstrU-1),MIN(Iend+1,Lm)
# endif
# ifdef NS_PERIODIC
#  define JU_RANGE Jstr-1,Jend+1
#  define JV_RANGE Jstr-1,Jend+1
# else
#  define JU_RANGE MAX(1,Jstr-1),MIN(Jend+1,Mm)
#  define JV_RANGE MAX(2,JstrV-1),MIN(Jend+1,Mm)
# endif
!
      do k=1,N
!
!---------------------------------------------------------------------
!  Compute horizontal biharmonic viscosity along constant S-surfaces.
!  The biharmonic operator is computed by applying the harmonic
!  operator twice.
!---------------------------------------------------------------------
!
!  Compute flux-components of the horizontal divergence of the stress
!  tensor (m4 s^-3/2) in XI- and ETA-directions.  It is assumed here
!  that "visc4_r" and "visc4_p" are the squared root of the biharmonic
!  viscosity coefficient.  For momentum balance purposes, the
!  thickness "Hz" appears only when computing the second harmonic
!  operator.
!
        do j=-1+JV_RANGE
          do i=-1+IU_RANGE
            cff=visc4_r(i,j)*0.5_r8*
     &          (pmon_r(i,j)*
     &           ((pn(i  ,j)+pn(i+1,j))*u(i+1,j,k,nrhs)-
     &            (pn(i-1,j)+pn(i  ,j))*u(i  ,j,k,nrhs))-
     &           pnom_r(i,j)*
     &           ((pm(i,j  )+pm(i,j+1))*v(i,j+1,k,nrhs)-
     &            (pm(i,j-1)+pm(i,j  ))*v(i,j  ,k,nrhs)))
            UFx(i,j)=on_r(i,j)*on_r(i,j)*cff
            VFe(i,j)=om_r(i,j)*om_r(i,j)*cff
          enddo
        enddo
        do j=JU_RANGE+1
          do i=IV_RANGE+1
            cff=visc4_p(i,j)*0.5_r8*
     &          (pmon_p(i,j)*
     &           ((pn(i  ,j-1)+pn(i  ,j))*v(i  ,j,k,nrhs)-
     &            (pn(i-1,j-1)+pn(i-1,j))*v(i-1,j,k,nrhs))+
     &           pnom_p(i,j)*
     &           ((pm(i-1,j  )+pm(i,j  ))*u(i,j  ,k,nrhs)-
     &            (pm(i-1,j-1)+pm(i,j-1))*u(i,j-1,k,nrhs)))
# ifdef MASKING
     &         *pmask(i,j)
# endif
            UFe(i,j)=om_p(i,j)*om_p(i,j)*cff
            VFx(i,j)=on_p(i,j)*on_p(i,j)*cff
          enddo
        enddo
!
!  Compute first harmonic operator (m s^-3/2).
!
        do j=JU_RANGE
          do i=IU_RANGE
            LapU(i,j)=0.125_r8*
     &                (pm(i-1,j)+pm(i,j))*(pn(i-1,j)+pn(i,j))*
     &                ((pn(i-1,j)+pn(i,j))*(UFx(i,j  )-UFx(i-1,j))+
     &                 (pm(i-1,j)+pm(i,j))*(UFe(i,j+1)-UFe(i  ,j)))
          enddo
        enddo
        do j=JV_RANGE
          do i=IV_RANGE
            LapV(i,j)=0.125_r8*
     &                (pm(i,j)+pm(i,j-1))*(pn(i,j)+pn(i,j-1))*
     &                ((pn(i,j-1)+pn(i,j))*(VFx(i+1,j)-VFx(i,j  ))-
     &                 (pm(i,j-1)+pm(i,j))*(VFe(i  ,j)-VFe(i,j-1)))
          enddo
        enddo
!
!  Apply boundary conditions (other than periodic) to the first
!  harmonic operator. These are gradient or closed (free slip or
!  no slip) boundary conditions.
!
# ifndef EW_PERIODIC
        if (WESTERN_EDGE) then
          do j=JU_RANGE
#  ifdef WESTERN_WALL
            LapU(IstrU-1,j)=0.0_r8
#  else
            LapU(IstrU-1,j)=LapU(IstrU,j)
#  endif
          enddo
          do j=JV_RANGE
#  ifdef WESTERN_WALL
            LapV(Istr-1,j)=gamma2*LapV(Istr,j)
#  else
            LapV(Istr-1,j)=0.0_r8
#  endif
          enddo
        endif
        if (EASTERN_EDGE) then
          do j=JU_RANGE
#  ifdef EASTERN_WALL
            LapU(Iend+1,j)=0.0_r8
#  else
            LapU(Iend+1,j)=LapU(Iend,j)
#  endif
          enddo
          do j=JV_RANGE
#  ifdef EASTERN_WALL
            LapV(Iend+1,j)=gamma2*LapV(Iend,j)
#  else
            LapV(Iend+1,j)=0.0_r8
#  endif
          enddo
        endif
# endif /* !EW_PERIODIC */
# ifndef NS_PERIODIC
        if (SOUTHERN_EDGE) then
          do i=IU_RANGE
#  ifdef SOUTHERN_WALL
            LapU(i,Jstr-1)=gamma2*LapU(i,Jstr)
#  else
            LapU(i,Jstr-1)=0.0_r8
#  endif
          enddo
          do i=IV_RANGE
#  ifdef SOUTHERN_WALL
            LapV(i,JstrV-1)=0.0_r8
#  else
            LapV(i,JstrV-1)=LapV(i,JstrV)
#  endif
          enddo
        endif
        if (NORTHERN_EDGE) then
          do i=IU_RANGE
#  ifdef NORTHERN_WALL
            LapU(i,Jend+1)=gamma2*LapU(i,Jend)
#  else
            LapU(i,Jend+1)=0.0_r8
#  endif
          enddo
          do i=IV_RANGE
#  ifdef NORTHERN_WALL
            LapV(i,Jend+1)=0.0_r8
#  else
            LapV(i,Jend+1)=LapV(i,Jend)
#  endif
          enddo
        endif
# endif /* !NS_PERIODIC */
# if !defined EW_PERIODIC && !defined NS_PERIODIC
        if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
          LapU(1,0)=0.5_r8*(LapU(2,0)+LapU(1,1))
          LapV(0,1)=0.5_r8*(LapV(0,2)+LapV(1,1))
        endif
        if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
          LapU(L,0)=0.5_r8*(LapU(Lm,0)+LapU(L,1))
          LapV(L,1)=0.5_r8*(LapV(Lm,1)+LapV(L,2))
        endif
        if (NORTHERN_EDGE .and. WESTERN_EDGE) then
          LapU(1,M)=0.5_r8*(LapU(2,M)+LapU(1,Mm))
          LapV(0,M)=0.5_r8*(LapV(1,M)+LapV(0,Mm))
        endif
        if (NORTHERN_EDGE .and. EASTERN_EDGE) then
          LapU(L,M)=0.5_r8*(LapU(Lm,M)+LapU(L,Mm))
          LapV(L,M)=0.5_r8*(LapV(Lm,M)+LapV(L,Mm))
        endif
# endif
!
!  Compute flux-components of the horizontal divergence of the
!  harmonic stress tensor (m4/s2) in XI- and ETA-directions.
!
        do j=JstrV-1,Jend
          do i=IstrU-1,Iend
            cff=visc4_r(i,j)*Hz(i,j,k)*0.5_r8*
     &          (pmon_r(i,j)*
     &           ((pn(i  ,j)+pn(i+1,j))*LapU(i+1,j)-
     &            (pn(i-1,j)+pn(i  ,j))*LapU(i  ,j))-
     &           pnom_r(i,j)*
     &           ((pm(i,j  )+pm(i,j+1))*LapV(i,j+1)-
     &            (pm(i,j-1)+pm(i,j  ))*LapV(i,j  )))
            UFx(i,j)=on_r(i,j)*on_r(i,j)*cff
            VFe(i,j)=om_r(i,j)*om_r(i,j)*cff
          enddo
        enddo
        do j=Jstr,Jend+1
          do i=Istr,Iend+1
            cff=visc4_p(i,j)*0.125_r8*(Hz(i-1,j  ,k)+Hz(i,j  ,k)+
     &                                 Hz(i-1,j-1,k)+Hz(i,j-1,k))*
     &          (pmon_p(i,j)*
     &           ((pn(i  ,j-1)+pn(i  ,j))*LapV(i  ,j)-
     &            (pn(i-1,j-1)+pn(i-1,j))*LapV(i-1,j))+
     &           pnom_p(i,j)*
     &           ((pm(i-1,j  )+pm(i,j  ))*LapU(i,j  )-
     &            (pm(i-1,j-1)+pm(i,j-1))*LapU(i,j-1)))
# ifdef MASKING
     &         *pmask(i,j)
# endif
            UFe(i,j)=om_p(i,j)*om_p(i,j)*cff
            VFx(i,j)=on_p(i,j)*on_p(i,j)*cff
          enddo
        enddo
!
! Time-step biharmonic, S-surfaces viscosity term.  Notice that
! momentum at this stage is HzU and HzV and has units m2/s.
!
        cff=dt*0.125_r8
        do j=Jstr,Jend
          do i=IstrU,Iend
            u(i,j,k,nnew)=u(i,j,k,nnew)-
     &                    cff*(pm(i-1,j)+pm(i,j))*(pn(i-1,j)+pn(i,j))*
     &                    ((pn(i-1,j)+pn(i,j))*(UFx(i,j  )-UFx(i-1,j))+
     &                     (pm(i-1,j)+pm(i,j))*(UFe(i,j+1)-UFe(i  ,j)))
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            v(i,j,k,nnew)=v(i,j,k,nnew)-
     &                    cff*(pm(i,j)+pm(i,j-1))*(pn(i,j)+pn(i,j-1))*
     &                    ((pn(i,j-1)+pn(i,j))*(VFx(i+1,j)-VFx(i,j  ))-
     &                     (pm(i,j-1)+pm(i,j))*(VFe(i  ,j)-VFe(i,j-1)))
          enddo
        enddo
      enddo
# undef IU_RANGE
# undef IV_RANGE
# undef JU_RANGE
# undef JV_RANGE
#else
      subroutine uv3dmix4_s
#endif
      return
      end
