#include "cppdefs.h"
#if defined SOLVE3D && defined UV_VIS2 && defined MIX_S_UV
      subroutine uv3dmix2_s (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine computes harmonic mixing of momentum, along constant !
!  S-surfaces,  from the horizontal divergence of the stress tensor. !
!  A transverse isotropy is assumed so the stress tensor is splitted !
!  into vertical and horizontal subtensors.                          !
!                                                                    !
!  Reference:                                                        !
!                                                                    !
!      Wajsowicz, R.C, 1993: A consistent formulation of the         !
!         anisotropic stress tensor for use in models of the         !
!         large-scale ocean circulation, JCP, 105, 333-338.          !
!                                                                    !
!      Sadourny, R. and K. Maynard, 1997: Formulations of            !
!         lateral diffusion in geophysical fluid dynamics            !
!         models, In "Numerical Methods of Atmospheric and           !
!         Oceanic Modelling". Lin, Laprise, and Ritchie,             !
!         Eds., NRC Research Press, 547-556.                         !
!                                                                    !
!      Griffies, S.M. and R.W. Hallberg, 2000: Biharmonic            !
!         friction with a Smagorinsky-like viscosity for             !
!         use in large-scale eddy-permitting ocean models,           !
!         Monthly Weather Rev., 128, 8, 2935-2946.                   !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (30)
# endif
      call uv3dmix2_s_tile (Istr,Iend,Jstr,Jend,
     &                      A2d(1,1),A2d(1,3),A2d(1,5),A2d(1,7))
# ifdef PROFILE
      call wclock_off (30)
# endif
      return
      end
!
!*********************************************************************
      subroutine uv3dmix2_s_tile (Istr,Iend,Jstr,Jend,UFx,UFe,VFx,VFe)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mask.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        cff
      REAL_TYPE
     &          UFe(PRIVATE_2D_SCRATCH_ARRAY),
     &          UFx(PRIVATE_2D_SCRATCH_ARRAY),
     &          VFe(PRIVATE_2D_SCRATCH_ARRAY),
     &          VFx(PRIVATE_2D_SCRATCH_ARRAY)
!
# include "set_bounds.h"
!
      do k=1,N
!
!---------------------------------------------------------------------
!  Compute horizontal harmonic viscosity along constant S-surfaces.
!---------------------------------------------------------------------
!
!  Compute flux-components of the horizontal divergence of the stress
!  tensor (m5/s2) in XI- and ETA-directions.
!
        do j=JstrV-1,Jend
          do i=IstrU-1,Iend
            cff=visc2_r(i,j)*Hz(i,j,k)*0.5_r8*
     &          (pmon_r(i,j)*
     &           ((pn(i  ,j)+pn(i+1,j))*u(i+1,j,k,nrhs)-
     &            (pn(i-1,j)+pn(i  ,j))*u(i  ,j,k,nrhs))-
     &           pnom_r(i,j)*
     &           ((pm(i,j  )+pm(i,j+1))*v(i,j+1,k,nrhs)-
     &            (pm(i,j-1)+pm(i,j  ))*v(i,j  ,k,nrhs)))
            UFx(i,j)=on_r(i,j)*on_r(i,j)*cff
            VFe(i,j)=om_r(i,j)*om_r(i,j)*cff
          enddo
        enddo
        do j=Jstr,Jend+1
          do i=Istr,Iend+1
            cff=visc2_p(i,j)*0.125_r8*(Hz(i-1,j  ,k)+Hz(i,j  ,k)+
     &                                 Hz(i-1,j-1,k)+Hz(i,j-1,k))*
     &          (pmon_p(i,j)*
     &           ((pn(i  ,j-1)+pn(i  ,j))*v(i  ,j,k,nrhs)-
     &            (pn(i-1,j-1)+pn(i-1,j))*v(i-1,j,k,nrhs))+
     &           pnom_p(i,j)*
     &           ((pm(i-1,j  )+pm(i,j  ))*u(i,j  ,k,nrhs)-
     &            (pm(i-1,j-1)+pm(i,j-1))*u(i,j-1,k,nrhs)))
# ifdef MASKING
     &         *pmask(i,j)
# endif
            UFe(i,j)=om_p(i,j)*om_p(i,j)*cff
            VFx(i,j)=on_p(i,j)*on_p(i,j)*cff
          enddo
        enddo
!
! Time-step harmonic, S-surfaces viscosity term.  Notice that momentum
! at this stage is HzU and HzV and has m2/s units.
!
        cff=dt*0.125_r8
        do j=Jstr,Jend
          do i=IstrU,Iend
            u(i,j,k,nnew)=u(i,j,k,nnew)+
     &                    cff*(pm(i-1,j)+pm(i,j))*(pn(i-1,j)+pn(i,j))*
     &                    ((pn(i-1,j)+pn(i,j))*(UFx(i,j  )-UFx(i-1,j))+
     &                     (pm(i-1,j)+pm(i,j))*(UFe(i,j+1)-UFe(i  ,j)))
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            v(i,j,k,nnew)=v(i,j,k,nnew)+
     &                    cff*(pm(i,j)+pm(i,j-1))*(pn(i,j)+pn(i,j-1))*
     &                    ((pn(i,j-1)+pn(i,j))*(VFx(i+1,j)-VFx(i,j  ))-
     &                     (pm(i,j-1)+pm(i,j))*(VFe(i  ,j)-VFe(i,j-1)))
          enddo
        enddo
      enddo
#else
      subroutine uv3dmix2_s
#endif
      return
      end
