#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine u3dbc_tile (Istr,Iend,Jstr,Jend,grad)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine sets lateral boundary conditions for total 3D     !
!  U-velocity.                                                       !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "boundary.h"
# include "mask.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        Ce, Cx, cff, dUde, dUdt, dUdx, eps, tau
      REAL_TYPE
     &        grad(PRIVATE_2D_SCRATCH_ARRAY)
      parameter (eps=1.0_e8-20)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
      Ce=0.0_r8
      Cx=0.0_r8
      cff=0.0_r8
      dUdx=0.0_r8
      dUde=0.0_r8
      dUdt=0.0_r8
      tau=0.0_r8
!
# ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the western edge.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE) then
!
#  if defined WEST_M3RADIATION
!
!  Western edge, implicit upstream radiation condition.
!
        do k=1,N
          do j=Jstr,Jend+1
            grad(1,j)=(u(1,j,k,nstp)-u(1,j-1,k,nstp))
            grad(2,j)=(u(2,j,k,nstp)-u(2,j-1,k,nstp))
          enddo
          do j=Jstr,Jend
            dUdt=u(2,j,k,nstp)-u(2,j,k,nnew)
            dUdx=u(2,j,k,nnew)-u(3,j,k,nnew)
#   ifdef WEST_M3NUDGING
            tau=M3obc_out(iwest)
            if ((dUdt*dUdx).lt.0.0_r8) tau=M3obc_in(iwest)
            tau=tau*dt
#   endif
            if ((dUdt*dUdx).lt.0.0_r8) dUdt=0.0_r8
            if ((dUdt*(grad(2,j)+grad(2,j+1))).gt.0.0_r8) then
              dUde=grad(2,j)
            else
              dUde=grad(2,j+1)
            endif
            cff=MAX(dUdx*dUdx+dUde*dUde,eps)
            Cx=dUdt*dUdx
#   ifdef RADIATION_2D
            Ce=MIN(cff,MAX(dUdt*dUde,-cff))
#   else
            Ce=0.0_r8
#   endif
            u(1,j,k,nnew)=(cff*u(1,j,k,nstp)+
     &                     Cx*u(2,j,k,nnew)-
     &                     MAX(Ce,0.0_r8)*grad(1,j  )-
     &                     MIN(Ce,0.0_r8)*grad(1,j+1))/(cff+Cx)
#   ifdef WEST_M3NUDGING
     &                   +tau*(u_west(j,k)-u(1,j,k,nstp))
#   endif
#   ifdef MASKING
            u(1,j,k,nnew)=u(1,j,k,nnew)*umask(1,j)
#   endif
          enddo
        enddo
#  elif defined WEST_M3CLAMPED
!
!  Western edge, clamped boundary condition.
!
        do k=1,N
          do j=Jstr,Jend
            u(1,j,k,nnew)=u_west(j,k)
#   ifdef MASKING
     &                   *umask(1,j)
#   endif
          enddo
        enddo
#  elif defined WEST_M3GRADIENT
!
!  Western edge, gradient boundary condition.
!
        do k=1,N
          do j=Jstr,Jend
            u(1,j,k,nnew)=u(2,j,k,nnew)
#   ifdef MASKING
     &                   *umask(1,j)
#   endif
          enddo
        enddo
#  else
!
!  Western edge, closed boundary condition.
!
        do k=1,N
          do j=Jstr,Jend
            u(1,j,k,nnew)=0.0_r8
          enddo
        enddo
#  endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the eastern edge.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
!
#  if defined EAST_M3RADIATION
!
!  Eastern edge, implicit upstream radiation condition.
!
        do k=1,N
          do j=Jstr,Jend+1
            grad(Lm,j)=(u(Lm,j,k,nstp)-u(Lm,j-1,k,nstp))
            grad(L ,j)=(u(L ,j,k,nstp)-u(L ,j-1,k,nstp))
          enddo
          do j=Jstr,Jend
            dUdt=u(Lm,j,k,nstp)-u(Lm,j,k,nnew)
            dUdx=u(Lm,j,k,nnew)-u(Lm-1,j,k,nnew)
#   ifdef EAST_M3NUDGING
            tau=M3obc_out(ieast)
            if ((dUdt*dUdx).lt.0.0_r8) tau=M3obc_in(ieast)
            tau=tau*dt
#   endif
            if ((dUdt*dUdx).lt.0.0_r8) dUdt=0.0_r8
            if ((dUdt*(grad(Lm,j)+grad(Lm,j+1))).gt.0.0_r8) then
              dUde=grad(Lm,j)
            else
              dUde=grad(Lm,j+1)
            endif
            cff=MAX(dUdx*dUdx+dUde*dUde,eps)
            Cx=dUdt*dUdx
#   ifdef RADIATION_2D
            Ce=MIN(cff,MAX(dUdt*dUde,-cff))
#   else
            Ce=0.0_r8
#   endif
            u(L,j,k,nnew)=(cff*u(L,j,k,nstp)+
     &                     Cx*u(Lm,j,k,nnew)-
     &                     MAX(Ce,0.0_r8)*grad(L,j  )-
     &                     MIN(Ce,0.0_r8)*grad(L,j+1))/(cff+Cx)
#   ifdef EAST_M3NUDGING
     &                   +tau*(u_east(j,k)-u(L,j,k,nstp))
#   endif
#   ifdef MASKING
            u(L,j,k,nnew)=u(L,j,k,nnew)*umask(L,j)
#   endif
          enddo
        enddo
#  elif defined EAST_M3CLAMPED
!
!  Eastern edge, clamped boundary condition.
!
      do k=1,N
        do j=Jstr,Jend
          u(L,j,k,nnew)=u_east(j,k)
#   ifdef MASKING
     &                 *umask(L,j)
#   endif
        enddo
      enddo
#  elif defined EAST_M3GRADIENT
!
!  Eastern edge, gradient boundary condition.
!
      do k=1,N
        do j=Jstr,Jend
          u(L,j,k,nnew)=u(Lm,j,k,nnew)
#   ifdef MASKING
     &                 *umask(L,j)
#   endif
        enddo
      enddo
#  else
!
!  Eastern edge, closed boundary condition.
!
        do k=1,N
          do j=Jstr,Jend
            u(L,j,k,nnew)=0.0_r8
          enddo
        enddo
#  endif
      endif
# endif /* !EW_PERIODIC */
# ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the southern edge.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE) then
!
#  if defined SOUTH_M3RADIATION
!
!  Southern edge, implicit upstream radiation condition.
!
        do k=1,N
          do i=IstrU-1,Iend
            grad(i,0)=(u(i+1,0,k,nstp)-u(i,0,k,nstp))
            grad(i,1)=(u(i+1,1,k,nstp)-u(i,1,k,nstp))
          enddo
          do i=IstrU,Iend
            dUdt=u(i,1,k,nstp)-u(i,1,k,nnew)
            dUde=u(i,1,k,nnew)-u(i,2,k,nnew)
#   ifdef SOUTH_M3NUDGING
            tau=M3obc_out(isouth)
            if ((dUdt*dUde).lt.0.0_r8) tau=M3obc_in(isouth)
            tau=tau*dt
#   endif
            if ((dUdt*dUde).lt.0.0_r8) dUdt=0.0_r8
            if ((dUdt*(grad(i-1,1)+grad(i,1))).gt.0.0_r8) then
              dUdx=grad(i-1,1)
            else
              dUdx=grad(i  ,1)
            endif
            cff=MAX(dUdx*dUdx+dUde*dUde,eps)
#   ifdef RADIATION_2D
            Cx=MIN(cff,MAX(dUdt*dUdx,-cff))
#   else
            Cx=0.0_r8
#   endif
            Ce=dUdt*dUde
            u(i,0,k,nnew)=(cff*u(i,0,k,nstp)+
     &                     Ce*u(i,1,k,nnew)-
     &                     MAX(Cx,0.0_r8)*grad(i-1,0)-
     &                     MIN(Cx,0.0_r8)*grad(i  ,0))/(cff+Ce)
#   ifdef SOUTH_M3NUDGING
     &                   +tau*(u_south(i,k)-u(i,0,k,nstp))
#   endif
#   ifdef MASKING
            u(i,0,k,nnew)=u(i,0,k,nnew)*umask(i,0)
#   endif
          enddo
        enddo
#  elif defined SOUTH_M3CLAMPED
!
!  Southern edge, clamped boundary condition.
!
        do k=1,N
          do i=IstrU,Iend
            u(i,0,k,nnew)=u_south(i,k)
#   ifdef MASKING
     &                   *umask(i,0)
#   endif
          enddo
        enddo
#  elif defined SOUTH_M3GRADIENT
!
!  Southern edge, gradient boundary condition.
!
        do k=1,N
          do i=IstrU,Iend
            u(i,0,k,nnew)=u(i,1,k,nnew)
#   ifdef MASKING
     &                   *umask(i,0)
#   endif
          enddo
        enddo
#  else
!
!  Southern edge, closed boundary condition: free slip (gamma2=1)  or
!                                            no   slip (gamma2=-1).
!
#   ifdef EW_PERIODIC
#    define I_RANGE IstrU,Iend
#   else
#    define I_RANGE Istr,IendR
#   endif
        do k=1,N
          do i=I_RANGE
            u(i,0,k,nnew)=gamma2*u(i,1,k,nnew)
#   ifdef MASKING
     &                   *umask(i,0)
#   endif
          enddo
        enddo
#   undef I_RANGE
#  endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the northern edge.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
!
#  if defined NORTH_M3RADIATION
!
!  Northern edge, implicit upstream radiation condition.
!
        do k=1,N
          do i=IstrU-1,Iend
            grad(i,Mm)=u(i+1,Mm,k,nstp)-u(i,Mm,k,nstp)
            grad(i,M )=u(i+1,M ,k,nstp)-u(i,M ,k,nstp)
          enddo
          do i=IstrU,Iend
            dUdt=u(i,Mm,k,nstp)-u(i,Mm,k,nnew)
            dUde=u(i,Mm,k,nnew)-u(i,Mm-1,k,nnew)
#   ifdef NORTH_M3NUDGING
            tau=M3obc_out(inorth)
            if ((dUdt*dUde).lt.0.0_r8) tau=M3obc_in(inorth)
            tau=tau*dt
#   endif
            if ((dUdt*dUde).lt.0.0_r8) dUdt=0.0_r8
            if ((dUdt*(grad(i-1,Mm)+grad(i,Mm))).gt.0.0_r8) then
              dUdx=grad(i-1,Mm)
            else
              dUdx=grad(i  ,Mm)
            endif
            cff=MAX(dUdx*dUdx+dUde*dUde,eps)
#   ifdef RADIATION_2D
            Cx=MIN(cff,MAX(dUdt*dUdx,-cff))
#   else
            Cx=0.0_r8
#   endif
            Ce=dUdt*dUde
            u(i,M,k,nnew)=(cff*u(i,M,k,nstp)+
     &                     Ce*u(i,Mm,k,nnew)-
     &                     MAX(Cx,0.0_r8)*grad(i-1,M)-
     &                     MIN(Cx,0.0_r8)*grad(i  ,M))/(cff+Ce)
#   ifdef NORTH_M3NUDGING
     &                   +tau*(u_north(i,k)-u(i,M,k,nstp))
#    endif
#   ifdef MASKING
            u(i,M,k,nnew)=u(i,M,k,nnew)*umask(i,M)
#   endif
          enddo
        enddo
#  elif defined NORTH_M3CLAMPED
!
!  Northern edge, clamped boundary condition.
!
        do k=1,N
          do i=IstrU,Iend
            u(i,M,k,nnew)=u_north(i,k)
#   ifdef MASKING
     &                   *umask(i,M)
#   endif
          enddo
        enddo
#  elif defined NORTH_M3GRADIENT
!
!  Northern edge, gradient boundary condition.
!
        do k=1,N
          do i=IstrU,Iend
            u(i,M,k,nnew)=u(i,Mm,k,nnew)
#   ifdef MASKING
     &                   *umask(i,M)
#   endif
          enddo
        enddo
#  else
!
!  Northern edge, closed boundary condition: free slip (gamma2=1)  or
!                                            no   slip (gamma2=-1).
!
#   ifdef EW_PERIODIC
#    define I_RANGE IstrU,Iend
#   else
#    define I_RANGE Istr,IendR
#   endif
        do k=1,N
          do i=I_RANGE
            u(i,M,k,nnew)=gamma2*u(i,Mm,k,nnew)
#   ifdef MASKING
     &                   *umask(i,M)
#   endif
          enddo
        enddo
#   undef I_RANGE
#  endif
      endif
# endif /* !NS_PERIODIC */
# if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          u(1,0,k,nnew)=0.5_r8*(u(2,0,k,nnew)+u(1,1,k,nnew))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          u(L,0,k,nnew)=0.5_r8*(u(Lm,0,k,nnew)+u(L,1,k,nnew))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          u(1,M,k,nnew)=0.5_r8*(u(2,M,k,nnew)+u(1,Mm,k,nnew))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          u(L,M,k,nnew)=0.5_r8*(u(Lm,M,k,nnew)+u(L,Mm,k,nnew))
        enddo
      endif
# endif
#else
      subroutine u3dbc
#endif /* SOLVE3D */
      return
      end
