#include "cppdefs.h"
      subroutine u2dbc (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine sets lateral boundary conditions for vertically   !
!  integrated U-velocity.                                            !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
#include "param.h"
#include "scratch.h"
#include "tile.h"
!
      call u2dbc_tile (Istr,Iend,Jstr,Jend,
     &                 A2d(1,1))
      return
      end
!
!*********************************************************************
      subroutine u2dbc_tile (Istr,Iend,Jstr,Jend,grad)
!*********************************************************************
!
      implicit none
#include "param.h"
#include "boundary.h"
#include "grid.h"
#include "mask.h"
#include "ocean.h"
#include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, know
      REAL_TYPE
     &        Ce, Cx, cff, dt2d, dUde, dUdt, dUdx, eps, tau
      REAL_TYPE
     &        grad(PRIVATE_2D_SCRATCH_ARRAY)
      parameter (eps=1.0_e8-20)
!
#include "set_bounds.h"
!
      i=0
      j=0
      Ce=0.0_r8
      Cx=0.0_r8
      cff=0.0_r8
      dUdx=0.0_r8
      dUde=0.0_r8
      dUdt=0.0_r8
      tau=0.0_r8
!
!---------------------------------------------------------------------
!  Set time-indices
!---------------------------------------------------------------------
!
      if (FIRST_2D_STEP) then
        know=krhs
        dt2d=dtfast
      elseif (PREDICTOR_2D_STEP) then
        know=krhs
        dt2d=2.0_r8*dtfast
      else
        know=kstp
        dt2d=dtfast
      endif
!
#ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the western edge.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE) then
!
# if defined WEST_M2RADIATION
!
!  Western edge, implicit upstream radiation condition.
!
        do j=Jstr,Jend+1
          grad(1,j)=(ubar(1,j,know)-ubar(1,j-1,know))
          grad(2,j)=(ubar(2,j,know)-ubar(2,j-1,know))
        enddo
        do j=Jstr,Jend
          dUdt=ubar(2,j,know)-ubar(2,j,knew)
          dUdx=ubar(2,j,knew)-ubar(3,j,knew)
#  ifdef WEST_M2NUDGING
          tau=M2obc_out(iwest)
          if ((dUdt*dUdx).lt.0.0_r8) tau=M2obc_in(iwest)
          tau=tau*dt2d
#  endif
          if ((dUdt*dUdx).lt.0.0_r8) dUdt=0.0_r8
          if ((dUdt*(grad(2,j)+grad(2,j+1))).gt.0.0_r8) then
            dUde=grad(2,j  )
          else
            dUde=grad(2,j+1)
          endif
          cff=MAX(dUdx*dUdx+dUde*dUde,eps)
          Cx=dUdt*dUdx
#  ifdef RADIATION_2D
          Ce=MIN(cff,MAX(dUdt*dUde,-cff))
#  else
          Ce=0.0_r8
#  endif
          ubar(1,j,knew)=(cff*ubar(1,j,know)+
     &                    Cx*ubar(2,j,knew)-
     &                    MAX(Ce,0.0_r8)*grad(1,j  )-
     &                    MIN(Ce,0.0_r8)*grad(1,j+1))/(cff+Cx)
#  ifdef WEST_M2NUDGING
     &                  +tau*(ubar_west(j)-ubar(1,j,know))
#  endif
#  ifdef MASKING
          ubar(1,j,knew)=ubar(1,j,knew)*umask(1,j)
#  endif
        enddo
# elif defined WEST_M2FLATHER
!
!  Western edge, Flather boundary condition.
!
        do j=Jstr,Jend
          ubar(1,j,knew)=(ubar_west(j)-
     &                    SQRT(g/(0.5_r8*(h(0,j)+h(1,j))))*
     &                    (0.5_r8*(zeta(0,j,know)+zeta(1,j,know))-
     &                     zeta_west(j)))
#  ifdef MASKING
     &                  *umask(1,j)
#  endif
        enddo
# elif defined WEST_M2CLAMPED
!
!  Western edge, clamped boundary condition.
!
        do j=Jstr,Jend
          ubar(1,j,knew)=ubar_west(j)
#  ifdef MASKING
     &                  *umask(1,j)
#  endif
        enddo
# elif defined WEST_M2GRADIENT
!
!  Western edge, gradient boundary condition.
!
        do j=Jstr,Jend
          ubar(1,j,knew)=ubar(2,j,knew)
#  ifdef MASKING
     &                  *umask(1,j)
#  endif
        enddo
# else
!
!  Western edge, closed boundary condition.
!
        do j=Jstr,Jend
          ubar(1,j,knew)=0.0_r8
#  ifdef NJ_BIGHT1
          if ((15.le.j).and.(j.le.28)) ubar(1,j,knew)=ubar(2,j,knew)
          if ((233.le.j).and.(j.le.239)) ubar(1,j,knew)=ubar(2,j,knew)
#  endif
        enddo
# endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the eastern edge.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
!
# if defined EAST_M2RADIATION
!
!  Eastern edge, implicit upstream radiation condition.
!
        do j=Jstr,Jend+1
          grad(Lm,j)=(ubar(Lm,j,know)-ubar(Lm,j-1,know))
          grad(L ,j)=(ubar(L ,j,know)-ubar(L ,j-1,know))
        enddo
        do j=Jstr,Jend
          dUdt=ubar(Lm,j,know)-ubar(Lm,j,knew)
          dUdx=ubar(Lm,j,knew)-ubar(Lm-1,j,knew)
#  ifdef EAST_M2NUDGING
          tau=M2obc_out(ieast)
          if ((dUdt*dUdx).lt.0.0_r8) tau=M2obc_in(ieast)
          tau=tau*dt2d
#  endif
          if ((dUdt*dUdx).lt.0.0_r8) dUdt=0.0_r8
          if ((dUdt*(grad(Lm,j)+grad(Lm,j+1))).gt.0.0_r8) then
            dUde=grad(Lm,j)
          else
            dUde=grad(Lm,j+1)
          endif
          cff=MAX(dUdx*dUdx+dUde*dUde,eps)
          Cx=dUdt*dUdx
#  ifdef RADIATION_2D
          Ce=MIN(cff,MAX(dUdt*dUde,-cff))
#  else
          Ce=0.0_r8
#  endif
          ubar(L,j,knew)=(cff*ubar(L,j,know)+
     &                    Cx*ubar(Lm,j,knew)-
     &                    MAX(Ce,0.0_r8)*grad(L,j  )-
     &                    MIN(Ce,0.0_r8)*grad(L,j+1))/(cff+Cx)
#  ifdef EAST_M2NUDGING
     &                  +tau*(ubar_east(j)-ubar(L,j,know))
#  endif
#  ifdef MASKING
          ubar(L,j,knew)=ubar(L,j,knew)*umask(L,j)
#  endif
        enddo
# elif defined EAST_M2FLATHER
!
!  Eastern edge, Flather boundary condition.
!
        do j=Jstr,Jend
          ubar(L,j,knew)=(ubar_east(j)+
     &                    SQRT(g/(0.5_r8*(h(Lm,j)+h(L,j))))*
     &                    (0.5_r8*(zeta(Lm,j,know)+zeta(L,j,know))-
     &                     zeta_east(j)))
#  ifdef MASKING
     &                  *umask(L,j)
#  endif
        enddo
# elif defined EAST_M2CLAMPED
!
!  Eastern edge, clamped boundary condition.
!
        do j=Jstr,Jend
          ubar(L,j,knew)=ubar_east(j)
#  ifdef MASKING
     &                  *umask(L,j)
#  endif
        enddo
# elif defined EAST_M2GRADIENT
!
!  Eastern edge, gradient boundary condition.
!
        do j=Jstr,Jend
          ubar(L,j,knew)=ubar(Lm,j,knew)
#  ifdef MASKING
     &                  *umask(L,j)
#  endif
        enddo
# else
!
!  Eastern edge, closed boundary condition.
!
        do j=Jstr,Jend
          ubar(L,j,knew)=0.0_r8
        enddo
# endif
      endif
#endif /* !EW_PERIODIC */
#ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the southern edge.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE) then
!
# if defined SOUTH_M2RADIATION
!
!  Southern edge, implicit upstream radiation condition.
!
        do i=IstrU-1,Iend
          grad(i,0)=(ubar(i+1,0,know)-ubar(i,0,know))
          grad(i,1)=(ubar(i+1,1,know)-ubar(i,1,know))
        enddo
        do i=IstrU,Iend
          dUdt=ubar(i,1,know)-ubar(i,1,knew)
          dUde=ubar(i,1,knew)-ubar(i,2,knew)
#  ifdef SOUTH_M2NUDGING
          tau=M2obc_out(isouth)
          if ((dUdt*dUde).lt.0.0_r8) tau=M2obc_in(isouth)
          tau=tau*dt2d
#  endif
          if ((dUdt*dUde).lt.0.0_r8) dUdt=0.0_r8
          if ((dUdt*(grad(i-1,1)+grad(i,1))).gt.0.0_r8) then
            dUdx=grad(i-1,1)
          else
            dUdx=grad(i  ,1)
          endif
          cff=MAX(dUdx*dUdx+dUde*dUde,eps)
#  ifdef RADIATION_2D
          Cx=MIN(cff,MAX(dUdt*dUdx,-cff))
#  else
          Cx=0.0_r8
#  endif
          Ce=dUdt*dUde
          ubar(i,0,knew)=(cff*ubar(i,0,know)+
     &                    Ce*ubar(i,1,knew)-
     &                    MAX(Cx,0.0_r8)*grad(i-1,0)-
     &                    MIN(Cx,0.0_r8)*grad(i  ,0))/(cff+Ce)
#  ifdef SOUTH_M2NUDGING
     &                  +tau*(ubar_south(i)-ubar(i,0,know))
#  endif
#  ifdef MASKING
          ubar(i,0,knew)=ubar(i,0,knew)*umask(i,0)
#  endif
        enddo
# elif defined SOUTH_M2FLATHER
!
!  Southern edge, Chapman boundary condition.
!
        do i=IstrU,Iend
          Ce=dt2d*0.5_r8*(pn(i-1,1)+pn(i,1))*
     &       SQRT(g*0.5_r8*(h(i-1,1)+h(i,1)))
          ubar(i,0,knew)=(ubar(i,0,know)+Ce*ubar(i,1,knew))/
     &                   (1.0_r8+Ce)
#  ifdef MASKING
     &                  *umask(i,0)
#  endif
        enddo
# elif defined SOUTH_M2CLAMPED
!
!  Southern edge, clamped boundary condition.
!
        do i=IstrU,Iend
          ubar(i,0,knew)=ubar_south(i)
#  ifdef MASKING
     &                  *umask(i,0)
#  endif
        enddo
# elif defined SOUTH_M2GRADIENT
!
!  Southern edge, gradient boundary condition.
!
        do i=IstrU,Iend
          ubar(i,0,knew)=ubar(i,1,knew)
#  ifdef MASKING
     &                  *umask(i,0)
#  endif
        enddo
# else
!
!  Southern edge, closed boundary condition: free slip (gamma2=1)  or
!                                            no   slip (gamma2=-1).
!
#  ifdef EW_PERIODIC
#   define I_RANGE IstrU,Iend
#  else
#   define I_RANGE Istr,IendR
#  endif
        do i=I_RANGE
          ubar(i,0,knew)=gamma2*ubar(i,1,knew)
#  ifdef MASKING
     &                  *umask(i,0)
#  endif
        enddo
#  undef I_RANGE
# endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the northern edge.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
!
# if defined NORTH_M2RADIATION
!
!  Northern edge, implicit upstream radiation condition.
!
        do i=IstrU-1,Iend
          grad(i,Mm)=(ubar(i+1,Mm,know)-ubar(i,Mm,know))
          grad(i,M )=(ubar(i+1,M ,know)-ubar(i,M ,know))
        enddo
        do i=IstrU,Iend
          dUdt=ubar(i,Mm,know)-ubar(i,Mm,knew)
          dUde=ubar(i,Mm,knew)-ubar(i,Mm-1,knew)
#  ifdef NORTH_M2NUDGING
          tau=M2obc_out(inorth)
          if ((dUdt*dUde).lt.0.0_r8) tau=M2obc_in(inorth)
          tau=tau*dt2d
#  endif
          if ((dUdt*dUde).lt.0.0_r8) dUdt=0.0_r8
          if ((dUdt*(grad(i-1,Mm)+grad(i,Mm))).gt.0.0_r8) then
            dUdx=grad(i-1,Mm)
          else
            dUdx=grad(i  ,Mm)
          endif
          cff=MAX(dUdx*dUdx+dUde*dUde,eps)
#  ifdef RADIATION_2D
          Cx=MIN(cff,MAX(dUdt*dUdx,-cff))
#  else
          Cx=0.0_r8
#  endif
          Ce=dUdt*dUde
          ubar(i,M,knew)=(cff*ubar(i,M,know)+
     &                    Ce*ubar(i,Mm,knew)-
     &                    MAX(Cx,0.0_r8)*grad(i-1,M)-
     &                    MIN(Cx,0.0_r8)*grad(i  ,M))/(cff+Ce)
#  ifdef NORTH_M2NUDGING
     &                  +tau*(ubar_north(i)-ubar(i,M,know))
#  endif
#  ifdef MASKING
          ubar(i,M,knew)=ubar(i,M,knew)*umask(i,M)
#  endif
        enddo
# elif defined NORTH_M2FLATHER
!
!  Northern edge, Chapman boundary condition.
!
        do i=IstrU,Iend
          Ce=dt2d*0.5_r8*(pn(i-1,Mm)+pn(i,Mm))*
     &       SQRT(g*0.5_r8*(h(i-1,Mm)+h(i,Mm)))
          ubar(i,M,knew)=(ubar(i,M,know)+Ce*ubar(i,Mm,knew))/
     &                   (1.0_r8+Ce)
#  ifdef MASKING
     &                  *umask(i,M)
#  endif
        enddo
# elif defined NORTH_M2CLAMPED
!
!  Northern edge, clamped boundary condition.
!
        do i=IstrU,Iend
          ubar(i,M,knew)=ubar_north(i)
#  ifdef MASKING
     &                  *umask(i,M)
#  endif
        enddo
# elif defined NORTH_M2GRADIENT
!
!  Northern edge, gradient boundary condition.
!
        do i=IstrU,Iend
          ubar(i,M,knew)=ubar(i,Mm,knew)
#  ifdef MASKING
     &                  *umask(i,M)
#  endif
        enddo
# else
!
!  Northern edge, closed boundary condition: free slip (gamma2=1)  or
!                                            no   slip (gamma2=-1).
!
#  ifdef EW_PERIODIC
#   define I_RANGE IstrU,Iend
#  else
#   define I_RANGE Istr,IendR
#  endif
        do i=I_RANGE
          ubar(i,M,knew)=gamma2*ubar(i,Mm,knew)
#  ifdef MASKING
     &                  *umask(i,M)
#  endif
        enddo
#  undef I_RANGE
# endif
      endif
#endif /* !NS_PERIODIC */
#if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        ubar(1,0,knew)=0.5_r8*(ubar(2,0,knew)+ubar(1,1,knew))
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        ubar(L,0,knew)=0.5_r8*(ubar(Lm,0,knew)+ubar(L,1,knew))
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        ubar(1,M,knew)=0.5_r8*(ubar(2,M,knew)+ubar(1,Mm,knew))
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        ubar(L,M,knew)=0.5_r8*(ubar(Lm,M,knew)+ubar(L,Mm,knew))
      endif
#endif
      return
      end
