#include "cppdefs.h"
#if defined SOLVE3D && (defined MY25_MIXING || defined GLS_MIXING)
      subroutine tkebc_tile (Istr,Iend,Jstr,Jend,indx,grad,gradL)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine sets lateral boundary conditions for turbulent    !
!  kinetic energy and turbulent length scale variables associated    !
!  with the Mellor and Yamada or GOTM closures.                      !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "mask.h"
# include "mixing.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, indx, j, k
      REAL_TYPE
     &        Ce, Cx, cff, dKde, dKdt, dKdx, eps
      REAL_TYPE
     &        grad (PRIVATE_2D_SCRATCH_ARRAY),
     &        gradL(PRIVATE_2D_SCRATCH_ARRAY)
      parameter (eps=1.0_e8-20)
!
# include "set_bounds.h"
!
      i=0
      j=0
      Ce=0.0_r8
      Cx=0.0_r8
      cff=0.0_r8
      dKdx=0.0_r8
      dKde=0.0_r8
      dKdt=0.0_r8
!
# ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the western edge.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE) then
!
#  if defined WEST_KRADIATION
!
!  Western edge, implicit upstream radiation condition.
!
        do k=0,N
          do j=Jstr,Jend+1
            grad (0,j)=(tke(0,j,k,nstp)-tke(0,j-1,k,nstp))
#   ifdef MASKING
     &                *vmask(0,j)
#   endif
            grad (1,j)=(tke(1,j,k,nstp)-tke(1,j-1,k,nstp))
#   ifdef MASKING
     &                *vmask(1,j)
#   endif
            gradL(0,j)=(gls(0,j,k,nstp)-gls(0,j-1,k,nstp))
#   ifdef MASKING
     &                *vmask(0,j)
#   endif
            gradL(1,j)=(gls(1,j,k,nstp)-gls(1,j-1,k,nstp))
#   ifdef MASKING
     &                *vmask(1,j)
#   endif
          enddo
          do j=Jstr,Jend
            dKdt=tke(1,j,k,nstp)-tke(1,j,k,nnew)
            dKdx=tke(1,j,k,nstp)-tke(2,j,k,nstp)
            if ((dKdt*dKdx).lt.0.0_r8) dKdt=0.0_r8
            if ((dKdt*(grad(1,j)+grad(1,j+1))).gt.0.0_r8) then
              dKde=grad(1,j  )
            else
              dKde=grad(1,j+1)
            endif
            cff=dKdt/MAX(dKdx*dKdx+dKde*dKde,eps)
            Cx=MIN(1.0_r8,cff*dKdx)
#   ifdef RADIATION_2D
            Ce=MIN(1.0_r8,MAX(cff*dKde,-1.0_r8))
#   else
            Ce=0.0_r8
#   endif
            tke(0,j,k,indx)=((1.0_r8-Cx)*tke(0,j,k,nstp)+
     &                       Cx*tke(1,j,k,nstp)-
     &                       MAX(Ce,0.0_r8)*grad(0,j  )-
     &                       MIN(Ce,0.0_r8)*grad(0,j+1))
#   ifdef MASKING
     &                     *rmask(0,j)
#   endif
            dKdt=gls(1,j,k,nstp)-gls(1,j,k,nnew)
            dKdx=gls(1,j,k,nstp)-gls(2,j,k,nstp)
            if ((dKdt*dKdx).lt.0.0_r8) dKdt=0.0_r8
            if ((dKdt*(gradL(1,j)+gradL(1,j+1))).gt.0.0_r8) then
              dKde=gradL(1,j  )
            else
              dKde=gradL(1,j+1)
            endif
            cff=dKdt/MAX(dKdx*dKdx+dKde*dKde,eps)
            Cx=MIN(1.0_r8,cff*dKdx)
#   ifdef RADIATION_2D
            Ce=MIN(1.0_r8,MAX(cff*dKde,-1.0_r8))
#   else
            Ce=0.0_r8
#   endif
            gls(0,j,k,indx)=((1.0_r8-Cx)*gls(0,j,k,nstp)+
     &                       Cx*gls(1,j,k,nstp)-
     &                       MAX(Ce,0.0_r8)*gradL(0,j  )-
     &                       MIN(Ce,0.0_r8)*gradL(0,j+1))
#   ifdef MASKING
     &                     *rmask(0,j)
#   endif
          enddo
        enddo
#  elif defined WEST_KGRADIENT
!
!  Western edge, gradient boundary condition.
!
        do k=0,N
          do j=Jstr,Jend
            tke(0,j,k,indx)=tke(1,j,k,indx)
#   ifdef MASKING
     &                     *rmask(0,j)
#   endif
            gls(0,j,k,indx)=gls(1,j,k,indx)
#   ifdef MASKING
     &                     *rmask(0,j)
#   endif
          enddo
        enddo
#  else
!
!  Western edge, closed boundary condition.
!
        do k=0,N
          do j=Jstr,Jend
            tke(0,j,k,indx)=tke(1,j,k,indx)
#   ifdef MASKING
     &                     *rmask(0,j)
#   endif
            gls(0,j,k,indx)=gls(1,j,k,indx)
#   ifdef MASKING
     &                     *rmask(0,j)
#   endif
          enddo
        enddo
#  endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the eastern edge.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
!
#  if defined EAST_KRADIATION
!
!  Eastern edge, implicit upstream radiation condition.
!
        do k=0,N
          do j=Jstr,Jend+1
           grad (Lm,j)=(tke(Lm,j,k,nstp)-tke(Lm,j-1,k,nstp))
#   ifdef MASKING
     &                *vmask(Lm,j)
#   endif
           grad (L ,j)=(tke(L ,j,k,nstp)-tke(L ,j-1,k,nstp))
#   ifdef MASKING
     &                *vmask(L ,j)
#   endif
          enddo
          do j=Jstr,Jend
            dKdt=tke(Lm,j,k,nstp)-tke(Lm,j,k,nnew)
            dKdx=tke(Lm,j,k,nstp)-tke(Lm-1,j,k,nstp)
            if ((dKdt*dKdx).lt.0.0_r8) dKdt=0.0_r8
            if ((dKdt*(grad(Lm,j)+grad(Lm,j+1))).gt.0.0_r8) then
              dKde=grad(Lm,j  )
            else
              dKde=grad(Lm,j+1)
            endif
            cff=dKdt/MAX(dKdx*dKdx+dKde*dKde,eps)
            Cx=MIN(1.0_r8,cff*dKdx)
#   ifdef RADIATION_2D
            Ce=MIN(1.0_r8,MAX(cff*dKde,-1.0_r8))
#   else
            Ce=0.0_r8
#   endif
            tke(L,j,k,indx)=((1.0_r8-Cx)*tke(L,j,k,nstp)+
     &                       Cx*tke(Lm,j,k,nstp)-
     &                       MAX(Ce,0.0_r8)*grad(L,j  )-
     &                       MIN(Ce,0.0_r8)*grad(L,j+1))
#   ifdef MASKING
     &                     *rmask(L,j)
#   endif
            dKdt=gls(Lm,j,k,nstp)-gls(Lm,j,k,nnew)
            dKdx=gls(Lm,j,k,nstp)-gls(Lm-1,j,k,nstp)
            if ((dKdt*dKdx).lt.0.0_r8) dKdt=0.0_r8
            if ((dKdt*(gradL(Lm,j)+gradL(Lm,j+1))).gt.0.0_r8) then
              dKde=gradL(Lm,j  )
            else
              dKde=gradL(Lm,j+1)
            endif
            cff=dKdt/MAX(dKdx*dKdx+dKde*dKde,eps)
            Cx=MIN(1.0_r8,cff*dKdx)
#   ifdef RADIATION_2D
            Ce=MIN(1.0_r8,MAX(cff*dKde,-1.0_r8))
#   else
            Ce=0.0_r8
#   endif
            gls(L,j,k,indx)=((1.0_r8-Cx)*gls(L,j,k,nstp)+
     &                       Cx*gls(Lm,j,k,nstp)-
     &                       MAX(Ce,0.0_r8)*gradL(L,j  )-
     &                       MIN(Ce,0.0_r8)*gradL(L,j+1))
#   ifdef MASKING
     &                     *rmask(L,j)
#   endif
          enddo
        enddo
#  elif defined EAST_KGRADIENT
!
!  Eastern edge, gradient boundary condition.
!
        do k=0,N
          do j=Jstr,Jend
            tke(L,j,k,indx)=tke(Lm,j,k,indx)
#   ifdef MASKING
     &                     *rmask(L,j)
#   endif
            gls(L,j,k,indx)=gls(Lm,j,k,indx)
#   ifdef MASKING
     &                     *rmask(L,j)
#   endif
          enddo
        enddo
#  else
!
!  Eastern edge, closed boundary condition.
!
        do k=0,N
          do j=Jstr,Jend
            tke(L,j,k,indx)=tke(Lm,j,k,indx)
#   ifdef MASKING
     &                     *rmask(L,j)
#   endif
            gls(L,j,k,indx)=gls(Lm,j,k,indx)
#   ifdef MASKING
     &                     *rmask(L,j)
#   endif
          enddo
        enddo
#  endif
      endif
# endif /* !EW_PERIODIC */
# ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the southern edge.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE) then
!
# if defined SOUTH_KRADIATION
!
!  Southern edge, implicit upstream radiation condition.
!
        do k=0,N
          do i=Istr,Iend+1
            grad (i,1)=(tke(i,1,k,nstp)-tke(i-1,1,k,nstp))
#   ifdef MASKING
     &                *umask(i,1)
#   endif
            grad (i,0)=(tke(i,0,k,nstp)-tke(i-1,0,k,nstp))
#   ifdef MASKING
     &                *umask(i,0)
#   endif
            gradL(i,1)=(gls(i,1,k,nstp)-gls(i-1,1,k,nstp))
#   ifdef MASKING
     &                *umask(i,1)
#   endif
            gradL(i,0)=(gls(i,0,k,nstp)-gls(i-1,0,k,nstp))
#   ifdef MASKING
     &                *umask(i,0)
#   endif
          enddo
          do i=Istr,Iend
            dKdt=tke(i,1,k,nstp)-tke(i,1,k,nnew)
            dKde=tke(i,1,k,nstp)-tke(i,2,k,nstp)
            if ((dKdt*dKde).lt.0.0_r8) dKdt=0.0_r8
            if ((dKdt*(grad(i,1)+grad(i+1,1))).gt.0.0_r8) then
              dKdx=grad(i  ,1)
            else
              dKdx=grad(i+1,1)
            endif
            cff=dKdt/MAX(dKdx*dKdx+dKde*dKde,eps)
#   ifdef RADIATION_2D
            Cx=MIN(1.0_r8,MAX(cff*dKdx,-1.0_r8))
#   else
            Cx=0.0_r8
#   endif
            Ce=MIN(1.0_r8,cff*dKde)
            tke(i,0,k,indx)=((1.0_r8-Ce)*tke(i,0,k,nstp)+
     &                       Ce*tke(i,1,k,nstp)-
     &                       MAX(Cx,0.0_r8)*grad(i  ,0)-
     &                       MIN(Cx,0.0_r8)*grad(i+1,0))
#   ifdef MASKING
     &                     *rmask(i,0)
#   endif
            dKdt=gls(i,1,k,nstp)-gls(i,1,k,nnew)
            dKde=gls(i,1,k,nstp)-gls(i,2,k,nstp)
            if ((dKdt*dKde).lt.0.0_r8) dKdt=0.0_r8
            if ((dKdt*(gradL(i,1)+gradL(i+1,1))).gt.0.0_r8) then
              dKdx=gradL(i  ,1)
            else
              dKdx=gradL(i+1,1)
            endif
            cff=dKdt/MAX(dKdx*dKdx+dKde*dKde,eps)
#   ifdef RADIATION_2D
            Cx=MIN(1.0_r8,MAX(cff*dKdx,-1.0_r8))
#   else
            Cx=0.0_r8
#   endif
            Ce=MIN(1.0_r8,cff*dKde)
            gls(i,0,k,indx)=((1.0_r8-Ce)*gls(i,0,k,nstp)+
     &                       Ce*gls(i,1,k,nstp)-
     &                       MAX(Cx,0.0_r8)*gradL(i  ,0)-
     &                       MIN(Cx,0.0_r8)*gradL(i+1,0))
#   ifdef MASKING
     &                     *rmask(i,0)
#   endif
          enddo
        enddo
#  elif defined SOUTH_KGRADIENT
!
!  Southern edge, gradient boundary condition.
!
        do k=0,N
          do i=Istr,Iend
            tke(i,0,k,indx)=tke(i,1,k,indx)
#   ifdef MASKING
     &                     *rmask(i,0)
#   endif
            gls(i,0,k,indx)=gls(i,1,k,indx)
#   ifdef MASKING
     &                     *rmask(i,0)
#   endif
          enddo
        enddo
#  else
!
!  Southern edge, closed boundary condition.
!
        do k=0,N
          do i=Istr,Iend
            tke(i,0,k,indx)=tke(i,1,k,indx)
#   ifdef MASKING
     &                     *rmask(i,0)
#   endif
            gls(i,0,k,indx)=gls(i,1,k,indx)
#   ifdef MASKING
     &                     *rmask(i,0)
#   endif
          enddo
        enddo
#  endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the northern edge.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
!
#  if defined NORTH_KRADIATION
!
!  Northern edge, implicit upstream radiation condition.
!
        do k=0,N
          do i=Istr,Iend+1
            grad (i,Mm)=(tke(i,Mm,k,nstp)-tke(i-1,Mm,k,nstp))
#   ifdef MASKING
     &                 *umask(i,Mm)
#   endif
            grad (i,M )=(tke(i,M ,k,nstp)-tke(i-1,M ,k,nstp))
#   ifdef MASKING
     &                 *umask(i,M )
#   endif
            gradL(i,Mm)=(gls(i,Mm,k,nstp)-gls(i-1,Mm,k,nstp))
#   ifdef MASKING
     &                 *umask(i,Mm)
#   endif
            gradL(i,M )=(gls(i,M ,k,nstp)-gls(i-1,M ,k,nstp))
#   ifdef MASKING
     &                 *umask(i,M )
#   endif
          enddo
          do i=Istr,Iend
            dKdt=tke(i,Mm,k,nstp)-tke(i,Mm  ,k,nnew)
            dKde=tke(i,Mm,k,nstp)-tke(i,Mm-1,k,nstp)
            if ((dKdt*dKde).lt.0.0_r8) dKdt=0.0_r8
            if ((dKdt*(grad(i,Mm)+grad(i+1,Mm))).gt.0.0_r8) then
              dKdx=grad(i  ,Mm)
            else
              dKdx=grad(i+1,Mm)
            endif
            cff=dKdt/MAX(dKdx*dKdx+dKde*dKde,eps)
#   ifdef RADIATION_2D
            Cx=MIN(1.0_r8,MAX(cff*dKdx,-1.0_r8))
#   else
            Cx=0.0_r8
#   endif
            Ce=MIN(1.0_r8,cff*dKde)
            tke(i,M,k,indx)=((1.0_r8-Ce)*tke(i,M,k,nstp)+
     &                       Ce*tke(i,Mm,k,nstp)-
     &                       MAX(Cx,0.0_r8)*grad(i  ,M)-
     &                       MIN(Cx,0.0_r8)*grad(i+1,M))
#   ifdef MASKING
     &                     *rmask(i,M)
#   endif
            dKdt=gls(i,Mm,k,nstp)-gls(i,Mm  ,k,nnew)
            dKde=gls(i,Mm,k,nstp)-gls(i,Mm-1,k,nstp)
            if ((dKdt*dKde).lt.0.0_r8) dKdt=0.0_r8
            if ((dKdt*(gradL(i,Mm)+gradL(i+1,Mm))).gt.0.0_r8) then
              dKdx=gradL(i  ,Mm)
            else
              dKdx=gradL(i+1,Mm)
            endif
            cff=dKdt/MAX(dKdx*dKdx+dKde*dKde,eps)
#   ifdef RADIATION_2D
            Cx=MIN(1.0_r8,MAX(cff*dKdx,-1.0_r8))
#   else
            Cx=0.0_r8
#   endif
            Ce=MIN(1.0_r8,cff*dKde)
            gls(i,M,k,indx)=((1.0_r8-Ce)*gls(i,M,k,nstp)+
     &                       Ce*gls(i,Mm,k,nstp)-
     &                       MAX(Cx,0.0_r8)*gradL(i  ,M)-
     &                       MIN(Cx,0.0_r8)*gradL(i+1,M))
#   ifdef MASKING
     &                     *rmask(i,M)
#   endif
          enddo
        enddo
#  elif defined NORTH_KGRADIENT
!
!  Northern edge, gradient boundary condition.
!
        do k=0,N
          do i=Istr,Iend
            tke(i,M,k,indx)=tke(i,Mm,k,indx)
#   ifdef MASKING
     &                     *rmask(i,M)
#   endif
            gls(i,M,k,indx)=gls(i,Mm,k,indx)
#   ifdef MASKING
     &                     *rmask(i,M)
#   endif
          enddo
        enddo
#  else
!
!  Northern edge, closed boundary condition.
!
        do k=0,N
          do i=Istr,Iend
            tke(i,M,k,indx)=tke(i,Mm,k,indx)
#   ifdef MASKING
     &                     *rmask(i,M)
#   endif
            gls(i,M,k,indx)=gls(i,Mm,k,indx)
#   ifdef MASKING
     &                     *rmask(i,M)
#   endif
          enddo
        enddo
#  endif
      endif
# endif /* ! NS_PERIODIC */
# if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=0,N
          tke(0,0,k,indx)=0.5_r8*(tke(1,0,k,indx)+tke(0,1,k,indx))
          gls(0,0,k,indx)=0.5_r8*(gls(1,0,k,indx)+gls(0,1,k,indx))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=0,N
          tke(L,0,k,indx)=0.5_r8*(tke(Lm,0,k,indx)+tke(L,1,k,indx))
          gls(L,0,k,indx)=0.5_r8*(gls(Lm,0,k,indx)+gls(L,1,k,indx))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=0,N
          tke(0,M,k,indx)=0.5_r8*(tke(1,M,k,indx)+tke(0,Mm,k,indx))
          gls(0,M,k,indx)=0.5_r8*(gls(1,M,k,indx)+gls(0,Mm,k,indx))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=0,N
          tke(L,M,k,indx)=0.5_r8*(tke(Lm,M,k,indx)+tke(L,Mm,k,indx))
          gls(L,M,k,indx)=0.5_r8*(gls(Lm,M,k,indx)+gls(L,Mm,k,indx))
        enddo
      endif
# endif
#else
      subroutine tkebc
#endif /* SOLVE3D && (MY25_MIXING || GLS_MIXING) */
      return
      end
