#include "cppdefs.h"
      subroutine wclock_on (region)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine turns on wall clock to meassure the elapsed time in  !
!  seconds spend by each parallel thread in requested model region.  !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "wclock.h"
!
      INTEGER_TYPE
     &        iregion, mythread, region
      INTEGER_TYPE
     &        my_getpid, my_threadnum
      REAL_TYPE
     &        my_wtime, wtime(2)
!
!---------------------------------------------------------------------
! Initialize timing for all threads.
!---------------------------------------------------------------------
!
      Cstr(region)=my_wtime(wtime)
      if ((region.eq.0).and.(proc(1).eq.0)) then
        do iregion=1,35
          Cend(iregion)=0.0_r8
          Csum(iregion)=0.0_r8
        enddo
        proc(1)=1
        proc(0)=my_getpid()
        mythread=my_threadnum()
        call my_setlock (lock)
        write(stdout,10) ' Thread #', mythread,
     &                   ' (pid=',proc(0),') is active.'
 10     format(a,i3,a,i8,a)
        call my_unsetlock (lock)
      endif
      return
      end
      subroutine wclock_off (region)
!
!=====================================================================
!                                                                    !
!  This routine turns off wall clock to meassure the elapsed time in !
!  seconds spend by each parallel thread in requested model region.  !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "scalars.h"
#include "wclock.h"
!
      INTEGER_TYPE
     &        mythread, region
      INTEGER_TYPE
     &        my_threadnum
      REAL_TYPE
     &        percent, wtime(2)
#ifdef PROFILE
      INTEGER_TYPE
     &        iregion
      REAL_TYPE
     &        sumcpu, sumper
#endif
      REAL_TYPE
     &        my_wtime
!
!---------------------------------------------------------------------
!  Compute elapsed wall time for all threads.
!---------------------------------------------------------------------
!
      Cend(region)=Cend(region)+(my_wtime(wtime)-Cstr(region))
!
!  Report elapsed wall time.
!
      if (region.eq.0 .and. proc(1).eq.1) then
        mythread=my_threadnum()
        proc(1)=0
        call my_setlock (lock)
        write(6,10) ' Thread #', mythread, ' CPU:', Cend(region)
 10     format(a,i3,a,f12.3)
        trd_count=trd_count+1
        Csum(region)=Csum(region)+Cend(region)
#ifdef PROFILE
        do iregion=1,35
          Csum(iregion)=Csum(iregion)+Cend(iregion)
        enddo
        Csum(35)=Csum(35)-Csum(15)-Csum(16)
#endif
        if (trd_count.eq.numthreads) then
          trd_count=0
          write(stdout,20) ' Total:', Csum(region)
 20       format(a,8x,f14.3)
#ifdef PROFILE
          write(stdout,30) ' Elapsed time profile: '
 30       format(/,a,/)
          sumcpu=0.0_r8
          sumper=0.0_r8
          Csum(35)=Csum(35)-Csum(15)-Csum(16)
          do iregion=1,35
            if (Csum(iregion).gt.0.0_r8) then
              percent=100.0_r8*Csum(iregion)/
     &                         Csum( region)
              write(stdout,40) Pregion(iregion), Csum(iregion),
     &                         percent
              sumcpu=sumcpu+Csum(iregion)
              sumper=sumper+percent
            endif
          enddo
 40       format(2x,a,t53,f14.3,2x,'(',f7.4,' %)')
          write(stdout,50) sumcpu, sumper
 50       format(t46,'Total: ',f14.3,2x,f8.4)
#endif
        endif
        call my_unsetlock (lock)
      endif 
      return
      end
