/*
** Include file "tile.h".
***************************************** Alexander F. Shchepetkin ***
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Compute the starting and ending horizontal indices (Istr,Iend)   **
** (Jstr,Jend) for each sub-domain partition or tile.               **
**                                                                  **
**********************************************************************
*/
      INTEGER_TYPE
     &        Istr, Iend, Jstr, Jend
      INTEGER_TYPE
     &        chunk_size_x, chunk_size_e, margin_x, margin_e, i, j
      parameter (chunk_size_x=(Lm+NSUB_X-1)/NSUB_X,
     &           chunk_size_e=(Mm+NSUB_E-1)/NSUB_E,
     &           margin_x=(NSUB_X*chunk_size_x-Lm)/2,
     &           margin_e=(NSUB_E*chunk_size_e-Mm)/2)
!
!  Compute horizontal indices for grid partition into tiles.
!
      j=tile/NSUB_X
      i=tile-j*NSUB_X
      Istr=1+i*chunk_size_x-margin_x
      Iend=Istr+chunk_size_x-1
      Istr=MAX(Istr,1)
      Iend=MIN(Iend,Lm)
      Jstr=1+j*chunk_size_e-margin_e
      Jend=Jstr+chunk_size_e-1
      Jstr=MAX(Jstr,1)
      Jend=MIN(Jend,Mm)
