/*
** Include file "tides.h"
*************************************************** Robert Hetland ***
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Tidal Components:                                                **
**                                                                  **
** Each of the following arrays has a dimension in tidal components **
** classified by period:                                            **
**                                                                  **
**   semi-diurnal:  M2, S2, N2, K2  (12.42, 12.00, 12.66, 11.97h)   **
**        diurnal:  K1, O1, P1, Q1  (23.93, 25.82, 24.07, 26.87h)   **
**                                                                  **
** and other longer periods. The order of these tidal components is **
** irrelevant here.  The number of components to use is depends on  **
** the regional application.                                        **
**                                                                  **
** NTC          Number of tidal components to consider.             **
** SSH_Tamp     Tidal elevation amplitude (m) at RHO-points.        **
** SSH_Tphase   Tidal elevation phase (degrees/360) at RHO-points.  **
** Tperiod      Tidal period (s).                                   **
** UV_Tangle    Tidal current angle (radians; counterclockwise      **
**                from EAST and rotated to curvilinear grid) at     **
**                RHO-points.                                       **
** UV_Tmajor    Maximum tidal current: tidal ellipse major axis     **
**                (m/s) at RHO-points.                              **
** UV_Tminor    Minimum tidal current: tidal ellipse minor axis     **
**                (m/s) at RHO-points.                              **
** UV_Tphase    Tidal current phase (degrees/360) at RHO-points.    **
**                                                                  **
**********************************************************************
*/

#if defined SSH_TIDES || defined UV_TIDES
      common /itides/ NTC
      INTEGER_TYPE
     &        NTC

      common /tides_Tperiod/ Tperiod
      REAL_TYPE Tperiod(MTC)
#endif /* SSH_TIDES || UV_TIDES */

#if defined SSH_TIDES
      common /tides_SSH_Tamp/ SSH_Tamp
      REAL_TYPE SSH_Tamp(GLOBAL_2D_ARRAY,MTC)

      common /tides_SSH_Tphase/ SSH_Tphase
      REAL_TYPE SSH_Tphase(GLOBAL_2D_ARRAY,MTC)
#endif /* SSH_TIDES */

#if defined UV_TIDES
      common /tides_UV_Tangle/ UV_Tangle
      REAL_TYPE UV_Tangle(GLOBAL_2D_ARRAY,MTC)

      common /tides_UV_Tmajor/ UV_Tmajor
      REAL_TYPE UV_Tmajor(GLOBAL_2D_ARRAY,MTC)

      common /tides_UV_Tminor/ UV_Tminor
      REAL_TYPE UV_Tminor(GLOBAL_2D_ARRAY,MTC)

      common /tides_UV_Tphase/ UV_Tphase
      REAL_TYPE UV_Tphase(GLOBAL_2D_ARRAY,MTC)
#endif /* UV_TIDES */
