#include "cppdefs.h"
#if defined TS_DIF4 && defined MIX_S_TS && defined SOLVE3D
      subroutine t3dmix4_s (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine computes horizontal biharmonic mixing of tracers  !
!  along S-coordinate levels surfaces.                               !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        itrc, tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (27)
# endif
      do itrc=1,NT
        call t3dmix4_s_tile (Istr,Iend,Jstr,Jend,itrc,
     &                       A2d(1,1),A2d(1,2),A2d(1,3))
      enddo
# ifdef PROFILE
      call wclock_off (27)
# endif
      return
      end
!
!*********************************************************************
      subroutine t3dmix4_s_tile (Istr,Iend,Jstr,Jend,itrc,FX,FE,LapT)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mask.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, itrc, j, k
      REAL_TYPE
     &          FE(PRIVATE_2D_SCRATCH_ARRAY),
     &          FX(PRIVATE_2D_SCRATCH_ARRAY),
     &        LapT(PRIVATE_2D_SCRATCH_ARRAY)
!
# include "set_bounds.h"
# ifdef EW_PERIODIC
#  define I_RANGE Istr-1,Iend+1
# else
#  define I_RANGE MAX(Istr-1,1),MIN(Iend+1,Lm)
# endif
# ifdef NS_PERIODIC
#  define J_RANGE Jstr-1,Jend+1
# else
#  define J_RANGE MAX(Jstr-1,1),MIN(Jend+1,Mm)
# endif
!
      do k=1,N
!
!--------------------------------------------------------------------
!  Compute horizontal biharmonic diffusion along constant S-surfaces.
!  The biharmonic operator is computed by applying the harmonic
!  operator twice.
!--------------------------------------------------------------------
!
!  Compute horizontal tracer flux in the XI- and ETA-directions.
!
        do j=J_RANGE
          do i=I_RANGE+1
            FX(i,j)=0.25_r8*(diff4(i,j,itrc)+diff4(i-1,j,itrc))*
     &              (Hz(i,j,k)+Hz(i-1,j,k))*pmon_u(i,j)*
     &              (t(i,j,k,nrhs,itrc)-t(i-1,j,k,nrhs,itrc))
# ifdef MASKING
     &             *umask(i,j)
# endif
          enddo
        enddo
        do j=J_RANGE+1
          do i=I_RANGE
            FE(i,j)=0.25_r8*(diff4(i,j,itrc)+diff4(i,j-1,itrc))*
     &              (Hz(i,j,k)+Hz(i,j-1,k))*pnom_v(i,j)*
     &              (t(i,j,k,nrhs,itrc)-t(i,j-1,k,nrhs,itrc))
# ifdef MASKING
     &             *vmask(i,j)
# endif
          enddo
        enddo
!
!  Compute first harmonic operator and multiply by the metrics of the
!  second harmonic operator.
!
        do j=J_RANGE
          do i=I_RANGE
            LapT(i,j)=(FX(i+1,j)-FX(i,j)+FE(i,j+1)-FE(i,j))*
     &                pm(i,j)*pn(i,j)/Hz(i,j,k)
          enddo
        enddo
!
!  Apply boundary conditions (except periodic; closed or gradient)
!  to the first harmonic operator.
!
# ifndef EW_PERIODIC
        if (WESTERN_EDGE) then
          do j=J_RANGE
#  ifdef WESTERN_WALL
            LapT(Istr-1,j)=0.0_r8
#  else
            LapT(Istr-1,j)=LapT(Istr,j)
#  endif
          enddo
        endif
        if (EASTERN_EDGE) then
          do j=J_RANGE
#  ifdef EASTERN_WALL
            LapT(Iend+1,j)=0.0_r8
#  else
            LapT(Iend+1,j)=LapT(Iend,j)
#  endif
          enddo
        endif
# endif /* !EW_PERIODIC */
# ifndef NS_PERIODIC
        if (SOUTHERN_EDGE) then
          do i=I_RANGE
#  ifdef SOUTHERN_WALL
            LapT(i,Jstr-1)=0.0_r8
#  else
            LapT(i,Jstr-1)=LapT(i,Jstr)
#  endif
          enddo
        endif
        if (NORTHERN_EDGE) then
          do i=I_RANGE
#  ifdef NORTHERN_WALL
            LapT(i,Jend+1)=0.0_r8
#  else
            LapT(i,Jend+1)=LapT(i,Jend)
#  endif
          enddo
        endif
# endif /* !NS_PERIODIC */
!
!  Compute FX=d(LapT)/d(xi) and FE=d(LapT)/d(eta) terms.
!
        do j=Jstr,Jend
          do i=Istr,Iend+1
            FX(i,j)=0.25_r8*(diff4(i,j,itrc)+diff4(i-1,j,itrc))*
     &              (Hz(i,j,k)+Hz(i-1,j,k))*pmon_u(i,j)*
     &              (LapT(i,j)-LapT(i-1,j))
# ifdef MASKING
     &             *umask(i,j)
# endif
          enddo
        enddo
        do j=Jstr,Jend+1
          do i=Istr,Iend
            FE(i,j)=0.25_r8*(diff4(i,j,itrc)+diff4(i,j-1,itrc))*
     &              (Hz(i,j,k)+Hz(i,j-1,k))*pnom_v(i,j)*
     &              (LapT(i,j)-LapT(i,j-1))
# ifdef MASKING
     &             *vmask(i,j)
# endif
          enddo
        enddo
!
! Time-step biharmonic, S-surfaces diffusion term.
!
        do j=Jstr,Jend
          do i=Istr,Iend
            t(i,j,k,nnew,itrc)=t(i,j,k,nnew,itrc)-
     &                         dt*pm(i,j)*pn(i,j)*
     &                            (FX(i+1,j)-FX(i,j)+
     &                             FE(i,j+1)-FE(i,j))
          enddo
        enddo
      enddo
# undef I_RANGE
# undef J_RANGE
#else
      subroutine t3dmix4_s
#endif
      return
      end
