#include "cppdefs.h"
#if defined TS_DIF4 && defined MIX_GEO_TS && defined SOLVE3D
      subroutine t3dmix4_geo (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine computes horizontal biharmonic mixing of tracers  !
!  along geopotential surfaces.                                      !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        itrc, tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (28)
# endif
      do itrc=1,NT
        call t3dmix4_geo_tile (Istr,Iend,Jstr,Jend,itrc,
     &                         A3d(1, 1),A2d(1, 1),A2d(1, 2),A2d(1, 3),
     &                         A2d(1, 5),A2d(1, 7),A2d(1, 9),A2d(1,11),
     &                         A2d(1,13))
      enddo
# ifdef PROFILE
      call wclock_off (28)
# endif
      return
      end
!
!*********************************************************************
      subroutine t3dmix4_geo_tile (Istr,Iend,Jstr,Jend,itrc,LapT,FX,
     &                             FE,FS,dTdz,dTdx,dTde,dZdx,dZde)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mask.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, itrc, j, k, k1, k2
      REAL_TYPE
     &        cff, cff1, cff2, cff3, cff4
      REAL_TYPE
     &        LapT(PRIVATE_2D_SCRATCH_ARRAY,0:N),
     &          FX(PRIVATE_2D_SCRATCH_ARRAY),
     &          FE(PRIVATE_2D_SCRATCH_ARRAY),
     &          FS(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        dTdz(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        dTdx(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        dTde(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        dZdx(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        dZde(PRIVATE_2D_SCRATCH_ARRAY,2)
!
# include "set_bounds.h"
# ifdef EW_PERIODIC
#  define I_RANGE Istr-1,Iend+1
# else
#  define I_RANGE MAX(Istr-1,1),MIN(Iend+1,Lm)
# endif
# ifdef NS_PERIODIC
#  define J_RANGE Jstr-1,Jend+1
# else
#  define J_RANGE MAX(Jstr-1,1),MIN(Jend+1,Mm)
# endif
!
!--------------------------------------------------------------------
!  Compute horizontal biharmonic diffusion along geopotential
!  surfaces.  The biharmonic operator is computed by applying
!  the harmonic operator twice.
!--------------------------------------------------------------------
!
!  Compute horizontal and vertical gradients associated with the
!  first rotated harmonic operator.  Notice the recursive blocking
!  sequence. The vertical placement of the gradients is:
!
!        dTdx,dTde(:,:,k1) k     rho-points
!        dTdx,dTde(:,:,k2) k+1   rho-points
!          FC,dTdz(:,:,k1) k-1/2   W-points
!          FC,dTdz(:,:,k2) k+1/2   W-points
!
      k2=1
      do k=0,N
        k1=k2
        k2=3-k1
        if (k.lt.N) then
          do j=J_RANGE
            do i=I_RANGE+1
              cff=0.5_r8*(pm(i,j)+pm(i-1,j))
# ifdef MASKING
     &           *umask(i,j)
# endif
              dZdx(i,j,k2)=cff*(z_r(i,j,k+1)-z_r(i-1,j,k+1))
              dTdx(i,j,k2)=cff*(t(i  ,j,k+1,nrhs,itrc)-
     &                          t(i-1,j,k+1,nrhs,itrc))
            enddo
          enddo
          do j=J_RANGE+1
            do i=I_RANGE
              cff=0.5_r8*(pn(i,j)+pn(i,j-1))
# ifdef MASKING
     &           *vmask(i,j)
# endif
              dZde(i,j,k2)=cff*(z_r(i,j,k+1)-z_r(i,j-1,k+1))
              dTde(i,j,k2)=cff*(t(i,j  ,k+1,nrhs,itrc)-
     &                          t(i,j-1,k+1,nrhs,itrc))
            enddo
          enddo
        endif
        if ((k.eq.0).or.(k.eq.N)) then
          do j=-1+J_RANGE+1
            do i=-1+I_RANGE+1
              dTdz(i,j,k2)=0.0_r8
              FS(i,j,k2)=0.0_r8
            enddo
          enddo
        else
          do j=-1+J_RANGE+1
            do i=-1+I_RANGE+1
              dTdz(i,j,k2)=(t(i,j,k+1,nrhs,itrc)-t(i,j,k,nrhs,itrc))/
     &                     (z_r(i,j,k+1)-z_r(i,j,k))
            enddo
          enddo
        endif
        if (k.gt.0) then
          do j=J_RANGE
            do i=I_RANGE+1
              FX(i,j)=0.25_r8*(diff4(i,j,itrc)+diff4(i-1,j,itrc))*
     &                (Hz(i,j,k)+Hz(i-1,j,k))*on_u(i,j)*
     &                (dTdx(i,j,k1)-
     &                 0.5_r8*(MIN(dZdx(i,j,k1),0.0_r8)*
     &                            (dTdz(i-1,j,k1)+dTdz(i,j,k2))+
     &                         MAX(dZdx(i,j,k1),0.0_r8)*
     &                            (dTdz(i-1,j,k2)+dTdz(i,j,k1))))
            enddo
          enddo
!
          do j=J_RANGE+1
            do i=I_RANGE
              FE(i,j)=0.25_r8*(diff4(i,j,itrc)+diff4(i,j-1,itrc))*
     &                (Hz(i,j,k)+Hz(i,j-1,k))*om_v(i,j)*
     &                (dTde(i,j,k1)-
     &                 0.5_r8*(MIN(dZde(i,j,k1),0.0_r8)*
     &                            (dTdz(i,j-1,k1)+dTdz(i,j,k2))+
     &                         MAX(dZde(i,j,k1),0.0_r8)*
     &                            (dTdz(i,j-1,k2)+dTdz(i,j,k1))))
            enddo
          enddo
!
          if (k.lt.N) then
            do j=J_RANGE
              do i=I_RANGE
                cff1=MIN(dZdx(i  ,j,k1),0.0_r8)
                cff2=MIN(dZdx(i+1,j,k2),0.0_r8)
                cff3=MAX(dZdx(i  ,j,k2),0.0_r8)
                cff4=MAX(dZdx(i+1,j,k1),0.0_r8)
                FS(i,j,k2)=0.5_r8*diff4(i,j,itrc)*
     &                     (cff1*(cff1*dTdz(i,j,k2)-dTdx(i  ,j,k1))+
     &                      cff2*(cff2*dTdz(i,j,k2)-dTdx(i+1,j,k2))+
     &                      cff3*(cff3*dTdz(i,j,k2)-dTdx(i  ,j,k2))+
     &                      cff4*(cff4*dTdz(i,j,k2)-dTdx(i+1,j,k1)))
                cff1=MIN(dZde(i,j  ,k1),0.0_r8)
                cff2=MIN(dZde(i,j+1,k2),0.0_r8)
                cff3=MAX(dZde(i,j  ,k2),0.0_r8)
                cff4=MAX(dZde(i,j+1,k1),0.0_r8)
                FS(i,j,k2)=FS(i,j,k2)+
     &                     0.5_r8*diff4(i,j,itrc)*
     &                     (cff1*(cff1*dTdz(i,j,k2)-dTde(i,j  ,k1))+
     &                      cff2*(cff2*dTdz(i,j,k2)-dTde(i,j+1,k2))+
     &                      cff3*(cff3*dTdz(i,j,k2)-dTde(i,j  ,k2))+
     &                      cff4*(cff4*dTdz(i,j,k2)-dTde(i,j+1,k1)))
              enddo
            enddo
          endif
!
!  Compute first harmonic operator, without mixing coefficient.
!  Multiply by the metrics of the second harmonic operator.  Save
!  into work array "LapT".
!
          do j=J_RANGE
            do i=I_RANGE
              LapT(i,j,k)=(pm(i,j)*pn(i,j)*(FX(i+1,j  )-FX(i,j)+
     &                                      FE(i  ,j+1)-FE(i,j))+
     &                     (FS(i,j,k2)-FS(i,j,k1)))/
     &                    Hz(i,j,k)
            enddo
          enddo
        endif
      enddo
!
!  Apply boundary conditions (except periodic; closed or gradient)
!  to the first harmonic operator.
!
# ifndef EW_PERIODIC
      if (WESTERN_EDGE) then
        do k=1,N
          do j=J_RANGE
#  ifdef WESTERN_WALL
            LapT(Istr-1,j,k)=0.0_r8
#  else
            LapT(Istr-1,j,k)=LapT(Istr,j,k)
#  endif
          enddo
        enddo
      endif
      if (EASTERN_EDGE) then
        do k=1,N
          do j=J_RANGE
#  ifdef EASTERN_WALL
            LapT(Iend+1,j,k)=0.0_r8
#  else
            LapT(Iend+1,j,k)=LapT(Iend,j,k)
#  endif
          enddo
        enddo
      endif
# endif /* !EW_PERIODIC */
# ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then
        do k=1,N
          do i=I_RANGE
#  ifdef SOUTHERN_WALL
            LapT(i,Jstr-1,k)=0.0_r8
#  else
            LapT(i,Jstr-1,k)=LapT(i,Jstr,k)
#  endif
          enddo
        enddo
      endif
      if (NORTHERN_EDGE) then
        do k=1,N
          do i=I_RANGE
#  ifdef NORTHERN_WALL
            LapT(i,Jend+1,k)=0.0_r8
#  else
            LapT(i,Jend+1,k)=LapT(i,Jend,k)
#  endif
          enddo
        enddo
      endif
# endif /* !NS_PERIODIC */
# undef I_RANGE
# undef J_RANGE
# if !defined EW_PERIODIC && !defined NS_PERIODIC
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          LapT(0,0,k)=0.5_r8*(LapT(1,0,k)+LapT(0,1,k))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          LapT(L,0,k)=0.5_r8*(LapT(Lm,0,k)+LapT(L,1,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          LapT(0,M,k)=0.5_r8*(LapT(1,M,k)+LapT(0,Mm,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          LapT(L,M,k)=0.5_r8*(LapT(Lm,M,k)+LapT(L,Mm,k))
        enddo
      endif
# endif /* !EW_PERIODIC && !NS_PERIODIC */
!
!  Compute horizontal and vertical gradients associated with the
!  second rotated harmonic operator.
!
      k2=1
      do k=0,N
        k1=k2
        k2=3-k1
        if (k.lt.N) then
          do j=Jstr,Jend
            do i=Istr,Iend+1
              cff=0.5_r8*(pm(i,j)+pm(i-1,j))
# ifdef MASKING
     &           *umask(i,j)
# endif
              dZdx(i,j,k2)=cff*(z_r(i,j,k+1)-z_r(i-1,j,k+1))
              dTdx(i,j,k2)=cff*(LapT(i,j,k+1)-LapT(i-1,j,k+1))
            enddo
          enddo
          do j=Jstr,Jend+1
            do i=Istr,Iend
              cff=0.5_r8*(pn(i,j)+pn(i,j-1))
# ifdef MASKING
     &           *vmask(i,j)
# endif
              dZde(i,j,k2)=cff*(z_r(i,j,k+1)-z_r(i,j-1,k+1))
              dTde(i,j,k2)=cff*(LapT(i,j,k+1)-LapT(i,j-1,k+1))
            enddo
          enddo
        endif
        if ((k.eq.0).or.(k.eq.N)) then
          do j=Jstr-1,Jend+1
            do i=Istr-1,Iend+1
              dTdz(i,j,k2)=0.0_r8
              FS(i,j,k2)=0.0_r8
            enddo
          enddo
        else
          do j=Jstr-1,Jend+1
            do i=Istr-1,Iend+1
              dTdz(i,j,k2)=(LapT(i,j,k+1)-LapT(i,j,k))/
     &                     (z_r(i,j,k+1)-z_r(i,j,k))
            enddo
          enddo
        endif
        if (k.gt.0) then
          do j=Jstr,Jend
            do i=Istr,Iend+1
              FX(i,j)=0.25_r8*(diff4(i,j,itrc)+diff4(i-1,j,itrc))*
     &                (Hz(i,j,k)+Hz(i-1,j,k))*on_u(i,j)*
     &                (dTdx(i  ,j,k1)-
     &                 0.5_r8*(MIN(dZdx(i,j,k1),0.0_r8)*
     &                            (dTdz(i-1,j,k1)+dTdz(i,j,k2))+
     &                         MAX(dZdx(i,j,k1),0.0_r8)*
     &                            (dTdz(i-1,j,k2)+dTdz(i,j,k1))))
            enddo
          enddo
          do j=Jstr,Jend+1
            do i=Istr,Iend
              FE(i,j)=0.25_r8*(diff4(i,j,itrc)+diff4(i,j-1,itrc))*
     &                (Hz(i,j,k)+Hz(i,j-1,k))*om_v(i,j)*
     &                (dTde(i,j,k1)-
     &                 0.5_r8*(MIN(dZde(i,j,k1),0.0_r8)*
     &                            (dTdz(i,j-1,k1)+dTdz(i,j,k2))+
     &                         MAX(dZde(i,j,k1),0.0_r8)*
     &                            (dTdz(i,j-1,k2)+dTdz(i,j,k1))))
            enddo
          enddo
          if (k.lt.N) then
            do j=Jstr,Jend
              do i=Istr,Iend
                cff1=MIN(dZdx(i  ,j,k1),0.0_r8)
                cff2=MIN(dZdx(i+1,j,k2),0.0_r8)
                cff3=MAX(dZdx(i  ,j,k2),0.0_r8)
                cff4=MAX(dZdx(i+1,j,k1),0.0_r8)
                FS(i,j,k2)=0.5_r8*diff4(i,j,itrc)*
     &                     (cff1*(cff1*dTdz(i,j,k2)-dTdx(i  ,j,k1))+
     &                      cff2*(cff2*dTdz(i,j,k2)-dTdx(i+1,j,k2))+
     &                      cff3*(cff3*dTdz(i,j,k2)-dTdx(i  ,j,k2))+
     &                      cff4*(cff4*dTdz(i,j,k2)-dTdx(i+1,j,k1)))
                cff1=MIN(dZde(i,j  ,k1),0.0_r8)
                cff2=MIN(dZde(i,j+1,k2),0.0_r8)
                cff3=MAX(dZde(i,j  ,k2),0.0_r8)
                cff4=MAX(dZde(i,j+1,k1),0.0_r8)
                FS(i,j,k2)=FS(i,j,k2)+
     &                     0.5_r8*diff4(i,j,itrc)*
     &                     (cff1*(cff1*dTdz(i,j,k2)-dTde(i,j  ,k1))+
     &                      cff2*(cff2*dTdz(i,j,k2)-dTde(i,j+1,k2))+
     &                      cff3*(cff3*dTdz(i,j,k2)-dTde(i,j  ,k2))+
     &                      cff4*(cff4*dTdz(i,j,k2)-dTde(i,j+1,k1)))
              enddo
            enddo
          endif
!
! Time-step biharmonic, geopotential diffusion term.
!
          do j=Jstr,Jend
            do i=Istr,Iend
              t(i,j,k,nnew,itrc)=t(i,j,k,nnew,itrc)-
     &                           (dt*pm(i,j)*pn(i,j)*
     &                              (FX(i+1,j  )-FX(i,j)+
     &                               FE(i  ,j+1)-FE(i,j))+
     &                            dt*(FS(i,j,k2)-FS(i,j,k1)))
            enddo
          enddo
        endif
      enddo
#else
      subroutine t3dmix4_geo
#endif
      return
      end
