#include "cppdefs.h"
#if defined TS_DIF2 && defined MIX_S_TS && defined SOLVE3D
      subroutine t3dmix2_s (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine computes horizontal harmonic mixing of tracers    !
!  along S-coordinate levels surfaces.                               !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        itrc, tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (24)
# endif
      do itrc=1,NT
        call t3dmix2_s_tile (Istr,Iend,Jstr,Jend,itrc,
     &                       A2d(1,1),A2d(1,2))
      enddo
# ifdef PROFILE
      call wclock_off (24)
# endif
      return
      end
!
!*********************************************************************
      subroutine t3dmix2_s_tile (Istr,Iend,Jstr,Jend,itrc,FX,FE)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mask.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, itrc, j, k
      REAL_TYPE
     &          FE(PRIVATE_2D_SCRATCH_ARRAY),
     &          FX(PRIVATE_2D_SCRATCH_ARRAY)
!
# include "set_bounds.h"
!
      do k=1,N
!
!--------------------------------------------------------------------
!  Compute horizontal harmonic diffusion along constant S-surfaces.
!--------------------------------------------------------------------
!
!  Compute XI- and ETA-components of diffusive tracer flux (T m3/s).
!
        do j=Jstr,Jend
          do i=Istr,Iend+1
            FX(i,j)=0.25_r8*(diff2(i,j,itrc)+diff2(i-1,j,itrc))*
     &              (Hz(i,j,k)+Hz(i-1,j,k))*pmon_u(i,j)*
     &              (t(i,j,k,nrhs,itrc)-t(i-1,j,k,nrhs,itrc))
# ifdef MASKING
     &             *umask(i,j)
# endif
          enddo
        enddo
        do j=Jstr,Jend+1
          do i=Istr,Iend
            FE(i,j)=0.25_r8*(diff2(i,j,itrc)+diff2(i,j-1,itrc))*
     &              (Hz(i,j,k)+Hz(i,j-1,k))*pnom_v(i,j)*
     &              (t(i,j,k,nrhs,itrc)-t(i,j-1,k,nrhs,itrc))
# ifdef MASKING
     &             *vmask(i,j)
# endif
          enddo
        enddo
!
! Time-step harmonic, S-surfaces diffusion term.
!
        do j=Jstr,Jend
          do i=Istr,Iend
            t(i,j,k,nnew,itrc)=t(i,j,k,nnew,itrc)+
     &                         dt*pm(i,j)*pn(i,j)*
     &                            (FX(i+1,j)-FX(i,j)+
     &                             FE(i,j+1)-FE(i,j))
          enddo
        enddo
      enddo
#else
      subroutine t3dmix2_s
#endif
      return
      end
