#include "cppdefs.h"
#if defined TS_DIF2 && defined MIX_GEO_TS && defined SOLVE3D
      subroutine t3dmix2_geo (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine computes horizontal harmonic mixing of tracers    !
!  along geopotential surfaces.                                      !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        itrc, tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (25)
# endif
      do itrc=1,NT
        call t3dmix2_geo_tile (Istr,Iend,Jstr,Jend,itrc,
     &                         A2d(1, 1),A2d(1, 2),A2d(1, 3),A2d(1, 5),
     &                         A2d(1, 7),A2d(1, 9),A2d(1,11),A2d(1,13))
      enddo
# ifdef PROFILE
      call wclock_off (25)
# endif
      return
      end
!
!*********************************************************************
      subroutine t3dmix2_geo_tile (Istr,Iend,Jstr,Jend,itrc,FX,FE,FS,
     &                             dTdz,dTdx,dTde,dZdx,dZde)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mask.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, itrc, j, k, k1, k2
      REAL_TYPE
     &        cff, cff1, cff2, cff3, cff4
      REAL_TYPE
     &          FX(PRIVATE_2D_SCRATCH_ARRAY),
     &          FE(PRIVATE_2D_SCRATCH_ARRAY),
     &          FS(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        dTdz(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        dTdx(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        dTde(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        dZdx(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        dZde(PRIVATE_2D_SCRATCH_ARRAY,2)
!
# include "set_bounds.h"
!
!--------------------------------------------------------------------
!  Compute horizontal harmonic diffusion along geopotential surfaces.
!--------------------------------------------------------------------
!
!  Compute horizontal and vertical gradients.  Notice the recursive
!  blocking sequence.  The vertical placement of the gradients is:
!
!        dTdx,dTde(:,:,k1) k     rho-points
!        dTdx,dTde(:,:,k2) k+1   rho-points
!          FS,dTdz(:,:,k1) k-1/2   W-points
!          FS,dTdz(:,:,k2) k+1/2   W-points
!
      k2=1
      do k=0,N
        k1=k2
        k2=3-k1
        if (k.lt.N) then
          do j=Jstr,Jend
            do i=Istr,Iend+1
              cff=0.5_r8*(pm(i,j)+pm(i-1,j))
# ifdef MASKING
     &           *umask(i,j)
# endif
              dZdx(i,j,k2)=cff*(z_r(i,j,k+1)-z_r(i-1,j,k+1))
              dTdx(i,j,k2)=cff*(t(i  ,j,k+1,nrhs,itrc)-
     &                          t(i-1,j,k+1,nrhs,itrc))
            enddo
          enddo
          do j=Jstr,Jend+1
            do i=Istr,Iend
              cff=0.5_r8*(pn(i,j)+pn(i,j-1))
# ifdef MASKING
     &           *vmask(i,j)
# endif
              dZde(i,j,k2)=cff*(z_r(i,j,k+1)-z_r(i,j-1,k+1))
              dTde(i,j,k2)=cff*(t(i,j  ,k+1,nrhs,itrc)-
     &                          t(i,j-1,k+1,nrhs,itrc))
            enddo
          enddo
        endif
        if ((k.eq.0).or.(k.eq.N)) then
          do j=Jstr-1,Jend+1
            do i=Istr-1,Iend+1
              dTdz(i,j,k2)=0.0_r8
              FS(i,j,k2)=0.0_r8
            enddo
          enddo
        else
          do j=Jstr-1,Jend+1
            do i=Istr-1,Iend+1
              dTdz(i,j,k2)=(t(i,j,k+1,nrhs,itrc)-t(i,j,k,nrhs,itrc))/
     &                     (z_r(i,j,k+1)-z_r(i,j,k))
            enddo
          enddo
        endif
!
!  Compute components of the rotated tracer flux (T m3/s) along
!  geopotential surfaces.
!
        if (k.gt.0) then
          do j=Jstr,Jend
            do i=Istr,Iend+1
              FX(i,j)=0.25_r8*(diff2(i,j,itrc)+diff2(i-1,j,itrc))*
     &                (Hz(i,j,k)+Hz(i-1,j,k))*on_u(i,j)*
     &                (dTdx(i,j,k1)-
     &                 0.5_r8*(MIN(dZdx(i,j,k1),0.0_r8)*
     &                            (dTdz(i-1,j,k1)+dTdz(i,j,k2))+
     &                         MAX(dZdx(i,j,k1),0.0_r8)*
     &                            (dTdz(i-1,j,k2)+dTdz(i,j,k1))))
            enddo
          enddo
          do j=Jstr,Jend+1
            do i=Istr,Iend
              FE(i,j)=0.25_r8*(diff2(i,j,itrc)+diff2(i,j-1,itrc))*
     &                (Hz(i,j,k)+Hz(i,j-1,k))*om_v(i,j)*
     &                (dTde(i,j,k1)-
     &                 0.5_r8*(MIN(dZde(i,j,k1),0.0_r8)*
     &                            (dTdz(i,j-1,k1)+dTdz(i,j,k2))+
     &                         MAX(dZde(i,j,k1),0.0_r8)*
     &                            (dTdz(i,j-1,k2)+dTdz(i,j,k1))))
            enddo
          enddo
          if (k.lt.N) then
            do j=Jstr,Jend
              do i=Istr,Iend
                cff1=MIN(dZdx(i  ,j,k1),0.0_r8)
                cff2=MIN(dZdx(i+1,j,k2),0.0_r8)
                cff3=MAX(dZdx(i  ,j,k2),0.0_r8)
                cff4=MAX(dZdx(i+1,j,k1),0.0_r8)
                FS(i,j,k2)=0.5_r8*diff2(i,j,itrc)*
     &                     (cff1*(cff1*dTdz(i,j,k2)-dTdx(i  ,j,k1))+
     &                      cff2*(cff2*dTdz(i,j,k2)-dTdx(i+1,j,k2))+
     &                      cff3*(cff3*dTdz(i,j,k2)-dTdx(i  ,j,k2))+
     &                      cff4*(cff4*dTdz(i,j,k2)-dTdx(i+1,j,k1)))
                cff1=MIN(dZde(i,j  ,k1),0.0_r8)
                cff2=MIN(dZde(i,j+1,k2),0.0_r8)
                cff3=MAX(dZde(i,j  ,k2),0.0_r8)
                cff4=MAX(dZde(i,j+1,k1),0.0_r8)
                FS(i,j,k2)=FS(i,j,k2)+
     &                     0.5_r8*diff2(i,j,itrc)*
     &                     (cff1*(cff1*dTdz(i,j,k2)-dTde(i,j  ,k1))+
     &                      cff2*(cff2*dTdz(i,j,k2)-dTde(i,j+1,k2))+
     &                      cff3*(cff3*dTdz(i,j,k2)-dTde(i,j  ,k2))+
     &                      cff4*(cff4*dTdz(i,j,k2)-dTde(i,j+1,k1)))
              enddo
            enddo
          endif
!
! Time-step harmonic, geopotential diffusion term.
!
          do j=Jstr,Jend
            do i=Istr,Iend
              t(i,j,k,nnew,itrc)=t(i,j,k,nnew,itrc)+
     &                           dt*pm(i,j)*pn(i,j)*
     &                              (FX(i+1,j  )-FX(i,j)+
     &                               FE(i  ,j+1)-FE(i,j))+
     &                           dt*(FS(i,j,k2)-FS(i,j,k1))
            enddo
          enddo
        endif
      enddo
#else
      subroutine t3dmix2_geo
#endif
      return
      end
