#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine t3dbc_tile (Istr,Iend,Jstr,Jend,indx,itrc,grad)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine sets lateral boundary conditions for the ITRC-th  !
!  tracer field.                                                     !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "boundary.h"
# include "mask.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, indx, itrc, j, k
      REAL_TYPE
     &        Ce, Cx, cff, dTde, dTdt, dTdx, eps, tau
      REAL_TYPE
     &        grad(PRIVATE_2D_SCRATCH_ARRAY)
      parameter (eps=1.0_e8-20)
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
      Ce=0.0_r8
      Cx=0.0_r8
      cff=0.0_r8
      dTdx=0.0_r8
      dTde=0.0_r8
      dTdt=0.0_r8
      tau=0.0_r8
!
# ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the western edge.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE) then
!
#  if defined WEST_TRADIATION
!
!  Western edge, implicit upstream radiation condition.
!
        do k=1,N
          do j=Jstr,Jend+1
            grad(0,j)=(t(0,j,k,nstp,itrc)-t(0,j-1,k,nstp,itrc))
#   ifdef MASKING
     &               *vmask(0,j)
#   endif
            grad(1,j)=(t(1,j,k,nstp,itrc)-t(1,j-1,k,nstp,itrc))
#   ifdef MASKING
     &               *vmask(1,j)
#   endif
          enddo
          do j=Jstr,Jend
            dTdt=t(1,j,k,nstp,itrc)-t(1,j,k,indx,itrc)
            dTdx=t(1,j,k,nstp,itrc)-t(2,j,k,nstp,itrc)
#   ifdef WEST_TNUDGING
            tau=Tobc_out(iwest,itrc)
            if ((dTdt*dTdx).lt.0.0_r8) tau=Tobc_in(iwest,itrc)
            tau=tau*dt
#   endif
            if ((dTdt*dTdx).lt.0.0_r8) dTdt=0.0_r8
            if ((dTdt*(grad(1,j)+grad(1,j+1))).gt.0.0_r8) then
              dTde=grad(1,j  )
            else
              dTde=grad(1,j+1)
            endif
            cff=dTdt/MAX(dTdx*dTdx+dTde*dTde,eps)
            Cx=MIN(1.0_r8,cff*dTdx)
#   ifdef RADIATION_2D
            Ce=MIN(1.0_r8,MAX(cff*dTde,-1.0_r8))
#   else
            Ce=0.0_r8
#   endif
            t(0,j,k,indx,itrc)=((1.0_r8-Cx)*t(0,j,k,nstp,itrc)+
     &                           Cx*t(1,j,k,nstp,itrc )-
     &                           MAX(Ce,0.0_r8)*grad(0,j  )-
     &                           MIN(Ce,0.0_r8)*grad(0,j+1))
#   ifdef WEST_TNUDGING
     &                        +tau*(t_west(j,k,itrc)-
     &                              t(0,j,k,nstp,itrc))
#   endif
#   ifdef MASKING
            t(0,j,k,indx,itrc)=t(0,j,k,indx,itrc)*rmask(0,j)
#   endif
          enddo
        enddo
#  elif defined WEST_TCLAMPED
!
!  Western edge, clamped boundary condition.
!
        do k=1,N
          do j=Jstr,Jend
            t(0,j,k,indx,itrc)=t_west(j,k,itrc)
#   ifdef MASKING
     &                        *rmask(0,j)
#   endif
          enddo
        enddo
#  elif defined WEST_TGRADIENT
!
!  Western edge, gradient boundary condition.
!
        do k=1,N
          do j=Jstr,Jend
            t(0,j,k,indx,itrc)=t(1,j,k,indx,itrc)
#   ifdef MASKING
     &                        *rmask(0,j)
#   endif
          enddo
        enddo
#  else
!
!  Western edge, closed boundary condition.
!
        do k=1,N
          do j=Jstr,Jend
            t(0,j,k,indx,itrc)=t(1,j,k,indx,itrc)
#   ifdef MASKING
     &                        *rmask(0,j)
#   endif
          enddo
        enddo
#  endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the eastern edge.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
!
#  if defined EAST_TRADIATION
!
!  Eastern edge, implicit upstream radiation condition.
!
        do k=1,N
          do j=Jstr,Jend+1
           grad(Lm,j)=(t(Lm,j,k,nstp,itrc)-t(Lm,j-1,k,nstp,itrc))
#   ifdef MASKING
     &               *vmask(Lm,j)
#   endif
           grad(L ,j)=(t(L ,j,k,nstp,itrc)-t(L ,j-1,k,nstp,itrc))
#   ifdef MASKING
     &               *vmask(L ,j)
#   endif
          enddo
          do j=Jstr,Jend
            dTdt=t(Lm,j,k,nstp,itrc)-t(Lm,j,k,indx,itrc)
            dTdx=t(Lm,j,k,nstp,itrc)-t(Lm-1,j,k,nstp,itrc)
#   ifdef EAST_TNUDGING
            tau=Tobc_out(ieast,itrc)
            if ((dTdt*dTdx).lt.0.0_r8) tau=Tobc_in(ieast,itrc)
            tau=tau*dt
#   endif
            if ((dTdt*dTdx).lt.0.0_r8) dTdt=0.0_r8
            if ((dTdt*(grad(Lm,j)+grad(Lm,j+1))).gt.0.0_r8) then
              dTde=grad(Lm,j  )
            else
              dTde=grad(Lm,j+1)
            endif
            cff=dTdt/MAX(dTdx*dTdx+dTde*dTde,eps)
            Cx=MIN(1.0_r8,cff*dTdx)
#   ifdef RADIATION_2D
            Ce=MIN(1.0_r8,MAX(cff*dTde,-1.0_r8))
#   else
            Ce=0.0_r8
#   endif
            t(L,j,k,indx,itrc)=((1.0_r8-Cx)*t(L,j,k,nstp,itrc)+
     &                          Cx*t(Lm,j,k,nstp,itrc)-
     &                          MAX(Ce,0.0_r8)*grad(L,j  )-
     &                          MIN(Ce,0.0_r8)*grad(L,j+1))
#   ifdef EAST_TNUDGING
     &                        +tau*(t_east(j,k,itrc)-
     &                              t(L,j,k,nstp,itrc))
#   endif
#   ifdef MASKING
            t(L,j,k,indx,itrc)=t(L,j,k,indx,itrc)*rmask(L,j)
#   endif
          enddo
        enddo
#  elif defined EAST_TCLAMPED
!
!  Eastern edge, clamped boundary condition.
!
        do k=1,N
          do j=Jstr,Jend
            t(L,j,k,indx,itrc)=t_east(j,k,itrc)
#   ifdef MASKING
     &                        *rmask(L,j)
#   endif
          enddo
        enddo
#  elif defined EAST_TGRADIENT
!
!  Eastern edge, gradient boundary condition.
!
        do k=1,N
          do j=Jstr,Jend
            t(L,j,k,indx,itrc)=t(Lm,j,k,indx,itrc)
#   ifdef MASKING
     &                        *rmask(L,j)
#   endif
          enddo
        enddo
#  else
!
!  Eastern edge, closed boundary condition.
!
        do k=1,N
          do j=Jstr,Jend
            t(L,j,k,indx,itrc)=t(Lm,j,k,indx,itrc)
#   ifdef MASKING
     &                        *rmask(L,j)
#   endif
          enddo
        enddo
#  endif
      endif
# endif /* !EW_PERIODIC */
# ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the southern edge.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE) then
!
#  if defined SOUTH_TRADIATION
!
!  Southern edge, implicit upstream radiation condition.
!
        do k=1,N
          do i=Istr,Iend+1
            grad(i,1)=(t(i,1,k,nstp,itrc)-t(i-1,1,k,nstp,itrc))
#   ifdef MASKING
     &               *umask(i,1)
#   endif
            grad(i,0)=(t(i,0,k,nstp,itrc)-t(i-1,0,k,nstp,itrc))
#   ifdef MASKING
     &               *umask(i,0)
#   endif
          enddo
          do i=Istr,Iend
            dTdt=t(i,1,k,nstp,itrc)-t(i,1,k,indx,itrc)
            dTde=t(i,1,k,nstp,itrc)-t(i,2,k,nstp,itrc)
#   ifdef SOUTH_TNUDGING
            tau=Tobc_out(isouth,itrc)
            if ((dTdt*dTde).lt.0.0_r8) tau=Tobc_in(isouth,itrc)
            tau=tau*dt
#   endif
            if ((dTdt*dTde).lt.0.0_r8) dTdt=0.0_r8
            if ((dTdt*(grad(i,1)+grad(i+1,1))).gt.0.0_r8) then
              dTdx=grad(i  ,1)
            else
              dTdx=grad(i+1,1)
            endif
            cff=dTdt/MAX(dTdx*dTdx+dTde*dTde,eps)
#   ifdef RADIATION_2D
            Cx=MIN(1.0_r8,MAX(cff*dTdx,-1.0_r8))
#   else
            Cx=0.0_r8
#   endif
            Ce=MIN(1.0_r8,cff*dTde)
            t(i,0,k,indx,itrc)=((1.0_r8-Ce)*t(i,0,k,nstp,itrc)+
     &                          Ce*t(i,1,k,nstp,itrc )-
     &                          MAX(Cx,0.0_r8)*grad(i  ,0)-
     &                          MIN(Cx,0.0_r8)*grad(i+1,0))
#   ifdef SOUTH_TNUDGING
     &                        +tau*(t_south(i,k,itrc)-
     &                              t(i,0,k,nstp,itrc))
#   endif
#   ifdef MASKING
            t(i,0,k,indx,itrc)=t(i,0,k,indx,itrc)*rmask(i,0)
#   endif
          enddo
        enddo
#  elif defined SOUTH_TCLAMPED
!
!  Southern edge, clamped boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            t(i,0,k,indx,itrc)=t_south(i,k,itrc)
#   ifdef MASKING
     &                        *rmask(i,0)
#   endif
          enddo
        enddo
#  elif defined SOUTH_TGRADIENT
!
!  Southern edge, gradient boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            t(i,0,k,indx,itrc)=t(i,1,k,indx,itrc)
#   ifdef MASKING
     &                        *rmask(i,0)
#   endif
          enddo
        enddo
#  else
!
!  Southern edge, closed boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            t(i,0,k,indx,itrc)=t(i,1,k,indx,itrc)
#   ifdef MASKING
     &                        *rmask(i,0)
#   endif
          enddo
        enddo
#  endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the northern edge.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
!
#  if defined NORTH_TRADIATION
!
!  Northern edge, implicit upstream radiation condition.
!
        do k=1,N
          do i=Istr,Iend+1
            grad(i,Mm)=(t(i,Mm,k,nstp,itrc)-t(i-1,Mm,k,nstp,itrc))
#   ifdef MASKING
     &                *umask(i,Mm)
#   endif
            grad(i,M )=(t(i,M ,k,nstp,itrc)-t(i-1,M ,k,nstp,itrc))
#   ifdef MASKING
     &                *umask(i,M )
#   endif
          enddo
          do i=Istr,Iend
            dTdt=t(i,Mm,k,nstp,itrc)-t(i,Mm,k,indx,itrc)
            dTde=t(i,Mm,k,nstp,itrc)-t(i,Mm-1,k,nstp,itrc)
#   ifdef NORTH_TNUDGING
            tau=Tobc_out(inorth,itrc)
            if ((dTdt*dTde).lt.0.0_r8) tau=Tobc_in(inorth,itrc)
            tau=tau*dt
#   endif
            if ((dTdt*dTde).lt.0.0_r8) dTdt=0.0_r8
            if ((dTdt*(grad(i,Mm)+grad(i+1,Mm))).gt.0.0_r8) then
              dTdx=grad(i  ,Mm)
            else
              dTdx=grad(i+1,Mm)
            endif
            cff=dTdt/MAX(dTdx*dTdx+dTde*dTde,eps)
#   ifdef RADIATION_2D
            Cx=MIN(1.0_r8,MAX(cff*dTdx,-1.0_r8))
#   else
            Cx=0.0_r8
#   endif
            Ce=MIN(1.0_r8,cff*dTde)
            t(i,M,k,indx,itrc)=((1.0_r8-Ce)*t(i,M,k,nstp,itrc)+
     &                          Ce*t(i,Mm,k,nstp,itrc)-
     &                          MAX(Cx,0.0_r8)*grad(i  ,M)-
     &                          MIN(Cx,0.0_r8)*grad(i+1,M))
#   ifdef NORTH_TNUDGING
     &                        +tau*(t_north(i,k,itrc)-
     &                              t(i,M,k,nstp,itrc))
#   endif
#   ifdef MASKING
            t(i,M,k,indx,itrc)=t(i,M,k,indx,itrc)*rmask(i,M)
#   endif
          enddo
        enddo
#  elif defined NORTH_TCLAMPED
!
!  Northern edge, clamped boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            t(i,M,k,indx,itrc)=t_north(i,k,itrc)
#   ifdef MASKING
     &                        *rmask(i,M)
#   endif
          enddo
        enddo
#  elif defined NORTH_TGRADIENT
!
!  Northern edge, gradient boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            t(i,M,k,indx,itrc)=t(i,Mm,k,indx,itrc)
#   ifdef MASKING
     &                        *rmask(i,M)
#   endif
          enddo
        enddo
#  else
!
!  Northern edge, closed boundary condition.
!
        do k=1,N
          do i=Istr,Iend
            t(i,M,k,indx,itrc)=t(i,Mm,k,indx,itrc)
#   ifdef MASKING
     &                        *rmask(i,M)
#   endif
          enddo
        enddo
#  endif
      endif
# endif /* ! NS_PERIODIC */
# if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          t(0,0,k,indx,itrc)=0.5_r8*(t(1,0,k,indx,itrc)+
     &                               t(0,1,k,indx,itrc))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          t(L,0,k,indx,itrc)=0.5_r8*(t(Lm,0,k,indx,itrc)+
     &                               t(L ,1,k,indx,itrc))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          t(0,M,k,indx,itrc)=0.5_r8*(t(1,M ,k,indx,itrc)+
     &                               t(0,Mm,k,indx,itrc))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          t(L,M,k,indx,itrc)=0.5_r8*(t(Lm,M ,k,indx,itrc)+
     &                               t(L ,Mm,k,indx,itrc))
        enddo
      endif
# endif
#else
      subroutine t3dbc
#endif /* SOLVE3D */
      return
      end
