#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine stiffness (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine surveys the 3D grid in order to determine maximum    !
!  grid stiffness ratio:                                             !
!                                                                    !
!             z(i,j,k)-z(i-1,j,k)+z(i,j,k-1)-z(i-1,j,k-1)            !
!      r_x = ---------------------------------------------           !
!             z(i,j,k)+z(i-1,j,k)-z(i,j,k-1)-z(i-1,j,k-1)            !
!                                                                    !
!  This is done for diagnostic purposes and it does not affect the   !
!  computations.                                                     !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "tile.h"
!
      call stiffness_tile (Istr,Iend,Jstr,Jend)
      return
      end
!
!*********************************************************************
      subroutine stiffness_tile (Istr,Iend,Jstr,Jend)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "iounits.h"
# include "mask.h"
# include "scalars.h"
# include "wclock.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        NSUB, my_rx0, my_rx1
!
# include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Compute grid stiffness.
!---------------------------------------------------------------------
!
      my_rx0=0.0_r8
      my_rx1=0.0_r8
!
      do j=Jstr,Jend
        do i=IstrU,Iend
# ifdef MASKING
          if (umask(i,j).gt.0.0_r8) then
# endif
            my_rx0=MAX(my_rx0,ABS((z_w(i,j,0)-z_w(i-1,j,0))/
     &                            (z_w(i,j,0)+z_w(i-1,j,0))))
            do k=1,N
              my_rx1=MAX(my_rx1,ABS((z_w(i,j,k  )-z_w(i-1,j,k  )+
     &                               z_w(i,j,k-1)-z_w(i-1,j,k-1))/
     &                              (z_w(i,j,k  )+z_w(i-1,j,k  )-
     &                               z_w(i,j,k-1)-z_w(i-1,j,k-1))))
            enddo
# ifdef MASKING
          endif
# endif
        enddo
      enddo
      do j=JstrV,Jend
        do i=Istr,Iend
# ifdef MASKING
          if (vmask(i,j).gt.0.0_r8) then
# endif
            my_rx0=MAX(my_rx0,ABS((z_w(i,j,0)-z_w(i,j-1,0))/
     &                            (z_w(i,j,0)+z_w(i,j-1,0))))
            do k=1,N
              my_rx1=MAX(my_rx1,ABS((z_w(i,j,k  )-z_w(i,j-1,k  )+
     &                               z_w(i,j,k-1)-z_w(i,j-1,k-1))/
     &                              (z_w(i,j,k  )+z_w(i,j-1,k  )-
     &                               z_w(i,j,k-1)-z_w(i,j-1,k-1))))
            enddo
# ifdef MASKING
          endif
# endif
        enddo
      enddo
!
!  Compute global maximum stiffness.
!
      if (WESTERN_EDGE .and. EASTERN_EDGE .and.
     &    SOUTHERN_EDGE .and. NORTHERN_EDGE) then
        NSUB=0.5_r8
      else
        NSUB=FLOAT(NSUB_X*NSUB_E)-0.5_r8
      endif
      call my_setlock (lock)
      if (dia_count.lt.0.5_r8) then
        rx0=my_rx0
        rx1=my_rx1
      else
        rx0=MAX(rx0,my_rx0)
        rx1=MAX(rx1,my_rx1)
      endif
      dia_count=dia_count+1.0_r8
      if (dia_count.gt.NSUB) then
        dia_count=0.0_r8
        write(stdout,10) rx0, rx1
  10    format(/,' Maximum grid stiffness ratios:  rx0 = ',1pe14.6,
     &         ' (Beckmann and Haidvogel)',/,t34,'rx1 = ',1pe14.6,
     &         ' (Haney)',/)
      endif
      call my_unsetlock (lock)
#else
      subroutine stiffness
#endif
      return
      end
