#include "cppdefs.h"
      subroutine step_floats (Lstr,Lend)
!
!================================================== John M. Klinck ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine time-steps  simulated  floats  trajectories using a  !
!  fourth-order Milne predictor and fourth-order Hamming corrector.  !
!                                                                    !
!  Vertical diffusion is optionally represented by a random walk,    !
!  in which case a forward scheme is used for vertical displacement. !
!  The probability distribution for the vertical displacement is     !
!  Gaussian and includes a correction for the vertical gradient in   !
!  diffusion coefficient                                             !
!                                                                    !
! Reference:                                                         !
!                                                                    !
!  Hunter, J.R, P.D. Craig, and H.E. Philips, 1993: On the use of    !
!    random walk models with spatially variable diffusivity,         !
!    Journal of Computational Physics, 106, 366-376.                 !
!---------------------------------------------------------------------
!
      implicit none
#include "param.h"
#include "floats.h"
#include "grid.h"
#include "ncparam.h"
#include "ocean.h"
#include "scalars.h"
#ifdef FLOAT_VWALK
# include "mixing.h"
#endif
!
      INTEGER_TYPE
     &        Lstr, Lend
#ifdef FLOATS
      logical Lmask
      INTEGER_TYPE
     &        i, itrc, iflt
      REAL_TYPE
     &        cff1, cff2, cff3, cff4, xrhs, yrhs, zrhs
# ifdef FLOAT_VWALK
      INTEGER_TYPE
     &        ierr, iseed
      data iseed /149876/
# endif
      REAL_TYPE
     &        nudg(Mfloats)
# ifdef MASKING
      parameter (Lmask=.true.)
# else
      parameter (Lmask=.false.)
# endif
!
      itrc=0
      zrhs=0.0_r8
# ifdef PROFILE
!
!---------------------------------------------------------------------
! Turn on floats time wall clock.
!---------------------------------------------------------------------
!
      call wclock_on (10)
# endif
# if defined SOLVE3D && defined FLOAT_VWALK
!
!---------------------------------------------------------------------
! Compute nudging velocities for vertical random walk.
!---------------------------------------------------------------------
!
      do iflt=Lstr,Lend
         nudg(iflt)=0.0_r8
      enddo
      call interp_floats (Akt(START_2D_ARRAY,0,1),w3dvar,
     &                    Lstr,Lend,nf,ifakt,Lmask,nudg)
      call interp_floats (dAktdz(START_2D_ARRAY,1),r3dvar,
     &                    Lstr,Lend,nf,ifdak,Lmask,nudg)
      call nrng (iseed,nudg(Lstr),Lend-Lstr+1,ierr)
      do iflt=Lstr,Lend
        if (bounded(iflt)) then
          nudg(iflt)=SQRT(2.0_r8*MAX(track(ifakt,nf,iflt),0.0_r8)/dt)*
     &               nudg(iflt)+track(ifdak,nf,iflt)
        else
          nudg(iflt)=0.0_r8
        endif
      enddo
      call interp_floats (W(START_2D_ARRAY,0),-w3dvar,
     &                    Lstr,Lend,nf,izrhs,Lmask,nudg)
!
!  For now, use a forward time step for vertical position.
!
      do iflt=Lstr,Lend
        if (bounded(iflt)) then
          track(izgrd,nfp1,iflt)=track(izgrd,nf,iflt)+
     &                           dt*track(izrhs,nf,iflt)
        endif
      enddo
# endif
      do iflt=Lstr,Lend
        nudg(iflt)=0.0_r8
      enddo
!
!---------------------------------------------------------------------
!  Predictor step: compute first guess floats locations using a
!                  4th-order Milne time-stepping scheme.
!---------------------------------------------------------------------
!
      cff1=8.0_r8/3.0_r8
      cff2=4.0_r8/3.0_r8
      do iflt=Lstr,Lend
        if (bounded(iflt)) then
          track(ixgrd,nfp1,iflt)=track(ixgrd,nfm3,iflt)+
     &                           dt*(cff1*track(ixrhs,nf  ,iflt)-
     &                               cff2*track(ixrhs,nfm1,iflt)+
     &                               cff1*track(ixrhs,nfm2,iflt))
          track(iygrd,nfp1,iflt)=track(iygrd,nfm3,iflt)+
     &                           dt*(cff1*track(iyrhs,nf  ,iflt)-
     &                               cff2*track(iyrhs,nfm1,iflt)+
     &                               cff1*track(iyrhs,nfm2,iflt))
# if defined SOLVE3D && !defined FLOAT_VWALK
          track(izgrd,nfp1,iflt)=track(izgrd,nfm3,iflt)+
     &                           dt*(cff1*track(izrhs,nf  ,iflt)-
     &                               cff2*track(izrhs,nfm1,iflt)+
     &                               cff1*track(izrhs,nfm2,iflt))
# endif
        endif
      enddo
!
!---------------------------------------------------------------------
!  Calculate slopes at new time-step.
!---------------------------------------------------------------------
!
# ifdef SOLVE3D
      call interp_floats (u(START_2D_ARRAY,1,nnew),-u3dvar,
     &                    Lstr,Lend,nfp1,ixrhs,Lmask,nudg)
      call interp_floats (v(START_2D_ARRAY,1,nnew),-v3dvar,
     &                    Lstr,Lend,nfp1,iyrhs,Lmask,nudg)
#  if !defined FLOAT_VWALK
      call interp_floats (W(START_2D_ARRAY,0),-w3dvar,
     &                    Lstr,Lend,nfp1,izrhs,Lmask,nudg)
#  endif
# else
      call interp_floats (ubar(START_2D_ARRAY,knew),-u2dvar,
     &                    Lstr,Lend,nfp1,ixrhs,Lmask,nudg)
      call interp_floats (vbar(START_2D_ARRAY,knew),-v2dvar,
     &                    Lstr,Lend,nfp1,iyrhs,Lmask,nudg)
# endif /* SOLVE3D */
!
!---------------------------------------------------------------------
!  Corrector step: correct floats locations using a 4th-order
!                  Hamming time-stepping scheme.
!---------------------------------------------------------------------
!
      cff1=9.0_r8/8.0_r8
      cff2=1.0_r8/8.0_r8
      cff3=3.0_r8/8.0_r8
      cff4=6.0_r8/8.0_r8
      do iflt=Lstr,Lend
        if (bounded(iflt)) then
          track(ixgrd,nfp1,iflt)=cff1*track(ixgrd,nf  ,iflt)-
     &                           cff2*track(ixgrd,nfm2,iflt)+
     &                           dt*(cff3*track(ixrhs,nfp1,iflt)+
     &                               cff4*track(ixrhs,nf  ,iflt)-
     &                               cff3*track(ixrhs,nfm1,iflt))
          track(iygrd,nfp1,iflt)=cff1*track(iygrd,nf  ,iflt)-
     &                           cff2*track(iygrd,nfm2,iflt)+
     &                           dt*(cff3*track(iyrhs,nfp1,iflt)+
     &                               cff4*track(iyrhs,nf  ,iflt)-
     &                               cff3*track(iyrhs,nfm1,iflt))
# if defined SOLVE3D && !defined FLOAT_VWALK
          track(izgrd,nfp1,iflt)=cff1*track(izgrd,nf  ,iflt)-
     &                           cff2*track(izgrd,nfm2,iflt)+
     &                           dt*(cff3*track(izrhs,nfp1,iflt)+
     &                               cff4*track(izrhs,nf  ,iflt)-
     &                               cff3*track(izrhs,nfm1,iflt))
# endif
        endif
      enddo
!
!---------------------------------------------------------------------
!  Determine floats status.
!---------------------------------------------------------------------
!
# ifdef EW_PERIODIC
      do iflt=Lstr,Lend
        if (bounded(iflt)) then
          if (track(ixgrd,nfp1,iflt).gt.FLOAT(L)-0.5_r8) then
            track(ixgrd,nfp1,iflt)=track(ixgrd,nfp1,iflt)-FLOAT(Lm)
            track(ixgrd,nf  ,iflt)=track(ixgrd,nf  ,iflt)-FLOAT(Lm)
            track(ixgrd,nfm1,iflt)=track(ixgrd,nfm1,iflt)-FLOAT(Lm)
            track(ixgrd,nfm2,iflt)=track(ixgrd,nfm2,iflt)-FLOAT(Lm)
            track(ixgrd,nfm3,iflt)=track(ixgrd,nfm3,iflt)-FLOAT(Lm)
          elseif (track(ixgrd,nfp1,iflt).lt.0.5_r8) then
            track(ixgrd,nfp1,iflt)=FLOAT(Lm)+track(ixgrd,nfp1,iflt)
            track(ixgrd,nf  ,iflt)=FLOAT(Lm)+track(ixgrd,nf  ,iflt)
            track(ixgrd,nfm1,iflt)=FLOAT(Lm)+track(ixgrd,nfm1,iflt)
            track(ixgrd,nfm2,iflt)=FLOAT(Lm)+track(ixgrd,nfm2,iflt)
            track(ixgrd,nfm3,iflt)=FLOAT(Lm)+track(ixgrd,nfm3,iflt)
          endif
        endif
      enddo
# else
      do iflt=Lstr,Lend
        if (bounded(iflt)) then
          if ((track(ixgrd,nfp1,iflt).gt.FLOAT(L)-0.5_r8).or.
     &        (track(ixgrd,nfp1,iflt).lt.0.5_r8)) then
            bounded(iflt)=.false.
          endif
        endif
      enddo
# endif
# ifdef NS_PERIODIC
      do iflt=Lstr,Lend
        if (bounded(iflt)) then
          if (track(iygrd,nfp1,iflt).gt.FLOAT(M)-0.5_r8) then
            track(iygrd,nfp1,iflt)=track(iygrd,nfp1,iflt)-FLOAT(Mm)
            track(iygrd,nf  ,iflt)=track(iygrd,nf  ,iflt)-FLOAT(Mm)
            track(iygrd,nfm1,iflt)=track(iygrd,nfm1,iflt)-FLOAT(Mm)
            track(iygrd,nfm2,iflt)=track(iygrd,nfm2,iflt)-FLOAT(Mm)
            track(iygrd,nfm3,iflt)=track(iygrd,nfm3,iflt)-FLOAT(Mm)
          elseif (track(iygrd,nfp1,iflt).lt.0.5_r8) then
            track(iygrd,nfp1,iflt)=FLOAT(Mm)+track(iygrd,nfp1,iflt)
            track(iygrd,nf  ,iflt)=FLOAT(Mm)+track(iygrd,nf  ,iflt)
            track(iygrd,nfm1,iflt)=FLOAT(Mm)+track(iygrd,nfm1,iflt)
            track(iygrd,nfm2,iflt)=FLOAT(Mm)+track(iygrd,nfm2,iflt)
            track(iygrd,nfm3,iflt)=FLOAT(Mm)+track(iygrd,nfm3,iflt)
          endif
        endif
      enddo
# else
      do iflt=Lstr,Lend
        if (bounded(iflt)) then
          if ((track(iygrd,nfp1,iflt).gt.FLOAT(M)-0.5_r8).or.
     &        (track(iygrd,nfp1,iflt).lt.0.5_r8)) then
            bounded(iflt)=.false.
          endif
        endif
      enddo
# endif
!
!  Reflect floats at surface or bottom.
!
      do iflt=Lstr,Lend
        if (bounded(iflt)) then
          if (track(izgrd,nfp1,iflt).gt.FLOAT(N))
     &      track(izgrd,nfp1,iflt)=2.0_r8*FLOAT(N)-
     &                             track(izgrd,nfp1,iflt)
          if (track(izgrd,nfp1,iflt).lt.0.0_r8)
     &      track(izgrd,nfp1,iflt)=-track(izgrd,nfp1,iflt)
        endif
      enddo
!
!---------------------------------------------------------------------
!  If appropriate, activate the release of new floats and set initial
!  positions for all time levels.
!---------------------------------------------------------------------
!
      do iflt=Lstr,Lend
        if (.not.bounded(iflt).and.
     &      (time-dt.le.Tinfo(itstr,iflt).and.
     &       time+dt.gt.Tinfo(itstr,iflt))) then
          bounded(iflt)=.true.
          do i=0,NFT
            track(ixgrd,i,iflt)=Tinfo(ixgrd,iflt)
            track(iygrd,i,iflt)=Tinfo(iygrd,iflt)
            track(izgrd,i,iflt)=Tinfo(izgrd,iflt)
          enddo
        endif
      enddo
!
!---------------------------------------------------------------------
!  Calculate slopes with corrected locations.
!---------------------------------------------------------------------
!
# ifdef SOLVE3D
      call interp_floats (u(START_2D_ARRAY,1,nnew),-u3dvar,
     &                    Lstr,Lend,nfp1,ixrhs,Lmask,nudg)
      call interp_floats (v(START_2D_ARRAY,1,nnew),-v3dvar,
     &                    Lstr,Lend,nfp1,iyrhs,Lmask,nudg)
#  if !defined FLOAT_VWALK
      call interp_floats (W(START_2D_ARRAY,0),-w3dvar,
     &                    Lstr,Lend,nfp1,izrhs,Lmask,nudg)
#  endif
# else
      call interp_floats (ubar(START_2D_ARRAY,knew),-u2dvar,
     &                    Lstr,Lend,nfp1,ixrhs,Lmask,nudg)
      call interp_floats (vbar(START_2D_ARRAY,knew),-v2dvar,
     &                    Lstr,Lend,nfp1,iyrhs,Lmask,nudg)
# endif /* SOLVE3D */
!
!  If newly released floats, initialize slopes at all time levels.
!
      do iflt=Lstr,Lend
        if (bounded(iflt).and.
     &      (time-dt.le.Tinfo(itstr,iflt).and.
     &       time+dt.gt.Tinfo(itstr,iflt))) then
          xrhs=track(ixrhs,nfp1,iflt)
          yrhs=track(iyrhs,nfp1,iflt)
# ifdef SOLVE3D
          zrhs=track(izrhs,nfp1,iflt)
# endif
          do i=0,NFT
            track(ixrhs,i,iflt)=xrhs
            track(iyrhs,i,iflt)=yrhs
# ifdef SOLVE3D
            track(izrhs,i,iflt)=zrhs
# endif
          enddo
        endif
      enddo
!
!---------------------------------------------------------------------
!  Interpolate various output variables at the corrected locations.
!---------------------------------------------------------------------
!
      if (spherical) then
        call interp_floats (lonr(START_2D_ARRAY),r2dvar,
     &                      Lstr,Lend,nfp1,iflon,.false.,nudg)
        call interp_floats (latr(START_2D_ARRAY),r2dvar,
     &                      Lstr,Lend,nfp1,iflat,.false.,nudg)
      else
        call interp_floats (xr(START_2D_ARRAY),r2dvar,
     &                      Lstr,Lend,nfp1,iflon,.false.,nudg)
        call interp_floats (yr(START_2D_ARRAY),r2dvar,
     &                      Lstr,Lend,nfp1,iflat,.false.,nudg)
      endif
# ifdef SOLVE3D
      call interp_floats (z_w(START_2D_ARRAY,0),w3dvar,
     &                    Lstr,Lend,nfp1,idpth,Lmask,nudg)
      call interp_floats (rho(START_2D_ARRAY,1),r3dvar,
     &                    Lstr,Lend,nfp1,ifden,Lmask,nudg)
      do itrc=1,NT
        call interp_floats (t(START_2D_ARRAY,1,nnew,itrc),r3dvar,
     &                      Lstr,Lend,nfp1,itrc+10,Lmask,nudg)
      enddo
# endif /* SOLVE3D */
# ifdef PROFILE
!
!---------------------------------------------------------------------
! Turn off floats time wall clock.
!---------------------------------------------------------------------
!
      call wclock_off (10)
# endif
#endif /* FLOATS */
      return
      end

#ifdef FLOAT_VWALK
      subroutine urng (ix, x, n, ierr)
!
!=====================================================================
!                                                                    !
!  Uniform random-number generator from the NSWC Library             !
!                                                                    !
!  Uses the recursion ix = ix*a mod p, where 0 < ix < p              !
!                                                                    !
!  Written by Linus Schrage, University of Chicago. Adapted for NSWC !
!  Library by A. H. Morris. Modernised & included in ROMS by Mark    !
!  Hadfield, NIWA.                                                   !
!                                                                    !
!=====================================================================
!
      implicit none
!
      INTEGER_TYPE
     &        ix, n, ierr
      REAL_TYPE
     &        x(n)
!
      INTEGER_TYPE
     &        a, b15, b16, fhi, k, l, leftlo, p, xalo, xhi
      REAL_TYPE
     &        s
!
      parameter (a=16807)          ! 7^5
      parameter (b15=32768)        ! 2^15
      parameter (b16=65536)        ! 2^16
      parameter (p=2147483647)     ! 2^31-1
      parameter (s=0.465661_e8-09)
!
      if (n.le.0) then
        ierr=1
        return
      endif
      if ((ix.le.0).or.(ix.ge.p)) then
         ierr=2
         return
      endif
!
      ierr=0
!
      do l=1,n
!
! Get 15 high order bits of ix
!
        xhi=ix/b16
!
! Get 16 lower bits of ix and multiply with a
!
        xalo=(ix-xhi*b16)*a
!
! Get 15 high order bits of the product
!
        leftlo=xalo/b16
!
! Form the 31 highest bits of a*ix
!
        fhi=xhi*a+leftlo
!
! Obtain the overflow past the 31st bit of a*ix
!
        k=fhi/b15
!
! Assemble all the parts and presubtract p. The parentheses are
! essential.
!
        ix=(((xalo-leftlo*b16)-p)+(fhi-k*b15)*b16)+k
!
! Add p if necessary
!
        if (ix.lt.0) ix=ix+p
!
! Rescale ix, to interpret it as a value between 0 and 1.
! the scale factor s is selected to be as near 1/p as is
! appropriate in order that the floating value for ix = 1,
! namely s, be roughly the same distance from 0 as (p-1)*s
! is from 1. the current value for s assures us that x(l)
! is less than 1 for any floating point arithmetic of 6
! or more digits.
!
         x(l)=FLOAT(ix)*s
      enddo
      return
      end
      subroutine nrng (ix,a,n,ierr)
!
!=====================================================================
!                                                                    !
!  Gaussian random-number generator from the NSWC Library. It calls  !
!  the NSWC uniform random-number generator, URNG.                   !
!                                                                    !
!  Modernised & included in ROMS by Mark Hadfield, NIWA.             !
!                                                                    !
!=====================================================================
!
      implicit none
!
      INTEGER_TYPE
     &        ix, n, ierr
      REAL_TYPE
     &        a(n)
!
      INTEGER_TYPE
     &        i, m
      REAL_TYPE
     &        phi, pi2, r, temp(1)
      parameter (pi2=6.2831853071796_r8)
!
      call urng (ix,a,n,ierr)
!
      if (ierr.ne.0) return
!
      if (n.gt.1) then
        m=n/2
        m=m+m
        do i=1,m,2
          r=SQRT(-2.0_r8*LOG(a(i)))
          phi=pi2*a(i+1)
          a(i  )=r*COS(phi)
          a(i+1)=r*SIN(phi)
        enddo
         if (m.eq.n) return
      end if
!
      call urng (ix,temp,1,ierr)
!
      r=SQRT(-2.0_r8*LOG(a(n)))
!
      a(n)=r*COS(pi2*temp(1))
!
      return
      end
#endif
