#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine step3d_uv (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine  performs the timestep for the horizontal momentum   !
!  equations.  The vertical viscosity terms are time-stepped using   !
!  an implicit algorithm.                                            !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (34)
# endif
      call step3d_uv_tile (Istr,Iend,Jstr,Jend,
     &                     A2d(1,1),A2d(1,2),A2d(1,3),A2d(1,4),
     &                     A2d(1,5),A2d(1,6),A2d(1,7))
# ifdef PROFILE
      call wclock_off (34)
# endif
      return
      end
!
!*********************************************************************
      subroutine step3d_uv_tile (Istr,Iend,Jstr,Jend,AK,BC,CF,FC,DC,
     &                           Hzk,oHz)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "clima.h"
# include "coupling.h"
# include "forces.h"
# include "grid.h"
# include "mask.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
# include "sources.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
# ifdef UV_PSOURCE
      INTEGER_TYPE
     &        is
# endif
      REAL_TYPE
     &        cff, cff1, cff2
      REAL_TYPE
     &        AK(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        BC(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        CF(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        DC(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        FC(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       Hzk(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       oHz(PRIVATE_1D_SCRATCH_ARRAY,0:N)
!
# include "set_bounds.h"
!
      cff=0.0_r8
      cff1=0.0_r8
      cff2=0.0_r8
!
!---------------------------------------------------------------------
!  Time step momentum equation in the XI-direction.
!---------------------------------------------------------------------
!
      do j=Jstr,Jend
        do i=IstrU,Iend
          AK(i,0)=0.5_r8*(Akv(i-1,j,0)+Akv(i,j,0))
          do k=1,N
            AK(i,k)=0.5_r8*(Akv(i-1,j,k)+Akv(i,j,k))
            Hzk(i,k)=0.5_r8*(Hz(i-1,j,k)+Hz(i,j,k))
# ifdef SPLINES
            oHz(i,k)=1.0_r8/Hzk(i,k)
# endif
          enddo
          AK(i,N)=0.5_r8*(Akv(i-1,j,N)+Akv(i,j,N))
        enddo
!
!  Time step right-hand-side terms.
!
        if (iic.eq.ntfirst) then
          cff=0.25_r8*dt
        elseif (iic.eq.(ntfirst+1)) then
          cff=0.25_r8*dt*3.0_r8/2.0_r8
        else
          cff=0.25_r8*dt*23.0_r8/12.0_r8
        endif
        do i=IstrU,Iend
          DC(i,0)=cff*(pm(i,j)+pm(i-1,j))*(pn(i,j)+pn(i-1,j))
        enddo
        do k=1,N
          do i=IstrU,Iend
            u(i,j,k,nnew)=(u(i,j,k,nnew)+DC(i,0)*ru(i,j,k,nrhs))
# ifdef SPLINES
     &                   *oHz(i,k)
# endif
          enddo
        enddo
# ifdef SPLINES
!
!  Use conservative, parabolic spline reconstruction of vertical
!  viscosity derivatives.  Then, time step vertical viscosity term
!  implicitly.
!
        cff1=1.0_r8/6.0_r8
        do k=1,N-1
          do i=IstrU,Iend
            FC(i,k)=cff1*Hzk(i,k  )-dt*AK(i,k-1)*oHz(i,k  )
            CF(i,k)=cff1*Hzk(i,k+1)-dt*AK(i,k+1)*oHz(i,k+1)
          enddo
        enddo
        do i=IstrU,Iend
          CF(i,0)=0.0_r8
          DC(i,0)=0.0_r8
        enddo
!
        cff1=1.0_r8/3.0_r8
        do k=1,N-1
          do i=IstrU,Iend
            BC(i,k)=cff1*(Hzk(i,k)+Hzk(i,k+1))+
     &              dt*AK(i,k)*(oHz(i,k)+oHz(i,k+1))
            cff=1.0_r8/(BC(i,k)-FC(i,k)*CF(i,k-1))
            CF(i,k)=cff*CF(i,k)
            DC(i,k)=cff*(u(i,j,k+1,nnew)-u(i,j,k,nnew)-
     &                   FC(i,k)*DC(i,k-1))
          enddo
        enddo
!
        do i=IstrU,Iend
          DC(i,N)=0.0_r8
        enddo
        do k=N-1,1,-1
          do i=IstrU,Iend
            DC(i,k)=DC(i,k)-CF(i,k)*DC(i,k+1)
          enddo
        enddo
!
        do k=1,N
          do i=IstrU,Iend
            DC(i,k)=DC(i,k)*AK(i,k)
            u(i,j,k,nnew)=u(i,j,k,nnew)+
     &                    dt*oHz(i,k)*(DC(i,k)-DC(i,k-1))
          enddo
        enddo
# else
!
!  Compute off-diagonal coefficients [lambda*dt*Akv/Hz] for the
!  implicit vertical viscosity term at horizontal U-points and
!  vertical W-points.
!
        cff=-lambda*dt/0.5_r8
        do k=1,Nm
          do i=IstrU,Iend
            FC(i,k)=cff*AK(i,k)/(z_r(i,j,k+1)+z_r(i-1,j,k+1)-
     &                           z_r(i,j,k  )-z_r(i-1,j,k  ))
          enddo
        enddo
        do i=IstrU,Iend
          FC(i,0)=0.0_r8
          FC(i,N)=0.0_r8
        enddo
!
!  Solve the tridiagonal system.
!
        do k=1,N
          do i=IstrU,Iend
            DC(i,k)=u(i,j,k,nnew)
            BC(i,k)=Hzk(i,k)-FC(i,k)-FC(i,k-1)
          enddo
        enddo
        do i=IstrU,Iend
          cff=1.0_r8/BC(i,1)
          CF(i,1)=cff*FC(i,1)
          DC(i,1)=cff*DC(i,1)
        enddo
        do k=2,Nm
          do i=IstrU,Iend
            cff=1.0_r8/(BC(i,k)-FC(i,k-1)*CF(i,k-1))
            CF(i,k)=cff*FC(i,k)
            DC(i,k)=cff*(DC(i,k)-FC(i,k-1)*DC(i,k-1))
          enddo
        enddo
!
!  Compute new solution by back subtitution.
!
        do i=IstrU,Iend
          DC(i,N)=(DC(i,N)-FC(i,Nm)*DC(i,Nm))/
     &            (BC(i,N)-FC(i,Nm)*CF(i,Nm))
          u(i,j,N,nnew)=DC(i,N)
        enddo
        do k=Nm,1,-1
          do i=IstrU,Iend
            DC(i,k)=DC(i,k)-CF(i,k)*DC(i,k+1)
            u(i,j,k,nnew)=DC(i,k)
          enddo
        enddo
# endif /* !SPLINES */
!
!  Replace incorrect vertical mean with more accurate barotropic
!  component, ubar=DU_avg1/(D*on_u).  Recall that, D=CF(:,0).
!
        do i=IstrU,Iend
          CF(i,0)=Hzk(i,1)
          DC(i,0)=u(i,j,1,nnew)*Hzk(i,1)
        enddo
        do k=2,N
          do i=IstrU,Iend
            CF(i,0)=CF(i,0)+Hzk(i,k)
            DC(i,0)=DC(i,0)+u(i,j,k,nnew)*Hzk(i,k)
          enddo
        enddo
        do i=IstrU,Iend
          DC(i,0)=(DC(i,0)*on_u(i,j)-DU_avg1(i,j))/
     &            (CF(i,0)*on_u(i,j))
        enddo
!
!  Couple and update new solution.
!
        do k=1,N
          do i=IstrU,Iend
            u(i,j,k,nnew)=(u(i,j,k,nnew)-DC(i,0))
# ifdef MASKING
     &                   *umask(i,j)
# endif
          enddo
        enddo
!
!---------------------------------------------------------------------
!  Time step momentum equation in the ETA-direction.
!---------------------------------------------------------------------
!
        if (j.ge.JstrV) then
          do i=Istr,Iend
            AK(i,0)=0.5_r8*(Akv(i,j-1,0)+Akv(i,j,0))
            do k=1,N
              AK(i,k)=0.5_r8*(Akv(i,j-1,k)+Akv(i,j,k))
              Hzk(i,k)=0.5_r8*(Hz(i,j-1,k)+Hz(i,j,k))
# ifdef SPLINES
              oHz(i,k)=1.0_r8/Hzk(i,k)
# endif
            enddo
            AK(i,N)=0.5_r8*(Akv(i,j-1,N)+Akv(i,j,N))
          enddo
!
!  Time step right-hand-side terms.
!
          if (iic.eq.ntfirst) then
            cff=0.25_r8*dt
          elseif (iic.eq.(ntfirst+1)) then
            cff=0.25_r8*dt*3.0_r8/2.0_r8
          else
            cff=0.25_r8*dt*23.0_r8/12.0_r8
          endif
          do i=Istr,Iend
            DC(i,0)=cff*(pm(i,j)+pm(i,j-1))*(pn(i,j)+pn(i,j-1))
          enddo
          do k=1,N
            do i=Istr,Iend
              v(i,j,k,nnew)=(v(i,j,k,nnew)+DC(i,0)*rv(i,j,k,nrhs))
# ifdef SPLINES
     &                     *oHz(i,k)
# endif
            enddo
          enddo
# ifdef SPLINES
!
!  Use conservative, parabolic spline reconstruction of vertical
!  viscosity derivatives.  Then, time step vertical viscosity term
!  implicitly.
!
          cff1=1.0_r8/6.0_r8
          do k=1,N-1
            do i=Istr,Iend
              FC(i,k)=cff1*Hzk(i,k  )-dt*AK(i,k-1)*oHz(i,k  )
              CF(i,k)=cff1*Hzk(i,k+1)-dt*AK(i,k+1)*oHz(i,k+1)
            enddo
          enddo
          do i=Istr,Iend
            CF(i,0)=0.0_r8
            DC(i,0)=0.0_r8
          enddo
!
          cff1=1.0_r8/3.0_r8
          do k=1,N-1
            do i=Istr,Iend
              BC(i,k)=cff1*(Hzk(i,k)+Hzk(i,k+1))+
     &                dt*AK(i,k)*(oHz(i,k)+oHz(i,k+1))
              cff=1.0_r8/(BC(i,k)-FC(i,k)*CF(i,k-1))
              CF(i,k)=cff*CF(i,k)
              DC(i,k)=cff*(v(i,j,k+1,nnew)-v(i,j,k,nnew)-
     &                     FC(i,k)*DC(i,k-1))
            enddo
          enddo
!
          do i=Istr,Iend
            DC(i,N)=0.0_r8
          enddo
          do k=N-1,1,-1
            do i=Istr,Iend
              DC(i,k)=DC(i,k)-CF(i,k)*DC(i,k+1)
            enddo
          enddo
!
          do k=1,N
            do i=Istr,Iend
              DC(i,k)=DC(i,k)*AK(i,k)
              v(i,j,k,nnew)=v(i,j,k,nnew)+
     &                      dt*oHz(i,k)*(DC(i,k)-DC(i,k-1))
            enddo
          enddo
# else
!
!  Compute off-diagonal coefficients [lambda*dt*Akv/Hz] for the
!  implicit vertical viscosity term at horizontal V-points and
!  vertical W-points.
!
          cff=-lambda*dt/0.5_r8
          do k=1,Nm
            do i=Istr,Iend
              FC(i,k)=cff*AK(i,k)/(z_r(i,j,k+1)+z_r(i,j-1,k+1)-
     &                             z_r(i,j,k  )-z_r(i,j-1,k  ))
            enddo
          enddo
          do i=Istr,Iend
            FC(i,0)=0.0_r8
            FC(i,N)=0.0_r8
          enddo
!
!  Solve the tridiagonal system.
!
          do k=1,N
            do i=Istr,Iend
              DC(i,k)=v(i,j,k,nnew)
              BC(i,k)=Hzk(i,k)-FC(i,k)-FC(i,k-1)
            enddo
          enddo
          do i=Istr,Iend
            cff=1.0_r8/BC(i,1)
            CF(i,1)=cff*FC(i,1)
            DC(i,1)=cff*DC(i,1)
          enddo
          do k=2,Nm
            do i=Istr,Iend
              cff=1.0_r8/(BC(i,k)-FC(i,k-1)*CF(i,k-1))
              CF(i,k)=cff*FC(i,k)
              DC(i,k)=cff*(DC(i,k)-FC(i,k-1)*DC(i,k-1))
            enddo
          enddo
!
!  Compute new solution by back subtitution.
!
          do i=Istr,Iend
            DC(i,N)=(DC(i,N)-FC(i,Nm)*DC(i,Nm))/
     &              (BC(i,N)-FC(i,Nm)*CF(i,Nm))
            v(i,j,N,nnew)=DC(i,N)
          enddo
          do k=Nm,1,-1
            do i=Istr,Iend
              DC(i,k)=DC(i,k)-CF(i,k)*DC(i,k+1)
              v(i,j,k,nnew)=DC(i,k)
            enddo
          enddo
# endif /* !SPLINES */
!
!  Replace incorrect vertical mean with more accurate barotropic
!  component, vbar=DV_avg1/(D*om_v).  Recall that, D=CF(:,0).
!
          do i=Istr,Iend
            CF(i,0)=Hzk(i,1)
            DC(i,0)=v(i,j,1,nnew)*Hzk(i,1)
          enddo
          do k=2,N
            do i=Istr,Iend
              CF(i,0)=CF(i,0)+Hzk(i,k)
              DC(i,0)=DC(i,0)+v(i,j,k,nnew)*Hzk(i,k)
            enddo
          enddo
          do i=Istr,Iend
            DC(i,0)=(DC(i,0)*om_v(i,j)-DV_avg1(i,j))/
     &              (CF(i,0)*om_v(i,j))
          enddo
!
!  Couple and update new solution.
!
          do k=1,N
            do i=Istr,Iend
              v(i,j,k,nnew)=(v(i,j,k,nnew)-DC(i,0))
# ifdef MASKING
     &                     *vmask(i,j)
# endif
            enddo
          enddo
        endif
      enddo
!
!---------------------------------------------------------------------
! Set lateral boundary conditions.
!---------------------------------------------------------------------
!
      call u3dbc_tile (Istr,Iend,Jstr,Jend,DC)
      call v3dbc_tile (Istr,Iend,Jstr,Jend,DC)
# if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_u3d_tile (Istr,Iend,Jstr,Jend,
     &                        u(START_2D_ARRAY,1,nnew))
      call exchange_v3d_tile (Istr,Iend,Jstr,Jend,
     &                        v(START_2D_ARRAY,1,nnew))
# endif
# ifdef UV_PSOURCE
!
!---------------------------------------------------------------------
! Apply mass point sources.
!---------------------------------------------------------------------
!
      do is=1,Nsrc
        i=Isrc(is)
        j=Jsrc(is)
        if (INT(Dsrc(is)).eq.0) then
          if (((Istr.le.i).and.(i.le.Iend+1)).and.
     &        ((Jstr.le.j).and.(j.le.Jend))) then
            do k=1,N
              u(i,j,k,nnew)=Qsrc(is,k)/
     &                      (on_u(i,j)*
     &                       0.5_r8*(z_w(i-1,j,k)-z_w(i-1,j,k-1)+
     &                               z_w(i  ,j,k)-z_w(i  ,j,k-1)))
            enddo
          endif
        else
          if (((Istr.le.i).and.(i.le.Iend)).and.
     &        ((Jstr.le.j).and.(j.le.Jend+1))) then
            do k=1,N
                v(i,j,k,nnew)=Qsrc(is,k)/
     &                        (om_v(i,j)*
     &                         0.5_r8*(z_w(i,j-1,k)-z_w(i,j-1,k-1)+
     &                                 z_w(i,j  ,k)-z_w(i,j  ,k-1)))
            enddo
          endif
        endif
      enddo
# endif /* UV_PSOURCE */
!
!---------------------------------------------------------------------
!  Couple 2D and 3D momentum equations.
!---------------------------------------------------------------------
!
# ifdef EW_PERIODIC
#  define IU_RANGE Istr,Iend
#  define IV_RANGE Istr,Iend
# else
#  define IU_RANGE Istr,IendR
#  define IV_RANGE IstrR,IendR
# endif
# ifdef NS_PERIODIC
#  define JU_RANGE Jstr,Jend
#  define JV_RANGE Jstr,Jend
# else
#  define JU_RANGE JstrR,JendR
#  define JV_RANGE Jstr,JendR
# endif
!
!  Couple velocity component in the XI-direction.
!
      do j=JU_RANGE
        do i=IU_RANGE
          DC(i,0)=0.0_r8
          CF(i,0)=0.0_r8
          FC(i,0)=0.0_r8
        enddo
!
!  Compute thicknesses of U-boxes DC(i,1:N), total depth of the water
!  column DC(i,0), and incorrect vertical mean CF(i,0).  Notice that
!  barotropic component is replaced with its fast-time averaged
!  values.
!
        do k=1,N
          do i=IU_RANGE
            DC(i,k)=0.5_r8*(Hz(i,j,k)+Hz(i-1,j,k))*on_u(i,j)
            DC(i,0)=DC(i,0)+DC(i,k)
            CF(i,0)=CF(i,0)+DC(i,k)*u(i,j,k,nnew)
          enddo
        enddo
        do i=IU_RANGE
          DC(i,0)=1.0_r8/DC(i,0)
          CF(i,0)=DC(i,0)*(CF(i,0)-DU_avg1(i,j))
          ubar(i,j,1)=DC(i,0)*DU_avg1(i,j)
          ubar(i,j,2)=ubar(i,j,1)
        enddo
!
!  Replace incorrect vertical mean with more accurate barotropic
!  component, ubar=DU_avg1/(D*on_u).  Recall that, D=CF(:,0).
!
        do k=N,1,-1
          do i=IU_RANGE
            u(i,j,k,nnew)=(u(i,j,k,nnew)-CF(i,0))
# ifdef MASKING
     &                   *umask(i,j)
# endif
            Huon(i,j,k)=0.5_r8*(Huon(i,j,k)+u(i,j,k,nnew)*DC(i,k))
            FC(i,0)=FC(i,0)+Huon(i,j,k)
          enddo
        enddo
!
!  Compute correct mass flux, Hz*u/n.
!
        do i=IU_RANGE
          FC(i,0)=DC(i,0)*(FC(i,0)-DU_avg2(i,j))
        enddo
        do k=1,N
          do i=IU_RANGE
            Huon(i,j,k)=Huon(i,j,k)-DC(i,k)*FC(i,0)
          enddo
        enddo
!
!  Couple velocity component in the ETA-direction.
!
        if (j.ge.Jstr) then
          do i=IV_RANGE
            DC(i,0)=0.0_r8
            CF(i,0)=0.0_r8
            FC(i,0)=0.0_r8
          enddo
!
!  Compute thicknesses of V-boxes DC(i,1:N), total depth of the water
!  column DC(i,0), and incorrect vertical mean CF(i,0).  Notice that
!  barotropic component is replaced with its fast-time averaged
!  values.
!
          do k=1,N
            do i=IV_RANGE
              DC(i,k)=0.5_r8*(Hz(i,j,k)+Hz(i,j-1,k))*om_v(i,j)
              DC(i,0)=DC(i,0)+DC(i,k)
              CF(i,0)=CF(i,0)+DC(i,k)*v(i,j,k,nnew)
            enddo
          enddo
          do i=IV_RANGE
            DC(i,0)=1.0_r8/DC(i,0)
            CF(i,0)=DC(i,0)*(CF(i,0)-DV_avg1(i,j))
            vbar(i,j,1)=DC(i,0)*DV_avg1(i,j)
            vbar(i,j,2)=vbar(i,j,1)
          enddo
!
!  Replace incorrect vertical mean with more accurate barotropic
!  component, vbar=DV_avg1/(D*om_v).  Recall that, D=CF(:,0).
!
          do k=N,1,-1
            do i=IV_RANGE
              v(i,j,k,nnew)=(v(i,j,k,nnew)-CF(i,0))
# ifdef MASKING
     &                     *vmask(i,j)
# endif
              Hvom(i,j,k)=0.5_r8*(Hvom(i,j,k)+v(i,j,k,nnew)*DC(i,k))
              FC(i,0)=FC(i,0)+Hvom(i,j,k)
            enddo
          enddo
!
!  Compute correct mass flux, Hz*v/m.
!
          do i=IV_RANGE
            FC(i,0)=DC(i,0)*(FC(i,0)-DV_avg2(i,j))
          enddo
          do k=1,N
            do i=IV_RANGE
              Hvom(i,j,k)=Hvom(i,j,k)-DC(i,k)*FC(i,0)
            enddo
          enddo
        endif
      enddo
# undef IU_RANGE
# undef JU_RANGE
# undef IV_RANGE
# undef JV_RANGE
!
# if defined EW_PERIODIC || defined NS_PERIODIC
!
!  Apply periodic boundaries conditions to mass fluxes and barotropic
!  velocity components, if so prescribed.
!
      call exchange_u3d_tile (Istr,Iend,Jstr,Jend,Huon)
      call exchange_v3d_tile (Istr,Iend,Jstr,Jend,Hvom)
!
      call exchange_u2d_tile (Istr,Iend,Jstr,Jend,
     &                        ubar(START_2D_ARRAY,1))
      call exchange_u2d_tile (Istr,Iend,Jstr,Jend,
     &                        ubar(START_2D_ARRAY,2))
      call exchange_v2d_tile (Istr,Iend,Jstr,Jend,
     &                        vbar(START_2D_ARRAY,1))
      call exchange_v2d_tile (Istr,Iend,Jstr,Jend,
     &                        vbar(START_2D_ARRAY,2))
# endif
#else
      subroutine step3d_uv
#endif
      return
      end
