#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine step3d_t (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine time-steps tracer equations. Notice that avective    !
!  and diffusive terms are time-steped differently.                  !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (35)
# endif
      call step3d_t_tile (Istr,Iend,Jstr,Jend,
     &                    A2d(1,1),A2d(1,2),A2d(1,3),A2d(1,4),
     &                    A2d(1,1),A2d(1,2),A2d(1,3),A2d(1,4),
     &                    A2d(1,5))
# ifdef PROFILE
      call wclock_off (35)
# endif
      return
      end
!
!*********************************************************************
      subroutine step3d_t_tile (Istr,Iend,Jstr,Jend,grad,curv,
     &                          FX,FE,FC,CF,BC,DC,oHz)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "clima.h"
# include "forces.h"
# include "grid.h"
# include "mask.h"
# include "mixing.h"
# include "ncparam.h"
# include "obs.h"
# include "ocean.h"
# include "scalars.h"
# include "sources.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, itrc, j, k, ltrc
# ifdef TS_PSOURCE
      INTEGER_TYPE
     &        is
# endif
      REAL_TYPE
     &        cff, cff1, cff2, cff3, eps
      REAL_TYPE
     &          CF(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &          BC(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &          DC(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &          FC(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &         oHz(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &          FE(PRIVATE_2D_SCRATCH_ARRAY),
     &          FX(PRIVATE_2D_SCRATCH_ARRAY),
     &        curv(PRIVATE_2D_SCRATCH_ARRAY),
     &        grad(PRIVATE_2D_SCRATCH_ARRAY)
      parameter (eps=1.0_e8-16)
!
# include "set_bounds.h"
!
      cff=0.0_r8
      cff1=0.0_r8
      cff2=0.0_r8
      cff3=0.0_r8
# ifdef SEDIMENT
!    
!---------------------------------------------------------------------
!  Compute sediment Source and Sink terms.
!---------------------------------------------------------------------
!
      call sediment_tile (Istr,Iend,Jstr,Jend)    
# endif /* SEDIMENT */
!
!---------------------------------------------------------------------
!  Time-step horizontal advection term.
!---------------------------------------------------------------------
!
      do itrc=1,NT
        do k=1,N
# ifdef TS_C2HADVECTION
          do j=Jstr,Jend
            do i=Istr,Iend+1
              FX(i,j)=Huon(i,j,k)*
     &                0.5_r8*(t(i-1,j,k,3,itrc)+t(i,j,k,3,itrc))
            enddo
          enddo
          do j=Jstr,Jend+1
            do i=Istr,Iend
              FE(i,j)=Hvom(i,j,k)*
     &                0.5_r8*(t(i,j-1,k,3,itrc)+t(i,j,k,3,itrc))
            enddo
          enddo
# else
#  ifdef EW_PERIODIC
#   define I_RANGE Istr-1,Iend+2
#  else
#   define I_RANGE MAX(Istr-1,1),MIN(Iend+2,Lm+1)
#  endif
          do j=Jstr,Jend
            do i=I_RANGE
              FX(i,j)=(t(i,j,k,3,itrc)-t(i-1,j,k,3,itrc))
#  ifdef MASKING
     &               *umask(i,j)
#  endif
            enddo
          enddo
#  undef I_RANGE
#  ifndef EW_PERIODIC
          if (WESTERN_EDGE) then
            do j=Jstr,Jend
              FX(Istr-1,j)=FX(Istr,j)
            enddo
          endif
          if (EASTERN_EDGE) then
            do j=Jstr,Jend
              FX(Iend+2,j)=FX(Iend+1,j)
            enddo
          endif
#  endif
!
          do j=Jstr,Jend
            do i=Istr-1,Iend+1
#  if defined TS_U3HADVECTION
              curv(i,j)=FX(i+1,j)-FX(i,j)
#  elif defined TS_A4HADVECTION
              cff=2.0_r8*FX(i+1,j)*FX(i,j)
              if (cff.gt.eps) then
                grad(i,j)=cff/(FX(i+1,j)+FX(i,j))
              else
                grad(i,j)=0.0_r8
              endif
#  else
              grad(i,j)=0.5_r8*(FX(i+1,j)+FX(i,j))
#  endif
            enddo
          enddo
!
          cff1=1.0_r8/6.0_r8
          cff2=1.0_r8/3.0_r8
          do j=Jstr,Jend
            do i=Istr,Iend+1
#  ifdef TS_U3HADVECTION
              FX(i,j)=Huon(i,j,k)*0.5_r8*
     &                (t(i-1,j,k,3,itrc)+t(i,j,k,3,itrc))-
     &                cff1*(curv(i-1,j)*MAX(Huon(i,j,k),0.0_r8)+
     &                      curv(i  ,j)*MIN(Huon(i,j,k),0.0_r8))
#  else
              FX(i,j)=Huon(i,j,k)*0.5_r8*
     &                (t(i-1,j,k,3,itrc)+t(i,j,k,3,itrc)-
     &                 cff2*(grad(i,j)-grad(i-1,j)))
#  endif
            enddo
          enddo
!
#  ifdef NS_PERIODIC
#   define J_RANGE Jstr-1,Jend+2
#  else
#   define J_RANGE MAX(Jstr-1,1),MIN(Jend+2,Mm+1)
#  endif
          do j=J_RANGE
            do i=Istr,Iend
              FE(i,j)=(t(i,j,k,3,itrc)-t(i,j-1,k,3,itrc))
#  ifdef MASKING
     &               *vmask(i,j)
#  endif
            enddo
          enddo
#  undef J_RANGE
#  ifndef NS_PERIODIC
          if (SOUTHERN_EDGE) then
            do i=Istr,Iend
              FE(i,Jstr-1)=FE(i,Jstr)
            enddo
          endif
          if (NORTHERN_EDGE) then
            do i=Istr,Iend
              FE(i,Jend+2)=FE(i,Jend+1)
            enddo
          endif
#  endif
!
          do j=Jstr-1,Jend+1
            do i=Istr,Iend
#  if defined TS_U3HADVECTION
              curv(i,j)=FE(i,j+1)-FE(i,j)
#  elif defined TS_A4HADVECTION
              cff=2.0_r8*FE(i,j+1)*FE(i,j)
              if (cff.gt.eps) then
                grad(i,j)=cff/(FE(i,j+1)+FE(i,j))
              else
                grad(i,j)=0.0_r8
              endif
#  else
              grad(i,j)=0.5_r8*(FE(i,j+1)+FE(i,j))
#  endif
            enddo
          enddo
!
          cff1=1.0_r8/6.0_r8
          cff2=1.0_r8/3.0_r8
          do j=Jstr,Jend+1
            do i=Istr,Iend
#  ifdef TS_U3HADVECTION
              FE(i,j)=Hvom(i,j,k)*0.5_r8*
     &                (t(i,j-1,k,3,itrc)+t(i,j,k,3,itrc))-
     &                cff1*(curv(i,j-1)*MAX(Hvom(i,j,k),0.0_r8)+
     &                      curv(i,j  )*MIN(Hvom(i,j,k),0.0_r8))
#  else
              FE(i,j)=Hvom(i,j,k)*0.5_r8*
     &                (t(i,j-1,k,3,itrc)+t(i,j,k,3,itrc)-
     &                 cff2*(grad(i,j)-grad(i,j-1)))
#  endif
            enddo
          enddo
# endif
# ifdef TS_PSOURCE
!
!  Apply tracers point sources to the horizontal advection terms.
!
          do is=1,Nsrc
            i=Isrc(is)
            j=Jsrc(is)
            if ((INT(Dsrc(is)).eq.0).and.(Lsrc(is,itrc))) then
              if (((Istr.le.i).and.(i.le.Iend+1)).and.
     &            ((Jstr.le.j).and.(j.le.Jend))) then
                FX(i,j)=Huon(i,j,k)*Tsrc(is,k,itrc)
              endif
            elseif ((INT(Dsrc(is)).eq.1).and.(Lsrc(is,itrc))) then
              if (((Istr.le.i).and.(i.le.Iend)).and.
     &            ((Jstr.le.j).and.(j.le.Jend+1))) then
                FE(i,j)=Hvom(i,j,k)*Tsrc(is,k,itrc)
              endif
            endif
          enddo
# endif /* TS_PSOURCE */
!
!  Time-step horizontal advection term.
!
          do j=Jstr,Jend
            do i=Istr,Iend
              t(i,j,k,nnew,itrc)=t(i,j,k,nnew,itrc)-
     &                           dt*(FX(i+1,j)-FX(i,j)+
     &                               FE(i,j+1)-FE(i,j))*
     &                           pm(i,j)*pn(i,j)
            enddo
          enddo
        enddo
      enddo
!
!---------------------------------------------------------------------
!  Time-step vertical advection term.
!---------------------------------------------------------------------
!
      do j=Jstr,Jend
        do itrc=1,NT
          ltrc=MIN(NAT,itrc)
# ifdef TS_SVADVECTION
!
!  Build conservative parabolic splines for the vertical derivatives
!  "FC" of the tracer.  Then, the interfacial "FC" values are
!  converted to vertical advective fluxes.
!
            do i=Istr,Iend
#  ifdef NEUMANN
              FC(i,0)=1.5_r8*t(i,j,1,3,itrc)
              CF(i,1)=0.5_r8
#  else
              FC(i,0)=2.0_r8*t(i,j,1,3,itrc)
              CF(i,1)=1.0_r8
#  endif
            enddo
            do k=1,N-1
              do i=Istr,Iend
                cff=1.0_r8/(2.0_r8*Hz(i,j,k)+
     &                      Hz(i,j,k+1)*(2.0_r8-CF(i,k)))
                CF(i,k+1)=cff*Hz(i,j,k)
                FC(i,k)=cff*(3.0_r8*(Hz(i,j,k  )*t(i,j,k+1,3,itrc)+
     &                               Hz(i,j,k+1)*t(i,j,k  ,3,itrc))-
     &                       Hz(i,j,k+1)*FC(i,k-1))
              enddo
            enddo
            do i=Istr,Iend
#  ifdef NEUMANN
              FC(i,N)=(3.0_r8*t(i,j,N,3,itrc)-FC(i,N-1))/
     &                (2.0_r8-CF(i,N))
#  else
              FC(i,N)=(2.0_r8*t(i,j,N,3,itrc)-FC(i,N-1))/
     &                (1.0_r8-CF(i,N))
#  endif
            enddo
            do k=N-1,0,-1
              do i=Istr,Iend
                FC(i,k)=FC(i,k)-CF(i,k+1)*FC(i,k+1)
                FC(i,k+1)=W(i,j,k+1)*FC(i,k+1)
              enddo
            enddo
            do i=Istr,Iend
              FC(i,N)=0.0_r8
              FC(i,0)=0.0_r8
            enddo
# elif defined TS_A4VADVECTION
            do k=1,N-1
              do i=Istr,Iend
                FC(i,k)=t(i,j,k+1,3,itrc)-t(i,j,k,3,itrc)
              enddo
            enddo
            do i=Istr,Iend
              FC(i,0)=FC(i,1)
              FC(i,N)=FC(i,N-1)
            enddo
            do k=1,N
              do i=Istr,Iend
                cff=2.0_r8*FC(i,k)*FC(i,k-1)
                if (cff.gt.eps) then
                  CF(i,k)=cff/(FC(i,k)+FC(i,k-1))
                else
                  CF(i,k)=0.0_r8
                endif
              enddo
            enddo
            cff1=1.0_r8/3.0_r8
            do k=1,N-1
              do i=Istr,Iend
                FC(i,k)=W(i,j,k)*
     &                  0.5_r8*(t(i,j,k  ,3,itrc)+
     &                          t(i,j,k+1,3,itrc)-
     &                          cff1*(CF(i,k+1)-CF(i,k)))
              enddo
            enddo
            do i=Istr,Iend
              FC(i,0)=0.0_r8
              FC(i,N)=0.0_r8
            enddo
# elif defined TS_C2VADVECTION
            do k=1,Nm
              do i=Istr,Iend
                FC(i,k)=W(i,j,k)*
     &                  0.5_r8*(t(i,j,k  ,3,itrc)+
     &                          t(i,j,k+1,3,itrc))
              enddo
            enddo
            do i=Istr,Iend
              FC(i,0)=0.0_r8
              FC(i,N)=0.0_r8
            enddo
# else
            cff1=0.5_r8
            cff2=7.0_r8/12.0_r8
            cff3=1.0_r8/12.0_r8
            do k=2,N-2
              do i=Istr,Iend
                FC(i,k)=W(i,j,k)*(cff2*(t(i,j,k  ,3,itrc)+
     &                                  t(i,j,k+1,3,itrc))-
     &                            cff3*(t(i,j,k-1,3,itrc)+
     &                                  t(i,j,k+2,3,itrc)))
              enddo
            enddo
            do i=Istr,Iend
              FC(i,0  )=0.0_r8
              FC(i,1  )=W(i,j,1  )*(cff1*t(i,j,1  ,3,itrc)+
     &                              cff2*t(i,j,2  ,3,itrc)-
     &                              cff3*t(i,j,3  ,3,itrc))
              FC(i,N-1)=W(i,j,N-1)*(cff1*t(i,j,N  ,3,itrc)+
     &                              cff2*t(i,j,N-1,3,itrc)-
     &                              cff3*t(i,j,N-2,3,itrc))
              FC(i,N  )=0.0_r8
            enddo
# endif
!
!  Time-step vertical advection term.
!
          do i=Istr,Iend
            CF(i,0)=dt*pm(i,j)*pn(i,j)
          enddo
          do k=1,N
            do i=Istr,Iend
              t(i,j,k,nnew,itrc)=(t(i,j,k,nnew,itrc)-
     &                            CF(i,0)*(FC(i,k)-FC(i,k-1)))
# ifdef SPLINES
     &                          /Hz(i,j,k)
# endif
            enddo
          enddo
!
!---------------------------------------------------------------------
!  Time-step vertical diffusion term.
!---------------------------------------------------------------------
# ifdef SPLINES
!
!  Use conservative, parabolic spline reconstruction of vertical
!  diffusion derivatives.  Then, time step vertical diffusion term
!  implicitly.
!
          do k=1,N
            do i=Istr,Iend
              oHz(i,k)=1.0_r8/Hz(i,j,k)
            enddo
          enddo
!
          cff1=1.0_r8/6.0_r8
          do k=1,N-1
            do i=Istr,Iend
              FC(i,k)=cff1*Hz(i,j,k  )-dt*Akt(i,j,k-1,ltrc)*oHz(i,k  )
              CF(i,k)=cff1*Hz(i,j,k+1)-dt*Akt(i,j,k+1,ltrc)*oHz(i,k+1)
            enddo
          enddo
          do i=Istr,Iend
            CF(i,0)=0.0_r8
            DC(i,0)=0.0_r8
          enddo
!
          cff1=1.0_r8/3.0_r8
          do k=1,N-1
            do i=Istr,Iend
              BC(i,k)=cff1*(Hz(i,j,k)+Hz(i,j,k+1))+
     &                dt*Akt(i,j,k,ltrc)*(oHz(i,k)+oHz(i,k+1))
              cff=1.0_r8/(BC(i,k)-FC(i,k)*CF(i,k-1))
              CF(i,k)=cff*CF(i,k)
              DC(i,k)=cff*(t(i,j,k+1,nnew,itrc)-t(i,j,k,nnew,itrc)-
     &                     FC(i,k)*DC(i,k-1))
            enddo
          enddo
!
          do i=Istr,Iend
            DC(i,N)=0.0_r8
          enddo
          do k=N-1,1,-1
            do i=Istr,Iend
              DC(i,k)=DC(i,k)-CF(i,k)*DC(i,k+1)
            enddo
          enddo
!
          do k=1,N
            do i=Istr,Iend
              DC(i,k)=DC(i,k)*Akt(i,j,k,ltrc)
              t(i,j,k,nnew,itrc)=t(i,j,k,nnew,itrc)+
     &                           dt*oHz(i,k)*(DC(i,k)-DC(i,k-1))
            enddo
          enddo
# else
!
!  Compute off-diagonal coefficients FC [lambda*dt*Akt/Hz] for the
!  implicit vertical diffusion terms at future time step, located
!  at horizontal RHO-points and vertical W-points.
!  Also set FC at the top and bottom levels.
!
          cff=-dt*lambda
          do k=1,N-1
            do i=Istr,Iend
              FC(i,k)=cff*Akt(i,j,k,ltrc)/(z_r(i,j,k+1)-z_r(i,j,k))
            enddo
          enddo
          do i=Istr,Iend
            FC(i,0)=0.0_r8
            FC(i,N)=0.0_r8
          enddo
!
!  Compute diagonal matrix coefficients BC and load right-hand-side
!  terms for the tracer equation into DC.
!
          do k=1,N
            do i=Istr,Iend
              BC(i,k)=Hz(i,j,k)-FC(i,k)-FC(i,k-1)
              DC(i,k)=t(i,j,k,nnew,itrc)
            enddo
          enddo
!
!  Solve the tridiagonal system.
!
          do i=Istr,Iend
            cff=1.0_r8/BC(i,1)
            CF(i,1)=cff*FC(i,1)
            DC(i,1)=cff*DC(i,1)
          enddo
          do k=2,Nm
            do i=Istr,Iend
              cff=1.0_r8/(BC(i,k)-FC(i,k-1)*CF(i,k-1))
              CF(i,k)=cff*FC(i,k)
              DC(i,k)=cff*(DC(i,k)-FC(i,k-1)*DC(i,k-1))
            enddo
          enddo
          do i=Istr,Iend
             DC(i,N)=(DC(i,N)-FC(i,N-1)*DC(i,N-1))/
     &               (BC(i,N)-FC(i,N-1)*CF(i,N-1))
             t(i,j,N,nnew,itrc)=DC(i,N)
          enddo
          do k=Nm,1,-1
            do i=Istr,Iend
              DC(i,k)=DC(i,k)-CF(i,k)*DC(i,k+1)
              t(i,j,k,nnew,itrc)=DC(i,k)
            enddo
          enddo
# endif /* !SPLINES */
        enddo
      enddo
!
!---------------------------------------------------------------------
!  Apply lateral boundary conditions and, if appropriate, nudge
!  to tracer data and apply Land/Sea mask.
!---------------------------------------------------------------------
!
      do itrc=1,NT
!
!  Set lateral boundary conditions.
!
        call t3dbc_tile (Istr,Iend,Jstr,Jend,nnew,itrc,grad)
# if defined BIOLOGY || defined SEDIMENT
      enddo
!
!  Apply interactive part of the biological module.
!
#  ifdef BIOLOGY
      call biology_tile (Istr,Iend,Jstr,Jend)
#  endif
#  ifdef SEDIMENT
!!    call sediment_tile (Istr,Iend,Jstr,Jend)    
#  endif
      do itrc=1,NT
# endif /* BIOLOGY */
# if defined TCLM_NUDGING && defined TCLIMATOLOGY
!
!  Nudge towards tracer climatology.
!
        do k=1,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              t(i,j,k,nnew,itrc)=t(i,j,k,nnew,itrc)+
     &                           dt*Tnudgcof(i,j,itrc)*
     &                           (tclm(i,j,k,itrc)-t(i,j,k,nnew,itrc))
            enddo
          enddo
        enddo
# endif /* TCLM_NUDGING && TCLIMATOLOGY */
# if defined NUDGING_SST || defined NUDGING_T
!
!  Assimilate tracer observations via nudging.
!
        if (update_T(itrc)) then
          do k=1,N
            do j=JstrR,JendR
              do i=IstrR,IendR
                cff=MIN(1.0_r8,MAX(0.0_r8,EobsT(i,j,k,itrc)))
                cff=dt*Tnudass(itrc)*(1.0_r8-cff)
                t(i,j,k,nnew,itrc)=t(i,j,k,nnew,itrc)+
     &                             cff*(Tobs(i,j,k,itrc)-
     &                                  t(i,j,k,nnew,itrc))
              enddo
            enddo
          enddo
        endif
# endif /* NUDGING_SST || NUDGING_T */
# ifdef MASKING
!
!  Apply Land/Sea mask.
!
        do k=1,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              t(i,j,k,nnew,itrc)=t(i,j,k,nnew,itrc)*rmask(i,j)
            enddo
          enddo
        enddo
# endif /* MASKING */
# if defined EW_PERIODIC || defined NS_PERIODIC
!
!  Apply periodic boundary conditions.
!
        call exchange_r3d_tile (Istr,Iend,Jstr,Jend,
     &                          t(START_2D_ARRAY,1,nnew,itrc))
# endif
      enddo
# if defined FLOATS && defined FLOAT_VWALK
!
!  Compute vertical gradient in vertical T-diffusion coefficient for
!  floats random walk.
!
      do j=Jstr,Jend
        do i=Istr,Iend
          do k=1,N
            dAktdz(i,j,k)=(Akt(i,j,k,1)-Akt(i,j,k-1,1))/Hz(i,j,k)
          enddo
        enddo
      enddo
# endif
#else
      subroutine step3d_t
#endif
      return
      end
