#if defined UV_PSOURCE || defined TS_PSOURCE

/*
** Include file "sources.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Dsrc       Direction of point Sources/Sinks:                     **
**              Dsrc(:) = 0,  Along XI-direction.                   **
**              Dsrc(:) > 0,  Along ETA-direction.                  **
** Fsrc       Point Source/Sinks identification flag:               **
**              Fsrc(:) = 0,  All Tracer source/sink are off.       **
**              Fsrc(:) = 1,  Only temperature is on.               **
**              Fsrc(:) = 2,  Only salinity is on.                  **
**              Fsrc(:) = 3,  Both temperature and salinity are on. **
** Isrc       I-grid location of point Sources/Sinks,               **
**              1 =< Isrc =< L.                                     **
** Jsrc       J-grid location of point Sources/Sinks,               **
**              1 =< Jsrc =< M.                                     **
** Lsrc       Logical switch indicating which tracer field to apply **
**              the point Sources/Sinks.                            **
** Nsrc       Number of point Sources/Sinks.                        **
** Qbar       Vertically integrated mass transport (m3/s) of point  **
**              Sources/Sinks at U- or V-points:                    **
**              Qbar -> positive, if the mass transport is in the   **
**                      positive U- or V-direction.                 **
**              Qbar -> negative, if the mass transport is in the   **
**                      negative U- or V-direction.                 **
** QbarG      Latest two-time snapshots of vertically integrated    **
**              mass transport (m3/s) of point Sources/Sinks.       **
** Qshape     Nondimensional shape function to distribute mass      **
**              mass point Sources/Sinks vertically.                **
** Qsrc       Mass transport profile (m3/s) of point Sources/Sinks. **
** Tsrc       Tracer (tracer units) point Sources/Sinks.            **
** TsrcG      Latest two-time snapshots of tracer (tracer units)    **
**              point Sources/Sinks.                                **
**                                                                  **
**********************************************************************
*/

      common /lsources/
     &        Lsrc
      logical
     &        Lsrc(Msrc,NT)

      common /isources/
     &        Isrc,              Jsrc,              Nsrc
      INTEGER_TYPE
     &        Isrc(Msrc),        Jsrc(Msrc),        Nsrc

      common /fsources1/
     &        Dsrc,              Fsrc,              Qbar,
     &        Qshape,            Qsrc,              Tsrc,
     &        Xsrc,              Ysrc
      REAL_TYPE
     &        Dsrc(Msrc),        Fsrc(Msrc),        Qbar(Msrc),
     &        Qshape(Msrc,N),    Qsrc(Msrc,N),      Tsrc(Msrc,N,NT),
     &        Xsrc(Msrc),        Ysrc(Msrc)

# ifndef ANA_PSOURCE
      common /fsources2/
     &        QbarG,             TsrcG
      REAL_TYPE
     &        QbarG(Msrc,2),     TsrcG(Msrc,N,2,NT)
# endif

#endif /* UV_PSOURCE || TS_PSOURCE */
