#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine set_vbc (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine sets vertical boundary conditons for momentum and    !
!  tracers.                                                          !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (6)
# endif
      call set_vbc_tile (Istr,Iend,Jstr,Jend,
     &                   A2d(1,1))
# ifdef PROFILE
      call wclock_off (6)
# endif
      return
      end
!
!********************************************************************
      subroutine set_vbc_tile (Istr,Iend,Jstr,Jend,wrk)
!********************************************************************
!
      implicit none
# include "param.h"
# include "forces.h"
# include "grid.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, itrc
      REAL_TYPE
     &        cff
      REAL_TYPE
     &        wrk(PRIVATE_2D_SCRATCH_ARRAY)
!
# include "set_bounds.h"
!
      i=0
      j=0
      itrc=0
      cff=0.0_r8
# ifdef QCORRECTION
!
!---------------------------------------------------------------------
!  Add in flux correction to surface net heat flux (degC m/s).
!---------------------------------------------------------------------
!
! Add in net heat flux correction.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          stflx(i,j,itemp)=stflx(i,j,itemp)+
     &                     dqdt(i,j)*(t(i,j,N,nrhs,itemp)-sst(i,j))
        enddo
      enddo
# endif /* QCORRECTION */
# ifdef SALINITY
!
!---------------------------------------------------------------------
!  Multiply fresh water flux with surface salinity. If appropriate,
!  apply correction.
!---------------------------------------------------------------------
!
      do j=JstrR,JendR
        do i=IstrR,IendR
#  if defined SCORRECTION
          stflx(i,j,isalt)=stflx(i,j,isalt)*t(i,j,N,nrhs,isalt)-
     &                     Tnudg(isalt)*Hz(i,j,N)*
     &                     (t(i,j,N,nrhs,isalt)-sss(i,j))
#  elif defined SRELAXATION
          stflx(i,j,isalt)=-Tnudg(isalt)*Hz(i,j,N)*
     &                     (t(i,j,N,nrhs,isalt)-sss(i,j))
#  else
          stflx(i,j,isalt)=stflx(i,j,isalt)*t(i,j,N,nrhs,isalt)
#  endif
          btflx(i,j,isalt)=btflx(i,j,isalt)*t(i,j,1,nrhs,isalt)
        enddo
      enddo
# endif /* SALINITY */
# ifdef ICESHELF
!
!---------------------------------------------------------------------
!  If ice shelf cavities, zero out for now the surface tracer flux
!  over the ice.
!---------------------------------------------------------------------
!
      do itrc=1,NT
        do j=JstrR,JendR
          do i=IstrR,IendR
            if (zice(i,j).ne.0.0_r8) then
              stflx(i,j,itrc)=0.0_r8
            endif
          enddo
        enddo
      enddo
#  ifdef SHORTWAVE
      do j=JstrR,JendR
        do i=IstrR,IendR
          if (zice(i,j).ne.0.0_r8) then
            srflx(i,j)=0.0_r8
          endif
        enddo
      enddo
#  endif /* SHORTWAVE */
!
!---------------------------------------------------------------------
!  If ice shelf cavities, replace surface wind stress with ice shelf
!  cavity stress (m2/s2).
!---------------------------------------------------------------------
!
      if (Zob.ne.0.0_r8) then
        do j=JstrV-1,Jend
          do i=IstrU-1,Iend
            cff=vonKar/LOG((z_w(i,j,N)-z_r(i,j,N))/Zob)
            wrk(i,j)=MIN(Cdb_max,MAX(Cdb_min,cff*cff))
          enddo
        enddo
        do j=Jstr,Jend
          do i=IstrU,Iend
            if (zice(i,j)*zice(i-1,j).ne.0.0_r8) then
              cff=0.25_r8*(v(i  ,j,N,nrhs)+v(i  ,j+1,N,nrhs)+
     &                     v(i-1,j,N,nrhs)+v(i-1,j+1,N,nrhs))
              sustr(i,j)=-0.5_r8*(wrk(i-1,j)+wrk(i,j))*u(i,j,N,nrhs)*
     &                   SQRT(u(i,j,N,nrhs)*u(i,j,N,nrhs)+cff*cff)
            endif
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            if (zice(i,j)*zice(i,j-1).ne.0.0_r8) then
              cff=0.25_r8*(u(i,j  ,N,nrhs)+u(i+1,j  ,N,nrhs)+
     &                     u(i,j-1,N,nrhs)+u(i+1,j-1,N,nrhs))
              svstr(i,j)=-0.5_r8*(wrk(i,j-1)+wrk(i,j))*v(i,j,N,nrhs)*
     &                   SQRT(cff*cff+v(i,j,N,nrhs)*v(i,j,N,nrhs))
            endif
          enddo
        enddo
      elseif (rdrg2.ne.0.0_r8) then
        do j=Jstr,Jend
          do i=IstrU,Iend
            if (zice(i,j)*zice(i-1,j).ne.0.0_r8) then
              cff=0.25_r8*(v(i  ,j,N,nrhs)+v(i  ,j+1,N,nrhs)+
     &                     v(i-1,j,N,nrhs)+v(i-1,j+1,N,nrhs))
              sustr(i,j)=-rdrg2*u(i,j,N,nrhs)*
     &                   SQRT(u(i,j,N,nrhs)*u(i,j,N,nrhs)+cff*cff)
            endif
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            if (zice(i,j)*zice(i,j-1).ne.0.0_r8) then
              cff=0.25_r8*(u(i,j  ,N,nrhs)+u(i+1,j  ,N,nrhs)+
     &                     u(i,j-1,N,nrhs)+u(i+1,j-1,N,nrhs))
              svstr(i,j)=-rdrg2*v(i,j,N,nrhs)*
     &                   SQRT(cff*cff+v(i,j,N,nrhs)*v(i,j,N,nrhs))
            endif
          enddo
        enddo
      elseif (rdrg.ne.0.0_r8) then
        do j=Jstr,Jend
          do i=IstrU,Iend
            if (zice(i,j)*zice(i-1,j).ne.0.0_r8) then
              sustr(i,j)=-rdrg*u(i,j,N,nrhs)
            endif
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            if (zice(i,j)*zice(i,j-1).ne.0.0_r8) then
              svstr(i,j)=-rdrg*v(i,j,N,nrhs)
            endif
          enddo
        enddo
      else
        do j=Jstr,Jend
          do i=IstrU,Iend
            if (zice(i,j)*zice(i-1,j).ne.0.0_r8) then
              sustr(i,j)=0.0_r8
            endif
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            if (zice(i,j)*zice(i,j-1).ne.0.0_r8) then
              svstr(i,j)=0.0_r8
            endif
          enddo
        enddo
      endif
!
!  Apply periodic or gradient boundary conditions for output
!  purposes only.
!
      call fill_u2d_tile (Istr,Iend,Jstr,Jend,sustr(START_2D_ARRAY))
      call fill_v2d_tile (Istr,Iend,Jstr,Jend,svstr(START_2D_ARRAY))
# endif /* ICESHELF */
# ifndef BBL
!
!---------------------------------------------------------------------
!  Set kinematic bottom momentum flux (m2/s2).
!---------------------------------------------------------------------
!
!  Set bottom stress using linear and/or quadratic formulation.
!
      if (Zob.ne.0.0_r8) then
        do j=JstrV-1,Jend
          do i=IstrU-1,Iend
            cff=vonKar/LOG((z_r(i,j,1)-z_w(i,j,0))/Zob)
            wrk(i,j)=MIN(Cdb_max,MAX(Cdb_min,cff*cff))
          enddo
        enddo
        do j=Jstr,Jend
          do i=IstrU,Iend
            cff=0.25_r8*(v(i  ,j,1,nrhs)+v(i  ,j+1,1,nrhs)+
     &                   v(i-1,j,1,nrhs)+v(i-1,j+1,1,nrhs))
            bustr(i,j)=0.5_r8*(wrk(i-1,j)+wrk(i,j))*u(i,j,1,nrhs)*
     &                 SQRT(u(i,j,1,nrhs)*u(i,j,1,nrhs)+cff*cff)
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            cff=0.25_r8*(u(i,j  ,1,nrhs)+u(i+1,j,1,nrhs)+
     &                   u(i,j-1,1,nrhs)+u(i+1,j-1,1,nrhs))
            bvstr(i,j)=0.5_r8*(wrk(i,j-1)+wrk(i,j))*v(i,j,1,nrhs)*
     &                 SQRT(cff*cff+v(i,j,1,nrhs)*v(i,j,1,nrhs))
          enddo
        enddo
      elseif (rdrg2.ne.0.0_r8) then
        do j=Jstr,Jend
          do i=IstrU,Iend
            cff=0.25_r8*(v(i  ,j,1,nrhs)+v(i  ,j+1,1,nrhs)+
     &                   v(i-1,j,1,nrhs)+v(i-1,j+1,1,nrhs))
            bustr(i,j)=rdrg2*u(i,j,1,nrhs)*
     &                 SQRT(u(i,j,1,nrhs)*u(i,j,1,nrhs)+cff*cff)
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            cff=0.25_r8*(u(i,j  ,1,nrhs)+u(i+1,j,1,nrhs)+
     &                   u(i,j-1,1,nrhs)+u(i+1,j-1,1,nrhs))
            bvstr(i,j)=rdrg2*v(i,j,1,nrhs)*
     &                 SQRT(cff*cff+v(i,j,1,nrhs)*v(i,j,1,nrhs))
          enddo
        enddo
      elseif (rdrg.ne.0.0_r8) then
        do j=Jstr,Jend
          do i=IstrU,Iend
            bustr(i,j)=rdrg*u(i,j,1,nrhs)
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            bvstr(i,j)=rdrg*v(i,j,1,nrhs)
          enddo
        enddo
      endif
!
!  Apply periodic or gradient boundary conditions for output
!  purposes only.
!
      call fill_u2d_tile (Istr,Iend,Jstr,Jend,bustr(START_2D_ARRAY))
      call fill_v2d_tile (Istr,Iend,Jstr,Jend,bvstr(START_2D_ARRAY))
# endif /* BBL */
#else
      subroutine set_vbc
#endif
      return
      end
