#include "cppdefs.h"
      subroutine set_scoord
#ifdef SOLVE3D
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
! This routine sets and initializes relevant variables associated    !
! with the vertical transformation to nondimensional S-coordinate.   !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "grid.h"
#include "iounits.h"
#include "scalars.h"
!
      INTEGER_TYPE
     &        k
      REAL_TYPE
     &        cff, cff1, cff2, cff3
!
!---------------------------------------------------------------------
!  Define S-Curves in domain [-1 < sc < 0] at vertical W- and
!  RHO-points.
!---------------------------------------------------------------------
!
      hc=MIN(hmin,Tcline)
      cff1=1.0_r8/SINH(theta_s)
      cff2=0.5_r8/TANH(0.5_r8*theta_s)
      sc_w(0)=-1.0_r8
      Cs_w(0)=-1.0_r8
      cff=1.0_r8/FLOAT(N)
      do k=1,N
        sc_w(k)=cff*FLOAT(k-N)
        Cs_w(k)=(1.0_r8-theta_b)*cff1*SINH(theta_s*sc_w(k))+
     &          theta_b*(cff2*TANH(theta_s*(sc_w(k)+0.5_r8))-0.5_r8)
        sc_r(k)=cff*(FLOAT(k-N)-0.5_r8)
        Cs_r(k)=(1.0_r8-theta_b)*cff1*SINH(theta_s*sc_r(k))+
     &          theta_b*(cff2*TANH(theta_s*(sc_r(k)+0.5_r8))-0.5_r8)
      enddo
!
!---------------------------------------------------------------------
!  Report information about vertical S-levels.
!---------------------------------------------------------------------
!
      write(stdout,10)
  10  format(/,' Vertical S-coordinate System: ',/,/,
     &         ' level   S-coord     Cs-curve',10x,
     &         'at_hmin  over_slope     at_hmax',/)
      do k=N,0,-1
        cff1=sc_w(k)*hc+(hmin-hc)*Cs_w(k)
        cff2=sc_w(k)*hc+(0.5*(hmin+hmax)-hc)*Cs_w(k)
        cff3=sc_w(k)*hc+(hmax-hc)*Cs_w(k)
        write(stdout,20) k, sc_w(k), Cs_w(k), cff1, cff2, cff3
  20    format(I6,2F12.7,4x,3F12.3 )
      enddo
#endif /* SOLVE3D */
      return
      end
