#include "cppdefs.h"
#ifdef NUDGING_COFF
      subroutine set_nudgcof (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine set nudging coefficients time-scales (1/s).          !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
      call set_nudgcof_tile (Istr,Iend,Jstr,Jend,
     &                       A2d(1,1))
      return
      end
!
!*********************************************************************
      subroutine set_nudgcof_tile (Istr,Iend,Jstr,Jend,wrk)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "boundary.h"
# include "clima.h"
# include "grid.h"
# include "ncparam.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Iwrk, Jstr, Jend, i, itrc, j
      REAL_TYPE
     &        cff1, cff2, cff3
      REAL_TYPE
     &        wrk(PRIVATE_2D_SCRATCH_ARRAY)

!
# include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Set up nudging towards data time-scale coefficients (1/s).
!---------------------------------------------------------------------
!
!  Initialize.
!
      Iwrk=0
      itrc=0
      cff1=0.0_r8
      cff2=0.0_r8
      cff3=0.0_r8
      do j=JstrR,JendR
        do i=IstrR,IendR
          wrk(i,j)=0.0_r8
        enddo
      enddo
!
# if defined ADRIATIC1 || defined ADRIATIC2
      cff1=1.0_r8/(3.0_r8*86400.0_r8)
      cff2=1.0_r8/(30.0_r8*86400.0_r8)
      do j=JstrR,MIN(6,JendR)
        do i=IstrR,IendR
          wrk(i,j)=cff2+FLOAT(6-j)*(cff1-cff2)/6.0_r8
        enddo
      enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
#  ifdef TCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Tnudgcof(i,j,itemp)=wrk(i,j)
          Tnudgcof(i,j,isalt)=wrk(i,j)
        enddo
      enddo
#  endif
# elif defined CALCOFI
      cff1=1.0_r8/(5.0_r8*86400.0_r8)
      cff2=1.0_r8/(60.0_r8*86400.0_r8)
      do j=JstrR,MIN(6,JendR)
        do i=IstrR,IendR
          wrk(i,j)=cff2+FLOAT(6-j)*(cff1-cff2)/6.0_r8
        enddo
      enddo
      do j=MAX(JstrR,M-6),JendR
        do i=IstrR,IendR
          wrk(i,j)=cff1+FLOAT(M-j)*(cff2-cff1)/6.0_r8
        enddo
      enddo
      do i=IstrR,MIN(6,IendR)
        do j=MAX(JstrR,i),MIN(M-i,JendR)
          wrk(i,j)=cff2+FLOAT(6-i)*(cff1-cff2)/6.0_r8
        enddo
      enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
#  ifdef M2CLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          M2nudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
#  ifdef M3CLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          M3nudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
#  ifdef TCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Tnudgcof(i,j,itemp)=wrk(i,j)
          Tnudgcof(i,j,isalt)=wrk(i,j)
        enddo
      enddo
#  endif
# elif defined BISCAY
      cff1=1.0_r8/( 5.0_r8*86400.0_r8)
      cff2=1.0_r8/(30.0_r8*86400.0_r8)
      cff3=(29.0_r8*cff1-cff2)/28.0_r8
      do i=IstrR,IendR
        do j=JstrR,MIN(6,JendR)
          wrk(i,j)=cff2+FLOAT(6-j)*(cff1-cff2)/6.0_r8
        enddo
        do j=MAX(JstrR,M-6),JendR
          wrk(i,j)=cff1+FLOAT(M-j)*(cff2-cff1)/6.0_r8
        enddo
      enddo
      do i=IstrR,MIN(6,IendR)
        do j=MAX(JstrR,i),MIN(M-i,JendR)
          wrk(i,j)=cff2+FLOAT(6-i)*(cff1-cff2)/6.0_r8
        enddo
      enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
      do j=MAX(JstrR,14),MIN(42,JendR)
        do i=MAX(IstrR,86),MIN(IendR,L)
          cff1=SQRT(FLOAT((i-L+1)*(i-L+1)+(j-28)*(j-28)))
          wrk(i,j)=MAX(0.0_r8,(cff3+cff1*(cff2-cff3)/28.0_r8))
        enddo
      enddo
#  ifdef TCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Tnudgcof(i,j,itemp)=wrk(i,j)
          Tnudgcof(i,j,isalt)=wrk(i,j)
        enddo
      enddo
#  endif
# elif defined DAMEE_4
      cff1=1.0_r8/(5.0_r8*86400.0_r8)
      cff2=1.0_r8/(60.0_r8*86400.0_r8)
      cff3=(7.0_r8*cff1-cff2)/6.0_r8
      do j=JstrR,MIN(8,JendR)
        do i=IstrR,IendR
          wrk(i,j)=cff2+FLOAT(8-j)*(cff1-cff2)/7.0_r8
        enddo
      enddo
      do j=MAX(JstrR,Mm-7),JendR
        do i=IstrR,IendR
          wrk(i,j)=cff1+FLOAT(Mm-j)*(cff2-cff1)/7.0_r8
        enddo
      enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
      do j=MAX(JstrR,74),MIN(80,JendR)
        do i=MAX(IstrR,102),MIN(108,IendR)
          cff1=SQRT(FLOAT((i-109)*(i-109)+(j-77)*(j-77)))
          wrk(i,j)=MAX(0.0_r8,(cff3+cff1*(cff2-cff3)/6.0_r8))
        enddo
      enddo
#  ifdef TCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Tnudgcof(i,j,itemp)=wrk(i,j)
          Tnudgcof(i,j,isalt)=wrk(i,j)
        enddo
      enddo
#  endif
# elif defined DAMEE_5
      cff1=1.0_r8/(5.0_r8*86400.0_r8)
      cff2=1.0_r8/(60.0_r8*86400.0_r8)
      cff3=(7.0_r8*cff1-cff2)/6.0_r8
      do j=JstrR,MIN(8,JendR)
        do i=IstrR,IendR
          wrk(i,j)=cff2+FLOAT(8-j)*(cff1-cff2)/7.0_r8
        enddo
      enddo
      do j=MAX(JstrR,Mm-7),JendR
        do i=IstrR,IendR
          wrk(i,j)=cff1+FLOAT(Mm-j)*(cff2-cff1)/7.0_r8
        enddo
      enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
      do j=MAX(JstrR,33),MIN(39,JendR)
        do i=MAX(IstrR,102),MIN(108,IendR)
          cff1=SQRT(FLOAT((i-109)*(i-109)+(j-36)*(j-36)))
          wrk(i,j)=MAX(0.0_r8,(cff3+cff1*(cff2-cff3)/6.0_r8))
        enddo
      enddo
#  ifdef TCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Tnudgcof(i,j,itemp)=wrk(i,j)
          Tnudgcof(i,j,isalt)=wrk(i,j)
        enddo
      enddo
#  endif
# elif defined DAMEE_6
      cff1=1.0_r8/(5.0_r8*86400.0_r8)
      cff2=1.0_r8/(60.0_r8*86400.0_r8)
      cff3=(9.0_r8*cff1-cff2)/8.0_r8
      do j=JstrR,MIN(6,JendR)
        do i=IstrR,IendR
          wrk(i,j)=cff2+FLOAT(6-j)*(cff1-cff2)/5.0_r8
        enddo
      enddo
      do j=MAX(JstrR,Mm-6),JendR
        do i=IstrR,IendR
          wrk(i,j)=cff1+FLOAT(Mm-j)*(cff2-cff1)/6.0_r8
        enddo
      enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
      do j=MAX(JstrR,57),MIN(65,JendR)
        do i=MAX(IstrR,176),MIN(184,IendR)
          cff1=SQRT(FLOAT((i-185)*(i-185)+(j-61)*(j-61)))
          wrk(i,j)=MAX(0.0_r8,(cff3+cff1*(cff2-cff3)/8.0_r8))
        enddo
      enddo
#  ifdef TCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Tnudgcof(i,j,itemp)=wrk(i,j)
          Tnudgcof(i,j,isalt)=wrk(i,j)
        enddo
      enddo
#  endif
# elif defined DAMEE_7
      cff1=1.0_r8/(5.0_r8*86400.0_r8)
      cff2=1.0_r8/(60.0_r8*86400.0_r8)
      cff3=(9.0_r8*cff1-cff2)/8.0_r8
      do j=JstrR,MIN(8,JendR)
        do i=IstrR,IendR
          wrk(i,j)=cff2+FLOAT(8-j)*(cff1-cff2)/7.0_r8
        enddo
      enddo
      do j=MAX(JstrR,Mm-7),JendR
        do i=IstrR,IendR
          wrk(i,j)=cff1+FLOAT(Mm-j)*(cff2-cff1)/7.0_r8
        enddo
      enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
      do j=MAX(JstrR,177),MIN(185,JendR)
        do i=MAX(IstrR,217),MIN(225,IendR)
          cff1=SQRT(FLOAT((i-226)*(i-226)+(j-181)*(j-181)))
          wrk(i,j)=MAX(0.0_r8,(cff3+cff1*(cff2-cff3)/8.0_r8))
        enddo
      enddo
#  ifdef TCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Tnudgcof(i,j,itemp)=wrk(i,j)
          Tnudgcof(i,j,isalt)=wrk(i,j)
        enddo
      enddo
#  endif
# elif defined DAMEE_9
      cff1=1.0_r8/(5.0_r8*86400.0_r8)
      cff2=1.0_r8/(60.0_r8*86400.0_r8)
      cff3=(11.0_r8*cff1-cff2)/10.0_r8
      do j=JstrR,MIN(8,JendR)
        do i=IstrR,IendR
          wrk(i,j)=cff2+FLOAT(8-j)*(cff1-cff2)/7.0_r8
        enddo
      enddo
      do j=MAX(JstrR,Mm-7),JendR
        do i=IstrR,IendR
          wrk(i,j)=cff1+FLOAT(Mm-j)*(cff2-cff1)/7.0_r8
        enddo
      enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
      do j=MAX(JstrR,154),MIN(164,JendR)
        do i=MAX(IstrR,229),MIN(237,IendR)
          cff1=SQRT(FLOAT((i-238)*(i-238)+(j-159)*(j-159)))
          Tnudgcof(i,j,itemp)=MAX(0.0_r8,
     &                            (cff3+cff1*(cff2-cff3)/10.0_r8))
        enddo
      enddo
#  ifdef TCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Tnudgcof(i,j,itemp)=wrk(i,j)
          Tnudgcof(i,j,isalt)=wrk(i,j)
        enddo
      enddo
#  endif
# elif defined NATL
      cff1=1.0_r8/(5.0_r8*86400.0_r8)
      cff2=1.0_r8/(60.0_r8*86400.0_r8)
      do j=JstrR,MIN(8,JendR)
        do i=IstrR,IendR
          wrk(i,j)=cff2+FLOAT(8-j)*(cff1-cff2)/7.0_r8
        enddo
      enddo
      do j=MAX(JstrR,Mm-7),JendR
        do i=IstrR,IendR
          wrk(i,j)=cff1+FLOAT(Mm-j)*(cff2-cff1)/7.0_r8
        enddo
      enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
#  ifdef TCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Tnudgcof(i,j,itemp)=wrk(i,j)
          Tnudgcof(i,j,isalt)=wrk(i,j)
        enddo
      enddo
#  endif
# elif defined NPACIFIC
      cff1=1.0_r8/(5.0_r8*86400.0_r8)
      cff2=1.0_r8/(60.0_r8*86400.0_r8)
      do j=JstrR,MIN(8,JendR)
        do i=IstrR,IendR
          wrk(i,j)=cff2+FLOAT(8-j)*(cff1-cff2)/7.0_r8
        enddo
      enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
#  ifdef TCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Tnudgcof(i,j,itemp)=wrk(i,j)
          Tnudgcof(i,j,isalt)=wrk(i,j)
        enddo
      enddo
#  endif
# elif defined USWEST
      cff1=0.5_r8/(90.0_r8*86400.0_r8)
      cff2=150.0_e8+3                    ! width (m) of nudging layer
      Iwrk=INT(cff2*FLOAT(Lm)/
     &         (xr(L,INT(0.5_r8*FLOAT(Mm)))-
     &          xr(1,INT(0.5_r8*FLOAT(Mm)))))
      do j=JstrR,JendR
        do i=IstrR,MIN(Iwrk,IendR)
          wrk(i,j)=cff1*(1.0_r8+COS(pi*FLOAT(i)/FLOAT(Iwrk)))
        enddo
        do i=MAX(IstrR,L-isp),IendR
          wrk(i,j)=cff1*(1.0_r8+COS(pi*FLOAT(L-i)/FLOAT(Iwrk)))
        enddo
      enddo
      do j=MAX(JstrR,M-Iwrk),MIN(M,JendR)
        do i=MAX(IstrR,M-j),MIN(L-M+j,IendR)
          wrk(i,j)=cff1*(1.0_r8+COS(pi*FLOAT(M-j)/FLOAT(Iwrk)))
        enddo
      enddo
!!    do j=JstrR,MIN(Iwrk,JendR)
!!      do i=MAX(IstrR,j),MIN(L-j,IendR)
!!        wrk(i,j)=cff1*(1.0_r8+COS(pi*FLOAT(j)/FLOAT(Iwrk)))
!!      enddo
!!    enddo
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=wrk(i,j)
        enddo
      enddo
#  endif
#  ifdef TCLM_NUDGING
      do itrc=1,NT
        do j=JstrR,JendR
          do i=IstrR,IendR
            Tnudgcof(i,j,itrc)=wrk(i,j)
          enddo
        enddo
      enddo
#  endif
# else
#  ifdef ZCLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          Znudgcof(i,j)=Znudg
        enddo
      enddo
#  endif /* ZCLM_NUDGING */
#  ifdef M2CLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          M2nudgcof(i,j)=M2nudg
        enddo
      enddo
#  endif /* M2CLM_NUDGING */
#  ifdef SOLVE3D
#   ifdef TCLM_NUDGING
      do itrc=1,NT
        do j=JstrR,JendR
          do i=IstrR,IendR
            Tnudgcof(i,j,itrc)=Tnudg(itrc)
          enddo
        enddo
      enddo
#   endif /* TCLM_NUDGING */
#   ifdef M3CLM_NUDGING
      do j=JstrR,JendR
        do i=IstrR,IendR
          M3nudgcof(i,j)=M3nudg
        enddo
      enddo
#   endif /* M3CLM_NUDGING */
#  endif /* SOLVE3D */
# endif
!
!---------------------------------------------------------------------
!  Set nudging coefficients (1/s) for passive/active (outflow/inflow)
!  open boundary conditions.  Weak nudging is expected in passive
!  outflow conditions and strong nudging is expected in active inflow
!  conditions.  Notice that interior nudging coefficient defined
!  above are zero out when boundary condition nudging.  The USER needs
!  to adapt this to his/her application!
!---------------------------------------------------------------------
!
!  Free-surface nudging coefficients.
!
# ifdef WEST_FSNUDGING
#  ifdef ZCLM_NUDGING
      if (SOUTH_WEST_CORNER) then
        FSobc_out(iwest)=Znudgcof(0,1)
        FSobc_in (iwest)=obcfac*FSobc_out(iwest)
      endif
      if (WESTERN_EDGE) then
        do j=JstrR,JendR
          Znudgcof(0,j)=0.0_r8
        enddo
      endif
#  else
      if (SOUTH_WEST_CORNER) then
        FSobc_out(iwest)=Znudg
        FSobc_in (iwest)=obcfac*Znudg
      endif
#  endif
# endif /* WEST_FSNUDGING */
# ifdef EAST_FSNUDGING
#  ifdef ZCLM_NUDGING
      if (NORTH_EAST_CORNER) then
        FSobc_out(ieast)=Znudgcof(L,Mm)
        FSobc_in (ieast)=obcfac*FSobc_out(ieast)
      endif
      if (EASTERN_EDGE) then
        do j=JstrR,JendR
          Znudgcof(L,j)=0.0_r8
        enddo
      endif
#  else
      if (NORTH_EAST_CORNER) then
        FSobc_out(ieast)=Znudg
        FSobc_in (ieast)=obcfac*Znudg
      endif
#  endif
# endif /* EAST_FSNUDGING */
# ifdef SOUTH_FSNUDGING
#  ifdef ZCLM_NUDGING
      if (SOUTH_WEST_CORNER) then
        FSobc_out(isouth)=Znudgcof(1,0)
        FSobc_in (isouth)=obcfac*FSobc_out(isouth)
      endif
      if (SOUTHERN_EDGE) then
        do i=IstrR,IendR
          Znudgcof(i,0)=0.0_r8
        enddo
      endif
#  else
      if (SOUTH_WEST_CORNER) then
        FSobc_out(isouth)=Znudg
        FSobc_in (isouth)=obcfac*Znudg
      endif
#  endif
# endif /* SOUTH_FSNUDGING */
# ifdef NORTH_FSNUDGING
#  ifdef ZCLM_NUDGING
      if (NORTH_EAST_CORNER) then
        FSobc_out(inorth)=Znudgcof(Lm,M)
        FSobc_in (inorth)=obcfac*FSobc_out(inorth)
      endif
      if (NORTHERN_EDGE) then
        do i=IstrR,IendR
          Znudgcof(i,M)=0.0_r8
        enddo
      endif
#  else
      if (NORTH_EAST_CORNER) then
        FSobc_out(inorth)=Znudg
        FSobc_in (inorth)=obcfac*Znudg
      endif
#  endif
# endif /* NORTH_FSNUDGING */
!
!  2D momentum nudging coefficients.
!
# ifdef WEST_M2NUDGING
#  ifdef M2CLM_NUDGING
      if (SOUTH_WEST_CORNER) then
        M2obc_out(iwest)=0.5_r8*(M2nudgcof(0,1)+M2nudgcof(1,1))
        M2obc_in (iwest)=obcfac*M2obc_out(iwest)
      endif
      if (WESTERN_EDGE) then
        do j=JstrR,JendR
          M2nudgcof(0,j)=-M2nudgcof(1,j)
        enddo
      endif
#  else
      if (SOUTH_WEST_CORNER) then
        M2obc_out(iwest)=M2nudg
        M2obc_in (iwest)=obcfac*M2nudg
      endif
#  endif
# endif /* WEST_M2NUDGING */
# ifdef EAST_M2NUDGING
#  ifdef M2CLM_NUDGING
      if (NORTH_EAST_CORNER) then
        M2obc_out(ieast)=0.5_r8*(M2nudgcof(Lm,Mm)+M2nudgcof(L,Mm))
        M2obc_in (ieast)=obcfac*M2obc_out(ieast)
      endif
      if (EASTERN_EDGE) then
        do j=JstrR,JendR
          M2nudgcof(L,j)=-M2nudgcof(Lm,j)
        enddo
      endif
#  else
      if (NORTH_EAST_CORNER) then
        M2obc_out(ieast)=M2nudg
        M2obc_in (ieast)=obcfac*M2nudg
      endif
#  endif
# endif /* EAST_M2NUDGING */
# ifdef SOUTH_M2NUDGING
#  ifdef M2CLM_NUDGING
      if (SOUTH_WEST_CORNER) then
        M2obc_out(isouth)=0.5_r8*(M2nudgcof(1,0)+M2nudgcof(1,1))
        M2obc_in (isouth)=obcfac*M2obc_out(isouth)
      endif
      if (SOUTHERN_EDGE) then
        do i=IstrR,IendR
          M2nudgcof(i,0)=-M2nudgcof(i,1)
        enddo
      endif
#  else
      if (SOUTH_WEST_CORNER) then
        M2obc_out(isouth)=M2nudg
        M2obc_in (isouth)=obcfac*M2nudg
      endif
#  endif
# endif /* SOUTH_M2NUDGING */
# ifdef NORTH_M2NUDGING
#  ifdef M2CLM_NUDGING
      if (NORTH_EAST_CORNER) then
        M2obc_out(inorth)=0.5_r8*(M2nudgcof(Lm,Mm)+M2nudgcof(Lm,M))
        M2obc_in (inorth)=obcfac*M2obc_out(inorth)
      endif
      if (NORTHERN_EDGE) then
        do i=IstrR,IendR
          M2nudgcof(i,M)=-M2nudgcof(i,Mm)
        enddo
      endif
#  else
      if (NORTH_EAST_CORNER) then
        M2obc_out(inorth)=M2nudg
        M2obc_in (inorth)=obcfac*M2nudg
      endif
#  endif
# endif /* NORTH_M2NUDGING */
# ifdef SOLVE3D
!
!  Tracers nudging coefficients.
!
#  ifdef WEST_TNUDGING
      do itrc=1,NT
#   ifdef TCLM_NUDGING
        if (SOUTH_WEST_CORNER) then
          Tobc_out(iwest,itrc)=Tnudgcof(0,1,itrc)
          Tobc_in (iwest,itrc)=obcfac*Tobc_out(iwest,itrc)
        endif
        if (WESTERN_EDGE) then
          do j=JstrR,JendR
            Tnudgcof(0,j,itrc)=0.0_r8
          enddo
        endif
#   else
        if (SOUTH_WEST_CORNER) then
          Tobc_out(iwest,itrc)=Tnudg(itrc)
          Tobc_in (iwest,itrc)=obcfac*Tnudg(itrc)
        endif
#   endif
      enddo
#  endif /* WEST_TNUDGING */
#  ifdef EAST_TNUDGING
      do itrc=1,NT
#   ifdef TCLM_NUDGING
        if (NORTH_EAST_CORNER) then
          Tobc_out(ieast,itrc)=Tnudgcof(L,Mm,itrc)
          Tobc_in (ieast,itrc)=obcfac*Tobc_out(ieast,itrc)
        endif
        if (EASTERN_EDGE) then
          do j=JstrR,JendR
            Tnudgcof(L,j,itrc)=0.0_r8
          enddo
        endif
#   else
        if (NORTH_EAST_CORNER) then
          Tobc_out(ieast,itrc)=Tnudg(itrc)
          Tobc_in (ieast,itrc)=obcfac*Tnudg(itrc)
        endif
#   endif
      enddo
#  endif /* EAST_TNUDGING */
#  ifdef SOUTH_TNUDGING
      do itrc=1,NT
#   ifdef TCLM_NUDGING
        if (SOUTH_WEST_CORNER) then
          Tobc_out(isouth,itrc)=Tnudgcof(1,0,itrc)
          Tobc_in (isouth,itrc)=obcfac*Tobc_out(isouth,itrc)
        endif
        if (SOUTHERN_EDGE) then
          do i=IstrR,IendR
            Tnudgcof(i,0,itrc)=0.0_r8
          enddo
        endif
#   else
        if (SOUTH_WEST_CORNER) then
          Tobc_out(isouth,itrc)=Tnudg(itrc)
          Tobc_in (isouth,itrc)=obcfac*Tnudg(itrc)
        endif
#   endif
      enddo
#  endif /* SOUTH_TNUDGING */
#  ifdef NORTH_TNUDGING
      do itrc=1,NT
#   ifdef TCLM_NUDGING
        if (NORTH_EAST_CORNER) then
          Tobc_out(inorth,itrc)=Tnudgcof(Lm,M,itrc)
          Tobc_in (inorth,itrc)=obcfac*Tobc_out(inorth,itrc)
        endif
        if (NORTHERN_EDGE) then
          do i=IstrR,IendR
            Tnudgcof(i,M,itrc)=0.0_r8
          enddo
        endif
#   else
        if (NORTH_EAST_CORNER) then
          Tobc_out(inorth,itrc)=Tnudg(itrc)
          Tobc_in (inorth,itrc)=obcfac*Tnudg(itrc)
        endif
#   endif
      enddo
#  endif /* NORTH_TNUDGING */
!
!  3D momentum nudging coefficients.
!
#  ifdef WEST_M3NUDGING
#   ifdef M3CLM_NUDGING
      if (SOUTH_WEST_CORNER) then
        M3obc_out(iwest)=0.5_r8*(M3nudgcof(0,1)+M3nudgcof(1,1))
        M3obc_in (iwest)=obcfac*M3obc_out(iwest)
      endif
      if (WESTERN_EDGE) then
        do j=JstrR,JendR
          M3nudgcof(0,j)=-M3nudgcof(1,j)
        enddo
      endif
#   else
      if (SOUTH_WEST_CORNER) then
        M3obc_out(iwest)=M3nudg
        M3obc_in (iwest)=obcfac*M3nudg
      endif
#   endif
#  endif /* WEST_M3NUDGING */
#  ifdef EAST_M3NUDGING
#   ifdef M3CLM_NUDGING
      if (NORTH_EAST_CORNER) then
        M3obc_out(ieast)=0.5_r8*(M3nudgcof(Lm,Mm)+M3nudgcof(L,Mm))
        M3obc_in (ieast)=obcfac*M3obc_out(ieast)
      endif
      if (EASTERN_EDGE) then
        do j=JstrR,JendR
          M3nudgcof(L,j)=-M3nudgcof(Lm,j)
        enddo
      endif
#   else
      if (NORTH_EAST_CORNER) then
        M3obc_out(ieast)=M3nudg
        M3obc_in (ieast)=obcfac*M3nudg
      endif
#   endif
#  endif /* EAST_M3NUDGING */
#  ifdef SOUTH_M3NUDGING
#   ifdef M3CLM_NUDGING
      if (SOUTH_WEST_CORNER) then
        M3obc_out(isouth)=0.5_r8*(M3nudgcof(1,0)+M3nudgcof(1,1))
        M3obc_in (isouth)=obcfac*M3obc_out(isouth)
      endif
      if (SOUTHERN_EDGE) then
        do i=IstrR,IendR
          M3nudgcof(i,0)=-M3nudgcof(i,1)
        enddo
      endif
#   else
      if (SOUTH_WEST_CORNER) then
        M3obc_out(isouth)=M3nudg
        M3obc_in (isouth)=obcfac*M3nudg
      endif
#   endif
#  endif /* SOUTH_M3NUDGING */
#  ifdef NORTH_M3NUDGING
#   ifdef M3CLM_NUDGING
      if (NORTH_EAST_CORNER) then
        M3obc_out(inorth)=0.5_r8*(M3nudgcof(Lm,Mm)+M3nudgcof(Lm,M))
        M3obc_in (inorth)=obcfac*M3obc_out(inorth)
      endif
      if (NORTHERN_EDGE) then
        do i=IstrR,IendR
          M3nudgcof(i,M)=-M3nudgcof(i,Mm)
        enddo
      endif
#   else
      if (NORTH_EAST_CORNER) then
        M3obc_out(inorth)=M3nudg
        M3obc_in (inorth)=obcfac*M3nudg
      endif
#   endif
#  endif /* NORTH_M3NUDGING */
# endif /* SOLVE3D */
#else
      subroutine set_nudgcof
#endif
      return
      end
