#include "cppdefs.h"
      subroutine set_ngfld (ifield,Finp,Fout,Is,Ie,Im,Jm,update)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine time-interpolates requested non-grided field from    !
!  time snapshots of input data.                                     !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     ifield     Field ID.                                           !
!     Finp       Latest snapshopts of field to interpolate.          !
!     Is         Finp/Fout 1st dimension lower-specifier in calling  !
!                  program.                                          !
!     Ie         Finp/Fout 1st dimension upper-specifier in calling  !
!                  program.                                          !
!     Im         Maximum number of points to process in the 1st      !
!                  dimension.                                        !
!     Jm         Maximum number of points to process in the 2nd      !
!                  dimension, if any. Otherwise, a one is expected.  !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     Fout       Interpolated field.                                 !
!     update     Switch indicating successful interpolation.         !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "iounits.h"
# include "ncparam.h"
# include "scalars.h"
!
      logical update
      INTEGER_TYPE
     &        Ie, Im, Is, Jm, Tindex, i, ifield, it1, it2, j, lvar
      INTEGER_TYPE
     &        lenstr
      REAL_TYPE
     &        Tend, fac, fac1, fac2
      REAL_TYPE
     &        Finp(Is:Ie,Jm,2), Fout(Is:Ie,Jm)
!
!--------------------------------------------------------------------
!  Interpolate requested field from data snapshots.
!--------------------------------------------------------------------
!
!  Set linear-interpolation factors.
!
      Tindex=Iinfo(5,ifield)
      it1=3-Tindex
      it2=Tindex
      fac1=Tintrp(it2,ifield)-time
      fac2=time-Tintrp(it1,ifield)
      update=.true.
!
!  Time-interpolate.
!
      if (((fac1*fac2).ge.0.0_r8).and.(fac1+fac2).gt.0.0_r8) then
        fac=1.0_r8/(fac1+fac2)
        fac1=fac*fac1
        fac2=fac*fac2
        do j=1,Jm
          do i=Is,Im
            Fout(i,j)=fac1*Finp(i,j,it1)+fac2*Finp(i,j,it2)
          enddo
        enddo
!
!  Activate synchronization flag if a new time record needs to be
!  read in at the next time step.
!
        if ((time+dt).gt.Tintrp(it2,ifield)) then
          synchro_flag=.true.
        endif
!
!  Unable to interpolate field.  Activate error flag to quit.
!
      else
        Tend=Finfo(2,ifield)
        lvar=lenstr(Vname(5,ifield))
        write(stdout,10) Vname(5,ifield)(1:lvar), tdays, Tend,
     &                   Tintrp(it1,ifield)*sec2day,
     &                   Tintrp(it2,ifield)*sec2day
  10    format(/,' SET_NGFLD  - current model time',
     &         ' exceeds ending value for variable: ',a,
     &         /,14x,'TDAYS   = ',f15.4,2x,'TEND    = ',f15.4,
     &         /,14x,'TINTRP1 = ',f15.4,2x,'TINTRP2 = ',f15.4)
        exit_flag=2
        update=.false.
      endif
      return
      end
