#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine set_massflux (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine computes horizontal mass fluxes, Hz*u/n and Hz*v/m.  !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (12)
# endif
      call set_massflux_tile (Istr,Iend,Jstr,Jend)
# ifdef PROFILE
      call wclock_off (12)
# endif
      return
      end
!
!*********************************************************************
      subroutine set_massflux_tile (Istr,Iend,Jstr,Jend)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
!
# include "set_bounds.h"
!
# ifdef EW_PERIODIC
#  define IU_RANGE Istr,Iend
#  define IV_RANGE Istr,Iend
# else
#  define IU_RANGE Istr,IendR
#  define IV_RANGE IstrR,IendR
# endif

# ifdef NS_PERIODIC
#  define JU_RANGE Jstr,Jend
#  define JV_RANGE Jstr,Jend
# else
#  define JU_RANGE JstrR,JendR
#  define JV_RANGE Jstr,JendR
# endif
!
!---------------------------------------------------------------------
!  Compute horizontal mass fluxes, Hz*u/n and Hz*v/m.
!---------------------------------------------------------------------
!
      do k=1,N
        do j=JU_RANGE
          do i=IU_RANGE
             Huon(i,j,k)=0.5_r8*(Hz(i,j,k)+Hz(i-1,j,k))*u(i,j,k,nrhs)*
     &                   on_u(i,j)
          enddo
        enddo
        do j=JV_RANGE
          do i=IV_RANGE
            Hvom(i,j,k)=0.5_r8*(Hz(i,j,k)+Hz(i,j-1,k))*v(i,j,k,nrhs)*
     &                  om_v(i,j)
          enddo
        enddo
      enddo
# if defined EW_PERIODIC || defined NS_PERIODIC
!
! Set periodic boundary conditions.
!
      call exchange_u3d_tile (Istr,Iend,Jstr,Jend,Huon)
      call exchange_v3d_tile (Istr,Iend,Jstr,Jend,Hvom)
# endif
#else
      subroutine set_massflux
#endif
      return
      end

