#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine set_depth (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine computes the time evolving depths of the model grid  !
!  and its associated vertical transformation metric (thickness).    !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "tile.h"
!
      call set_depth_tile (Istr,Iend,Jstr,Jend)
      return
      end
!
!*********************************************************************
      subroutine set_depth_tile (Istr,Iend,Jstr,Jend)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "coupling.h"
# include "grid.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr
      INTEGER_TYPE
     &        i, j, k
      REAL_TYPE
     &        cff_r, cff1_r, cff2_r, cff_w, cff1_w, cff2_w, z_r0, z_w0
!
# include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Compute time evolving depths and vertical thicknesses.
!---------------------------------------------------------------------
!
!  At initialization, load initial free-surface field into fast-time
!  averaged array.
!
      if (iic.eq.0) then
        do j=JstrR,JendR
          do i=IstrR,IendR
            Zt_avg1(i,j)=zeta(i,j,1)
            hinv(i,j)=1.0_r8/h(i,j)
          enddo
        enddo
      endif
!
!  Compute vertical depths (meters, negative) at RHO- and W-points,
!  and vertical grid thicknesses.
!
      do j=JstrR,JendR
        do i=IstrR,IendR
           z_w(i,j,0)=-h(i,j)
# ifdef ICESHELF
     &               +zice(i,j)
# endif
        enddo
        do k=1,N
          cff_w=hc*(sc_w(k)-Cs_w(k))
          cff1_w=Cs_w(k)
          cff2_w=sc_w(k)+1.0_r8
          cff_r=hc*(sc_r(k)-Cs_r(k))
          cff1_r=Cs_r(k)
          cff2_r=sc_r(k)+1.0_r8
          do i=IstrR,IendR
# ifdef ICESHELF
            z_w0=cff_w+cff1_w*h(i,j)+zice(i,j)
            z_w(i,j,k)=z_w0+
     &                 Zt_avg1(i,j)*(1.0_r8+(z_w0-zice(i,j))*hinv(i,j))
            z_r0=cff_r+cff1_r*h(i,j)+zice(i,j)
            z_r(i,j,k)=z_r0+
     &                 Zt_avg1(i,j)*(1.0_r8+(z_r0-zice(i,j))*hinv(i,j))
# else
            z_w0=cff_w+cff1_w*h(i,j)
            z_w(i,j,k)=z_w0+Zt_avg1(i,j)*(1.0_r8+z_w0*hinv(i,j))
            z_r0=cff_r+cff1_r*h(i,j)
            z_r(i,j,k)=z_r0+Zt_avg1(i,j)*(1.0_r8+z_r0*hinv(i,j))
# endif
            Hz(i,j,k)=z_w(i,j,k)-z_w(i,j,k-1)
          enddo
        enddo
      enddo
#else
      subroutine set_depth
#endif
      return
      end

