#include "cppdefs.h"
      subroutine set_data (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine processes forcing, boundary, climatology, and     !
!  assimilation input data. It time-interpolates between snapshots.  !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
#include "param.h"
#include "scratch.h"
#include "tile.h"
!
#ifdef PROFILE
      call wclock_on (4)
#endif
      call set_data_tile (Istr,Iend,Jstr,Jend,
     &                    A2d(1,1),A2d(1,2))
#ifdef PROFILE
      call wclock_off (4)
#endif
      return
      end
!
!********************************************************************
      subroutine set_data_tile (Istr,Iend,Jstr,Jend,work1,work2)
!********************************************************************
!
      implicit none
#include "param.h"
#include "boundary.h"
#include "clima.h"
#include "forces.h"
#include "grid.h"
#include "mixing.h"
#include "ncparam.h"
#include "ocean.h"
#include "obs.h"
#include "scalars.h"
#include "sources.h"
!
      logical update
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, irad, itrc, j, k, order
      REAL_TYPE
     &        Zr, cff, cff1, cff2
      REAL_TYPE
     &        work1(PRIVATE_2D_SCRATCH_ARRAY),
     &        work2(PRIVATE_2D_SCRATCH_ARRAY)
!
#include "set_bounds.h"
!
      i=0
      j=0
      k=0
      itrc=0
      irad=0
      order=0
      cff=0.0_r8
      cff1=0.0_r8
      cff2=0.0_r8
      Zr=0.0_r8
      update=.false.
!
#ifdef SOLVE3D
# ifdef CLOUDS
!
!---------------------------------------------------------------------
!  Set cloud fraction (nondimensional).  Notice that clouds are
!  processed first in case that they are used to adjust shortwave
!  radiation.
!---------------------------------------------------------------------
!
#  ifdef ANA_CLOUD
      call ana_cloud_tile (Istr,Iend,Jstr,Jend)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idCfra,
     &                     cloudG(START_2D_ARRAY,1),
     &                     cloud (START_2D_ARRAY),update)
#  endif
# endif /* CLOUDS */
# ifdef SHORTWAVE
!
!---------------------------------------------------------------------
!  Set kinematic surface solar shortwave radiation flux (degC m/s).
!---------------------------------------------------------------------
!
#  ifdef ANA_SRFLUX
      call ana_srflux_tile (Istr,Iend,Jstr,Jend)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idSrad,
     &                     srflxG(START_2D_ARRAY,1),
     &                     srflx (START_2D_ARRAY),update)
#  endif
# endif /* SHORTWAVE */
# ifdef BULK_FLUXES
!
!---------------------------------------------------------------------
!  Set data for bulk parameterization of surface fluxes.
!---------------------------------------------------------------------
#  ifndef LONGWAVE
!
!  Surface net longwave radiation (degC m/s).
!
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idLrad,
     &                     lrflxG(START_2D_ARRAY,1),
     &                     lrflx (START_2D_ARRAY),update)
#  endif
!
!  Set surface air pressure (mb).
!
#  ifdef ANA_PAIR
      call ana_pair_tile (Istr,Iend,Jstr,Jend)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idPair,
     &                     PairG(START_2D_ARRAY,1),
     &                     Pair (START_2D_ARRAY),update)
#  endif
!
!  Set surface air temperature (degC).
!
#  ifdef ANA_TAIR
      call ana_tair_tile (Istr,Iend,Jstr,Jend)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idTair,
     &                     TairG(START_2D_ARRAY,1),
     &                     Tair (START_2D_ARRAY),update)
#  endif
!
!  Set surface air relative or specific humidity.
!
#  ifdef ANA_HUMIDITY
      call ana_humid_tile (Istr,Iend,Jstr,Jend)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idQair,
     &                     HairG(START_2D_ARRAY,1),
     &                     Hair (START_2D_ARRAY),update)
#  endif
!
!  Set surface winds (m/s).
!
#  ifdef ANA_WINDS
      call ana_winds_tile (Istr,Iend,Jstr,Jend)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idUair,
     &                     UwindG(START_2D_ARRAY,1),
     &                     Uwind (START_2D_ARRAY),update)
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idVair,
     &                     VwindG(START_2D_ARRAY,1),
     &                     Vwind (START_2D_ARRAY),update)
#   ifdef CURVGRID
!
!  If input point surface winds, rotate to curvilinear grid.
!
      if (.not.Linfo(1,idUair)) then
        do j=JstrR,JendR
          do i=IstrR,IendR
            cff1=Uwind(i,j)*COS(angler(i,j))+
     &           Vwind(i,j)*SIN(angler(i,j))
            cff2=Vwind(i,j)*COS(angler(i,j))-
     &           Uwind(i,j)*SIN(angler(i,j))
            Uwind(i,j)=cff1
            Vwind(i,j)=cff2
          enddo
        enddo
      endif
#   endif /* CURVGRID */
#  endif
!
!  Set rain fall rate (kg/m2/s).
!
#  ifdef ANA_RAIN
      call ana_rain_tile (Istr,Iend,Jstr,Jend)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idrain,
     &                     rainG(START_2D_ARRAY,1),
     &                     rain (START_2D_ARRAY),update)
#  endif
# else /* !BULK_FLUXES */
!
!---------------------------------------------------------------------
!  Set kinematic surface net heat flux (degC m/s).
!---------------------------------------------------------------------
!
#  ifdef ANA_STFLUX
      call ana_stflux_tile (Istr,Iend,Jstr,Jend,itemp)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idTsur(itemp),
     &                     stflxG(START_2D_ARRAY,1,itemp),
     &                     stflx (START_2D_ARRAY,itemp),update)
#  endif
# endif /* !BULK_FLUXES */
# ifdef QCORRECTION
!
!---------------------------------------------------------------------
!  Set sea surface temperature (SST) and heat flux sensitivity to
!  SST (dQdSST) which are used for surface heat flux correction.
!---------------------------------------------------------------------
!
#  ifdef ANA_SST
      call ana_sst_tile (Istr,Iend,Jstr,Jend)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idSSTc,
     &                     sstG(START_2D_ARRAY,1),
     &                     sst (START_2D_ARRAY),update)
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,iddQdT,
     &                     dqdtG(START_2D_ARRAY,1),
     &                     dqdt (START_2D_ARRAY),update)
#  endif
# endif /* QCORRECTION */
!
!---------------------------------------------------------------------
!  Set kinematic bottom net heat flux (degC m/s).
!---------------------------------------------------------------------
!
# ifdef ANA_BTFLUX
      call ana_btflux_tile (Istr,Iend,Jstr,Jend,itemp)
# else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idTbot(itemp),
     &                     btflxG(START_2D_ARRAY,1,itemp),
     &                     btflx (START_2D_ARRAY,itemp),update)
# endif
# ifdef SALINITY
!
!---------------------------------------------------------------------
!  Set kinematic surface freshwater (E-P) flux (m/s).
!---------------------------------------------------------------------
!
#  ifdef ANA_SSFLUX
      call ana_stflux_tile (Istr,Iend,Jstr,Jend,isalt)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idTsur(isalt),
     &                     stflxG(START_2D_ARRAY,1,isalt),
     &                     stflx (START_2D_ARRAY,isalt),update)
#  endif
#  if defined SCORRECTION || defined SRELAXATION
!
!---------------------------------------------------------------------
!  Set surface salinity for freshwater flux correction.
!---------------------------------------------------------------------
!
#   ifdef ANA_SSS
      call ana_sss_tile (Istr,Iend,Jstr,Jend)
#   else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idSSSc,
     &                     sssG(START_2D_ARRAY,1),
     &                     sss (START_2D_ARRAY),update)
#   endif
#  endif /* SCORRECTION || SRELAXATION */
!
!---------------------------------------------------------------------
!  Set kinematic bottom salt flux (m/s).
!---------------------------------------------------------------------
!
#  ifdef ANA_BSFLUX
      call ana_btflux_tile (Istr,Iend,Jstr,Jend,isalt)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idTbot(isalt),
     &                     btflxG(START_2D_ARRAY,1,isalt),
     &                     btflx (START_2D_ARRAY,isalt),update)
#  endif
# endif /* SALINITY */
# if defined SEDIMENT || defined BIOLOGY
!
!---------------------------------------------------------------------
!  Set kinematic surface and bottom pasive tracer fluxes (T m/s).
!---------------------------------------------------------------------
!
      do itrc=NAT+1,NT
#  ifdef ANA_SPFLUX
        call ana_stflux_tile (Istr,Iend,Jstr,Jend,itrc)
#  else
        call set_2dfld_tile (Istr,Iend,Jstr,Jend,idTsur(itrc),
     &                       stflxG(START_2D_ARRAY,1,itrc),
     &                       stflx (START_2D_ARRAY,itrc),update)
#  endif
#  ifdef ANA_BPFLUX
      call ana_btflux_tile (Istr,Iend,Jstr,Jend,itrc)
#  else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idTbot(itrc),
     &                     btflxG(START_2D_ARRAY,1,itrc),
     &                     btflx (START_2D_ARRAY,itrc),update)
#  endif
      enddo
# endif /* SEDIMENT || BIOLOGY */
#endif /* SOLVE3D */
#ifndef BULK_FLUXES
!
!---------------------------------------------------------------------
!  Set kinematic surface momentum flux (m2/s2).
!---------------------------------------------------------------------
!
# ifdef ANA_SMFLUX
      call ana_smflux_tile (Istr,Iend,Jstr,Jend)
# else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idUsms,
     &                     sustrG(START_2D_ARRAY,1),
     &                     sustr (START_2D_ARRAY),update)
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idVsms,
     &                     svstrG(START_2D_ARRAY,1),
     &                     svstr (START_2D_ARRAY),update)
#  ifdef CURVGRID
!
!  If input point wind stress, rotate to curvilinear grid.  Notice
!  that rotation is done at RHO-points. It does not matter.
!
      if (.not.Linfo(1,idUsms)) then
        do j=JstrR,JendR
          do i=IstrR,IendR
            cff1=sustr(i,j)*COS(angler(i,j))+
     &           svstr(i,j)*SIN(angler(i,j))
            cff2=svstr(i,j)*COS(angler(i,j))-
     &           sustr(i,j)*SIN(angler(i,j))
            sustr(i,j)=cff1
            svstr(i,j)=cff2
          enddo
        enddo
      endif
#  endif /* CURVGRID */
# endif
#endif
#ifdef BBL
!
!---------------------------------------------------------------------
!  Set surface wind-induced wave amplitude, direction and period.
!---------------------------------------------------------------------
!
# ifdef ANA_WWAVE
      call ana_wwave_tile (Istr,Iend,Jstr,Jend)
# else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idWamp,
     &                     AwaveG(START_2D_ARRAY,1),
     &                     Awave (START_2D_ARRAY),update)
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idWdir,
     &                     DwaveG(START_2D_ARRAY,1),
     &                     Dwave (START_2D_ARRAY),update)
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idWper,
     &                     PwaveG(START_2D_ARRAY,1),
     &                     Pwave (START_2D_ARRAY),update)
#  ifdef CURVGRID
!
!  If input point-data, rotate direction to curvilinear coordinates.
!
      if (.not.Linfo(1,idWdir)) then
        do j=JstrR,JendR
          do i=IstrR,IendR
            Dwave(i,j)=Dwave(i,j)-angler(i,j)
          enddo
        enddo
      endif
#  endif /* CURVGRID */
# endif
#endif /* BBL */
#ifdef ANA_SPINNING
!
!---------------------------------------------------------------------
!  Set time-varying rotation force (Coriolis plus centripetal
!  accelerations) for polar coordinate grids.
!---------------------------------------------------------------------
!
      call ana_spinning_tile (Istr,Iend,Jstr,Jend)
#endif
#if defined UV_PSOURCE || defined TS_PSOURCE
!
!---------------------------------------------------------------------
!  Set point Sources/Sinks (river runoff).
!---------------------------------------------------------------------
!
      if (SOUTH_WEST_CORNER) then
# ifdef ANA_PSOURCE
        call ana_psource
# else
#  ifdef UV_PSOURCE
        call set_ngfld (idRtra,QbarG,Qbar,1,Msrc,Nsrc,1,update)
#   ifdef SOLVE3D
        do k=1,N
          do i=1,Nsrc
            Qsrc(i,k)=Qbar(i)*Qshape(i,k)
          enddo
        enddo
#   endif
#  endif
#  if defined TS_PSOURCE && defined SOLVE3D
        do itrc=1,NAT
          call set_ngfld (idRtrc(itrc),TsrcG(1,1,1,itrc),
     &                    Tsrc(1,1,itrc),1,Msrc,Nsrc,N,update)
          if (.not.update) then
            do i=1,Nsrc
              Lsrc(i,itrc)=.false.
            enddo
            exit_flag=0
          endif
        enddo
#  endif
# endif
      endif
#endif /* UV_PSOURCE || TS_PSOURCE */
#ifdef OBC
!
!---------------------------------------------------------------------
!  Set open boundary conditions fields.
!---------------------------------------------------------------------
!
# ifdef ANA_FSOBC
      call ana_fsobc_tile (Istr,Iend,Jstr,Jend)
# else
      if (SOUTH_WEST_CORNER) then
#  ifdef WEST_FSOBC
        call set_ngfld (idZbry(iwest),zetaG_west(0,1),
     &                  zeta_west(0),0,M,M,1,update)
#  endif
#  ifdef EAST_FSOBC
        call set_ngfld (idZbry(ieast),zetaG_east(0,1),
     &                  zeta_east(0),0,M,M,1,update)
#  endif
#  ifdef SOUTH_FSOBC
        call set_ngfld (idZbry(isouth),zetaG_south(0,1),
     &                  zeta_south(0),0,L,L,1,update)
#  endif
#  ifdef NORTH_FSOBC
        call set_ngfld (idZbry(inorth),zetaG_north(0,1),
     &                  zeta_north(0),0,L,L,1,update)
#  endif
      endif
# endif
# ifdef ANA_M2OBC
      call ana_m2obc_tile (Istr,Iend,Jstr,Jend)
# else
      if (SOUTH_WEST_CORNER) then
#  ifdef WEST_M2OBC
        call set_ngfld (idU2bc(iwest),ubarG_west(0,1),
     &                  ubar_west(0),0,M,M,1,update)
        call set_ngfld (idV2bc(iwest),vbarG_west(1,1),
     &                  vbar_west(1),1,M,M,1,update)
#  endif
#  ifdef EAST_M2OBC
        call set_ngfld (idU2bc(ieast),ubarG_east(0,1),
     &                  ubar_east(0),0,M,M,1,update)
        call set_ngfld (idV2bc(ieast),vbarG_east(1,1),
     &                  vbar_east(1),1,M,M,1,update)
#  endif
#  ifdef SOUTH_M2OBC
        call set_ngfld (idU2bc(isouth),ubarG_south(1,1),
     &                  ubar_south(1),1,L,L,1,update)
        call set_ngfld (idV2bc(isouth),vbarG_south(0,1),
     &                  vbar_south(0),0,L,L,1,update)
#  endif
#  ifdef NORTH_M2OBC
        call set_ngfld (idU2bc(inorth),ubarG_north(1,1),
     &                  ubar_north(1),1,L,L,1,update)
        call set_ngfld (idV2bc(inorth),vbarG_north(0,1),
     &                  vbar_north(0),0,L,L,1,update)
#  endif
      endif
# endif
# ifdef SOLVE3D
#  ifdef ANA_M3OBC
      call ana_m3obc_tile (Istr,Iend,Jstr,Jend)
#  else
      if (SOUTH_WEST_CORNER) then
#   ifdef WEST_M3OBC
        call set_ngfld (idU3bc(iwest),uG_west(0,1,1),
     &                  u_west(0,1),0,M,M,N,update)
        call set_ngfld (idV3bc(iwest),vG_west(1,1,1),
     &                  v_west(1,1),1,M,M,N,update)
#   endif
#   ifdef EAST_M3OBC
        call set_ngfld (idU3bc(ieast),uG_east(0,1,1),
     &                  u_east(0,1),0,M,M,N,update)
        call set_ngfld (idV3bc(ieast),vG_east(1,1,1),
     &                  v_east(1,1),1,M,M,N,update)
#   endif
#   ifdef SOUTH_M3OBC
        call set_ngfld (idU3bc(isouth),uG_south(1,1,1),
     &                  u_south(1,1),1,L,L,N,update)
        call set_ngfld (idV3bc(isouth),vG_south(0,1,1),
     &                  v_south(0,1),0,L,L,N,update)
#   endif
#   ifdef NORTH_M3OBC
        call set_ngfld (idU3bc(inorth),uG_north(1,1,1),
     &                  u_north(1,1),1,L,L,N,update)
        call set_ngfld (idV3bc(inorth),vG_north(0,1,1),
     &                  v_north(0,1),0,L,L,N,update)
#   endif
      endif
#  endif
#  ifdef ANA_TOBC
      call ana_tobc_tile (Istr,Iend,Jstr,Jend)
#  else
      if (SOUTH_WEST_CORNER) then
        do itrc=1,NAT
#   ifdef WEST_TOBC
          call set_ngfld (idTbry(iwest,itrc),tG_west(0,1,1,itrc),
     &                    t_west(0,1,itrc),0,M,M,N,update)
#   endif
#   ifdef EAST_TOBC
          call set_ngfld (idTbry(ieast,itrc),tG_east(0,1,1,itrc),
     &                    t_east(0,1,itrc),0,M,M,N,update)
#   endif
#   ifdef SOUTH_TOBC
          call set_ngfld (idTbry(isouth,itrc),tG_south(0,1,1,itrc),
     &                    t_south(0,1,itrc),0,L,L,N,update)
#   endif
#   ifdef NORTH_TOBC
          call set_ngfld (idTbry(inorth,itrc),tG_north(0,1,1,itrc),
     &                    t_north(0,1,itrc),0,L,L,N,update)
#   endif
        enddo
      endif
#  endif
# endif /* SOLVE3D */
#endif /* OBC */
#ifdef ZCLIMATOLOGY
!
!---------------------------------------------------------------------
!  Set sea surface height climatology (m).
!---------------------------------------------------------------------
!
# ifdef ANA_SSH
      call ana_ssh_tile (Istr,Iend,Jstr,Jend)
# else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idSSHc,
     &                     sshG(START_2D_ARRAY,1),
     &                     ssh (START_2D_ARRAY),update)
# endif
#endif /* ZCLIMATOLOGY */
#ifdef M2CLIMATOLOGY
!
!---------------------------------------------------------------------
!  Set 2D momentum climatology (m/s).
!---------------------------------------------------------------------
!
# ifdef ANA_M2CLIMA
      call ana_m2clima_tile (Istr,Iend,Jstr,Jend)
# else
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idUbcl,
     &                     ubarclmG(START_2D_ARRAY,1),
     &                     ubarclm (START_2D_ARRAY),update)
      call set_2dfld_tile (Istr,Iend,Jstr,Jend,idVbcl,
     &                     vbarclmG(START_2D_ARRAY,1),
     &                     vbarclm (START_2D_ARRAY),update)
# endif
#endif /* M2CLIMATOLOGY */
#if defined SOLVE3D && defined TCLIMATOLOGY
!
!---------------------------------------------------------------------
!  Set tracer climatology.
!---------------------------------------------------------------------
!
# ifdef ANA_TCLIMA
      call ana_tclima_tile (Istr,Iend,Jstr,Jend)
# else
      do itrc=1,NAT
        call set_3dfld_tile (Istr,Iend,Jstr,Jend,idTclm(itrc),
     &                       tclmG(START_2D_ARRAY,1,1,itrc),
     &                       tclm (START_2D_ARRAY,1,itrc),update)
      enddo
# endif
#endif /* SOLVE3D && TCLIMATOLOGY */
#if defined SOLVE3D && defined M3CLIMATOLOGY
!
!---------------------------------------------------------------------
!  Set 3D momentum climatology (m/s).
!---------------------------------------------------------------------
!
# ifdef ANA_M3CLIMA
      call ana_m3clima_tile (Istr,Iend,Jstr,Jend)
# else
      call set_3dfld_tile (Istr,Iend,Jstr,Jend,idUclm,
     &                     uclmG(START_2D_ARRAY,1,1),
     &                     uclm (START_2D_ARRAY,1),update)
      call set_3dfld_tile (Istr,Iend,Jstr,Jend,idVclm,
     &                     vclmG(START_2D_ARRAY,1,1),
     &                     vclm (START_2D_ARRAY,1),update)
# endif
#endif /* SOLVE3D && M3CLIMATOLOGY */
#if defined NUDGING_SSH
!
!---------------------------------------------------------------------
!  Set sea surface height observations and error variance.
!---------------------------------------------------------------------
!
      if (assi_SSH) then
        call set_2dfld_tile (Istr,Iend,Jstr,Jend,idSSHo,
     &                       SSHdat(START_2D_ARRAY,1),
     &                       SSHobs(START_2D_ARRAY),update)
        call set_2dfld_tile (Istr,Iend,Jstr,Jend,idSSHe,
     &                       EdatSSH(START_2D_ARRAY,1),
     &                       EobsSSH(START_2D_ARRAY),update)
        if (.not.update.and.SOUTH_WEST_CORNER) then
          update_SSH=.false.
          exit_flag=0
        endif
      endif
#endif
#ifdef SOLVE3D
# if defined NUDGING_SST || defined ASSIMILATION_SST
!
!---------------------------------------------------------------------
!  Set sea surface temperature observations and error variance.
!---------------------------------------------------------------------
!
      if (assi_SST) then
#  ifdef NUDGING_SST
        call set_2dfld_tile (Istr,Iend,Jstr,Jend,idSSTo,
     &                       SSTdat(START_2D_ARRAY,1),
     &                       SSTobs(START_2D_ARRAY),update)
        call set_2dfld_tile (Istr,Iend,Jstr,Jend,idSSTe,
     &                       EdatSST(START_2D_ARRAY,1),
     &                       EobsSST(START_2D_ARRAY),update)
        if (.not.update.and.SOUTH_WEST_CORNER) then
          update_SST=.false.
          update_T(itemp)=.false.
          exit_flag=0
        endif
#  endif
!
!  Extend sea surface temperature and associated error variance using
!  provided basis function polynomials.
!
        if (extend_SST.and.update_SST) then
          if (SOUTH_WEST_CORNER) then
            update_SST=.false.
            update_T(itemp)=.true.
#  ifdef ASSIMILATION_SST
            tTobs(1,itemp)=Vtime(1,idSSTo)
            tsTobs(itemp)=Vtime(1,idSSTo)*day2sec
            Tmono(idSSTo)=tsTobs(itemp)
            Tmono(idSSTe)=tsTobs(itemp)
            EobsTmin(itemp)=Finfo(4,idSSTe)
            EobsTmax(itemp)=Finfo(5,idSSTe)
#  endif
          endif
          do k=1,N
            do j=JstrR,JendR
              do i=IstrR,IendR
                Zr=z_r(i,j,k)/h(i,j)
                cff=perr_SST(npSST)
                cff1=pcoef_SST(npSST)
                do order=npSST-1,0,-1
                  cff=Zr*cff+perr_SST(order)
                  cff1=Zr*cff+pcoef_SST(order)
                enddo
                EobsT(i,j,k,itemp)=MIN(1.0_r8,cff*EobsSST(i,j))
                Tobs(i,j,k,itemp)=cff1*SSTobs(i,j)
              enddo
            enddo
          enddo
        endif
      endif
# endif /* NUDGING_SST || ASSIMILATION_SST */
# if defined NUDGING_T
!
!---------------------------------------------------------------------
!  Set tracers observations and error variance.
!---------------------------------------------------------------------
!
      do itrc=1,NAT
        if (assi_T(itrc)) then
          call set_3dfld_tile (Istr,Iend,Jstr,Jend,idTobs(itrc),
     &                         Tdat(START_2D_ARRAY,1,1,itrc),
     &                         Tobs(START_2D_ARRAY,1,itrc),update)
          call set_3dfld_tile (Istr,Iend,Jstr,Jend,idTerr(itrc),
     &                         EdatT(START_2D_ARRAY,1,1,itrc),
     &                         EobsT(START_2D_ARRAY,1,itrc),update)
          if (.not.update.and.SOUTH_WEST_CORNER) then
            update_T(itrc)=.false.
            exit_flag=0
          endif
        endif
      enddo
# endif /* NUDGING_T */
# if defined NUDGING_UVsur || defined ASSIMILATION_UVsur
!
!---------------------------------------------------------------------
!  Set surface current observations and error variance.
!---------------------------------------------------------------------
!
      if (assi_UVsur) then
#  ifdef NUDGING_UVsur
        call set_2dfld_tile (Istr,Iend,Jstr,Jend,idUsur,
     &                       Usurdat(START_2D_ARRAY,1),
     &                       Usur   (START_2D_ARRAY),update)
        call set_2dfld_tile (Istr,Iend,Jstr,Jend,idVsur,
     &                       Vsurdat(START_2D_ARRAY,1),
     &                       Vsur   (START_2D_ARRAY),update)
        call set_2dfld_tile (Istr,Iend,Jstr,Jend,idUVse,
     &                       EdatVsur(START_2D_ARRAY,1),
     &                       EobsVsur(START_2D_ARRAY),update)
        if (.not.update.and.SOUTH_WEST_CORNER) then
          update_UVsur=.false.
          update_UV=.false.
          exit_flag=0
        endif
#  endif
!
!  Extend surface currents observations and associated error variance
!  using provided basis function polynomials.
!
        if (extend_UV.and.update_UVsur) then
          if (SOUTH_WEST_CORNER) then
            update_UVsur=.false.
            update_UV=.true.
# ifdef ASSIMILATION_UVsur
            tVobs(1)=Vtime(1,idVsur)
            tsVobs=Vtime(1,idVsur)*day2sec
            Tmono(idUsur)=tsVobs
            Tmono(idVsur)=tsVobs
            Tmono(idUVse)=tsVobs
            EobsUVmin=Finfo(4,idUVse)
            EobsUVmax=Finfo(5,idUVse)
# endif
          endif
          do k=1,N
            do j=JstrR,JendR
              do i=IstrR,IendR
                Zr=z_r(i,j,k)/h(i,j)
                cff=perr_V(npUV)
                do order=npUV-1,0,-1
                  cff=Zr*cff+perr_V(order)
                enddo
                EobsUV(i,j,k)=MIN(1.0_r8,cff+EobsVsur(i,j))
              enddo
            enddo
            do j=JstrV-1,Jend
              do i=IstrU-1,Iend
                Zr=z_r(i,j,k)/h(i,j)
                cff1=pcoef_U(npUV)
                cff2=pcoef_V(npUV)
                do order=npUV-1,0,-1
                  cff1=Zr*cff1+pcoef_U(order)
                  cff2=Zr*cff2+pcoef_V(order)
                enddo
                work1(i,j)=cff1*Usur(i,j)-cff2*Vsur(i,j)
                work2(i,j)=cff2*Usur(i,j)+cff1*Vsur(i,j)
              enddo
            enddo
            do j=Jstr,Jend
              do i=IstrU,Iend
                Uobs(i,j,k)=0.5_r8*(work1(i-1,j)+work1(i,j))
              enddo
              if (j.ge.JstrV) then
                do i=Istr,Iend
                  Vobs(i,j,k)=0.5_r8*(work2(i,j-1)+work2(i,j))
                enddo
              endif
            enddo
          enddo
        endif
      endif
# endif /* NUDGING_UVsur || ASSIMILATION_UVsur */
# ifdef NUDGING_UV
!
!---------------------------------------------------------------------
!  Set horizontal current observations and error variance.
!---------------------------------------------------------------------
!
      if (assi_UV) then
        call set_3dfld_tile (Istr,Iend,Jstr,Jend,idUobs,
     &                       Udat(START_2D_ARRAY,1,1),
     &                       Uobs(START_2D_ARRAY,1),update)
        call set_3dfld_tile (Istr,Iend,Jstr,Jend,idVobs,
     &                       Vdat(START_2D_ARRAY,1,1),
     &                       Vobs(START_2D_ARRAY,1),update)
        call set_3dfld_tile (Istr,Iend,Jstr,Jend,idUVer,
     &                       EdatUV(START_2D_ARRAY,1,1),
     &                       EobsUV(START_2D_ARRAY,1),update)
        if (.not.update.and.SOUTH_WEST_CORNER) then
          update_UV=.false.
          exit_flag=0
        endif
      endif
# endif /* NUDGING_UV */
#endif /* SOLVE3D */
      return
      end
