!
!---------------------------------------------------------------------
!  Compute bound indices over a particular domain partition or tile
!  for RHO-, U-, and V-variables.
!---------------------------------------------------------------------
!

/*
**  WARNING:   Because this file also contains type declarations for
**             these bounds, it must be included just after the last
**             type declaration inside a subroutine,  but before the
**             first executable statement.
*/

      INTEGER_TYPE
     &        IendR, IstrR, JendR, JstrR
#ifdef EW_PERIODIC
# define IstrU Istr
#else
      INTEGER_TYPE
     &        IstrU
#endif
#ifdef NS_PERIODIC
# define JstrV Jstr
#else
      INTEGER_TYPE
     &        JstrV
#endif
      if (WESTERN_EDGE) then
#ifdef EW_PERIODIC
        IstrR=Istr-2
#else
        IstrR=Istr-1
        IstrU=Istr+1
#endif
      else
        IstrR=Istr
#ifndef EW_PERIODIC
        IstrU=Istr
#endif
      endif
      if (EASTERN_EDGE) then
#ifdef EW_PERIODIC
        IendR=Iend+2
#else
        IendR=Iend+1
#endif
      else
        IendR=Iend
      endif
      if (SOUTHERN_EDGE) then
#ifdef NS_PERIODIC
        JstrR=Jstr-2
#else
        JstrR=Jstr-1
        JstrV=Jstr+1
#endif
      else
        JstrR=Jstr
#ifndef NS_PERIODIC
        JstrV=Jstr
#endif
      endif
      if (NORTHERN_EDGE) then
#ifdef NS_PERIODIC
        JendR=Jend+2
#else
        JendR=Jend+1
#endif
      else
        JendR=Jend
      endif
