#include "cppdefs.h"
#ifdef AVERAGES
      subroutine set_avg (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine accumulates and computes output time-averaged     !
!  fields.  Due to synchronization, the time-averaged fields are     !
!  computed in delayed mode. All averages are accumulated at the     !
!  beggining of the next time-step.                                  !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (5)
# endif
      call set_avg_tile (Istr,Iend,Jstr,Jend)
# ifdef PROFILE
      call wclock_off (5)
# endif
      return
      end
!
!*********************************************************************
      subroutine set_avg_tile (Istr,Iend,Jstr,Jend)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "averages.h"
# include "grid.h"
# include "mixing.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
# ifdef SOLVE3D
      INTEGER_TYPE
     &        k, itrc
# endif
      REAL_TYPE
     &        fac
!
#include "set_bounds.h"
!
!---------------------------------------------------------------------
! Initialize time-averaged arrays when appropriate.  Notice that
! fields are initilized twice during re-start.  However, the time-
! averaged fields are computed correctly.
!---------------------------------------------------------------------
!
      if (((iic.gt.ntsavg).and.(MOD(iic-1,navg).eq.1)).or.
     &    ((nrrec.gt.0).and.(iic.eq.ntstart))) then
        do j=JstrR,JendR
          do i=IstrR,IendR
            avgzeta(i,j)=zeta(i,j,KOUT)
            avgu2d (i,j)=ubar(i,j,KOUT)
            avgv2d (i,j)=vbar(i,j,KOUT)
          enddo
        enddo
# ifdef SOLVE3D
#  ifdef LMD_SKPP
        do j=JstrR,JendR
          do i=IstrR,IendR
            avghsbl(i,j)=hsbl(i,j)
          enddo
        enddo
#  endif
#  ifdef LMD_BKPP
        do j=JstrR,JendR
          do i=IstrR,IendR
            avghbbl(i,j)=hbbl(i,j)
          enddo
        enddo
#  endif
        do k=1,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgu3d(i,j,k)=u(i,j,k,NOUT)
              avgv3d(i,j,k)=v(i,j,k,NOUT)
              avgw3d(i,j,k)=W(i,j,k)*pm(i,j)*pn(i,j)
              avgrho(i,j,k)=rho(i,j,k)
            enddo
          enddo
          do itrc=1,NT
            do j=JstrR,JendR
              do i=IstrR,IendR
                avgt(i,j,k,itrc)=t(i,j,k,NOUT,itrc)
              enddo
            enddo
          enddo
        enddo
#  ifdef AVERAGES_AKV
        do k=0,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgAKv(i,j,k)=Akv(i,j,k)
            enddo
          enddo
        enddo
#  endif
#  ifdef AVERAGES_AKT
        do k=0,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgAKt(i,j,k)=Akt(i,j,k,itemp)
            enddo
          enddo
        enddo
#  endif
#  ifdef AVERAGES_AKS
        do k=0,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgAKs(i,j,k)=Akt(i,j,k,isalt)
            enddo
          enddo
        enddo
#  endif
# endif
!
!---------------------------------------------------------------------
!  Accumulate time-averaged fields.
!---------------------------------------------------------------------
!
      elseif (iic.gt.ntsavg) then
        do j=JstrR,JendR
          do i=IstrR,IendR
            avgzeta(i,j)=avgzeta(i,j)+zeta(i,j,KOUT)
            avgu2d (i,j)=avgu2d (i,j)+ubar(i,j,KOUT)
            avgv2d (i,j)=avgv2d (i,j)+vbar(i,j,KOUT)
          enddo
        enddo
# ifdef SOLVE3D
#  ifdef LMD_SKPP
        do j=JstrR,JendR
          do i=IstrR,IendR
            avghsbl(i,j)=avghsbl(i,j)+hsbl(i,j)
          enddo
        enddo
#  endif
#  ifdef LMD_BKPP
        do j=JstrR,JendR
          do i=IstrR,IendR
            avghbbl(i,j)=avghbbl(i,j)+hbbl(i,j)
          enddo
        enddo
#  endif
        do k=1,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgu3d(i,j,k)=avgu3d(i,j,k)+u(i,j,k,NOUT)
              avgv3d(i,j,k)=avgv3d(i,j,k)+v(i,j,k,NOUT)
              avgw3d(i,j,k)=avgw3d(i,j,k)+W(i,j,k)*pm(i,j)*pn(i,j)
              avgrho(i,j,k)=avgrho(i,j,k)+rho(i,j,k)
            enddo
          enddo
          do itrc=1,NT
            do j=JstrR,JendR
              do i=IstrR,IendR
                avgt(i,j,k,itrc)=avgt(i,j,k,itrc)+t(i,j,k,NOUT,itrc)
              enddo
            enddo
          enddo
        enddo
#  ifdef AVERAGES_AKV
        do k=0,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgAKv(i,j,k)=avgAKv(i,j,k)+Akv(i,j,k)
            enddo
          enddo
        enddo
#  endif
#  ifdef AVERAGES_AKT
        do k=0,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgAKt(i,j,k)=avgAKt(i,j,k)+Akt(i,j,k,itemp)
            enddo
          enddo
        enddo
#  endif
#  ifdef AVERAGES_AKS
        do k=0,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgAKs(i,j,k)=avgAKs(i,j,k)+Akt(i,j,k,isalt)
            enddo
          enddo
        enddo
#  endif
# endif
      endif
!
!---------------------------------------------------------------------
!  Convert accumulated sums into time-averages, if appropriate.
!---------------------------------------------------------------------
!
      if ((iic.gt.ntsavg).and.(MOD(iic-1,navg).eq.0).and.
     &    ((iic.ne.ntstart).or.(nrrec.eq.0))) then
        fac=1.0_r8/FLOAT(navg)
        if (SOUTH_WEST_CORNER) then
          avgtime=avgtime+FLOAT(navg)*dt
        endif
        do j=JstrR,JendR
          do i=IstrR,IendR
            avgzeta(i,j)=fac*avgzeta(i,j)
            avgu2d (i,j)=fac*avgu2d (i,j)
            avgv2d (i,j)=fac*avgv2d (i,j)
          enddo
        enddo
# ifdef SOLVE3D
#  ifdef LMD_SKPP
        do j=JstrR,JendR
          do i=IstrR,IendR
            avghsbl(i,j)=fac*avghsbl(i,j)
          enddo
        enddo
#  endif
#  ifdef LMD_BKPP
        do j=JstrR,JendR
          do i=IstrR,IendR
            avghbbl(i,j)=fac*avghbbl(i,j)
          enddo
        enddo
#  endif
        do k=1,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgu3d(i,j,k)=fac*avgu3d(i,j,k)
              avgv3d(i,j,k)=fac*avgv3d(i,j,k)
              avgw3d(i,j,k)=fac*avgw3d(i,j,k)
              avgrho(i,j,k)=fac*avgrho(i,j,k)
            enddo
          enddo
          do itrc=1,NT
            do j=JstrR,JendR
              do i=IstrR,IendR
                avgt(i,j,k,itrc)=fac*avgt(i,j,k,itrc)
              enddo
            enddo
          enddo
        enddo
#  ifdef AVERAGES_AKV
        do k=0,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgAKv(i,j,k)=fac*avgAKv(i,j,k)
            enddo
          enddo
        enddo
#  endif
#  ifdef AVERAGES_AKT
        do k=0,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgAKt(i,j,k)=fac*avgAKt(i,j,k)
            enddo
          enddo
        enddo
#  endif
#  ifdef AVERAGES_AKS
        do k=0,N
          do j=JstrR,JendR
            do i=IstrR,IendR
              avgAKs(i,j,k)=fac*avgAKs(i,j,k)
            enddo
          enddo
        enddo
#  endif
# endif /* SOLVE3D */
      endif
#else
      subroutine set_avg
#endif
      return
      end
