#include "cppdefs.h"
      subroutine set_3dfld_tile (Istr,Iend,Jstr,Jend,ifield,
     &                           Finp,Fout,update)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine time-interpolates requested 3D field from snapshots  !
!  of input data.                                                    !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "iounits.h"
# include "ncparam.h"
# include "scalars.h"
!
      logical Lgrided, Lonerec, update
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, Tindex, i, ifield, it1, it2,
     &        j, k, lvar
      INTEGER_TYPE
     &        lenstr
      REAL_TYPE
     &        Fval, Tend, fac, fac1, fac2
      REAL_TYPE
     &        Finp(GLOBAL_2D_ARRAY,N,2),
     &        Fout(GLOBAL_2D_ARRAY,N)
!
# include "set_bounds.h"
!
!--------------------------------------------------------------------
!  Set-up requested field for current tile.
!--------------------------------------------------------------------
!
!  Get requested field information from global storage.
!
      Lgrided=Linfo(1,ifield)
      Lonerec=Linfo(3,ifield)
      Tindex =Iinfo(5,ifield)
      update=.true.
!
!  Set linear-interpolation factors.
!
      it1=3-Tindex
      it2=Tindex
      fac1=Tintrp(it2,ifield)-time
      fac2=time-Tintrp(it1,ifield)
!
!  Load time-invariant data. Time interpolation is not necessary.
!
      if (Lonerec) then
        if (Lgrided) then
          do k=1,N
            do j=JstrR,JendR
              do i=IstrR,IendR
                Fout(i,j,k)=Finp(i,j,k,Tindex)
              enddo
            enddo
          enddo
        else
          Fval=Fpoint(Tindex,ifield)
          do k=1,N
            do j=JstrR,JendR
              do i=IstrR,IendR
                Fout(i,j,k)=Fval
              enddo
            enddo
          enddo
        endif
!
!  Time-interpolate from grided or point data.
!
      elseif (((fac1*fac2).ge.0.0_r8).and.
     &        ((fac1+fac2).gt.0.0_r8)) then
        fac=1.0_r8/(fac1+fac2)
        fac1=fac*fac1
        fac2=fac*fac2
        if (Lgrided) then
          do k=1,N
            do j=JstrR,JendR
              do i=IstrR,IendR
                Fout(i,j,k)=fac1*Finp(i,j,k,it1)+fac2*Finp(i,j,k,it2)
              enddo
            enddo
          enddo
        else
          Fval=fac1*Fpoint(it1,ifield)+fac2*Fpoint(it2,ifield)
          do k=1,N
            do j=JstrR,JendR
              do i=IstrR,IendR
                Fout(i,j,k)=Fval
              enddo
            enddo
          enddo
        endif
!
!  Activate synchronization flag if a new time record needs to be
!  read in at the next time step.
!
        if ((time+dt).gt.Tintrp(it2,ifield)) then
          if (SOUTH_WEST_CORNER) synchro_flag=.TRUE.
        endif
!
!  Unable to set-up requested field.  Activate error flag to quit.
!
      else
        if (SOUTH_WEST_CORNER) then
          Tend=Finfo(2,ifield)
          lvar=lenstr(Vname(5,ifield))
          write(stdout,10) Vname(5,ifield)(1:lvar), tdays, Tend,
     &                     Tintrp(it1,ifield)*sec2day,
     &                     Tintrp(it2,ifield)*sec2day
  10      format(/,' SET_3DFLD  - current model time',
     &           ' exceeds ending value for variable: ',a,
     &           /,14x,'TDAYS   = ',f15.4,2x,'TEND    = ',f15.4,
     &           /,14x,'TINTRP1 = ',f15.4,2x,'TINTRP2 = ',f15.4)
          exit_flag=2
          update=.false.
        endif
      endif
      return
      end
