#ifdef SEDIMENT

/*
** Include file "sediment.h".
*************************************************** John C. Warner ***
** Copyright (c) 2002 Rutgers                                       **
************************************************* Hernan G. Arango ***
**                                                                  **
**  bed      Sediment bed layer properties.                         **
**  bed_frac Sediment class fraction composition in each layer      **
**             (non-dimensional: 0.0-1.0).                          **
**  bottom   Bottom (exposed sediment layer) properties.            **
**                                                                  **
** Parameters for sediment model:                                   **
**                                                                  **
**  Csed     Sediment concentration (mg/l), used during analytical  **
**             initialization.                                      **
**  Erate    Surface erosion rate (kg/m2/s).                        **
**  Sd50     Median sediment grain diameter (m).                    **
**  Srho     Sediment grain density (kg/m3).                        **
**  SedIter  Maximum number of iterations.                          **
**  Wsed     Particle settling velocity (m/s).                      **
**  poros    Porosity (non-dimensional: 0.0-1.0):                   **
**             Vwater/(Vwater+Vsed).                                **
**  tau_ce   Kinematic critical shear for erosion (m2/s2).          **
**  tau_cd   Kinematic critical shear for deposition (m2/s2).       **
**                                                                  **
** BED properties indices:                                          **
**                                                                  **
**  MBEDP    Number of bed properties (array dimension).            **
**  idSbed   IO indices for bed properties variables.               **
**  idfrac   sediment class fraction (non-dimensional).             **
**  ithck    Sediment layer thickness (m).                          **
**  iaged    Sediment layer age (days).                             **
**  iporo    Sediment layer porosity (non-dimensional).             **
**  idiff    Bio-diffusivity at the bottom of each layer.           **
**                                                                  **
** BOTTOM properties indices:                                       **
**                                                                  **
**  MBOTP    Number of bottom properties (array dimension).         **
**  idBott   IO indices for bottom properties variables.            **
**  irlen    Sediment ripple length (m).                            **
**  irhgt    Sediment ripple height (m).                            **
**  ishgt    Sediment saltation height (m).                         **
**  izNik    Nikuradse bottom roughness (m).                        **
**  izbio    Biological bottom roughness (m).                       **
**  izbld    Bed load bottom roughness (m).                         **
**  izbfm    Bed form bottom roughness (m).                         **
**  izapp    Apparent bottom roughness (m).                         **
**                                                                  **
** Sediment tracers identification indices:                         **
**                                                                  **
**  idsed    Cohesive and non-cohesive sediment indices.            **
**  idmud    Cohesive sediment indices.                             **
**  isand    Non-cohesive sediment indices.                         **
**                                                                  **
**********************************************************************
*/

      INTEGER_TYPE
     &        MBEDP,             ithck,             iaged,
     &        iporo,             idiff
      parameter
     &       (MBEDP=4,           ithck=1,           iaged=2,
     &        iporo=3,           idiff=4)

      INTEGER_TYPE
     &        MBOTP,             irlen,             irhgt,
     &        ishgt,             izNik,             izbio,
     &        izbld,             izbfm,             izapp
      parameter
     &       (MBOTP=8,           irlen=1,           irhgt=2,
     &        ishgt=3,           izNik=4,           izbio=5,
     &        izbld=6,           izbfm=7,           izapp=8)

      common /isediment/
     &        SedIter,           idBott,            idSbed,
     &        idfrac,            idsed,             idmud,
     &        isand
      INTEGER_TYPE
     &        SedIter,           idBott(MBOTP),     idSbed(MBEDP),
     &        idfrac(NST),       idsed(NST),        idmud(NCS+1),
     &        isand(NNS+1)

      common /ssediment/
     &        Csed,              Erate,             Sd50,
     &        Srho,              Wsed,              poros,
     &        tau_ce,            tau_cd
      REAL_TYPE
     &        Csed(NST),         Erate(NST),        Sd50(NST),
     &        Srho(NST),         Wsed(NST),         poros(NST),
     &        tau_ce(NST),       tau_cd(NST)

      common /sediment_bed/ bed
      REAL_TYPE bed(GLOBAL_2D_ARRAY,Nbed,MBEDP)

      common /sediment_bed_frac/ bed_frac
      REAL_TYPE bed_frac(GLOBAL_2D_ARRAY,Nbed,NST)

      common /sediment_bottom/ bottom
      REAL_TYPE bottom(GLOBAL_2D_ARRAY,MBOTP)

#endif /* SEDIMENT */
