/*
** Include file "scratch.h"
***************************************** Alexander F. Shchepetkin ***
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** A2d        Horizontal, slice scratch-arrays.                     **
** A3d        vertical, slice scratch-arrays.                       **
** B3d        volume scratch array.                                 **
** NSA2       Number of horizontal, slice scratch-arrays needed.    **
** NSA3       Number of vertical, slice scratch-arrays needed.      **
** N2d        Total size of horizontal slice.                       **
** N3d        Total size of vertical slice.                         **
** size_ETA   Size of tile in the ETA-direction.                    **
** size_XI    Size of tile in the XI-direction.                     **
**                                                                  **
**********************************************************************
*/

      INTEGER_TYPE
     &        NSA2, NSA3, N2d, N3d, size_XI, size_ETA
!!    parameter (NSA2=16, NSA3=4)
      parameter (NSA2=30, NSA3=4)

      parameter (size_XI =7+(Lm+NSUB_X-1)/NSUB_X,
     &           size_ETA=7+(Mm+NSUB_E-1)/NSUB_E)

      INTEGER_TYPE
     &        se, sse, sz, ssz
      parameter (sse=size_ETA/Np, ssz=Np/size_ETA,
     &           se=sse/(sse+ssz), sz=1-se)
      parameter (N2d=size_XI*(se*size_ETA+sz*Np),
     &           N3d=size_XI*size_ETA*Np)

/*
**  Private scratch arrays.
*/

      common /scratch_A2d/ A2d
!$OMP THREADPRIVATE(/scratch_A2d/)
      REAL_TYPE A2d(N2d,NSA2)

      common /scratch_A3d/ A3d
!$OMP THREADPRIVATE(/scratch_A3d/)
      REAL_TYPE A3d(N3d,NSA3)

      common /scratch_B3d/ B3d
      REAL_TYPE B3d(GLOBAL_2D_ARRAY,0:N)

