/*
** Include file "scalars.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Cdb_max   Maximum bottom drag coefficient allowed.               **
** Cdb_max   Minimum bottom drag coefficient to avoid the           **
**             law-of-the-wall to extend indefinitely.              **
** Cp        Specific heat for seawater (Joules/Kg/degC).           **
** Csolar    Solar irradiantion constant (W/m2).                    **
** ERstr     Starting ensemble run number.                          **
** ERend     Ending ensemble run number.                            **
** Eradius   Equatorial radius of the Earth (m).                    **
** LastRec   Logical switch to inialize model with latest time      **
**             record from initial (restart/history) NetCDF file.   **
** LdefAVG   Logical switch to activate creation of AVERAGES NetCDF **
**             file.                                                **
** LdefFLT   Logical switch to activate creation of FLOATS NetCDF   **
**             file.                                                **
** LdefHIS   Logical switch to activate creation of HISTORY NetCDF  **
**             file.                                                **
** LdefRST   Logical switch to activate creation of RESTART NetCDF  **
**             file.                                                **
** LdefSTA   Logical switch to activate creation of STATIONS NetCDF **
**             file.                                                **
** LwrtHIS   Logical switch to activate writing fields into history **
**             file.                                                **
** LwrtPER  Logical switch to activate writing fields into history  **
**             file in perturbation mode.                           **
** M2nudg    Inverse time scale (1/s) of the nudging towards 2D     **
**             momentum data.                                       **
** M3nudg    Inverse time scale (1/s) of the nudging towards 3D     **
**             momentum data.                                       **
** Nrun      Ensemble run number.                                   **
** Nuser     Number of generic user parameters read from standard   **
**             input.                                               **
** R0        Background constant density anomaly (kg/m^3) used in   **
**             linear equation of state.                            **
** Scoef     Saline contraction coefficient in linear equation of   **
**             state.                                               **
** S0        Background salinity (PSU) value used in analytical     **
**             fields.                                              **
** StefBo    Stefan-Boltzmann constant (W/m2/K4).                   **
** Tcoef     Thermal expansion coefficient in linear equation of    **
**             state.                                               **
** Tnudg     Inverse time scale (1/s) of the nudging towards tracer **
**             data.                                                **
** T0        Background potential temperature (Celsius) value used  **
**             in analytical fields.                                **
** Znudg     Inverse time scale (1/s) of the nudging towards sea    **
**             surface height data.                                 **
** Zob       Bottom roughness (m).                                  **
** Zos       Surface roughness (m).                                 **
** adv_ord   Number of iterations or passes trough advection        **
**             operator in the Smolarkiewicz scheme.                **
** day2sec   Factor to convert from days to seconds.                **
** deg2rad   Factor to convert from degrees to radians.             **
** dstart    Time stamp assigned to model initialization (usually   **
**             a Calendar day, like modified Julian Day).           **
** dt        Size of 3D primitive equations timestep (s).           **
** dtfast    Size of 2D primitive equations timestep (s).           **
** emmiss    Infrared emmissivity.                                  **
** exit_flag Execution termination flag.                            **
** g         Acceleration due to gravity (m/s^2).                   **
** gorho0    gravity divided by mean density anomaly.               **
** gamma2    Slipperiness variable, either 1.0 (free slip) or -1.0  **
**             (no slip).                                           **
** icavg     Current number of time-records accumulated in output   **
**             time-averaged arrays.                                **
** iic       Timestep counter for 3D primitive equations.           **
** iif       Timestep counter for 2D primitive equations.           **
** jul_off   Modified Julian day offset (days).                     **
** knew      Fast time index corresponding to the newest time step  **
**             for variables associated with 2D primitive equations **
** krhs      Fast time index corresponding to the time step 2D      **
**             primitive variables used to calculate the right-hand **
**             terms.                                               **
** kstp      Fast time index corresponding to the time step 2D      **
**             primitive variables to which the current changes     **
**             are added to compute the new time step values.       **
** lambda    Weighting coefficient for the newest [implicit] time   **
**             step derivatives in the Crack-Nicolson implicit      **
**             scheme [usually, lambda=0.5].                        **
** lcycle    Logical switch used to recycle time records in output  **
**             restart file. If TRUE, only the latest two restart   **
**             time records are maintained.  If FALSE, all restart  **
**             fields are saved every NRST timesteps without        **
**             recycling.                                           **
** ldefout   Logical switch used to create new output NetCDF files. **
**             If TRUE, new output files are created. If FALSE,     **
**             data is appended to an existing output files.        **
** levbfrc   Shallowest level to apply bottom momentum stress as a  **
**             bodyforce.                                           **
** levsfrc   Deepest level to apply surface momentum stress as a    **
**             bodyforce.                                           **
** navg      Number of timesteps between storage of time-averaged   **
**             fields.                                              **
** ndefavg   Number of time-steps between the creation of new       **
**             time-averaged NetCDF file.                           **
** ndefhis   Number of time-steps between the creation of new       **
**             history NetCDF file.                                 **
** ndtfast   Number of timesteps for 2-D equations between each     **
**             baroclinic time-step "dt".                           **
** nfast                                                            **
** nfm3       Float index for time level "n-3".                     **
** nfm2       Float index for time level "n-2".                     **
** nfm1       Float index for time level "n-1".                     **
** nf         Float index for time level "n".                       **
** nfp1       Float index for time level "n+1".                     **
** nflt      Number of timesteps between storage of float data.     **
** nhis      Number of timesteps between writing of fields into     **
**             output history file.                                 **
** ninfo     Number of timesteps between print of single line       **
**             information to standard output.                      **
** nmix_en   Number of timesteps between computations of isopycnal  **
**             slopes used in the rotated mixing tensor.            **
** nrecavg   Number of time records written in averages file.       **
** nrecflt   Number of time records written in floats file.         **
** nrechis   Number of time records written in history file.        **
** nrecrst   Number of time records written in restart file.        **
** nrecsta   Number of time records written in stations file.       **
** nnew                                                             **
** nrhs                                                             **
** nstp                                                             **
** nrrec     Number of restart time records to read from disk, the  **
**             last is used as the initial conditions.              **
** nrst      Number of timesteps between storage of restart fields. **
** nsta      Number of timesteps between storage of station data.   **
** ntend     Ending timestep                                        **
** ntfirst   Timestep at which at Forward-Euler step is performed,  **
**             usually at initialization and after assimilation.    **
** ntimes    Ending timestep in evolving the 3D primitive equations **
**             in current run.                                      **
** ntsavg    Starting timestep for accumulation of output           **
**             time-averaged fields.                                **
** ntstart   Starting timestep in evolving the 3D primitive         **
**             equations; usually 1, if not a restart run.          **
** obcfac    Factor between passive and active open boundary        **
**             conditions (nondimensional).                         **
** pi        Ratio of circumference to diameter.                    **
** rad2def   Factor to convert from radians to degrees.             **
** rdrg      Linear bottom drag coefficient.                        **
** rdrg2     Quadratic bottom drag coefficient.                     **
** rho0      Mean density anomaly (kg/m^3).                         **
** rstflag   Logical switch which indicates whether or not a model  **
**             restart.                                             **
** r_date    Model initialization reference date (vector):          **
**             r_date(1) => reference date (yyyymmdd.f).            **
**             r_date(2) => year.                                   **
**             r_date(3) => year day.                               **
**             r_date(4) => month.                                  **
**             r_date(5) => day.                                    **
**             r_date(6) => hour.                                   **
**             r_date(7) => minute.                                 **
**             r_date(8) => second.                                 **
** r_text    Model initialization reference text (string).          **
** sec2day   Factor to convert from seconds to days.                **
** spval     Special value.                                         **
** tdays     Model time since initialization (days).                **
** time      Model time since initialization (s).                   **
** time_ref  Reference time for "units" attribute (yyyymmdd.f).     **
** user      Generic user parameters (real vector).                 **
** vonKar    von Karman constant.                                   **
** weight    Time-averagin filters for barotropic fields.           **
**                                                                  **
**********************************************************************
*/

      common /lscalars/
     &        LastRec,           LdefAVG,           LdefFLT,
     &        LdefHIS,           LdefRST,           LdefSTA,
     &        LwrtHIS,           LwrtPER,           lcycle,
     &        ldefout,           rstflag,           synchro_flag
      logical
     &        LastRec,           LdefAVG,           LdefFLT,
     &        LdefHIS,           LdefRST,           LdefSTA,
     &        LwrtHIS,           LwrtPER,           lcycle,
     &        ldefout,           rstflag,           synchro_flag

      common /iscalars/
     &        ERend,             ERstr,             Nrun,
     &        Nuser,             adv_ord,           exit_flag,
     &        first_time,        icavg,             levbfrc,
     &        levsfrc,           navg,              ndefavg,
     &        ndefhis,           ndtfast,           nfast,
     &        nflt,              nhis,              ninfo,
     &        nmix_en,           nrrec,             nrecavg,
     &        nrecflt,           nrechis,           nrecrst,
     &        nrecsta,           nrst,              nsta,
     &        ntfirst,           ntsavg,            ntimes,
     &        ntstart,           nwrt
      INTEGER_TYPE
     &        ERend,             ERstr,             Nrun,
     &        Nuser,             adv_ord,           exit_flag,
     &        first_time,        icavg,             levbfrc,
     &        levsfrc,           navg,              ndefavg,
     &        ndefhis,           ndtfast,           nfast,
     &        nflt,              nhis,              ninfo,
     &        nmix_en,           nrrec,             nrecavg,
     &        nrecflt,           nrechis,           nrecrst,
     &        nrecsta,           nrst,              nsta,
     &        ntfirst,           ntsavg,            ntimes,
     &        ntstart,           nwrt

      common /sscalars/
     &        Cdb_max,           Cdb_min,           Cp,
     &        Csolar,            R0,                Eradius,
     &        M2nudg,            M3nudg,            T0,
     &        S0,                StefBo,            Tcoef,
     &        Tnudg,             Scoef,             Znudg,
     &        Zob,               Zos,               avgtime,
     &        day2sec,           deg2rad,           dt,
     &        dtfast,            dstart,            emmiss,
     &        gamma2,            g,                 gorho0,
     &        jul_off,           lambda,            obcfac,
     &        pi,                rad2deg,           rdrg,
     &        rdrg2,             rho0,              r_date,
     &        sec2day,           spval,             time_ref,
     &        user,              vonKar
      REAL_TYPE
     &        Cdb_max,           Cdb_min,           Cp,
     &        Csolar,            R0,                Eradius,
     &        M2nudg,            M3nudg,            T0,
     &        S0,                StefBo,            Tcoef,
     &        Tnudg(NT+1),       Scoef,             Znudg,
     &        Zob,               Zos,               avgtime,
     &        day2sec,           deg2rad,           dt,
     &        dtfast,            dstart,            emmiss,
     &        gamma2,            g,                 gorho0,
     &        jul_off,           lambda,            obcfac,
     &        pi,                rad2deg,           rdrg,
     &        rdrg2,             rho0,              r_date(8),
     &        sec2day,           spval,             time_ref,
     &        user(25),          vonKar

      common /cscalars/
     &        r_text
      character*19 r_text

      common /diagnostics/
     &        avgke,             avgkp,             avgpe,
     &        dia_count,         grdmax,            rx0,
     &        rx1,               volume
      REAL_TYPE
     &        avgke,             avgkp,             avgpe,
     &        dia_count,         grdmax,            rx0,
     &        rx1,               volume

/*
** The following common block contains time indices for 2D and 3D
** computational engines.
*/

      common /model_indices/
     &        PREDICTOR_2D_STEP, iic,               iif,
     &        indx1,             knew,              krhs,
     &        kstp,              nnew,              nrhs,
     &        nstp,              ntend,             numthreads
      logical
     &        PREDICTOR_2D_STEP
      INTEGER_TYPE
     &        iic,               iif,               indx1,
     &        knew,              krhs,              kstp,
     &        nnew,              nrhs,              nstp,
     &        ntend,             numthreads

#ifdef FLOATS
      common /floats_indices/
     &        nf,                nfm1,              nfm2,
     &        nfm3,              nfp1
      INTEGER_TYPE
     &        nf,                nfm1,              nfm2,
     &        nfm3,              nfp1
#endif  

      common /model_time/
     &        tdays,             time
      REAL_TYPE
     &        tdays,             time

/*
** The following common block contains time-averaging filter for
** barotropic fields.
*/

#ifdef SOLVE3D
      common /weights/
     &        weight
      REAL_TYPE
     &        weight(2,0:256)
#endif

/*
** The following common block contains variables used to impose mass
** flux conservation in open boundary configurations.
*/

      common /bc_volcons/
     &        bc_area,           bc_count,          bc_flux,
     &        ubar_xs
      REAL_TYPE
     &        bc_area,           bc_count,          bc_flux,
     &        ubar_xs

#ifdef BULK_FLUXES
/*
**********************************************************************
** Constants used in surface fluxes bulk parameterization.          **
**********************************************************************
**                                                                  **
** blk_Cpa   Specific heat capacity for dry air (J/kg/K).           **
** blk_Cpw   Specific heat capacity for seawater (J/kg/K).          **
** blk_Rgas  Gas constant for dry air (J/kg/K).                     **
** blk_Rr    Liu et al (1979) look-up table ranges for wind         **
**             Reynolds number.                                     **
** blk_Zabl  Height (m) of atmospheric boundary layer.              **
** blk_ZQ    Height (m) of surface air humidity meassurement.       **
** blk_ZT    Height (m) of surface air temperature meassurement.    **
** blk_ZW    Height (m) of surface winds meassurement.              **
** blk_a     Liu et al (1979) look-up table coefficient "a" for     **
**             then computation of rougness Reynolds numbers.       **
** blk_a     Liu et al (1979) look-up table coefficient "b" for     **
**             then computation of rougness Reynolds numbers.       **
** blk_beta  Beta parameter evaluated from Fairall low windspeed    **
**             turbulence data.                                     **
** blk_fdg   Fairall LKB roughness Reynolds number to Von Karman    **
**             adjustment.                                          **
** blk_tcw   Thermal conductivity of water (W/m/K).                 **
** blk_visw  Kinematic viscosity water (m2/s).                      **
**                                                                  **
**********************************************************************
*/

      common /blk_Fscalars/
     &        blk_Cpa,           blk_Cpw,           blk_Rgas,
     &        blk_Zabl,          blk_ZQ,            blk_ZT,
     &        blk_ZW,            blk_beta,          blk_fdg,
     &        blk_tcw,           blk_visw
      REAL_TYPE
     &        blk_Cpa,           blk_Cpw,           blk_Rgas,
     &        blk_Zabl,          blk_ZQ,            blk_ZT,
     &        blk_ZW,            blk_beta,          blk_fdg,
     &        blk_tcw,           blk_visw

      common /blk_Liu/
     &        Liu_a,             Liu_b,             Liu_Rr
      REAL_TYPE
     &        Liu_a(8,2),        Liu_b(8,2),        Liu_Rr(9)
#endif /* BULK_FLUXES */
