#include "cppdefs.h"
      program roms
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  Regional Ocean Model System (ROMS), Version 2.0                   !
!                                                                    !
!  This ocean model solves the free surface, hydrostatic, primitive  !
!  equations  over  variable  topography  using  stretched terrain-  !
!  following coordinates in the vertical and orthogonal curvilinear  !
!  coordinates in the horizontal.                                    !
!                                                                    !
!  Developers:                                                       !
!                                                                    !
!  Dr. Hernan G. Arango                                              !
!    Institute of Marine and Coastal Sciences                        !
!    Rutgers University, New Brunswick, NJ, USA                      !
!    (arango@imcs.rutgers.edu)                                       !
!                                                                    !
!  Dr. Alexander F. Shchepetkin                                      !
!    Institute of Geophysics and Planetary Physics                   !
!    UCLA, Los Angeles, CA, USA                                      !
!    (alex@atmos.ucla.edu)                                           !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "scalars.h"
#include "wclock.h"
!
!---------------------------------------------------------------------
!  Initialize model internal parameters.
!---------------------------------------------------------------------
!
      call init_scalars
!
!---------------------------------------------------------------------
!  Read in model tunable parameters from standard input.
!---------------------------------------------------------------------
!
      call inp_par
!
!---------------------------------------------------------------------
!  Run model once or an ensemble set.
!---------------------------------------------------------------------
!
#ifdef _OPENMP
      call my_initlock (lock)
#endif
      do Nrun=ERstr,ERend
!
!  Initialize model state variables.
!
        call initial
        if (exit_flag.ne.0) then
          write(stdout,10) Rerror(exit_flag), exit_flag
 10       format(/,a,i3,/)
          goto 30
        endif
!
!  Time step ocean model.
!
        write(stdout,20) ntstart, ntend
 20     format(/,' ROMS: started time-stepping:',
     &         '( TimeSteps: ',i8.8,' - ',i8.8,')',/)
!
        time=time-dt
        do iic=ntstart,ntend+1
#ifdef SOLVE3D
          call main3d
#else
          call main2d
#endif
          if (exit_flag.ne.0) then
            write(stdout,10) Rerror(exit_flag), exit_flag
            goto 30
          endif
        enddo
      enddo
 30   continue
#ifdef _OPENMP
      call my_destroylock (lock)
#endif
!
!---------------------------------------------------------------------
!  Close IO files.
!---------------------------------------------------------------------
!
      call close_io
      stop
      end
