#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine rhs3d (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine evaluates the right-hand-side term of the 3D      !
!  momentum and tracers equations.                                   !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
!---------------------------------------------------------------------
!  Initialize computations for new time step of the 3D primitive
!  variables.
!---------------------------------------------------------------------
!
      call pre_step3d (tile)
!
!---------------------------------------------------------------------
!  Compute baroclinic pressure gradient.
!---------------------------------------------------------------------
!
      call prsgrd (tile)
# ifndef DIAGNOSTIC
#  ifdef TS_DIF2
!
!---------------------------------------------------------------------
!  Compute horizontal harmonic mixing of tracer type variables.
!---------------------------------------------------------------------
!
#   if defined MIX_S_TS
      call t3dmix2_s (tile)
#   elif defined MIX_GEO_TS
      call t3dmix2_geo (tile)
#   elif defined MIX_ISO_TS
      call t3dmix2_iso (tile)
#   endif
#  endif /* TS_DIF2 */
#  ifdef TS_DIF4
!
!---------------------------------------------------------------------
!  Compute horizontal biharmonic mixing of tracer type variables.
!---------------------------------------------------------------------
!
#   if defined MIX_S_TS
      call t3dmix4_s (tile)
#   elif defined MIX_GEO_TS
      call t3dmix4_geo (tile)
#   elif defined MIX_ISO_TS
      call t3dmix4_iso (tile)
#   endif
#  endif /* TS_DIF4 */
# endif /* !DIAGNOSTIC */
# ifdef UV_VIS2
!
!---------------------------------------------------------------------
!  Compute horizontal, harmonic mixing of momentum.
!---------------------------------------------------------------------
!
#  if defined MIX_S_UV
      call uv3dmix2_s (tile)
#  elif defined MIX_GEO_UV
      call uv3dmix2_geo (tile)
#  endif
# endif /* UV_VIS2 */
# ifdef UV_VIS4
!---------------------------------------------------------------------
!  Compute horizontal, biharmonic mixing of momentum.
!---------------------------------------------------------------------
!
#  if defined MIX_S_UV
      call uv3dmix4_s (tile)
#  elif defined MIX_GEO_UV
      call uv3dmix4_geo (tile)
#  endif
# endif /* UV_VIS4 */
!
!---------------------------------------------------------------------
!  Compute the right-hand-side term of the 3D momentum equations.
!---------------------------------------------------------------------
!
# ifdef PROFILE
      call wclock_on (21)
# endif
      call rhs3d_tile (Istr,Iend,Jstr,Jend,
     &                 A2d(1,1),A2d(1,2),A2d(1,3),A2d(1,4),
     &                 A2d(1,5),A2d(1,6),A2d(1,7),A2d(1,8),
     &                 A2d(1,9))
# ifdef PROFILE
      call wclock_off (21)
# endif
      return
      end
!
!*********************************************************************
      subroutine rhs3d_tile (Istr,Iend,Jstr,Jend,CF,DC,FC,wrk1,wrk2,
     &                       UFx,UFe,VFx,VFe)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "clima.h"
# include "coupling.h"
# include "forces.h"
# include "grid.h"
# include "ncparam.h"
# include "obs.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        Gadv, cff, cff1, cff2
# ifdef UV_SADVECTION
      REAL_TYPE
     &        cff3, cff4
# endif
      REAL_TYPE
     &          CF(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &          DC(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &          FC(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &         UFx(PRIVATE_2D_SCRATCH_ARRAY),
     &         UFe(PRIVATE_2D_SCRATCH_ARRAY),
     &         VFx(PRIVATE_2D_SCRATCH_ARRAY),
     &         VFe(PRIVATE_2D_SCRATCH_ARRAY),
     &        wrk1(PRIVATE_2D_SCRATCH_ARRAY),
     &        wrk2(PRIVATE_2D_SCRATCH_ARRAY)
!
      parameter (Gadv=-0.25_r8)
!
# include "set_bounds.h"
!
# ifdef BODYFORCE
!---------------------------------------------------------------------
!  Apply surface stress as a bodyforce: determine the thickness (m)
!  of the surface layer; then add in surface stress as a bodyfoce.
!---------------------------------------------------------------------
!
#  define Uwrk UFx
#  define Vwrk VFe
#  define wrk UFe
      do j=JstrV-1,Jend
        do i=IstrU-1,Iend
          wrk(i,j)=0.0_r8
        enddo
      enddo
      do k=N,levsfrc,-1
        do j=JstrV-1,Jend
          do i=IstrU-1,Iend
            wrk(i,j)=wrk(i,j)+Hz(i,j,k)
          enddo
        enddo
      enddo
      do j=Jstr,Jend
        do i=IstrU,Iend
          Uwrk(i,j)=sustr(i,j)*4.0_r8/((wrk(i-1,j)+wrk(i,j))*
     &                                 (pm (i-1,j)+pm (i,j))*
     &                                 (pn (i-1,j)+pn (i,j)))
        enddo
      enddo
      do j=JstrV,Jend
        do i=Istr,Iend
          Vwrk(i,j)=svstr(i,j)*4.0_r8/((wrk(i,j-1)+wrk(i,j))*
     &                                 (pm (i,j-1)+pm (i,j))*
     &                                 (pn (i,j-1)+pn (i,j)))
        enddo
      enddo
      do k=levsfrc,N
        do j=Jstr,Jend
          do i=IstrU,Iend
            ru(i,j,k,nrhs)=ru(i,j,k,nrhs)+
     &                     Uwrk(i,j)*(Hz(i,j,k)+Hz(i-1,j,k))
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            rv(i,j,k,nrhs)=rv(i,j,k,nrhs)+
     &                     Vwrk(i,j)*(Hz(i,j,k)+Hz(i,j-1,k))
          enddo
        enddo
      enddo
!
!  Apply bottom stress as a bodyforce: determine the thickness (m)
!  of the bottom layer; then add in bottom stress as a bodyfoce.
!
      do j=JstrV-1,Jend
        do i=IstrU-1,Iend
          wrk(i,j)=0.0_r8
        enddo
      enddo
      do k=1,levbfrc
        do j=JstrV-1,Jend
          do i=IstrU-1,Iend
            wrk(i,j)=wrk(i,j)+Hz(i,j,k)
          enddo
        enddo
      enddo
      do j=Jstr,Jend
        do i=IstrU,Iend
          Uwrk(i,j)=bustr(i,j)*4.0_r8/((wrk(i-1,j)+wrk(i,j))*
     &                                 (pm (i-1,j)+pm (i,j))*
     &                                 (pn (i-1,j)+pn (i,j)))
        enddo
      enddo
      do j=JstrV,Jend
        do i=Istr,Iend
          Vwrk(i,j)=bvstr(i,j)*4.0_r8/((wrk(i,j-1)+wrk(i,j))*
     &                                 (pm (i,j-1)+pm (i,j))*
     &                                 (pn (i,j-1)+pn (i,j)))
        enddo
      enddo
      do k=1,levbfrc
        do j=Jstr,Jend
          do i=IstrU,Iend
            ru(i,j,k,nrhs)=ru(i,j,k,nrhs)-
     &                     Uwrk(i,j)*(Hz(i,j,k)+Hz(i-1,j,k))
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            rv(i,j,k,nrhs)=rv(i,j,k,nrhs)-
     &                     Vwrk(i,j)*(Hz(i,j,k)+Hz(i,j-1,k))
          enddo
        enddo
      enddo
#  undef wrk
#  undef Vwrk
#  undef Uwrk
# endif /* BODYFORCE */
!
      do k=1,N
!
# if defined UV_COR || (defined CURVGRID && defined UV_ADV)
!---------------------------------------------------------------------
!  Add in Coriolis and curvilinear transformation terms, if any.
!---------------------------------------------------------------------
!
        do j=JstrV-1,Jend
          do i=IstrU-1,Iend
            cff=0.5_r8*Hz(i,j,k)*(
#  ifdef UV_COR
     &          fomn(i,j)
#  endif
#  if (defined CURVGRID && defined UV_ADV)
     &         +0.5_r8*((v(i,j,k,nrhs)+v(i,j+1,k,nrhs))*dndx(i,j)-
     &                  (u(i,j,k,nrhs)+u(i+1,j,k,nrhs))*dmde(i,j))
#  endif
     &          )
            UFx(i,j)=cff*(v(i,j,k,nrhs)+v(i,j+1,k,nrhs))
            VFe(i,j)=cff*(u(i,j,k,nrhs)+u(i+1,j,k,nrhs))
          enddo
        enddo
        do j=Jstr,Jend
          do i=IstrU,Iend
            ru(i,j,k,nrhs)=ru(i,j,k,nrhs)+
     &                     0.5_r8*(UFx(i,j)+UFx(i-1,j))
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            rv(i,j,k,nrhs)=rv(i,j,k,nrhs)-
     &                     0.5_r8*(VFe(i,j)+VFe(i,j-1))
          enddo
        enddo
# endif /* UV_COR || (CURVGRID && UV_ADV) */
# ifdef M3CLM_NUDGING
!
!---------------------------------------------------------------------
!  Add in nudging of 3D momentum climatology.
!---------------------------------------------------------------------
!
        do j=Jstr,Jend
          do i=IstrU,Iend
            ru(i,j,k,nrhs)=ru(i,j,k,nrhs)+
     &                     0.25_r8*(M3nudgcof(i-1,j)+M3nudgcof(i,j))*
     &                     (Hz(i-1,j,k)+Hz(i,j,k))*
     &                     (uclm(i,j,k)-u(i,j,k,nrhs))*
     &                     om_u(i,j)*on_u(i,j)
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            rv(i,j,k,nrhs)=rv(i,j,k,nrhs)+
     &                     0.25_r8*(M3nudgcof(i,j-1)+M3nudgcof(i,j))*
     &                     (Hz(i,j-1,k)+Hz(i,j,k))*
     &                     (vclm(i,j,k)-v(i,j,k,nrhs))*
     &                     om_v(i,j)*on_v(i,j)
         enddo
       enddo
# endif /* M3CLM_NUDGING */
# if defined NUDGING_UVsur || defined NUDGING_UV
!
!---------------------------------------------------------------------
!  Assimilate horizontal currents observations via nudging.
!---------------------------------------------------------------------
!
!  Notice that the nondimensional error variance "EobsUV" is flipped,
!  so a value of unity represents unavailable data.
!
        if (update_UV) then
          do j=Jstr,Jend
            do i=IstrU,Iend
              cff=MIN(1.0_r8,MAX(0.0_r8,0.5_r8*(EobsUV(i-1,j,k)+
     &                                          EobsUV(i  ,j,k))))
              cff=M3nudass*(1.0_r8-cff)
              ru(i,j,k,nrhs)=ru(i,j,k,nrhs)+
     &                       cff*0.5_r8*(Hz(i,j,k)+Hz(i-1,j,k))*
     &                           (Uobs(i,j,k)-u(i,j,k,nrhs))*
     &                           om_u(i,j)*on_u(i,j)
            enddo
          enddo
          do j=JstrV,Jend
            do i=Istr,Iend
              cff=MIN(1.0_r8,MAX(0.0_r8,0.5_r8*(EobsUV(i,j-1,k)+
     &                                          EobsUV(i,j  ,k))))
              cff=M3nudass*(1.0_r8-cff)
              rv(i,j,k,nrhs)=rv(i,j,k,nrhs)+
     &                       cff*0.5_r8*(Hz(i,j-1,k)+Hz(i,j,k))*
     &                           (Vobs(i,j,k)-v(i,j,k,nrhs))*
     &                           om_v(i,j)*on_v(i,j)
            enddo
          enddo
        endif
# endif /* NUDGING_UVsur || NUDGING_UV */
# ifdef UV_ADV
!---------------------------------------------------------------------
!  Add in horizontal advection of momentum.
!---------------------------------------------------------------------
!
!  Compute diagonal [UFx,VFe] and off-diagonal [UFe,VFx] components
!  of tensor of momentum flux due to horizontal advection.
!
#  ifdef UV_C2ADVECTION
!
!  Second-order, centered differences advection.
!
        do j=Jstr,Jend
          do i=IstrU-1,Iend
            UFx(i,j)=0.25_r8*(u(i,j,k,nrhs)+u(i+1,j,k,nrhs))*
     &                       (Huon(i,j,k)+Huon(i+1,j,k))
          enddo
        enddo
        do j=Jstr,Jend+1
          do i=IstrU,Iend
            UFe(i,j)=0.25_r8*(u(i,j-1,k,nrhs)+u(i,j,k,nrhs))*
     &                       (Hvom(i-1,j,k)+Hvom(i,j,k))
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend+1
            VFx(i,j)=0.25_r8*(v(i-1,j,k,nrhs)+v(i,j,k,nrhs))*
     &                       (Huon(i,j-1,k)+Huon(i,j,k))
          enddo
        enddo
        do j=JstrV-1,Jend
          do i=Istr,Iend
            VFe(i,j)=0.25_r8*(v(i,j,k,nrhs)+v(i,j+1,k,nrhs))*
     &                       (Hvom(i,j,k)+Hvom(i,j+1,k))
          enddo
        enddo
#  else
#   define uxx wrk1
#   define Huxx wrk2
#   ifdef EW_PERIODIC
#    define IU_RANGE IstrU-1,Iend+1
#   else
#    define IU_RANGE MAX(IstrU-1,2),MIN(Iend+1,Lm)
#   endif
        do j=Jstr,Jend
          do i=IU_RANGE
            uxx (i,j)=u(i-1,j,k,nrhs)-2.0_r8*u(i,j,k,nrhs)+
     &                u(i+1,j,k,nrhs)
            Huxx(i,j)=Huon(i-1,j,k)-2.0_r8*Huon(i,j,k)+Huon(i+1,j,k)
          enddo
        enddo
#   undef IU_RANGE
#   ifndef EW_PERIODIC
        if (WESTERN_EDGE) then
          do j=Jstr,Jend
            uxx (Istr,j)=uxx (Istr+1,j)
            Huxx(Istr,j)=Huxx(Istr+1,j)
          enddo
        endif
        if (EASTERN_EDGE) then
          do j=Jstr,Jend
            uxx (Iend+1,j)=uxx (Iend,j)
            Huxx(Iend+1,j)=Huxx(Iend,j)
          enddo
        endif
#   endif /* !EW_PERIODIC */
#   ifdef UV_C4ADVECTION
!
!  Fourth-order, centered differences advection.
!
        cff=1.0_r8/6.0_r8
        do j=Jstr,Jend
          do i=IstrU-1,Iend
            UFx(i,j)=0.25_r8*(u(i,j,k,nrhs)+u(i+1,j,k,nrhs)-
     &                        cff*(uxx (i,j)+uxx (i+1,j)))*
     &                       (Huon(i,j,k)+Huon(i+1,j,k)-
     &                        cff*(Huxx(i,j)+Huxx(i+1,j)))
          enddo
        enddo
#   else
!
!  Third-order, upstream bias advection with velocity dependent
!  hyperdiffusion.
!
        do j=Jstr,Jend
          do i=IstrU-1,Iend
            cff1=u(i,j,k,nrhs)+u(i+1,j,k,nrhs)
            if (cff1.gt.0.0_r8) then
              cff=uxx(i,j)
            else
              cff=uxx(i+1,j)
            endif
            UFx(i,j)=0.25_r8*(cff1+Gadv*cff)*
     &               (Huon(i,j,k)+Huon(i+1,j,k)+
     &                Gadv*0.5_r8*(Huxx(i,j)+Huxx(i+1,j)))
          enddo
        enddo
#   endif
#   undef Huxx
#   undef uxx
#   define uee wrk1
#   define Hvxx wrk2
#   ifdef NS_PERIODIC
#    define JU_RANGE Jstr-1,Jend+1
#   else
#    define JU_RANGE MAX(Jstr-1,1),MIN(Jend+1,Mm)
#   endif
        do j=JU_RANGE
          do i=IstrU,Iend
            uee(i,j)=u(i,j-1,k,nrhs)-2.0_r8*u(i,j,k,nrhs)+
     &               u(i,j+1,k,nrhs)
          enddo
        enddo
#   undef JU_RANGE
#   ifndef NS_PERIODIC
        if (SOUTHERN_EDGE) then
          do i=IstrU,Iend
            uee(i,Jstr-1)=uee(i,Jstr)
          enddo
        endif
        if (NORTHERN_EDGE) then
          do i=IstrU,Iend
            uee(i,Jend+1)=uee(i,Jend)
          enddo
        endif
#   endif
        do j=Jstr,Jend+1
          do i=IstrU-1,Iend
           Hvxx(i,j)=Hvom(i-1,j,k)-2.0_r8*Hvom(i,j,k)+Hvom(i+1,j,k)
          enddo
        enddo
#   ifdef UV_C4ADVECTION
        cff=1.0_r8/6.0_r8
        do j=Jstr,Jend+1
          do i=IstrU,Iend
            UFe(i,j)=0.25_r8*(u(i,j,k,nrhs)+u(i,j-1,k,nrhs)-
     &                        cff*(uee (i,j)+uee (i,j-1)))*
     &                       (Hvom(i,j,k)+Hvom(i-1,j,k)-
     &                        cff*(Hvxx(i,j)+Hvxx(i-1,j)))
          enddo
        enddo
#   else
        do j=Jstr,Jend+1
          do i=IstrU,Iend
            cff1=u(i,j,k,nrhs)+u(i,j-1,k,nrhs)
            cff2=Hvom(i,j,k)+Hvom(i-1,j,k)
            if (cff2.gt.0.0_r8) then
              cff=uee(i,j-1)
            else
              cff=uee(i,j)
            endif
            UFe(i,j)=0.25_r8*(cff1+Gadv*cff)*
     &               (cff2+Gadv*0.5_r8*(Hvxx(i,j)+Hvxx(i-1,j)))
          enddo
        enddo
#   endif
#   undef Hvxx
#   undef uee
#   define vxx wrk1
#   define Huee wrk2
#   ifdef EW_PERIODIC
#    define IV_RANGE Istr-1,Iend+1
#   else
#    define IV_RANGE MAX(Istr-1,1),MIN(Iend+1,Lm)
#   endif
        do j=JstrV,Jend
          do i=IV_RANGE
            vxx(i,j)=v(i-1,j,k,nrhs)-2.0_r8*v(i,j,k,nrhs)+
     &               v(i+1,j,k,nrhs)
          enddo
        enddo
#   undef IV_RANGE
#   ifndef EW_PERIODIC
        if (WESTERN_EDGE) then
          do j=JstrV,Jend
            vxx(Istr-1,j)=vxx(Istr,j)
          enddo
        endif
        if (EASTERN_EDGE) then
          do j=JstrV,Jend
            vxx(Iend+1,j)=vxx(Iend,j)
          enddo
        endif
#   endif
        do j=JstrV-1,Jend
          do i=Istr,Iend+1
           Huee(i,j)=Huon(i,j-1,k)-2.0_r8*Huon(i,j,k)+Huon(i,j+1,k)
          enddo
        enddo
#   ifdef UV_C4ADVECTION
        cff=1.0_r8/6.0_r8
        do j=JstrV,Jend
          do i=Istr,Iend+1
            VFx(i,j)=0.25_r8*(v(i,j,k,nrhs)+v(i-1,j,k,nrhs)-
     &                        cff*(vxx (i,j)+vxx (i-1,j)))*
     &                       (Huon(i,j,k)+Huon(i,j-1,k)-
     &                        cff*(Huee(i,j)+Huee(i,j-1)))
          enddo
        enddo
#   else
        do j=JstrV,Jend
          do i=Istr,Iend+1
            cff1=v(i,j,k,nrhs)+v(i-1,j,k,nrhs)
            cff2=Huon(i,j,k)+Huon(i,j-1,k)
            if (cff2.gt.0.0_r8) then
              cff=vxx(i-1,j)
            else
              cff=vxx(i,j)
            endif
            VFx(i,j)=0.25_r8*(cff1+Gadv*cff)*
     &               (cff2+Gadv*0.5_r8*(Huee(i,j)+Huee(i,j-1)))
          enddo
        enddo
#   endif
#   undef Huee
#   undef vxx
#   define vee wrk1
#   define Hvee wrk2
#   ifdef NS_PERIODIC
#    define JV_RANGE JstrV-1,Jend+1
#   else
#    define JV_RANGE MAX(JstrV-1,2),MIN(Jend+1,Mm)
#   endif
        do j=JV_RANGE
          do i=Istr,Iend
            vee(i,j)=v(i,j-1,k,nrhs)-2.0_r8*v(i,j,k,nrhs)+
     &               v(i,j+1,k,nrhs)
            Hvee(i,j)=Hvom(i,j-1,k)-2.0_r8*Hvom(i,j,k)+Hvom(i,j+1,k)
          enddo
        enddo
#   undef JV_RANGE
#   ifndef NS_PERIODIC
        if (SOUTHERN_EDGE) then
          do i=Istr,Iend
            vee (i,Jstr)=vee (i,Jstr+1)
            Hvee(i,Jstr)=Hvee(i,Jstr+1)
          enddo
        endif
        if (NORTHERN_EDGE) then
          do i=Istr,Iend
            vee (i,Jend+1)=vee (i,Jend)
            Hvee(i,Jend+1)=Hvee(i,Jend)
          enddo
        endif
#   endif
#   ifdef UV_C4ADVECTION
        cff=1.0_r8/6.0_r8
        do j=JstrV-1,Jend
          do i=Istr,Iend
            VFe(i,j)=0.25_r8*(v(i,j,k,nrhs)+v(i,j+1,k,nrhs)-
     &                        cff*(vee (i,j)+vee (i,j+1)))*
     &                       (Hvom(i,j,k)+Hvom(i,j+1,k)-
     &                        cff*(Hvee(i,j)+Hvee(i,j+1)))
          enddo
        enddo
#   else
        do j=JstrV-1,Jend
          do i=Istr,Iend
            cff1=v(i,j,k,nrhs)+v(i,j+1,k,nrhs)
            if (cff1.gt.0.0_r8) then
              cff=vee(i,j)
            else
              cff=vee(i,j+1)
            endif
            VFe(i,j)=0.25_r8*(cff1+Gadv*cff)*
     &               (Hvom(i,j,k)+Hvom(i,j+1,k)+
     &                Gadv*0.5_r8*(Hvee(i,j)+Hvee(i,j+1)))
          enddo
        enddo
#   endif
#   undef Hvee
#   undef vee
#  endif
!
!  Add in horizontal advection.
!
        do j=Jstr,Jend
          do i=IstrU,Iend
            ru(i,j,k,nrhs)=ru(i,j,k,nrhs)-
     &                     (UFx(i,j)-UFx(i-1,j))-(UFe(i,j+1)-UFe(i,j))
          enddo
        enddo
        do j=JstrV,Jend
          do i=Istr,Iend
            rv(i,j,k,nrhs)=rv(i,j,k,nrhs)-
     &                     (VFx(i+1,j)-VFx(i,j))-(VFe(i,j)-VFe(i,j-1))
          enddo
        enddo
# endif /* UV_ADV */
      enddo
      do j=Jstr,Jend
# ifdef UV_ADV
!
!---------------------------------------------------------------------
!  Add in vertical advection.
!---------------------------------------------------------------------
!
#  ifdef UV_SADVECTION
!
!  Construct conservative parabolic splines for the vertical
!  derivatives "CF" of u-momentum.
!
        cff1=9.0_r8/16.0_r8
        cff2=1.0_r8/16.0_r8
        do k=1,N
          do i=IstrU,Iend
            DC(i,k)=(cff1*(Hz(i  ,j,k)+Hz(i-1,j,k))-
     &               cff2*(Hz(i+1,j,k)+Hz(i-2,j,k)))
          enddo
        enddo
        do i=IstrU,Iend
          FC(i,0)=0.0_r8
          CF(i,0)=0.0_r8
        enddo
        do k=1,N-1
          do i=IstrU,Iend
            cff=1.0_r8/(2.0_r8*DC(i,k+1)+DC(i,k)*(2.0_r8-FC(i,k-1)))
            FC(i,k)=cff*DC(i,k+1)
            CF(i,k)=cff*(6.0_r8*(u(i,j,k+1,nrhs)-u(i,j,k,nrhs))-
     &                   DC(i,k)*CF(i,k-1))
          enddo
        enddo
        do i=IstrU,Iend
          CF(i,N)=0.0_r8
        enddo
        do k=N-1,1,-1
          do i=IstrU,Iend
            CF(i,k)=CF(i,k)-FC(i,k)*CF(i,k+1)
          enddo
        enddo
!
! Compute spline-interpolated, vertical advective u-momentum flux.
!
        cff3=1.0_r8/3.0_r8
        cff4=1.0_r8/6.0_r8
        do k=1,N-1
          do i=IstrU,Iend
            FC(i,k)=(cff1*(W(i  ,j,k)+W(i-1,j,k))-
     &               cff2*(W(i+1,j,k)+W(i-2,j,k)))*
     &              (u(i,j,k,nrhs)+
     &               DC(i,k)*(cff3*CF(i,k)+cff4*CF(i,k-1)))
          enddo
        enddo
        do i=IstrU,Iend
          FC(i,N)=0.0_r8
          FC(i,0)=0.0_r8
        enddo
#  elif defined UV_C2ADVECTION
        do k=1,Nm
          do i=IstrU,Iend
            FC(i,k)=0.25_r8*(u(i,j,k,nrhs)+u(i,j,k+1,nrhs))*
     &              (W(i,j,k)+W(i-1,j,k))
          enddo
        enddo
        do i=IstrU,Iend
          FC(i,0)=0.0_r8
          FC(i,N)=0.0_r8
        enddo
#  elif defined UV_C4ADVECTION
        cff1=9.0_r8/32.0_r8
        cff2=1.0_r8/32.0_r8
        do k=2,N-2
          do i=IstrU,Iend
            FC(i,k)=(cff1*(u(i,j,k  ,nrhs)+u(i,j,k+1,nrhs))-
     &               cff2*(u(i,j,k-1,nrhs)+u(i,j,k+2,nrhs)))*
     &              (W(i,j,k)+W(i-1,j,k))
          enddo
        enddo
        do i=IstrU,Iend
          FC(i,N)=0.0_r8
          FC(i,N-1)=(cff1*(u(i,j,N-1,nrhs)+u(i,j,N,nrhs))-
     &               cff2*(u(i,j,N-2,nrhs)+u(i,j,N,nrhs)))*
     &              (W(i,j,N-1)+W(i-1,j,N-1))
          FC(i,1  )=(cff1*(u(i,j,  1,nrhs)+u(i,j,2,nrhs))-
     &               cff2*(u(i,j,  1,nrhs)+u(i,j,3,nrhs)))*
     &              (W(i,j,1)+W(i-1,j,1))
          FC(i,0)=0.0_r8
        enddo
#  else
        cff1=9.0_r8/16.0_r8
        cff2=1.0_r8/16.0_r8
        do k=2,N-2
          do i=IstrU,Iend
            FC(i,k)=(cff1*(u(i,j,k  ,nrhs)+u(i,j,k+1,nrhs))-
     &               cff2*(u(i,j,k-1,nrhs)+u(i,j,k+2,nrhs)))*
     &              (cff1*(W(i  ,j,k)+W(i-1,j,k))-
     &               cff2*(W(i+1,j,k)+W(i-2,j,k)))
          enddo
        enddo
        do i=IstrU,Iend
          FC(i,N)=0.0_r8
          FC(i,N-1)=(cff1*(u(i,j,N-1,nrhs)+u(i,j,N,nrhs))-
     &               cff2*(u(i,j,N-2,nrhs)+u(i,j,N,nrhs)))*
     &              (cff1*(W(i  ,j,N-1)+W(i-1,j,N-1))-
     &               cff2*(W(i+1,j,N-1)+W(i-2,j,N-1)))
          FC(i,1  )=(cff1*(u(i,j,  1,nrhs)+u(i,j,2,nrhs))-
     &               cff2*(u(i,j,  1,nrhs)+u(i,j,3,nrhs)))*
     &              (cff1*(W(i  ,j,1)+W(i-1,j,1))-
     &               cff2*(W(i+1,j,1)+W(i-2,j,1)))
          FC(i,0)=0.0_r8
        enddo
#  endif
        do k=1,N
          do i=IstrU,Iend
            ru(i,j,k,nrhs)=ru(i,j,k,nrhs)-
     &                     (FC(i,k)-FC(i,k-1))
          enddo
        enddo
        if (j.ge.JstrV) then
#  ifdef UV_SADVECTION
!
!  Construct conservative parabolic splines for the vertical
!  derivatives "CF" of v-momentum.
!
          cff1=9.0_r8/16.0_r8
          cff2=1.0_r8/16.0_r8
          do k=1,N
            do i=Istr,Iend
              DC(i,k)=(cff1*(Hz(i,j  ,k)+Hz(i,j-1,k))-
     &                 cff2*(Hz(i,j+1,k)+Hz(i,j-2,k)))
            enddo
          enddo
          do i=Istr,Iend
            FC(i,0)=0.0_r8
            CF(i,0)=0.0_r8
          enddo
          do k=1,N-1
            do i=Istr,Iend
              cff=1.0_r8/(2.0_r8*DC(i,k+1)+DC(i,k)*(2.0_r8-FC(i,k-1)))
              FC(i,k)=cff*DC(i,k+1)
              CF(i,k)=cff*(6.0_r8*(v(i,j,k+1,nrhs)-v(i,j,k,nrhs))-
     &                     DC(i,k)*CF(i,k-1))
            enddo
          enddo
          do i=Istr,Iend
            CF(i,N)=0.0_r8
          enddo
          do k=N-1,1,-1
            do i=Istr,Iend
              CF(i,k)=CF(i,k)-FC(i,k)*CF(i,k+1)
            enddo
          enddo
!
! Compute spline-interpolated, vertical advective v-momentum flux.
!
          cff3=1.0_r8/3.0_r8
          cff4=1.0_r8/6.0_r8
          do k=1,N-1
            do i=Istr,Iend
              FC(i,k)=(cff1*(W(i,j  ,k)+W(i,j-1,k))-
     &                 cff2*(W(i,j+1,k)+W(i,j-2,k)))*
     &                (v(i,j,k,nrhs)+
     &                 DC(i,k)*(cff3*CF(i,k)+cff4*CF(i,k-1)))
            enddo
          enddo
          do i=Istr,Iend
            FC(i,N)=0.0_r8
            FC(i,0)=0.0_r8
          enddo
#  elif defined UV_C2ADVECTION
          do k=1,Nm
            do i=Istr,Iend
              FC(i,k)=0.25_r8*(v(i,j,k,nrhs)+v(i,j,k+1,nrhs))*
     &                (W(i,j,k)+W(i,j-1,k))
            enddo
          enddo
          do i=Istr,Iend
            FC(i,0)=0.0_r8
            FC(i,N)=0.0_r8
          enddo
#  elif defined UV_C4ADVECTION
          cff1=9.0_r8/32.0_r8
          cff2=1.0_r8/32.0_r8
          do k=2,N-2
            do i=Istr,Iend
              FC(i,k)=(cff1*(v(i,j,k  ,nrhs)+v(i,j,k+1,nrhs))-
     &                 cff2*(v(i,j,k-1,nrhs)+v(i,j,k+2,nrhs)))*
     &                (W(i,j,k)+W(i,j-1,k))
            enddo
          enddo
          do i=Istr,Iend
            FC(i,N)=0.0_r8
            FC(i,N-1)=(cff1*(v(i,j,N-1,nrhs)+v(i,j,N,nrhs))-
     &                 cff2*(v(i,j,N-2,nrhs)+v(i,j,N,nrhs)))*
     &                (W(i,j,N-1)+W(i,j-1,N-1))
            FC(i,  1)=(cff1*(v(i,j,  1,nrhs)+v(i,j,2,nrhs))-
     &                 cff2*(v(i,j,  1,nrhs)+v(i,j,3,nrhs)))*
     &                (W(i,j,1  )+W(i,j-1,1  ))
            FC(i,0)=0.0_r8
          enddo
#  else
          cff1=9.0_r8/16.0_r8
          cff2=1.0_r8/16.0_r8
          do k=2,N-2
            do i=Istr,Iend
              FC(i,k)=(cff1*(v(i,j,k,nrhs)+v(i,j,k+1,nrhs))-
     &                 cff2*(v(i,j,k-1,nrhs)+v(i,j,k+2,nrhs)))*
     &                (cff1*(W(i,j  ,k)+W(i,j-1,k))-
     &                 cff2*(W(i,j+1,k)+W(i,j-2,k)))
            enddo
          enddo
          do i=Istr,Iend
            FC(i,N)=0.0_r8
            FC(i,N-1)=(cff1*(v(i,j,N-1,nrhs)+v(i,j,N,nrhs))-
     &                 cff2*(v(i,j,N-2,nrhs)+v(i,j,N,nrhs)))*
     &                (cff1*(W(i,j  ,N-1)+W(i,j-1,N-1))-
     &                 cff2*(W(i,j+1,N-1)+W(i,j-2,N-1)))
            FC(i,  1)=(cff1*(v(i,j,  1,nrhs)+v(i,j,2,nrhs))-
     &                 cff2*(v(i,j,  1,nrhs)+v(i,j,3,nrhs)))*
     &                (cff1*(W(i,j  ,1)+W(i,j-1,1))-
     &                 cff2*(W(i,j+1,1  )+W(i,j-2,1  )))
            FC(i,0)=0.0_r8
          enddo
#  endif
          do k=1,N
            do i=Istr,Iend
              rv(i,j,k,nrhs)=rv(i,j,k,nrhs)-
     &                       (FC(i,k)-FC(i,k-1))
            enddo
          enddo
        endif
# endif /* UV_ADV */
!
!---------------------------------------------------------------------
!  Compute forcing term for the 2D momentum equations.
!---------------------------------------------------------------------
!
!  Vertically integrate baroclinic right-hand-side terms. If so not
!  body force stresses, add in the difference between surface and
!  bottom stresses.
!
        do i=IstrU,Iend
          rufrc(i,j)=ru(i,j,1,nrhs)
        enddo
        do k=2,N
          do i=IstrU,Iend
            rufrc(i,j)=rufrc(i,j)+ru(i,j,k,nrhs)
          enddo
        enddo
# ifndef BODYFORCE
        do i=IstrU,Iend
          rufrc(i,j)=rufrc(i,j)+
     &               (sustr(i,j)-bustr(i,j))*om_u(i,j)*on_u(i,j)
        enddo
# endif
        if (j.ge.JstrV) then
          do i=Istr,Iend
            rvfrc(i,j)=rv(i,j,1,nrhs)
            enddo
          do k=2,N
            do i=Istr,Iend
              rvfrc(i,j)=rvfrc(i,j)+rv(i,j,k,nrhs)
            enddo
          enddo
# ifndef BODYFORCE
          do i=Istr,Iend
            rvfrc(i,j)=rvfrc(i,j)+
     &                 (svstr(i,j)-bvstr(i,j))*om_v(i,j)*on_v(i,j)
          enddo
# endif
        endif
      enddo
!
!  Prepare to time-stepping 2D equations:  set initial free-sruface
!  to its fast-time averaged values (which corresponds to the time
!  step "n").
!
      do j=JstrR,JendR
        do i=IstrR,IendR
          zeta(i,j,1)=Zt_avg1(i,j)
          zeta(i,j,2)=Zt_avg1(i,j)
        enddo
      enddo
# if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,
     &                        zeta(START_2D_ARRAY,1))
      call exchange_r2d_tile (Istr,Iend,Jstr,Jend,
     &                        zeta(START_2D_ARRAY,2))
# endif
#else
      subroutine rhs3d
#endif
      return
      end
