#include "cppdefs.h"
#ifdef SOLVE3D
# undef NEUMANN
      subroutine prsgrd (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!=====================================================================
!                                                                    !
!  This subroutine evaluates the baroclinic,  hydrostatic pressure   !
!  gradient term using a  finite-volume  pressure Jacobian scheme.   !
!  The scheme is based on local, conservative, limited-oscillation   !
!  vertical quartic polynomial reconstruction of density field and   !
!  subsequent  projection fits of the derivatives of  density into   !
!  isosurface of vertical coordinate.  The monotonicity constraint   !
!  uses a  PPM-style  limitting  algorithm with a  power-law slope   !
!  reconciliation step.                                              !
!                                                                    !
!  isosurface of vertical coordinate.                                !
!                                                                    !
!  The pressure gradient terms (m4/s2) are loaded into right-hand-   !
!  side arrays "ru" and "rv".                                        !
!                                                                    !
!  Reference:                                                        !
!                                                                    !
!    Shchepetkin A.F and J.C. McWilliams, 2001:  A method for        !
!      computing horizontal pressure gradient force in an ocean      !
!      model with non-aligned vertical coordinate.  DRAFT            !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (23)
# endif
      call prsgrd_tile (Istr,Iend,Jstr,Jend,
     &                  A3d(1,1),A3d(1,2),A3d(1,3),A3d(1,4),
     &                  A2d(1,1),A2d(1,2),A2d(1,3),A2d(1,4),
     &                  A2d(1,5),A2d(1,6),A2d(1,7))
# ifdef PROFILE
      call wclock_off (23)
# endif
      return
      end
!
!*********************************************************************
      subroutine prsgrd_tile (Istr,Iend,Jstr,Jend,P,r,dd,FX, FC,r1,d1,
     &                        aR,dR,aL,dL)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        Ampl, Hdd, cff, cff1, cff2, cff3, cffL, cffR, deltaL,
     &        deltaR, dh, dP, eps, limtr, rr
      REAL_TYPE
     &       FX(PRIVATE_2D_SCRATCH_ARRAY,  N),
     &        P(PRIVATE_2D_SCRATCH_ARRAY,0:N),
     &        r(PRIVATE_2D_SCRATCH_ARRAY,0:N),
     &       d(PRIVATE_2D_SCRATCH_ARRAY,0:N),
     &       FC(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       aL(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       aR(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       dL(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       dR(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       d1(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       r1(PRIVATE_1D_SCRATCH_ARRAY,0:N)
      parameter (eps=1.0_e8-8)
!
# include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Finite-volume pressure gradient force algorithm.
!---------------------------------------------------------------------
!
      do j=JstrV-1,Jend
        do k=N-1,1,-1
          do i=IstrU-1,Iend
            FC(i,k)=1.0_r8/(Hz(i,j,k+1)+Hz(i,j,k))
            r(i,j,k)=FC(i,k)*(rho(i,j,k+1)*Hz(i,j,k  )+
     &                        rho(i,j,k  )*Hz(i,j,k+1))
            d(i,j,k)=FC(i,k)*(rho(i,j,k+1)-rho(i,j,k))
          enddo
        enddo
!
!  Parabolic WENO reconstruction of density field. Compute left and
!  right side limits aL and aR for the density assuming monotonized
!  quartic polynomial distributions within each grid box.  Also
!  compute dL and dR which are used as a measure of quadratic
!  variation during subsquent WENO reconciliation of side limits.
!
        do k=2,N-1
          do i=IstrU-1,Iend
            deltaR=Hz(i,j,k)*d(i,j,k  )
            deltaL=Hz(i,j,k)*d(i,j,k-1)
            if ((deltaR*deltaL).lt.0.0_r8) then
              deltaR=0.0_r8
              deltaL=0.0_r8
            endif
            cff=Hz(i,j,k-1)+2.0_r8*Hz(i,j,k)+Hz(i,j,k+1)
            cffR=cff*d(i,j,k  )
            cffL=cff*d(i,j,k-1)
            if (ABS(deltaR).gt.ABS(cffL)) deltaR=cffL
            if (ABS(deltaL).gt.ABS(cffR)) deltaL=cffR
            cff=(deltaR-deltaL)/(Hz(i,j,k-1)+Hz(i,j,k)+Hz(i,j,k+1))
            deltaR=deltaR-cff*Hz(i,j,k+1)
            deltaL=deltaL+cff*Hz(i,j,k-1)
            aR(i,k)=rho(i,j,k)+deltaR
            aL(i,k)=rho(i,j,k)-deltaL
            dR(i,k)=(2.0_r8*deltaR-deltaL)**2
            dL(i,k)=(2.0_r8*deltaL-deltaR)**2
          enddo
        enddo
!
        do i=IstrU-1,Iend
          aL(i,N)=aR(i,N-1)
          aR(i,N)=2.0_r8*rho(i,j,N)-aL(i,N)
          dR(i,N)=(2.0_r8*aR(i,N)+aL(i,N)-3.0_r8*rho(i,j,N))**2
          dL(i,N)=(3.0_r8*rho(i,j,N)-2.0_r8*aL(i,N)-aR(i,N))**2
          aR(i,1)=aL(i,2)
          aL(i,1)=2.0_r8*rho(i,j,1)-aR(i,1)
          dR(i,1)=(2.0_r8*aR(i,1)+aL(i,1)-3.0_r8*rho(i,j,1))**2
          dL(i,1)=(3.0_r8*rho(i,j,1)-2.0_r8*aL(i,1)-aR(i,1))**2
        enddo
!
        do k=1,N-1
          do i=IstrU-1,Iend
            deltaL=MAX(dL(i,k  ),eps)
            deltaR=MAX(dR(i,k+1),eps)
            r1(i,k)=(deltaR*aR(i,k)+deltaL*aL(i,k+1))/(deltaR+deltaL)
          enddo
        enddo
!
        do i=IstrU-1,Iend
# ifdef NEUMANN
          r1(i,N)=1.5_r8*rho(i,j,N)-0.5_r8*r1(i,N-1)
          r1(i,0)=1.5_r8*rho(i,j,1)-0.5_r8*r1(i,1  )
# else
          r1(i,N)=2.0_r8*rho(i,j,N)-r1(i,N-1)
          r1(i,0)=2.0_r8*rho(i,j,1)-r1(i,1  )
# endif
        enddo
!
!  Power-law reconciliation step.  It starts with the computation of
!  side limits dR and dL of the first derivative assuming parabolic
!  distributions within each grid box.  In this version of the code,
!  before doing so (see "else" branch of 3-way switch below), in the
!  situation when interfacial deviations deltaR and deltaL differ by
!  more than a factor of two (hence monotonic parabolic fit becomes
!  impossible), the parabolic assumption is switched to power-law
!  function,  such that its derivative is zero at one end and,
!  consequently, larger than that of (would be) limited parabolic
!  on the other end.  The basic parabolic version of the code is
!  commented out, but left here for reference.
!
        do k=1,N
          do i=IstrU-1,Iend
!!          cff=2.0_r8/Hz(i,j,k)
!!          dR(i,k)=cff*(2.0_r8*r1(i,k)+r1(i,k-1)-3.0_r8*rho(i,j,k))
!!          dL(i,k)=cff*(3.0_r8*rho(i,j,k)-2.0_r8*r1(i,k-1)-r1(i,k))
!!          cff=r(i,j,k)-r(i,j,k-1)
!!          if (cff*dR(i,k).lt.0.0_r8) dR(i,k)=0.0_r8
!!          if (cff*dL(i,k).lt.0.0_r8) dL(i,k)=0.0_r8
            deltaR=r1(i,k)-rho(i,j,k)
            deltaL=rho(i,j,k)-r1(i,k-1)
            cff=deltaR*deltaL
            if (cff.gt.eps) then
              cff=(deltaR+deltaL)/cff
            else
              cff=0.0_r8
            endif
            cffL=cff*deltaL
            cffR=cff*deltaR
            if (cffL.gt.3.0_r8) then
              cffL=cffL*deltaL
              cffR=0.0_r8
            elseif (cffR.gt.3.0_r8) then
              cffL=0.0_r8
              cffR=cffR*deltaR
            else
              cffL=4.0_r8*deltaL-2.0_r8*deltaR
              cffR=4.0_r8*deltaR-2.0_r8*deltaL
            endif
            cff=1.0_r8/Hz(i,j,k)
            dR(i,k)=cff*cffR
            dL(i,k)=cff*cffL
          enddo
        enddo
!
!  Compute final value of derivative at each interface by reconciling
!  two side limits dR(k) and dL(k+1) coming from adjacent grid boxes.
!  The difference between these two also causes change of interfacial
!  value r(k) by Ampl. The commented code (left here for reference)
!  computes the exact value of Ampl assuming power law reconciliation
!  and solving associated quadratic equation. The code segment below
!  corresponds to Pade fit to exact solution, which avoids computation
!  of SQRT for the sake of computational efficiency.
!
        do k=N-1,1,-1
          do i=IstrU-1,Iend
            d(i,j,k)=FC(i,k)*(Hz(i,j,k+1)*dL(i,k+1)+Hz(i,j,k)*dR(i,k))
            cffR=8.0_r8*(dR(i,k  )+2.0_r8*dL(i,k  ))
            cffL=8.0_r8*(dL(i,k+1)+2.0_r8*dR(i,k+1))
            if (ABS(d(i,j,k)).gt.ABS(cffR)) d(i,j,k)=cffR
            if (ABS(d(i,j,k)).gt.ABS(cffL)) d(i,j,k)=cffL
            if ((dL(i,k+1)-dR(i,k))*
     &          (rho(i,j,k+1)-rho(i,j,k)).gt.0.0_r8) then
              Hdd=Hz(i,j,k)*(d(i,j,k)-dR(i,k))
              rr=rho(i,j,k)-r1(i,k-1)
            else
              Hdd=Hz(i,j,k+1)*(dL(i,k+1)-d(i,j,k))
              rr=r1(i,k+1)-rho(i,j,k+1)
            endif
            rr=abs(rr)
!!          Ampl=0.4_r8*Hdd*rr
!!          Hdd=ABS(Hdd)
!!          cff=rr*(rr+0.16_r8*Hdd)
!!          if (cff.gt.eps) Ampl=Ampl/(rr+sqrt(cff))
            Ampl=0.2_r8*Hdd*rr
            Hdd=ABS(Hdd)
            cff=rr*rr+0.0763636363636363636_r8*Hdd*
     &                (rr+0.004329004329004329_r8*Hdd)
            if (cff.gt.eps) then
              Ampl=Ampl*(rr+0.0363636363636363636_r8*Hdd)/cff
            else
              Ampl=0.0_r8
            endif
            r(i,j,k)=r1(i,k)+Ampl
          enddo
        enddo
        do i=IstrU-1,Iend
# ifdef NEUMANN
          r(i,j,0)=1.5_r8*rho(i,j,1)-0.5_r8*r(i,j,1  )
          r(i,j,N)=1.5_r8*rho(i,j,N)-0.5_r8*r(i,j,N-1)
          d(i,j,0)=0.0_r8
          d(i,j,N)=0.0_r8
# else
          r(i,j,0)=2.0_r8*rho(i,j,1)-r(i,j,1  )
          r(i,j,N)=2.0_r8*rho(i,j,N)-r(i,j,N-1)
          d(i,j,0)=d(i,j,1  )
          d(i,j,N)=d(i,j,N-1)
# endif
        enddo
!
!  Compute pressure (P) and lateral pressure force (FX). Initialize
!  pressure at the free-surface as zero
!
        do i=IstrU-1,Iend
          P(i,j,N)=0.0_r8
        enddo
        cff3=1.0_r8/12.0_r8
        do k=N,1,-1
          do i=IstrU-1,Iend
            P(i,j,k-1)=P(i,j,k)+Hz(i,j,k)*rho(i,j,k)
            FX(i,j,k)=0.5_r8*Hz(i,j,k)*
     &                (P(i,j,k)+P(i,j,k-1)+
     &                 0.2_r8*Hz(i,j,k)*
     &                 (r(i,j,k)-r(i,j,k-1)-
     &                  cff3*Hz(i,j,k)*(d(i,j,k)+d(i,j,k-1))))
          enddo
        enddo
!
!  Compute net pressure gradient forces in the XI- and ETA-directions.
!
        if (j.ge.Jstr) then
          do i=IstrU,Iend
            FC(i,N)=0.0_r8
          enddo
          cff=0.5_r8*g
          cff1=g/rho0
          cff2=1.0_r8/6.0_r8
          cff3=1.0_r8/12.0_r8
          do k=N,1,-1
            do i=IstrU,Iend
              dh=z_w(i,j,k-1)-z_w(i-1,j,k-1)
              dP=P(i-1,j,k-1)-P(i,j,k-1)
              rr=0.5_r8*dh*(r(i,j,k-1)+r(i-1,j,k-1)-
     &                      cff2*dh*(d(i,j,k-1)-d(i-1,j,k-1)))
              limtr=2.0_r8*dP*rr
              rr=rr*rr+dP*dP
              if (limtr.gt.eps*rr) then
                limtr=limtr/rr
              else
                limtr=0.0_r8
              endif
              FC(i,k-1)=0.5_r8*dh*
     &                  (P(i,j,k-1)+P(i-1,j,k-1)+
     &                   limtr*0.2_r8*dh*
     &                   (r(i,j,k-1)-r(i-1,j,k-1)-
     &                    cff3*dh*(d(i,j,k-1)+d(i-1,j,k-1))))
              ru(i,j,k,nrhs)=(cff*(Hz(i-1,j,k)+Hz(i,j,k))*
     &                            (z_w(i-1,j,N)-z_w(i,j,N))+
     &                        cff1*(FX(i-1,j,k)-FX(i,j,k)+
     &                              FC(i,k)-FC(i,k-1)))*on_u(i,j)
            enddo
          enddo
        endif
!
        if (j.ge.JstrV) then
          do i=Istr,Iend
            FC(i,N)=0.0_r8
          enddo
          cff=0.5_r8*g
          cff1=g/rho0
          cff2=1.0_r8/6.0_r8
          cff3=1.0_r8/12.0_r8
          do k=N,1,-1
            do i=Istr,Iend
              dh=z_w(i,j,k-1)-z_w(i,j-1,k-1)
              dP=P(i,j-1,k-1)-P(i,j,k-1)
              rr=0.5_r8*dh*(r(i,j,k-1)+r(i,j-1,k-1)-
     &                      cff2*dh*(d(i,j,k-1)-d(i,j-1,k-1)))
              limtr=2.0_r8*dP*rr
              rr=rr*rr+dP*dP
              if (limtr.gt.eps*rr) then
                limtr=limtr/rr
              else
                limtr=0.0_r8
              endif
              FC(i,k-1)=0.5_r8*dh*
     &                  (P(i,j,k-1)+P(i,j-1,k-1)+
     &                   limtr*0.2_r8*dh*
     &                   (r(i,j,k-1)-r(i,j-1,k-1)-
     &                    cff3*dh*(d(i,j,k-1)+d(i,j-1,k-1))))
              rv(i,j,k,nrhs)=(cff*(Hz(i,j-1,k)+Hz(i,j,k))*
     &                            (z_w(i,j-1,N)-z_w(i,j,N))+
     &                        cff1*(FX(i,j-1,k)-FX(i,j,k)+
     &                              FC(i,k)-FC(i,k-1)))*om_v(i,j)
            enddo
          enddo
        endif
      enddo
      return
      end
#else
      subroutine prsgrd
      return
      end
#endif
