#ifdef SOLVE3D
      subroutine prsgrd (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!=====================================================================
!                                                                    !
!  This subroutine evaluates the baroclinic, hydrostatic pressure    !
!  gradient term using the finite-volume pressure Jacobian scheme    !
!  of Lin (1997).                                                    !
!                                                                    !
!  The pressure gradient terms (m4/s2) are loaded into right-hand-   !
!  side arrays "ru" and "rv".                                        !
!                                                                    !
!  Reference:                                                        !
!                                                                    !
!    Lin, Shian-Jiann, 1997:  A finite volume integration method     !
!      for computing pressure gradient force in general vertical     !
!      coordinates, Q. J. R. Meteorol. Soc., 123, 1749-1762.         !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (23)
# endif
      call prsgrd_tile (Istr,Iend,Jstr,Jend,
     &                  A3d(1,1),A3d(1,2),A2d(1,1))
# ifdef PROFILE
      call wclock_off (23)
# endif
      return
      end
!
!*********************************************************************
      subroutine prsgrd_tile (Istr,Iend,Jstr,Jend,P,FX,FC)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        cff, cff1, dh
      REAL_TYPE
     &        FC(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &        FX(PRIVATE_2D_SCRATCH_ARRAY,  N),
     &         P(PRIVATE_2D_SCRATCH_ARRAY,0:N)
!
# include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Finite Volume pressure gradient algorithm (Lin, 1997).
!---------------------------------------------------------------------
!
!  Compute pressure and its vertical integral.  Initialize pressure at
!  the free-surface as zero.
!
      do j=JstrV-1,Jend
        do i=IstrU-1,Iend
          P(i,j,N)=0.0_r8
        enddo
        do k=N,1,-1
          do i=IstrU-1,Iend
            P(i,j,k-1)=P(i,j,k)+Hz(i,j,k)*rho(i,j,k)
            FX(i,j,k)=0.5_r8*Hz(i,j,k)*(P(i,j,k)+P(i,j,k-1))
          enddo
        enddo
!
!  Calculate pressure gradient in the XI-direction (m4/s2).
!
        if (j.ge.Jstr) then
          do i=IstrU,Iend
            FC(i,N)=0.0_r8
          enddo
          cff=0.5_r8*g
          cff1=g/rho0
          do k=N,1,-1
            do i=IstrU,Iend
              dh=z_w(i,j,k-1)-z_w(i-1,j,k-1)
              FC(i,k-1)=0.5_r8*dh*(P(i,j,k-1)+P(i-1,j,k-1))
              ru(i,j,k,nrhs)=(cff *(Hz (i-1,j,k)+Hz (i,j,k))*
     &                             (z_w(i-1,j,N)-z_w(i,j,N))+
     &                        cff1*(FX(i-1,j,k)-FX(i,j,k)+
     &                              FC(i,k)-FC(i,k-1)))*on_u(i,j)
            enddo
          enddo
        endif
!
!  Calculate pressure gradient in the ETA-direction (m4/s2).
!
        if (j.ge.JstrV) then
          do i=Istr,Iend
            FC(i,N)=0.0_r8
          enddo
          cff=0.5_r8*g
          cff1=g/rho0
          do k=N,1,-1
            do i=Istr,Iend
              dh=z_w(i,j,k-1)-z_w(i,j-1,k-1)
              FC(i,k-1)=0.5_r8*dh*(P(i,j,k-1)+P(i,j-1,k-1))
              rv(i,j,k,nrhs)=(cff *(Hz(i,j-1,k)+Hz(i,j,k))*
     &                             (z_w(i,j-1,N)-z_w(i,j,N))+
     &                        cff1*(FX(i,j-1,k)-FX(i,j,k)+
     &                              FC(i,k)-FC(i,k-1)))*om_v(i,j)
            enddo
          enddo
        endif
      enddo
      return
      end
#else
      subroutine prsgrd
      return
      end
#endif
