#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine prsgrd (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!=====================================================================
!                                                                    !
!  This subroutine evaluates the baroclinic, hydrostatic pressure    !
!  gradient term using a nonconservative Density-Jacobian scheme,    !
!  based on cubic polynomial fits for RHO and Z_R as functions of    !
!  nondimensional coordinates (XI,ETA,s), that is, its respective    !
!  array indices.  The cubic polynomials are monotonized by using    !
!  harmonic mean instead of linear averages to interpolate slopes.   !
!  This scheme retains exact anti-symmetry J(rho,z_r)=-J(z_r,rho).   !
!                                                                    !
!  If parameter OneFifth (see below) is set to zero,  the scheme     !
!  becomes identical to standard Jacobian.                           !
!                                                                    !
!  Reference:                                                        !
!                                                                    !
!    Shchepetkin A.F and J.C. McWilliams, 2001:  A method for        !
!      computing horizontal pressure gradient force in an ocean      !
!      model with non-aligned vertical coordinate.  DRAFT            !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (23)
# endif
      call prsgrd_tile (Istr,Iend,Jstr,Jend,
     &                  A3d(1,1),A2d(1,1),A2d(1,2),A2d(1,1),
     &                  A2d(1,2),A2d(1,3),A2d(1,4))
# ifdef PROFILE
      call wclock_off (23)
# endif
      return
      end
!
!*********************************************************************
      subroutine prsgrd_tile (Istr,Iend,Jstr,Jend,P,dR,dZ,FC,aux,
     &                        dRx,dZx)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mask.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        GRho, GRho0,  HalfGRho, OneFifth, OneTwelfth, cff, cff1,
     &        eps
      REAL_TYPE
     &        P(PRIVATE_2D_SCRATCH_ARRAY,N),
     &       dR(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       dZ(PRIVATE_1D_SCRATCH_ARRAY,0:N),
     &       FC(PRIVATE_2D_SCRATCH_ARRAY),
     &      aux(PRIVATE_2D_SCRATCH_ARRAY),
     &      dRx(PRIVATE_2D_SCRATCH_ARRAY),
     &      dZx(PRIVATE_2D_SCRATCH_ARRAY)
      parameter (OneFifth=0.2_r8, OneTwelfth=1.0_r8/12.0_r8,
     &           eps=1.0_e8-10)
!
# include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Preliminary step (same for XI- and ETA-components:
!---------------------------------------------------------------------
!
      GRho=g/rho0
      GRho0=1000.0_r8*GRho
      HalfGRho=0.5_r8*GRho
!
      do j=JstrV-1,Jend
        do k=1,N-1
          do i=IstrU-1,Iend
            dR(i,k)=rho(i,j,k+1)-rho(i,j,k)
            dZ(i,k)=z_r(i,j,k+1)-z_r(i,j,k)
          enddo
        enddo
        do i=IstrU-1,Iend
          dR(i,N)=dR(i,N-1)
          dZ(i,N)=dZ(i,N-1)
          dR(i,0)=dR(i,1)
          dZ(i,0)=dZ(i,1)
        enddo
        do k=N,1,-1
          do i=IstrU-1,Iend
            cff=2.0_r8*dR(i,k)*dR(i,k-1)
            if (cff.gt.eps) then
              dR(i,k)=cff/(dR(i,k)+dR(i,k-1))
            else
              dR(i,k)=0.0_r8
            endif
            dZ(i,k)=2.0_r8*dZ(i,k)*dZ(i,k-1)/(dZ(i,k)+dZ(i,k-1))
          enddo
        enddo
        do i=IstrU-1,Iend
# ifdef ICESHELF
          P(i,j,N)=GRho0*(z_w(i,j,N)-zice(i,j))-
     &             GRho*rho(i,j,N)*zice(i,j)+
     &             GRho*(rho(i,j,N)+
     &                   0.5_r8*(rho(i,j,N)-rho(i,j,N-1))*
     &                   (z_w(i,j,N)-z_r(i,j,N))/
     &                   (z_r(i,j,N)-z_r(i,j,N-1)))*
     &             (z_w(i,j,N)-z_r(i,j,N))
# else
          P(i,j,N)=GRho0*z_w(i,j,N)+
     &             GRho*(rho(i,j,N)+
     &                   0.5_r8*(rho(i,j,N)-rho(i,j,N-1))*
     &                   (z_w(i,j,N)-z_r(i,j,N))/
     &                   (z_r(i,j,N)-z_r(i,j,N-1)))*
     &             (z_w(i,j,N)-z_r(i,j,N))
# endif
        enddo
        do k=N-1,1,-1
          do i=IstrU-1,Iend
            P(i,j,k)=P(i,j,k+1)+
     &               HalfGRho*((rho(i,j,k+1)+rho(i,j,k))*
     &                          (z_r(i,j,k+1)-z_r(i,j,k))
     &              -OneFifth*((dR(i,k+1)-dR(i,k))*
     &                         (z_r(i,j,k+1)-z_r(i,j,k)-
     &                         OneTwelfth*(dZ(i,k+1)+dZ(i,k)))-
     &                         (dZ(i,k+1)-dZ(i,k))*
     &                         (rho(i,j,k+1)-rho(i,j,k)-
     &                         OneTwelfth*(dR(i,k+1)+dR(i,k)))))
          enddo
        enddo
      enddo
!
!---------------------------------------------------------------------
!  Compute XI-component pressure gradient term.
!---------------------------------------------------------------------
!
      do k=N,1,-1
        do j=Jstr,Jend
          do i=IstrU-1,Iend+1
            aux(i,j)=(z_r(i,j,k)-z_r(i-1,j,k))
# ifdef MASKING
     &              *umask(i,j)
# endif
            FC(i,j)=(rho(i,j,k)-rho(i-1,j,k))
# ifdef MASKING
     &             *umask(i,j)
# endif
          enddo
        enddo
!
        do j=Jstr,Jend
          do i=IstrU-1,Iend
            cff=2.0_r8*aux(i,j)*aux(i+1,j)
            if (cff.gt.eps) then
              dZx(i,j)=cff/(aux(i,j)+aux(i+1,j))
            else
              dZx(i,j)=0.0_r8
            endif
            cff1=2.0_r8*FC(i,j)*FC(i+1,j)
            if (cff1.gt.eps) then
              dRx(i,j)=cff1/(FC(i,j)+FC(i+1,j))
            else
              dRx(i,j)=0.0_r8
            endif
          enddo
        enddo
!
        do j=Jstr,Jend
          do i=IstrU,Iend
            ru(i,j,k,nrhs)=0.5_r8*(Hz(i,j,k)+Hz(i-1,j,k))*on_u(i,j)*
     &                     (P(i-1,j,k)-P(i,j,k)-
     &                      HalfGRho*((rho(i,j,k)+rho(i-1,j,k))*
     &                                (z_r(i,j,k)-z_r(i-1,j,k))-
     &                                OneFifth*
     &                                ((dRx(i,j)-dRx(i-1,j))*
     &                                 (z_r(i,j,k)-z_r(i-1,j,k)-
     &                                  OneTwelfth*
     &                                  (dZx(i,j)+dZx(i-1,j)))-
     &                                 (dZx(i,j)-dZx(i-1,j))*
     &                                 (rho(i,j,k)-rho(i-1,j,k)-
     &                                  OneTwelfth*
     &                                  (dRx(i,j)+dRx(i-1,j))))))
          enddo
        enddo
      enddo
!
!---------------------------------------------------------------------
!  ETA-component pressure gradient term.
!---------------------------------------------------------------------
!
      do k=N,1,-1
        do j=JstrV-1,Jend+1
          do i=Istr,Iend
            aux(i,j)=(z_r(i,j,k)-z_r(i,j-1,k))
# ifdef MASKING
     &              *vmask(i,j)
# endif
            FC(i,j)=(rho(i,j,k)-rho(i,j-1,k))
# ifdef MASKING
     &             *vmask(i,j)
# endif
          enddo
        enddo
!
        do j=JstrV-1,Jend
          do i=Istr,Iend
            cff=2.0_r8*aux(i,j)*aux(i,j+1)
            if (cff.gt.eps) then
              dZx(i,j)=cff/(aux(i,j)+aux(i,j+1))
            else
              dZx(i,j)=0.0_r8
            endif
            cff1=2.0_r8*FC(i,j)*FC(i,j+1)
            if (cff1.gt.eps) then
              dRx(i,j)=cff1/(FC(i,j)+FC(i,j+1))
            else
              dRx(i,j)=0.0_r8
            endif
          enddo
        enddo
!
        do j=JstrV,Jend
          do i=Istr,Iend
            rv(i,j,k,nrhs)=0.5_r8*(Hz(i,j,k)+Hz(i,j-1,k))*om_v(i,j)*
     &                     (P(i,j-1,k)-P(i,j,k)-
     &                      HalfGRho*((rho(i,j,k)+rho(i,j-1,k))*
     &                                (z_r(i,j,k)-z_r(i,j-1,k))-
     &                                OneFifth*
     &                                ((dRx(i,j)-dRx(i,j-1))*
     &                                 (z_r(i,j,k)-z_r(i,j-1,k)-
     &                                  OneTwelfth*
     &                                  (dZx(i,j)+dZx(i,j-1)))-
     &                                 (dZx(i,j)-dZx(i,j-1))*
     &                                 (rho(i,j,k)-rho(i,j-1,k)-
     &                                  OneTwelfth*
     &                                  (dRx(i,j)+dRx(i,j-1))))))
          enddo
        enddo
      enddo
      return
      end
#else
      subroutine prsgrd
      return
      end
#endif
