#ifdef SOLVE3D
      subroutine prsgrd (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine evaluates the  baroclinic  hydrostatic  pressure  !
!  gradient term using  the STANDARD density Jacobian  or  WEIGHTED  !
!  density Jacobian scheme of Song (1998). Both of these approaches  !
!  compute horizontal differences of density before of the vertical  !
!  integration.                                                      !
!                                                                    !
!  The pressure gradient terms (m4/s2) are loaded into right-hand-   !
!  side arrays "ru" and "rv".                                        !
!                                                                    !
!  Reference:                                                        !
!                                                                    !
!    Song, Y.T., 1998:  A general pressure gradient formulation for  !
!      numerical ocean models. Part I: Scheme design and diagnostic  !
!      analysis, Monthly Weather Rev., 126, 3213-3230.               !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (23)
# endif
      call prsgrd_tile (Istr,Iend,Jstr,Jend,
     &                  A2d(1,1),A2d(1,2))
# ifdef PROFILE
      call wclock_off (23)
# endif
      return
      end
!
!*********************************************************************
      subroutine prsgrd_tile (Istr,Iend,Jstr,Jend,phix,phie)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        cff, cff1
# ifdef WJ_GRADP
      REAL_TYPE
     &        gamma
# endif
      REAL_TYPE
     &        phie(PRIVATE_1D_SCRATCH_ARRAY),
     &        phix(PRIVATE_1D_SCRATCH_ARRAY)
!
# include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Calculate pressure gradient in the XI-direction (m4/s2).
!---------------------------------------------------------------------
!
!  Compute surface baroclinic pressure gradient.
!
      do j=Jstr,Jend
        cff=0.5_r8*g/rho0
        cff1=1000.0_r8*g/rho0
        do i=IstrU,Iend
          phix(i)=cff*(rho(i,j,N)-rho(i-1,j,N))*
     &            (z_w(i,j,N)-z_r(i,j,N)+z_w(i-1,j,N)-z_r(i-1,j,N))
#ifdef RHO_SURF
     &           +(cff1+cff*(rho(i,j,N)+rho(i-1,j,N)))*
     &            (z_w(i,j,N)-z_w(i-1,j,N))
#endif
          ru(i,j,N,nrhs)=-0.5_r8*(Hz(i,j,N)+Hz(i-1,j,N))*
     &                   phix(i)*on_u(i,j)
        enddo
!
!  Compute interior baroclinic pressure gradient.  Differentiate and
!  then vertically integrate.
!
        cff=0.25_r8*g/rho0
        do k=Nm,1,-1
          do i=IstrU,Iend
# ifdef WJ_GRADP
            gamma=0.125_r8*(z_r(i  ,j,k  )-z_r(i-1,j,k  )+
     &                      z_r(i  ,j,k+1)-z_r(i-1,j,k+1))*
     &                     (z_r(i  ,j,k+1)-z_r(i  ,j,k  )-
     &                      z_r(i-1,j,k+1)+z_r(i-1,j,k  ))/
     &            ((z_r(i  ,j,k+1)-z_r(i  ,j,k))*
     &             (z_r(i-1,j,k+1)-z_r(i-1,j,k)))
# endif
            phix(i)=phix(i)+cff*(
# ifdef WJ_GRADP
     &              ((1.0_r8+gamma)*(rho(i,j,k+1)-rho(i-1,j,k+1))+
     &               (1.0_r8-gamma)*(rho(i,j,k  )-rho(i-1,j,k  )))*
     &              (z_r(i,j,k+1)+z_r(i-1,j,k+1)-
     &               z_r(i,j,k  )-z_r(i-1,j,k  ))
     &             -(rho(i,j,k+1)+rho(i-1,j,k+1)-
     &               rho(i,j,k  )-rho(i-1,j,k  ))*
     &              ((1.0_r8+gamma)*(z_r(i,j,k+1)-z_r(i-1,j,k+1))+
     &               (1.0_r8-gamma)*(z_r(i,j,k  )-z_r(i-1,j,k  )))
# else
     &              (rho(i,j,k+1)-rho(i-1,j,k+1)+
     &               rho(i,j,k  )-rho(i-1,j,k  ))*
     &              (z_r(i,j,k+1)+z_r(i-1,j,k+1)-
     &               z_r(i,j,k  )-z_r(i-1,j,k  ))
     &             -(rho(i,j,k+1)+rho(i-1,j,k+1)-
     &               rho(i,j,k  )-rho(i-1,j,k  ))*
     &              (z_r(i,j,k+1)-z_r(i-1,j,k+1)+
     &               z_r(i,j,k  )-z_r(i-1,j,k  ))
# endif
     &             )
            ru(i,j,k,nrhs)=-0.5_r8*(Hz(i,j,k)+Hz(i-1,j,k))*
     &                     phix(i)*on_u(i,j)
          enddo
        enddo
!
!---------------------------------------------------------------------
!  Calculate pressure gradient in the ETA-direction (m4/s2).
!---------------------------------------------------------------------
!
!  Compute surface baroclinic pressure gradient.
!
        if (j.ge.JstrV) then
          cff=0.5_r8*g/rho0
          cff1=1000.0_r8*g/rho0
          do i=Istr,Iend
            phie(i)=cff*(rho(i,j,N)-rho(i,j-1,N))*
     &              (z_w(i,j,N)-z_r(i,j,N)+z_w(i,j-1,N)-z_r(i,j-1,N))
#ifdef RHO_SURF
     &             +(cff1+cff*(rho(i,j,N)+rho(i,j-1,N)))*
     &              (z_w(i,j,N)-z_w(i,j-1,N))
#endif
            rv(i,j,N,nrhs)=-0.5_r8*(Hz(i,j,N)+Hz(i,j-1,N))*
     &                     phie(i)*om_v(i,j)
          enddo
!
!  Compute interior baroclinic pressure gradient.  Differentiate and
!  then vertically integrate.
!
          cff=0.25_r8*g/rho0
          do k=Nm,1,-1
            do i=Istr,Iend
# ifdef WJ_GRADP
              gamma=0.125_r8*(z_r(i,j  ,k  )-z_r(i,j-1,k  )+
     &                        z_r(i,j  ,k+1)-z_r(i,j-1,k+1))*
     &                       (z_r(i,j  ,k+1)-z_r(i,j  ,k  )-
     &                        z_r(i,j-1,k+1)+z_r(i,j-1,k  ))/
     &              ((z_r(i,j  ,k+1)-z_r(i,j  ,k))*
     &               (z_r(i,j-1,k+1)-z_r(i,j-1,k)))
# endif
              phie(i)=phie(i)+cff*(
# ifdef WJ_GRADP
     &                ((1.0_r8+gamma)*(rho(i,j,k+1)-rho(i,j-1,k+1))+
     &                 (1.0_r8-gamma)*(rho(i,j,k  )-rho(i,j-1,k  )))*
     &                (z_r(i,j,k+1)+z_r(i,j-1,k+1)-
     &                 z_r(i,j,k  )-z_r(i,j-1,k  ))
     &               -(rho(i,j,k+1)+rho(i,j-1,k+1)-
     &                 rho(i,j,k  )-rho(i,j-1,k  ))*
     &                ((1.0_r8+gamma)*(z_r(i,j,k+1)-z_r(i,j-1,k+1))+
     &                 (1.0_r8-gamma)*(z_r(i,j,k  )-z_r(i,j-1,k  )))
# else
     &                (rho(i,j,k+1)-rho(i,j-1,k+1)+
     &                 rho(i,j,k  )-rho(i,j-1,k  ))*
     &                (z_r(i,j,k+1)+z_r(i,j-1,k+1)-
     &                 z_r(i,j,k  )-z_r(i,j-1,k  ))
     &               -(rho(i,j,k+1)+rho(i,j-1,k+1)-
     &                 rho(i,j,k  )-rho(i,j-1,k  ))*
     &                (z_r(i,j,k+1)-z_r(i,j-1,k+1)+
     &                 z_r(i,j,k  )-z_r(i,j-1,k  ))
# endif
     &               )
              rv(i,j,k,nrhs)=-0.5_r8*(Hz(i,j,k)+Hz(i,j-1,k))*
     &                       phie(i)*om_v(i,j)
            enddo
          enddo
        endif
      enddo
#else
      subroutine prsgrd
#endif
      return
      end
