/*
** Include file "param.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA, ROMS version 2.0                **
************************************************* Hernan G. Arango ***
**                                                                  **
** Lm          Number of internal grid points in the XI-direction.  **
** Mm          Number of internal grid points in the ETA-direction. **
** Mfloats     Maximum number of floats tracjectories.              **
** Msev        Maximum number of state error eigenvectors.          **
** MTC         Maximum number of tidal components.                  **
** Msrc        Maximum number of point Sources/Sinks.               **
** N           Number of vertical levels.                           **
** NS          Maximum number of output stations.                   **
** NSUB_E      Number of sub-domains in the ETA-direction.          **
** NSUB_X      Number of sub-domains in the XI-direction.           **
** NSV         Number of model state variables.                     **
**                                                                  **
** NAT         Number of active tracer type variables (usually,     **
**               NTA=2 for potential temperature and salinity).     **
** NBT         Number of biological tracer type variables.          **
** NST         Number of sediment tracer type variables (NCS+NNS).  **
** NT          Total number of tracer type variables.               **
**                                                                  **
** Nbed        Number of sediment bed layers.                       **
** NCS         Number of cohesive (mud) sediment tracers.           **
** NNS         Number of non-cohesive (sand) sediment tracers.      **
**                                                                  **
** Nbac        Number of bacteria constituents in EcoSim.           **
** Ndom        Number of dissolved matter constituents in EcoSim.   **
** Nfec        Number of fecal matter constituents in EcoSim.       **
** Nphy        Number of phytoplankton constituents in EcoSim.      **
** Npig        Number of pigment constituents in EcoSim.            **
** PHY         EcoSim indices of phytoplankton species considered.  **
**                                                                  **
**********************************************************************
*/

      INTEGER_TYPE
     &        Lm, Mm, N, NAT
#if defined ADRIATIC1
      parameter (Lm=40,  Mm=140, N=40, NAT=2)
!!    parameter (Lm=40,  Mm=140, N=20, NAT=2)
#elif defined ADRIATIC2
      parameter (Lm=98,  Mm=298, N=40, NAT=2)
#elif defined BASIN
      parameter (Lm=180, Mm=140, N=12, NAT=1)
#elif defined BISCAY
      parameter (Lm=96,  Mm=128, N=20, NAT=2)
#elif defined BL_TEST
      parameter (Lm=39,  Mm=4,   N=30, NAT=2)
#elif defined CALCOFI
      parameter (Lm=78, Mm=118, N=20, NAT=2)
#elif defined CANYON_A
      parameter (Lm=65,  Mm=48,  N=10, NAT=1)
#elif defined CANYON_B
      parameter (Lm=66,  Mm=48,  N=12, NAT=1)
#elif defined DAMEE_4
      parameter (Lm=128, Mm=128, N=20, NAT=2)
#elif defined DAMEE_5
      parameter (Lm=128, Mm=56,  N=20, NAT=2)
#elif defined DAMEE_6
      parameter (Lm=192, Mm=96,  N=20, NAT=2)
#elif defined DAMEE_7
      parameter (Lm=256, Mm=256, N=20, NAT=2)
#elif defined DAMEE_9
      parameter (Lm=286, Mm=286, N=20, NAT=2)
#elif defined DOUBLE_GYRE
      parameter (Lm=54,  Mm=108,  N=3, NAT=1)
#elif defined FLT_TEST
      parameter (Lm=14,  Mm=12,  N=4,  NAT=1)
#elif defined GRAV_ADJ
      parameter (Lm=128, Mm=4,   N=40, NAT=1)
#elif defined LAB_CANYON
      parameter (Lm=110, Mm=250, N=25, NAT=1)
#elif defined LMD_TEST
      parameter (Lm=10,  Mm=10,  N=50, NAT=2)
#elif defined NATL
      parameter (Lm=1000, Mm=1024, N=30, NAT=2)
#elif defined NENA
      parameter (Lm=384,  Mm=128,  N=30, NAT=2)
#elif defined NJ_BIGHT
      parameter (Lm=109, Mm=239, N=25, NAT=2)
!!    parameter (Lm=160, Mm=248, N=25, NAT=2)
#elif defined NPACIFIC
      parameter (Lm=174, Mm=94,  N=20, NAT=2)
#elif defined OVERFLOW
      parameter (Lm=4,   Mm=128, N=20, NAT=1)
#elif defined RIVERPLUME
      parameter (Lm=39,  Mm=67,  N=25, NAT=2)
#elif defined SEAMOUNT
      parameter (Lm=49,  Mm=48,  N=13, NAT=1)
#elif defined SHELFRONT
      parameter (Lm=4,   Mm=40,  N=20, NAT=2)

#elif defined ISWAKE
      parameter (Lm=360, Mm=160, N=10,  NAT=1)

#elif defined SOLITON
c*    parameter (Lm=384,  Mm=128,  N=1,  NAT=1)
      parameter (Lm=768,  Mm=256,  N=1,  NAT=1)

#elif defined TASMAN_SEA
      parameter	(Lm=128, Mm=128, N=4,  NAT=2)
#elif defined SED_TEST1
      parameter (Lm=100, Mm=3,   N=40, NAT=2)
!1    parameter (Lm=100, Mm=3,   N=20, NAT=2)
#elif defined UPWELLING
      parameter (Lm=41,  Mm=80,  N=16, NAT=2)
#elif defined USWEST
      parameter (Lm=126, Mm=30,  N=20, NAT=2)
!!7   parameter (Lm=254, Mm=62,  N=20, NAT=2)
#elif defined WEDDELL
      parameter (Lm=300,  Mm=5,  N=30, NAT=2)
#else
      Illegal choice of parameters Lm, Mm, N, NAT
#endif

      INTEGER_TYPE
     &        Mfloats, Msev, Msrc, MTC, NS
      parameter (Msev=300, Msrc=25, MTC=7, NS=51)
#if defined FLT_TEST
      parameter (Mfloats=300)
#else
      parameter (Mfloats=900)
#endif

/*
** Tracer identification indices:
**
**    itemp   Potential temperature.
**    isalt   Salinity.
*/

      INTEGER_TYPE
     &        itemp, isalt
      parameter (itemp=1,  isalt=2)

#ifdef SEDIMENT
/*
** Sediment tracers parameters and identification indices.
*/
      INTEGER_TYPE
     &        Nbed, NCS, NNS, NST
# if defined SED_TEST1
      parameter (Nbed=1, NCS=1, NNS=1, NST=NCS+NNS)
# else
      Illegal choice of parameters Nbed, NCS, NNS, NST
# endif
#else
      INTEGER_TYPE
     &        Nbed, NST
      parameter (Nbed=0, NST=0)
#endif

#if defined BIO_FASHAM
      INTEGER_TYPE
     &        NBT
      parameter (NBT=7)
#elif defined ECOSIM
      INTEGER_TYPE
     &        NBT, Nbac, Ndom, Nfec, Nphy, Npig
      parameter (NBT=61, Nbac=1, Ndom=2, Nfec=2, Nphy=4, Npig=7)
      INTEGER_TYPE
     &        PHY(Nphy)
#else
      INTEGER_TYPE
     &        NBT
      parameter (NBT=0)
#endif

/*
** Domain parallel subdivision parameters:
*/

      INTEGER_TYPE
     &        NSUB_X, NSUB_E
#ifdef SERIAL
      parameter (NSUB_X=1, NSUB_E=1 )
#else
!!    parameter (NSUB_X=1, NSUB_E=1 )
!!    parameter (NSUB_X=1, NSUB_E=2 )
!!    parameter (NSUB_X=2, NSUB_E=1 )
!!    parameter (NSUB_X=2, NSUB_E=2 )
c     parameter (NSUB_X=2, NSUB_E=32)  !<-- island wake
c     parameter (NSUB_X=3, NSUB_E=26)  !<-- soliton
      parameter (NSUB_X=6, NSUB_E=32)

!!    parameter (NSUB_X=1, NSUB_E=8 )
!!    parameter (NSUB_X=2, NSUB_E=2 )
!!    parameter (NSUB_X=2, NSUB_E=4 )
!!    parameter (NSUB_X=1, NSUB_E=6 )
!!    parameter (NSUB_X=1, NSUB_E=8 )
!!    parameter (NSUB_X=2, NSUB_E=8 )
!!    parameter (NSUB_X=2, NSUB_E=4 )
!!    parameter (NSUB_X=4, NSUB_E=8 )
!!    parameter (NSUB_X=1, NSUB_E=16)
!!    parameter (NSUB_X=2, NSUB_E=8 )
!!    parameter (NSUB_X=4, NSUB_E=8 )
!!    parameter (NSUB_X=4, NSUB_E=8 )
!!    parameter (NSUB_X=4, NSUB_E=16)
#endif

/*
** Derived dimension parameters.
*/

      INTEGER_TYPE
     &        L, Lp, Lm2, M, Mp, Mm2, Nm, Np, NT, NSV
      parameter (L=Lm+1, Lp=Lm+2, Lm2=Lm-1, Np=N+1,
     &           M=Mm+1, Mp=Mm+2, Mm2=Mm-1, Nm=N-1, NT=NAT+NBT+NST,
     &           NSV=5+NT)
      INTEGER_TYPE
     &        padd_X, padd_E
      parameter (padd_X=(Lm+2)/2-(Lm+1)/2,
     &           padd_E=(Mm+2)/2-(Mm+1)/2)
