#include "cppdefs.h"
      subroutine output
!
!=====================================================================
!  Copyright (c) 2002 Rutgers University                             !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine manages model output. It creates output NetCDF       !
!  files and writes out data into NetCDF files.  If requested,       !
!  it can create several history and/or time-averaged files to       !
!  avoid generating too large files during a single model run.       !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "floats.h"
#include "iounits.h"
#include "ncparam.h"
#include "netcdf.inc"
#include "scalars.h"
!
      INTEGER_TYPE
     &        ifile, lstr, rem, status
      INTEGER_TYPE
     &        lenstr
#ifdef PROFILE
!
!---------------------------------------------------------------------
!  Turn on output data time wall clock.
!---------------------------------------------------------------------
!
      call wclock_on (8)
#endif
!
!---------------------------------------------------------------------
!  If appropriate, process history NetCDF file.
!---------------------------------------------------------------------
!
!  Create output history NetCDF file or prepare existing file to
!  append new data to it.  Also,  notice that it is possible to
!  create several files during a single model run.
!
      if (LdefHIS) then
        if (ndefhis.gt.0) then
          if ((iic-1).eq.idefhis) then
            rem=MOD(iic-1,ndefhis)
            if ((rem.eq.0).and.(nhis.ne.ndefhis)) then
              idefhis=idefhis+ndefhis+nhis
            else
              idefhis=idefhis+ndefhis
            endif
            nrechis=0
            lstr=lenstr(hisbase)
            if (nhis.eq.ndefhis) then
              ifile=MAX(1,((iic-1)/ndefhis))
            else
              ifile=((iic-1)/ndefhis)+1
            endif
            write(hisname,10) hisbase(1:lstr-3), ifile
 10         format(a,'_',i3.3,'.nc')
            lstr=lenstr(hisname)
            if (nchisid.ne.-1) status=nf_close(nchisid)
            if (nrrec.gt.0) then
              if ((iic-1.lt.ndefhis).or.((iic.eq.ntstart).and.
     &            (iic-1.gt.ndefhis).and.(rem.ne.0))) then
                ldefout=.false.
                write(stdout,20) 'inquiring', hisname(1:lstr)
 20             format(6x,'OUTPUT  - ',a,' history file: ',a)
              else
                ldefout=.true.
                write(stdout,20) 'creating ', hisname(1:lstr)
              endif
            else
              ldefout=.true.
              write(stdout,20) 'creating ', hisname(1:lstr)
            endif
            call def_his
            if (exit_flag.ne.0) return
            LwrtHIS=.true.
          endif
        else
          if (iic.eq.ntstart) then
            lstr=lenstr(hisname)
            write(stdout,20) 'creating ', hisname(1:lstr)
            call def_his
            if (exit_flag.ne.0) return
            LwrtHIS=.true.
            LdefHIS=.false.
          endif
        endif
      endif
!
!  Write out data into history NetCDF file.  Avoid writing initial
!  conditions in perturbation mode computations.
!
      if (LwrtHIS) then
        if (ERend.gt.1) then
          if ((iic.gt.ntstart).and.(MOD(iic-1,nhis).eq.0)) then
            call wrt_his
            if (exit_flag.ne.0) return
          endif
        else
          if ((MOD(iic-1,nhis).eq.0).and.
     &        ((nrrec.eq.0).or.(iic.ne.ntstart))) then
            call wrt_his
            if (exit_flag.ne.0) return
          endif
        endif
      endif
#ifdef AVERAGES
!
!---------------------------------------------------------------------
!  If appropriate, process time-averaged NetCDF file.
!---------------------------------------------------------------------
!
!  Create output time-averaged NetCDF file or prepare existing file
!  to append new data to it.  Also,  notice that it is possible to
!  create several files during a single model run.
!
      if (LdefAVG) then
        if (ndefavg.gt.0) then
          if ((iic-1).eq.idefavg) then
            rem=MOD(iic-1,ndefavg)
            if ((rem.eq.0).and.(navg.ne.ndefavg)) then
              idefavg=idefavg+ndefavg+navg
            else
              idefavg=idefavg+ndefavg
            endif
            lstr=lenstr(avgbase)
            if (navg.eq.ndefavg) then
              ifile=MAX(1,((iic-1)/ndefavg))
            else
              ifile=((iic-1)/ndefavg)+1
            endif
            write(avgname,30) avgbase(1:lstr-3), ifile
 30         format(a,'_',i3.3,'.nc')
            lstr=lenstr(avgname)
            if (ncavgid.ne.-1) status=nf_close(ncavgid)
            if (nrrec.gt.0) then
              if ((iic-1.lt.ndefavg).or.((iic.eq.ntstart).and.
     &            (iic-1.gt.ndefavg).and.(rem.ne.0))) then
                ldefout=.false.
                write(stdout,40) 'inquiring', avgname(1:lstr)
 40             format(6x,'OUTPUT  - ',a,' average file: ',a)
              else
                ldefout=.true.
                write(stdout,40) 'creating ', avgname(1:lstr)
              endif
            else
              ldefout=.true.
              write(stdout,40) 'creating ', avgname(1:lstr)
            endif
            call def_avg
            if (exit_flag.ne.0) return
          endif
        else
          if (iic.eq.ntstart) then
            lstr=lenstr(avgname)
            write(stdout,40) 'creating ', avgname(1:lstr)
            call def_avg
            if (exit_flag.ne.0) return
            LdefAVG=.false.
          endif
        endif
      endif
!
!  Write out data into time-averaged NetCDF file.
!
      if ((iic.gt.ntstart).and.(MOD(iic-1,navg).eq.0)) then
        call wrt_avg
        if (exit_flag.ne.0) return
      endif
#endif /* AVERAGES */
#ifdef STATIONS
!
!---------------------------------------------------------------------
!  If appropriate, process stations NetCDF file.
!---------------------------------------------------------------------
!
      if (nstation.gt.0) then
!
!  Create output station NetCDF file or prepare existing file to
!  append new data to it.
!
        if (LdefSTA.and.(iic.eq.ntstart)) then
          call def_station
          if (exit_flag.ne.0) return
          LdefSTA=.false.
        endif
!
!  Write out data into stations NetCDF file.
!
        if ((MOD(iic-1,nsta).eq.0).and.
     &      ((nrrec.eq.0).or.(iic.ne.ntstart))) then
          call wrt_station
          if (exit_flag.ne.0) return
        endif
      endif
#endif /* STATIONS */
#ifdef FLOATS
!
!---------------------------------------------------------------------
!  If appropriate, process floats NetCDF file.
!---------------------------------------------------------------------
!
      if (nfloats.gt.0) then
!
!  Create output floats NetCDF file or prepare existing file to
!  append new data to it.
!
        if (LdefFLT) then
          call def_floats
          if (exit_flag.ne.0) return
          LdefFLT=.false.
        endif
!
!  Write out data into floats NetCDF file.
!
        if ((MOD(iic-1,nflt).eq.0).and.
     &      ((frrec.eq.0).or.(iic.ne.ntstart))) then
          call wrt_floats
          if (exit_flag.ne.0) return
        endif
      endif
#endif /* FLOATS */
!
!---------------------------------------------------------------------
!  If appropriate, process restart NetCDF file.
!---------------------------------------------------------------------
!
!  Create output restart NetCDF file or prepare existing file to
!  append new data to it.
!
      if (LdefRST) then
        call def_rst
        if (exit_flag.ne.0) return
        LdefRST=.false.
      endif
!
!  Write out data into restart NetCDF file.
!
      if ((iic.gt.ntstart).and.(MOD(iic-1,nrst).eq.0)) then
        call wrt_rst
        if (exit_flag.ne.0) return
      endif
#ifdef PROFILE
!
!---------------------------------------------------------------------
!  Turn off output data time wall clock.
!---------------------------------------------------------------------
!
      call wclock_off (8)
#endif
      return
      end
