#include "cppdefs.h"
      subroutine opencdf (ncname,nvlev,ifield,nrec)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine opens an existing NetCDF file and inquires about     !
!  it contents, and checks for consistency with model dimensions.    !
!                                                                    !
!  Input:                                                            !
!                                                                    !
!     ncname   Input NetCDF file name.                               !
!     nvlev    Number of vertical levels to check for consistency.   !
!     ifield   Index of field to inquire for the size of its time    !
!              dimension, if any.                                    !
!                                                                    !
!  Output:                                                           !
!                                                                    !
!     nrec     Number of time records available for requested field. !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "scalars.h"
#include "iounits.h"
#include "ncparam.h"
#include "netcdf.inc"
!
      logical
     &        timeatt
      INTEGER_TYPE
     &        attype, dimid, dimsiz, i, ifield, j, latt, ldim, lfvar,
     &        lstr, ltvar, ltype, lvar, ncid, ndims, ngatts, nrec,
     &        nvlev, nvatts, recdim, status, varid, vartype
      INTEGER_TYPE
     &        lenstr
      character*20  dimnam, attnam
      character*45  text
      character*(*) ncname
!
!---------------------------------------------------------------------
!  Open input NetCDF file.
!---------------------------------------------------------------------
!
      lstr=lenstr(ncname)
      status=nf_open (ncname(1:lstr),nf_nowrite,ncid)
      if (status.ne.nf_noerr) then
        write(stdout,10) ncname(1:lstr)
        exit_flag=4
        return
      endif
!
!---------------------------------------------------------------------
!  Inquire and get global "type" attribute.
!---------------------------------------------------------------------
!
      status=nf_inq_att (ncid,nf_global,'type',attype,ltype)
      if (status.eq.nf_noerr) then
        status=nf_get_att_text (ncid,nf_global,'type',type)
        if(status.ne.nf_noerr) then
          write(stdout,20) 'type (global)', ncname(1:lstr)
          exit_flag=4
          return
        endif
      else
        write(stdout,30) 'type (global)',ncname(1:lstr)
      endif
!
!---------------------------------------------------------------------
!  Inquire about the dimensions and variables.
!---------------------------------------------------------------------
!
      recdim=-1
      status=nf_inq(ncid,ndims,nvars,ngatts,recdim)
      if (status.eq.nf_noerr) then
        if (nvars.gt.MV) then
          write(stdout,40) MV, nvars
          exit_flag=4
          return
        endif
!
!  Inquire about dimensions. Check dimensions for consistency.
!
        nrec=0
        ltvar=0
        if (ifield.gt.0) then
          ltvar=lenstr(Vname(5,ifield))
          Tname(ifield)=Vname(5,ifield)(1:ltvar)
        endif
        do i=1,ndims
          dimid=i
          status=nf_inq_dim(ncid,dimid,dimnam,dimsiz)
          if (status.ne.nf_noerr) then
            write(stdout,50) dimid, ncname(1:lstr)
            exit_flag=4
            return
          endif
          ldim=lenstr(dimnam)
          if ((dimnam(1:ldim).eq.'xi_rho').or.
     &        (dimnam(1:ldim).eq.'xi_v')) then
            if (dimsiz.ne.Lp) then
              write(stdout,60) dimnam(1:ldim), dimsiz, Lp
              exit_flag=4
              return
            endif
          elseif ((dimnam(1:ldim).eq.'xi_u').or.
     &            (dimnam(1:ldim).eq.'xi_psi')) then
            if (dimsiz.ne.L) then
              write(stdout,60) dimnam(1:ldim), dimsiz, L
              exit_flag=4
              return
            endif
          elseif ((dimnam(1:ldim).eq.'eta_rho').or.
     &            (dimnam(1:ldim).eq.'eta_u')) then
            if (dimsiz.ne.Mp) then
              write(stdout,60) dimnam(1:ldim), dimsiz, Mp
              exit_flag=4
              return
            endif
          elseif ((dimnam(1:ldim).eq.'eta_v').or.
     &            (dimnam(1:ldim).eq.'eta_psi')) then
            if (dimsiz.ne.M) then
              write(stdout,60) dimnam(1:ldim), dimsiz, M
              exit_flag=4
              return
            endif
#ifdef SOLVE3D
          elseif (dimnam(1:ldim).eq.'s_rho') then
            if (dimsiz.ne.nvlev) then
              write(stdout,60) dimnam(1:ldim), dimsiz, nvlev
              exit_flag=4
              return
            endif
#endif /* SOLVE3D */
          elseif ((ltvar.gt.0).and.
     &            (dimnam(1:ldim).eq.Tname(ifield)(1:ltvar))) then
            nrec=dimsiz
          endif
        enddo
!
!  Inquire about variables.  If "nrec" is zero, indicating that the
!  requested variable does not have the specified time dimension;
!  then, check the size of the dimension of its associated time
!  variable.  The associated time variable is reset to the value
!  specified in the "time" attribute, if any.  Check if only water
!  points are available.
!
        timeatt=.false.
        lfvar=lenstr(Vname(1,ifield))
        do i=1,nvars
          varid=i
          vflag(i)=1
          status=nf_inq_var(ncid,varid,varnam(i),vartype,nvdims(i),
     &                      vdims(1,i),nvatts)
          if (status.ne.nf_noerr) then
            write(stdout,70) varid, ncname(1:lstr)
            exit_flag=4
            return
          endif
          lvar=lenstr(varnam(i))
          if (nvdims(i).gt.0) then
            do j=1,nvatts
              status=nf_inq_attname(ncid,varid,j,attnam)
              if (status.eq.nf_noerr) then
                latt=lenstr(attnam)
                if (attnam(1:latt).eq.'water_points') then
                  vflag(i)=-1
                endif
              else
                write(stdout,100) varnam(i)(1:lvar)
                exit_flag=4
                return
              endif
            enddo
          endif
          if ((lfvar.gt.0).and.
     &        (varnam(i)(1:lvar).eq.Vname(1,ifield)(1:lfvar))) then
            do j=1,nvatts
              status=nf_inq_attname(ncid,varid,j,attnam)
              if (status.eq.nf_noerr) then
                latt=lenstr(attnam)
                if (attnam(1:latt).eq.'time') then
                  status=nf_inq_attlen(ncid,varid,attnam(1:latt),
     &                                 ltvar)
                  if (status.ne.nf_noerr) then
                    write (stdout,80) attnam(1:latt)
                    exit_flag=4
                    return
                  endif
                  status=nf_get_att_text(ncid,varid,attnam(1:latt),
     &                                   text(1:ltvar))
                  if (status.ne.nf_noerr) then
                    write (stdout,90) attnam(1:latt)
                    exit_flag=4
                    return
                  endif
                  Tname(ifield)=text(1:ltvar)
                  timeatt=.true.
                endif
              else
                write(stdout,100) varnam(i)(1:lvar)
                exit_flag=4
                return
              endif
            enddo
          endif
        enddo
        if (timeatt) then
          ltvar=lenstr(Tname(ifield))
          if ((ifield.gt.0).and.(nrec.eq.0).and.(ltvar.gt.0)) then
            do i=1,nvars
              varid=i
              status=nf_inq_var (ncid,varid,varnam(i),vartype,
     &                           nvdims(i),vdims(1,i),nvatts)
              if (status.ne.nf_noerr) then
                write(stdout,70) varid, ncname(1:lstr)
                exit_flag=4
                return
              endif
              lvar=lenstr(varnam(i))
              if (varnam(i)(1:lvar).eq.Tname(ifield)(1:ltvar)) then
                do j=1,nvdims(i)
                  status=nf_inq_dim (ncid,vdims(j,i),dimnam,dimsiz)
                  if (status.ne.nf_noerr) then
                    write(stdout,110) Tname(ifield)(1:ltvar)
                    exit_flag=4
                    return
                  endif
                  ldim=lenstr(dimnam)
                  if (index(dimnam(1:ldim),'time').ne.0) then
                    nrec=dimsiz
                  endif
                enddo
              endif
            enddo
          endif
        endif
      else
        write(stdout,120) ncname(1:lstr)
        exit_flag=4
        return
      endif
!
!---------------------------------------------------------------------
!  Inquire size of unlimited time record dimension.
!---------------------------------------------------------------------
!
      tsize=0
      if (recdim.gt.0) then
        status=nf_inq_dim (ncid,recdim,dimnam,tsize)
        if (status.ne.nf_noerr) then
          write(stdout,130) 'time', ncname(1:lstr)
          exit_flag=4
          return
        endif
      endif
!
!---------------------------------------------------------------------
!  Close input NetCDF file.
!---------------------------------------------------------------------
!
      status=nf_close (ncid)
!
  10  format(/,' OPENCDF - unable to open input NetCDF file: ',a)
  20  format(/,' OPENCDF - error while reading attribute: ',a,2x,
     &       ' in input NetCDF file: ',a)
  30  format(/,' OPENCDF - cannot find attribute: ',a,2x,
     &       ' in input NetCDF file: ',a)
  40  format(/,' OPENCDF - too small dimension parameter, MV = ',
     &       2i5,/,11x,'change file  ncparam.h  and recompile.')
  50  format(/,' OPENCDF - error while reading dimension ID: ',i3,2x,
     &       ' in input NetCDF file: ',a)
  60  format(/,' OPENCDF - inconsistent size of dimension: ',a,2x,
     &       2i5)
  70  format(/,' OPENCDF - error while inquiring information for ',
     &       ' variable ID: ',i3,2x,' in input NetCDF file: ',a)
  80  format(/,' OPENCDF - error while inquiring length of',
     &         ' attribute: ',a)
  90  format(/,' OPENCDF - error while reading attribute: ',a)
 100  format(/,' OPENCDF - error while inquiring attributes for',
     &        ' variable: ',a)
 110  format(/,' OPENCDF - unable to inquire size of time dimesion',
     &       ' in variable: ',a)
 120  format(/,' OPENCDF - unable to inquire about contents of',
     &       ' input NetCDF file: ',a)
 130  format(/,' OPENCDF - error inquiring dimension: ',a,2x,
     &       ' in input NetCDF file: ',a)
      return
      end
