#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine omega (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine computes S-coordinate vertical velocity (m^3/s),     !
!                                                                    !
!                  W=[Hz/(m*n)]*omega,                               !
!                                                                    !
!  diagnostically at horizontal RHO-points and vertical W-points.    !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (13)
# endif
      call omega_tile (Istr,Iend,Jstr,Jend,
     &                 A2d(1,1))
# ifdef PROFILE
      call wclock_off (13)
# endif
      return
      end
!
!*********************************************************************
      subroutine omega_tile (Istr,Iend,Jstr,Jend,wrk)
!*********************************************************************
!
      implicit none
#include "param.h"
#include "grid.h"
#include "ocean.h"
#include "scalars.h"
#include "sources.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        wrk(PRIVATE_1D_SCRATCH_ARRAY)
!
#include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Vertically integrage horizontal mass flux divergence.
!---------------------------------------------------------------------
!
!  Starting with zero vertical velocity at the bottom, integrate
!  from the bottom (k=0) to the free-surface (k=N).  The w(:,:,N)
!  contains the vertical velocity at the free-surface, d(zeta)/d(t).
!  Notice that barotropic mass flux divergence is not used directly.
!
      do j=Jstr,Jend
        do i=Istr,Iend
          W(i,j,0)=0.0_r8
        enddo
        do k=1,N
          do i=Istr,Iend
            W(i,j,k)=W(i,j,k-1)-
     &               (Huon(i+1,j,k)-Huon(i,j,k)+
     &                Hvom(i,j+1,k)-Hvom(i,j,k))
          enddo
        enddo
        do i=Istr,Iend
          wrk(i)=W(i,j,N)/(z_w(i,j,N)-z_w(i,j,0))
        enddo
!
!  In order to insure zero vertical velocity at the free-surface,
!  subtract the vertical velocities of the moving S-coordinates
!  isosurfaces. These isosurfaces are proportional to d(zeta)/d(t).
!  The proportionally coefficients are a linear function of the
!  S-coordinate with zero value at the bottom (k=0) and unity at
!  the free-surface (k=N).
!
        do k=Nm,1,-1
          do i=Istr,Iend
            W(i,j,k)=W(i,j,k)-wrk(i)*(z_w(i,j,k)-z_w(i,j,0))
          enddo
        enddo
        do i=Istr,Iend
          W(i,j,N)=0.0_r8
        enddo
      enddo
!
!  Set lateral boundary conditions.
!
      call w3dbc_tile (Istr,Iend,Jstr,Jend)
#else
      subroutine omega
#endif /* SOLVE3D */
      return
      end
