#include "cppdefs.h"
#ifdef ASSIMILATION
      subroutine oi_update (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine assimilates fields as a  pointwise  linear  optimal  !
!  combination between model and observations. During initilization  !
!  (at first assimilation cycle),  the initial model error variance  !
!  has the same shape distribution as observations.                  !
!                                                                    !
!  Reference:                                                        !
!                                                                    !
!    Dombrowsky, E. and P. De May, 1992:  Continuous assimilation    !
!      in an open domain of the Northeast Atlantic 1. Methodology    !
!      and application to AtheA-88, JGR, 97, 9719-9731.              !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "scratch.h"
# include "tile.h"
!
# ifdef PROFILE
      call wclock_on (2)
# endif
      call oi_update_tile (Istr,Iend,Jstr,Jend,
     &                     A2d(1,1),A2d(1,3))
# ifdef PROFILE
      call wclock_off (2)
# endif
      return
      end
!
!*********************************************************************
      subroutine oi_update_tile (Istr,Iend,Jstr,Jend,Uwrk,Vwrk)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "iounits.h"
# include "grid.h"
# include "mask.h"
# include "ncparam.h"
# include "obs.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, itrc, j, k
      REAL_TYPE
     &        Emod, Eobs, arg, cff, cff1, cff2, delta, decay, eps, mu,
     &        ratio, weight
      REAL_TYPE
     &        Uwrk(PRIVATE_2D_SCRATCH_ARRAY,2),
     &        Vwrk(PRIVATE_2D_SCRATCH_ARRAY,2)
      parameter (eps=1.0_e8-4)
!
# include "set_bounds.h"
!
# ifdef EW_PERIODIC
#  define IU_RANGE Istr,Iend
#  define IV_RANGE Istr,Iend
# else
#  define IU_RANGE Istr,IendR
#  define IV_RANGE IstrR,IendR
# endif
# ifdef NS_PERIODIC
#  define JU_RANGE Jstr,Jend
#  define JV_RANGE Jstr,Jend
# else
#  define JU_RANGE JstrR,JendR
#  define JV_RANGE Jstr,JendR
# endif
      Emod=0.0_r8
      Eobs=0.0_r8
      cff=0.0_r8
      cff1=0.0_r8
      cff2=0.0_r8
# ifdef ASSIMILATION_SSH
!
!---------------------------------------------------------------------
!  Assimilate sea surface height data.
!---------------------------------------------------------------------
!
      if (assi_SSH.and.update_SSH) then
!
!  On first pass, initialize model error variance.
!
        if (first_SSH) then
          delta=MAX(EobsSSHmax-EobsSSHmin,eps)
          do j=JU_RANGE
            do i=IV_RANGE
              ratio=(EobsSSHmax-EobsSSH(i,j))/delta
              mu=MIN(1.0_r8,ratio)*Emod0
              cff1=1.0_r8-2.0_r8*mu
              cff2=(cor*cff1+
     &              SQRT(1.0_r8+cff1*cff1*(cor*cor-1.0_r8)))/
     &             MAX(2.0_r8-2.0_r8*mu,eps)
              EmodSSH(i,j)=cff2*cff2*EobsSSH(i,j)
            enddo
          enddo
          if (SOUTH_WEST_CORNER)
     &      tSSHobs(2)=tSSHobs(1)
          if (NORTH_EAST_CORNER)
     &      first_SSH=.false.
        endif
!
!  Determine assimilation weights and meld model and observations.
!
        if ((time.le.tsSSHobs).and.(tsSSHobs.lt.(time+dt))) then
          arg=ABS(tSSHobs(1)-tSSHobs(2))/Tgrowth
          decay=2.0_r8*(1.0_r8-EXP(-arg*arg))
          do j=JU_RANGE
            do i=IV_RANGE
              EmodSSH(i,j)=EmodSSH(i,j)+decay
              cff1=cor*SQRT(EobsSSH(i,j)*EmodSSH(i,j))
              cff2=EobsSSH(i,j)+EmodSSH(i,j)-2.0_r8*cff1
              weight=(EmodSSH(i,j)-cff1)/MAX(cff2,eps)
              weight=MAX(0.0_r8,MIN(1.0_r8,weight))
              zeta(i,j,1)=(weight*SSHobs(i,j)+
     &                     (1.0_r8-weight)*zeta(i,j,knew))
#  ifdef MASKING
     &                   *rmask(i,j)
#  endif
              zeta(i,j,2)=zeta(i,j,1)
              EmodSSH(i,j)=(1.0_r8-cor)*EobsSSH(i,j)*
     &                                  EmodSSH(i,j)/cff2
            enddo
          enddo
          if (NORTH_EAST_CORNER) then
            tSSHobs(2)=tSSHobs(1)
            synchro_flag=.true.
            update_SSH=.false.
            write(stdout,10) 'SSH', tSSHobs(1)
          endif
        endif
      endif
# endif /* ASSIMILATION_SSH */
# ifdef ASSIMILATION_T
!
!---------------------------------------------------------------------
!  Assimilate tracer data.
!---------------------------------------------------------------------
!
      do itrc=1,NT
        if (assi_T(itrc).and.update_T(itrc)) then
!
!  On first pass, initialize model error variance.
!
          if (first_T(itrc)) then
            delta=MAX(EobsTmax(itrc)-EobsTmin(itrc),eps)
            do k=1,N
              do j=JU_RANGE
                do i=IV_RANGE
                  ratio=(EobsTmax(itrc)-EobsT(i,j,k,itrc))/delta
                  mu=MIN(1.0_r8,ratio)*Emod0
                  cff1=1.0_r8-2.0_r8*mu
                  cff2=(cor*cff1+
     &                  SQRT(1.0_r8+cff1*cff1*(cor*cor-1.0_r8)))/
     &                 MAX(2.0_r8-2.0_r8*mu,eps)
                  EmodT(i,j,k,itrc)=cff2*cff2*EobsT(i,j,k,itrc)
                enddo
              enddo
            enddo
            if (SOUTH_WEST_CORNER)
     &        tTobs(2,itrc)=tTobs(1,itrc)
            if (NORTH_EAST_CORNER)
     &        first_T(itrc)=.false.
          endif
!
!  Determine assimilation weights and meld model and observations.
!
          if ((time.le.tsTobs(itrc)).and.
     &        (tsTobs(itrc).lt.(time+dt))) then
            arg=ABS(tTobs(1,itrc)-tTobs(2,itrc))/Tgrowth
            decay=2.0_r8*(1.0_r8-EXP(-arg*arg))
            do k=1,N
              do j=JU_RANGE
                do i=IV_RANGE
                  EmodT(i,j,k,itrc)=EmodT(i,j,k,itrc)+decay
                  cff1=cor*SQRT(EobsT(i,j,k,itrc)*EmodT(i,j,k,itrc))
                  cff2=EobsT(i,j,k,itrc)+EmodT(i,j,k,itrc)-2.0_r8*cff1
                  weight=(EmodT(i,j,k,itrc)-cff1)/MAX(cff2,eps)
                  weight=MAX(0.0_r8,MIN(1.0_r8,weight))
                  t(i,j,k,1,itrc)=(weight*Tobs(i,j,k,itrc)+
     &                             (1.0_r8-weight)*t(i,j,k,nnew,itrc))
#  ifdef MASKING
     &                           *rmask(i,j)
#  endif
                  t(i,j,k,2,itrc)=t(i,j,k,1,itrc)
                  EmodT(i,j,k,itrc)=(1.0_r8-cor)*EobsT(i,j,k,itrc)*
     &                                           EmodT(i,j,k,itrc)/cff2
                enddo
              enddo
            enddo
            if (NORTH_EAST_CORNER) then
              tTobs(2,itrc)=tTobs(1,itrc)
              synchro_flag=.true.
              update_T(itrc)=.false.
              ntfirst=iic+1
              if (update_SST.and.(itrc.eq.itemp)) then
                write(stdout,10) 'SST', tTobs(1,itrc)
              else
                write(stdout,20) 'TRACER', itrc, tTobs(1,itrc)
              endif
            endif
          endif
        endif
      enddo
# endif /* ASSIMILATION_T */
# if defined ASSIMILATION_UV || defined ASSIMILATION_UVsur
!
!---------------------------------------------------------------------
!  Assimilate velocity data.
!---------------------------------------------------------------------
!
      if ((assi_UVsur.or.assi_UV).and.update_UV) then
!
!  On first pass, initialize model error variance.
!
        if (first_UV) then
          delta=MAX(EobsUVmax-EobsUVmin,eps)
          do k=1,N
            do j=JU_RANGE
              do i=IU_RANGE
                Eobs=0.5_r8*(EobsUV(i-1,j,k)+EobsUV(i,j,k))
                ratio=(EobsUVmax-Eobs)/delta
                mu=MIN(1.0_r8,ratio)*Emod0
                cff1=1.0_r8-2.0_r8*mu
                cff2=(cor*cff1+
     &                SQRT(1.0_r8+cff1*cff1*(cor*cor-1.0_r8)))/
     &               MAX(2.0_r8-2.0_r8*mu,eps)
                EmodU(i,j,k)=cff2*cff2*Eobs
              enddo
            enddo
            do j=JV_RANGE
              do i=IV_RANGE
                Eobs=0.5_r8*(EobsUV(i,j-1,k)+EobsUV(i,j,k))
                ratio=(EobsUVmax-Eobs)/delta
                mu=MIN(1.0_r8,ratio)*Emod0
                cff1=1.0_r8-2.0_r8*mu
                cff2=(cor*cff1+
     &                SQRT(1.0_r8+cff1*cff1*(cor*cor-1.0_r8)))/
     &               MAX(2.0_r8-2.0_r8*mu,eps)
                EmodU(i,j,k)=cff2*cff2*Eobs
              enddo
            enddo
          enddo
          if (SOUTH_WEST_CORNER)
     &      tVobs(2)=tVobs(1)
          if (NORTH_EAST_CORNER)
     &      first_UV=.false.
        endif
!
!  Determine assimilation weights and meld model and observations.
!
        if ((time.le.tsVobs).and.(tsVobs.lt.(time+dt))) then
          do j=JU_RANGE
            do i=IU_RANGE
              Uwrk(i,j,1)=0.0_r8
              Uwrk(i,j,2)=0.5_r8*(Hz(i-1,j,N)+Hz(i,j,N))
            enddo
          enddo
          do j=JV_RANGE
            do i=IV_RANGE
              Vwrk(i,j,1)=0.0_r8
              Vwrk(i,j,2)=0.5_r8*(Hz(i,j-1,N)+Hz(i,j,N))
            enddo
          enddo
#  ifdef UV_BAROCLINIC
          do k=1,N
            do j=JU_RANGE
              do i=IU_RANGE
                cff=0.5_r8*(Hz(i-1,j,k)+Hz(i,j,k))
                Uwrk(i,j,1)=Uwrk(i,j,1)+cff*Uobs(i,j,k)
              enddo
            enddo
            do j=JV_RANGE
              do i=IV_RANGE
                cff=0.5_r8*(Hz(i,j-1,k)+Hz(i,j,k))
                Vwrk(i,j,1)=Vwrk(i,j,1)+cff*Vobs(i,j,k)
              enddo
            enddo
          enddo
          do j=JU_RANGE
            do i=IU_RANGE
              Uwrk(i,j,1)=Uwrk(i,j,1)/Uwrk(i,j,2)
            enddo
          enddo
          do j=JV_RANGE
            do i=IV_RANGE
              Vwrk(i,j,1)=Vwrk(i,j,1)/Vwrk(i,j,2)
            enddo
          enddo
#  endif
!
          arg=ABS(tVobs(1)-tVobs(2))/Tgrowth
          decay=2.0_r8*(1.0_r8-EXP(-arg*arg))
          do k=1,N
            do j=JU_RANGE
              do i=IU_RANGE
                EmodU(i,j,k)=EmodU(i,j,k)+decay
                Eobs=0.5_r8*(EobsUV(i-1,j,k)+EobsUV(i,j,k))
                cff1=cor*SQRT(Eobs*EmodU(i,j,k))
                cff2=Eobs+EmodU(i,j,k)-2.0_r8*cff1
                weight=(EmodU(i,j,k)-cff1)/MAX(cff2,eps)
                weight=MAX(0.0_r8,MIN(1.0_r8,weight))
#  ifdef UV_BAROCLINIC
                u(i,j,k,1)=(ubar(i,j,knew)+
     &                      weight*(Uobs(i,j,k)-Uwrk(i,j,1))+
     &                      (1.0_r8-weight)*(u(i,j,k,nnew)-
     &                                       ubar(i,j,knew)))
#   ifdef MASKING
     &                    *umask(i,j)
#   endif
                u(i,j,k,2)=u(i,j,k,1)
#  else
                u(i,j,k,1)=(weight*Uobs(i,j,k)+
     &                      (1.0_r8-weight)*u(i,j,k,nnew))
#   ifdef MASKING
     &                    *umask(i,j)
#   endif
                u(i,j,k,2)=u(i,j,k,1)
                cff=0.5_r8*(Hz(i-1,j,k)+Hz(i,j,k))
                Uwrk(i,j,1)=Uwrk(i,j,1)+cff*u(i,j,k,1)
                Uwrk(i,j,2)=Uwrk(i,j,2)+cff
#  endif
                EmodU(i,j,k)=(1.0_r8-cor)*Eobs*EmodU(i,j,k)/cff2
              enddo
            enddo
            do j=JV_RANGE
              do i=IV_RANGE
                EmodV(i,j,k)=EmodV(i,j,k)+decay
                Eobs=0.5_r8*(EobsUV(i,j-1,k)+EobsUV(i,j,k))
                cff1=cor*SQRT(Eobs*EmodV(i,j,k))
                cff2=Eobs+EmodV(i,j,k)-2.0_r8*cff1
                weight=(EmodV(i,j,k)-cff1)/MAX(cff2,eps)
                weight=MAX(0.0_r8,MIN(1.0_r8,weight))
#  ifdef UV_BAROCLINIC
                v(i,j,k,1)=(vbar(i,j,1)+
     &                      weight*(Vobs(i,j,k)-Vwrk(i,j,1))+
     &                      (1.0_r8-weight)*(v(i,j,k,nnew)-
     &                                       vbar(i,j,1)))
#   ifdef MASKING
     &                    *vmask(i,j)
#   endif
                v(i,j,k,2)=v(i,j,k,1)
#  else
                v(i,j,k,1)=(weight*Vobs(i,j,k)+
     &                      (1.0_r8-weight)*v(i,j,k,nnew))
#   ifdef MASKING
     &                    *vmask(i,j)
#   endif
                v(i,j,k,2)=v(i,j,k,1)
                cff=0.5_r8*(Hz(i,j-1,k)+Hz(i,j,k))
                Vwrk(i,j,1)=Vwrk(i,j,1)+cff*v(i,j,k,1)
                Vwrk(i,j,2)=Vwrk(i,j,2)+cff
#  endif
                EmodV(i,j,k)=(1.0_r8-cor)*Eobs*EmodV(i,j,k)/cff2
              enddo
            enddo
          enddo
          if (NORTH_EAST_CORNER) then
            tVobs(2)=tVobs(1)
            synchro_flag=.true.
            ntfirst=iic+1
            if (update_UVsur) then
              update_UVsur=.false.
              write(stdout,10) 'UVsur', tVobs(1)
            else
              update_UV=.false.
              write(stdout,10) 'UV', tVobs(1)
            endif
          endif
#  ifndef UV_BAROCLINIC
!
!  Set barotropic momentum to the vertically integrated values.
!
          do j=JU_RANGE
            do i=IU_RANGE
              ubar(i,j,1)=Uwrk(i,j,1)/Uwrk(i,j,2)
#   ifdef MASKING
     &                   *umask(i,j)
#   endif
              ubar(i,j,2)=ubar(i,j,1)
            enddo
          enddo
          do j=JV_RANGE
            do i=IV_RANGE
              vbar(i,j,1)=Vwrk(i,j,1)/Vwrk(i,j,2)
#   ifdef MASKING
     &                   *vmask(i,j)
#   endif
              vbar(i,j,2)=vbar(i,j,1)
            enddo
          enddo
#  endif /* !UV_BAROCLINIC */
        endif
      endif
# endif /* ASSIMILATION_UV || ASSIMILATION_UVsur */
  10  format(' OI_UPDATE   - Assimilating ',a,' data,',t64,
     &       't = ',f12.4)
  20  format(' OI_UPDATE   - Assimilating ',a,1x,i2.2,' data,',t64,
     &       't = ',f12.4)
#else
      subroutine oi_update
#endif
      return
      end
