/*
** Include file "ocean.h".
***************************************** Alexander F. Shchepetkin ***
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** 2D Primitive Variables.                                          **
**                                                                  **
** rubar      Right-hand-side of 2D U-momentum equation (m4/s2).    **
** rvbar      Right-hand-side of 2D V-momentum equation (m4/s2).    **
** rzeta      Right-hand-side of free surface equation (m3/s).      **
** ubar       Vertically integrated U-momentum component (m/s).     **
** vbar       Vertically integrated V-momentum component (m/s).     **
** zeta       Free surface (m).                                     **
**                                                                  **
**********************************************************************
*/

      common /ocean_rubar/ rubar
      REAL_TYPE rubar(GLOBAL_2D_ARRAY,2)

      common /ocean_rvbar/ rvbar
      REAL_TYPE rvbar(GLOBAL_2D_ARRAY,2)

      common /ocean_rzeta/ rzeta
      REAL_TYPE rzeta(GLOBAL_2D_ARRAY,2)

      common /ocean_ubar/ ubar
      REAL_TYPE ubar(GLOBAL_2D_ARRAY,3)

      common /ocean_vbar/ vbar
      REAL_TYPE vbar(GLOBAL_2D_ARRAY,3)

      common /ocean_zeta/ zeta
      REAL_TYPE zeta(GLOBAL_2D_ARRAY,3)

#ifdef SOLVE3D

/*
**********************************************************************
** 3D Primitive Variables.                                          **
**********************************************************************
**                                                                  **
** pden       Potential Density anomaly (kg/m3).                    **
** rho        Density anomaly (kg/m3).                              **
** rhobar     Mean density anomaly (kg/m3).                         **
** ru         Right-hand-side of 3D U-momentum equation (m4/s2).    **
** rv         Right hand side of 3D V-momentum equation (m4/s2).    **
** t          Tracer type variables (usually, potential temperature **
**              and salinity).                                      **
** u          3D U-momentum component (m/s).                        **
** v          3D V-momentum component (m/s).                        **
** W          S-coordinate (omega*Hz/mn) vertical velocity (m3/s).  **
**                                                                  **
**********************************************************************
*/

      common /ocean_pden/ pden
      REAL_TYPE pden(GLOBAL_2D_ARRAY,N)

      common /ocean_rho/ rho
      REAL_TYPE rho(GLOBAL_2D_ARRAY,N)

      common /ocean_ru/ ru
      REAL_TYPE ru(GLOBAL_2D_ARRAY,0:N,2)

      common /ocean_rv/ rv
      REAL_TYPE rv(GLOBAL_2D_ARRAY,0:N,2)

      common /ocean_t/ t
      REAL_TYPE t(GLOBAL_2D_ARRAY,N,3,NT)

      common /ocean_u/ u
      REAL_TYPE u(GLOBAL_2D_ARRAY,N,2)

      common /ocean_v/ v
      REAL_TYPE v(GLOBAL_2D_ARRAY,N,2)

      common /ocean_W/ W
      REAL_TYPE W(GLOBAL_2D_ARRAY,0:N)

#endif /* SOLVE3D */
