/*
** Include file "obs.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Emod0           Initial model error (percentage, 0-100%).        **
** KP              Parameter for maximum number of extension        **
**                   polynomial coefficients.                       **
** M2nudass        Inverse time scale (1/s) for nudging towards     **
**                   2D momentum observations.                      **
** M3nudass        Inverse time scale (1/s) for nudging towards     **
**                   3D momentum observations.                      **
** Nsev            Number of state error vectors to use.            **
** Prms            Nondimensional perturbation strenght of state    **
**                   variables.                                     **
** Tgrowth         Empirical model error growth scale (days).       **
** Tnudass         Inverse time scales (1/s) for nudging towards    **
**                   tracer observations.                           **
** Znudass         Inverse time scale  (1/s) for nudging towards    **
**                   sea surface height observations.               **
** err_fct         Model RMS error adjustment factor due to         **
**                   truncation.                                    **
** extend_SST      Logical switch to extend vertically sea surface  **
**                   temperature observations before assimilation.  **
** extend_UV       Logical switch to extend vertically surface      **
**                   velocity observations before assimilation.     **
** assi            Logical switches to assimilate state variables.  **
** assi_SSH        Logical switch to assimilate sea surface height. **
** assi_SST        Logical switch to assimilate sea surface         **
**                   temperature.                                   **
** assi_T          Logical switch to assimilate tracer observations **
** assi_UV         Logical switch to assimilate horizontal currents **
**                   observations.                                  **
** assi_UVsur      Logical switch to assimilate surface currents.   **
** cor             Correlation between model and observations.      **
** first_SSH       Logical switch activated at the beginning of     **
**                   sea surface height assimilation.               **
** first_T         Logical switch activated at the beginning of     **
**                   tracer assimilation.                           **
** first_UV        Logical switch activated at the beginning of     **
**                   horizontal currents assimilation.              **
** npSST           Order of the polynomial representing the basis   **
**                   functions used for extension of sea surface    **
**                   temperature.                                   **
** npUV            Order of the polynomial representing the basis   **
**                   functions used for extension of surface        **
**                   currents and its associated error variance.    **
** pcoef_SST       Polynomial coefficients for vertical extension   **
**                   of sea surface temperature.                    **
** pcoef_U         Polynomial coefficients for vertical extension   **
**                   of surface U-momentum component.               **
** pcoef_V         Polynomial coefficients for vertical extension   **
**                   of surface V-momentum component.               **
** perr_SST        Polynomial coefficients for vertical extension   **
**                   of sea surface temperature error variance.     **
** perr_V          Polynomial coefficients for vertical extension   **
**                   of surface currents error variance.            **
** pert            Logical switches to perturb state variables.     **
** update_SSH      Logical switch to activate SSH assimilation at   **
**                   current timestep.                              **
** update_SST      Logical switch to activate SST assimilation at   **
**                   current timestep.                              **
** update_T        Logical switch to activate tracers assimilation  **
**                   at current timestep.                           **
** update_UV       Logical switch to activate horizontal currents   **
**                   assimilation at current timestep.              **
** update_UVsur    Logical switch to activate horizontal currents   **
**                   assimilation at current time-step.             **
** ZmSST           Maximum valid depth (meters) for sea surface     **
**                   temperature extension basis function.          **
** ZoSST           E-folding depth (m; positive) to extend          **
**                   vertically SST nondimensional error variance.  **
** ZmUV            Maximum valid depth (meters) for surface         **
**                   velocity extension basis functions.            **
** ZoUV            E-folding depth (m; positive) to extend          **
**                   vertically surface currents nondimensional     **
**                   error variance.                                **
**                                                                  **
**********************************************************************
*/

      INTEGER_TYPE
     &        KP
      parameter (KP=100)

      common /Lobs/
     &        assi,              assi_SSH,          assi_SST,
     &        assi_T,            assi_UV,           assi_UVsur,
     &        extend_SST,        extend_UV,         first_SSH,
     &        first_T,           first_UV,          pert,
     &        update_SSH,        update_SST,        update_T,
     &        update_UV,         update_UVsur
      logical
     &        assi(NSV),         assi_SSH,          assi_SST,
     &        assi_T(NT+1),      assi_UV,           assi_UVsur,
     &        extend_SST,        extend_UV,         first_SSH,
     &        first_T(NT+1),     first_UV,          pert(NSV),
     &        update_SSH,        update_SST,        update_T(NT+1),
     &        update_UV,         update_UVsur

      common /Iobs/
     &        Nsev,              npSST,             npUV
      INTEGER_TYPE
     &        Nsev,              npSST,             npUV

      common /Fobs/
     &        Emod0,             M2nudass,          M3nudass,
     &        Prms,              Tgrowth,           Tnudass,
     &        Znudass,           cor,               err_fct,
     &        pcoef_SST,         pcoef_U,           pcoef_V,
     &        perr_SST,          perr_V,            ZmSST,
     &        ZoSST,             ZmUV,              ZoUV
      REAL_TYPE
     &        Emod0,             M2nudass,          M3nudass,
     &        Prms(NSV),         Tgrowth,           Tnudass(NT+1),
     &        Znudass,           cor,               err_fct,
     &        pcoef_SST(0:KP),   pcoef_U(0:KP),     pcoef_V(0:KP),
     &        perr_SST(0:KP),    perr_V(0:KP),      ZmSST,
     &        ZoSST,             ZmUV,              ZoUV

#if defined ASSIMILATION_SSH || defined NUDGING_SSH

/*
**********************************************************************
** Assimilation of sea surface height data, SSH.                    **
**********************************************************************
**                                                                  **
** EdatSSH         Latest two-time snapshots of SSH observation     **
**                   error variance data used for interpolation.    **
** EmodSSH         SSH model error variance.                        **
** EobsSSH         SSH observation error variance (nondimensional). **
** EobsSSHmax      SSH maximun observation error variance.          **
** EobsSSHmin      SSH minimum error variance.                      **
** SSHdat          Latest two-time snapshots of SSH observation     **
**                   data used for interpolation.                   **
** SSHobs          Current SSH observations (m).                    **
** tSSHobs         Time (days) of current SSH data snapshots.       **
** timeSSHobs      Starting time (days) for SSH assimilation.       **
** tsSSHobs        Latest SSH time (sec, monotonic) of read data.   **
**                                                                  **
**********************************************************************
*/

      common /Fobs_SSHobs/
     &        EobsSSHmax,        EobsSSHmin,        tSSHobs,
     &        timeSSHobs,        tsSSHobs
      REAL_TYPE
     &        EobsSSHmax,        EobsSSHmin,        tSSHobs(2),
     &        timeSSHobs,        tsSSHobs

# ifdef ASSIMILATION_SSH
      common /obs_EmodSSH/ EmodSSH
      REAL_TYPE EmodSSH(GLOBAL_2D_ARRAY)
# endif /* ASSIMILATION_SSH */

      common /obs_EobsSSH/ EobsSSH
      REAL_TYPE EobsSSH(GLOBAL_2D_ARRAY)

      common /obs_SSHobs/ SSHobs
      REAL_TYPE SSHobs(GLOBAL_2D_ARRAY)

# ifdef NUDGING_SSH
      common /obs_EdatSSH/ EdatSSH
      REAL_TYPE EdatSSH(GLOBAL_2D_ARRAY,2)

      common /obs_SSHdat/ SSHdat
      REAL_TYPE SSHdat(GLOBAL_2D_ARRAY,2)
# endif /* NUDGING_SSH */

#endif /* ASSIMILATION_SSH || NUDGING_SSH */

#if defined ASSIMILATION_SST || defined NUDGING_SST

/*
**********************************************************************
** Assimilation of sea surface temperature, SST.                    **
**********************************************************************
**                                                                  **
** EdatSST         Latest two-time snapshots of SST observation     **
**                   error variance data used for interpolation.    **
** EmodSST         SST model error variance.                        **
** EobsSST         SST observation error variance (nondimensional). **
** EobsSSTmax      SST maximun observation error variance.          **
** EobsSSTmin      SST minimum error variance.                      **
** SSTdat          Latest two-time snapshots of SST observation     **
**                   data used for interpolation.                   **
** SSTobs          Current SST observations (Celsius).              **
**                                                                  **
**********************************************************************
*/

      common /Fobs_SSTobs/
     &        EobsSSTmax,        EobsSSTmin
      REAL_TYPE
     &        EobsSSTmax,        EobsSSTmin

# ifdef ASSIMILATION_SST
      common /obs_EmodSST/ EmodSST
      REAL_TYPE EmodSST(GLOBAL_2D_ARRAY)
# endif /* ASSIMILATION_SST */

      common /obs_EobsSST/ EobsSST
      REAL_TYPE EobsSST(GLOBAL_2D_ARRAY)

      common /obs_SSTobs/ SSTobs
      REAL_TYPE SSTobs(GLOBAL_2D_ARRAY)

# ifdef NUDGING_SST
      common /obs_EdatSST/ EdatSST
      REAL_TYPE EdatSST(GLOBAL_2D_ARRAY,2)

      common /obs_SSTdat/ SSTdat
      REAL_TYPE SSTdat(GLOBAL_2D_ARRAY,2)
# endif /* NUDGING_SST */

#endif /* ASSIMILATION_SST || NUDGING_SST */

#if defined ASSIMILATION_T   || defined NUDGING_T   || \
    defined ASSIMILATION_SST || defined NUDGING_SST

/*
**********************************************************************
** Assimilation of tracers data.                                    **
**********************************************************************
**                                                                  **
** EdatT           Latest two-time snapshots of tracers observation **
**                   error variance data used for interpolation.    **
** EmodT           Tracers model error variance.                    **
** EobsT           Tracers observation error variance               **
**                   (nondimensional).                              **
** EobsTmax        Tracers maximun observation error variance.      **
** EobsTmin        Tracers minimum error variance.                  **
** Tdat            Latest two-time snapshots of tracers observation **
**                   data used for interpolation.                   **
** Tobs            Current Tracers observations (m).                **
** tTobs           Time (days) of current tracers data snapshots.   **
** timeTobs        Starting time (days) for tracers assimilation.   **
** tsTobs          Latest tracers time (sec) of read data.          **
**                                                                  **
**********************************************************************
*/

      common /Fobs_Tobs/
     &        EobsTmax,          EobsTmin,          tTobs,
     &        timeTobs,          tsTobs
      REAL_TYPE
     &        EobsTmax(NT),      EobsTmin(NT),      tTobs(NT,2),
     &        timeTobs(NT),      tsTobs(NT)

# if defined ASSIMILATION_T || defined ASSIMILATION_SST
      common /obs_EmodT/ EmodT
      REAL_TYPE EmodT(GLOBAL_2D_ARRAY,N,NT)
# endif /* ASSIMILATION_T || ASSIMILATION_SST */

      common /obs_EobsT/ EobsT
      REAL_TYPE EobsT(GLOBAL_2D_ARRAY,N,NT)

      common /obs_Tobs/ Tobs
      REAL_TYPE Tobs(GLOBAL_2D_ARRAY,N,NT)

# ifdef NUDGING_T
      common /obs_EdatT/ EdatT
      REAL_TYPE EdatT(GLOBAL_2D_ARRAY,N,2,NT)

      common /obs_Tdat/ Tdat
      REAL_TYPE Tdat(GLOBAL_2D_ARRAY,N,2,NT)
# endif /* NUDGING_T */

#endif /* ASSIMILATION_T || NUDGING_SST */

#if defined ASSIMILATION_UVsur || defined NUDGING_UVsur  || \
    defined ASSIMILATION_UV    || defined NUDGING_UV

/*
**********************************************************************
** Horizontal currents observations for assimilation.               **
**********************************************************************
**                                                                  **
** EdatUV          Latest two-time snapshots of horizontal currents **
**                   observations error variance data.              **
** EdatVsur        Latest two-time snapshots of surface currents    **
**                   observations error variance data.              **
** EmodU           U-velocity model error variance.                 **
** EmodV           V-velocity model error variance.                 **
** EobsUV          Horizontal currents observations error variance  **
**                   at RHO-points (nondimsnsional).                **
** EobsUVmax       Horizontal currents maximun error variance.      **
** EobsUVmin       Horizontal currents minimum error variance.      **
** EobsVsur        Surface currents observations error variance     **
**                   error variance.                                **
** Udat            Latest two-time snapshots of U-velocity data.    **
** Uobs            Current U-velocity observations.                 **
** Usur            Current surface U-velocity observations.         **
** Usurdat         Latest two-time snapshots of surface U-velocity  **
**                   data.                                          **
** Vdat            Latest two-time snapshots of V-velocity data.    **
** Vobs            Current V-velocity observations.                 **
** Vsur            Current surface V-velocity observations.         **
** Vsurdat         Latest two-time snapshots of surface U-velocity  **
**                   data.                                          **
** tVobs           Time (days) of horizontal currents data          **
**                   snapshots                                      **
** timeVobs        Starting time (days) for horizontal currents     **
**                   assimilation.                                  **
** tsVobs          Latest horizontal currents time (sec) of read    **
**                   data.                                          **
**                                                                  **
**********************************************************************
*/

      common /Fobs_Vobs/
     &        EobsUVmax,         EobsUVmin,         tVobs,
     &        timeVobs,          tsVobs
      REAL_TYPE
     &        EobsUVmax,         EobsUVmin,         tVobs(2),
     &        timeVobs,          tsVobs

# if defined ASSIMILATION_UV || defined ASSIMILATION_UVsur
      common /obs_EmodU/ EmodU
      REAL_TYPE EmodU(GLOBAL_2D_ARRAY,N)

      common /obs_EmodV/ EmodV
      REAL_TYPE EmodV(GLOBAL_2D_ARRAY,N)
# endif /* ASSIMILATION_UV || ASSIMILATION_UVsur */

      common /obs_EobsUV/ EobsUV
      REAL_TYPE EobsUV(GLOBAL_2D_ARRAY,N)

      common /obs_Uobs/ Uobs
      REAL_TYPE Uobs(GLOBAL_2D_ARRAY,N)

      common /obs_Vobs/ Vobs
      REAL_TYPE Vobs(GLOBAL_2D_ARRAY,N)

# ifdef NUDGING_UV
      common /obs_Udat/ Udat
      REAL_TYPE Udat(GLOBAL_2D_ARRAY,N,2)

      common /obs_Vdat/ Vdat
      REAL_TYPE Vdat(GLOBAL_2D_ARRAY,N,2)

      common /obs_EdatUV/ EdatUV
      REAL_TYPE EdatUV(GLOBAL_2D_ARRAY,N,2)
# endif /* NUDGING_UV */

# if defined ASSIMILATION_UVsur || defined NUDGING_UVsur
      common /obs_Usur/ Usur
      REAL_TYPE Usur(GLOBAL_2D_ARRAY)

      common /obs_Vsur/ Vsur
      REAL_TYPE Vsur(GLOBAL_2D_ARRAY)

      common /obs_EobsVsur/ EobsVsur
      REAL_TYPE EobsVsur(GLOBAL_2D_ARRAY)
# endif /* ASSIMILATION_UVsur || NUDGING_UVsur */

# ifdef NUDGING_UVsur
      common /obs_Usurdat/ Usurdat
      REAL_TYPE Usurdat(GLOBAL_2D_ARRAY,2)

      common /obs_Vsurdat/ Vsurdat
      REAL_TYPE Vsurdat(GLOBAL_2D_ARRAY,2)

      common /obs_EdatVsur/ EdatVsur
      REAL_TYPE EdatVsur(GLOBAL_2D_ARRAY,2)
# endif /* NUDGING_UVsur */

#endif
