#include "cppdefs.h"
#ifdef OBC_VOLCONS
      subroutine obc_flux (tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine computes integral mass flux "obc_flux" accross       !
!  the open boundaries, which is needed to enforce global mass       !
!  conservation constraint.                                          !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
# include "param.h"
# include "tile.h"
!
      call obc_flux_tile (Istr,Iend,Jstr,Jend)
      return
      end
!
!*********************************************************************
      subroutine obc_flux_tile (Istr,Iend,Jstr,Jend)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mask.h"
# include "ocean.h"
# include "scalars.h"
# include "wclock.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
      REAL_TYPE
     &        NSUB, cff, my_area, my_flux
!
# include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Compute open segments cross-section area and mass flux.
!---------------------------------------------------------------------
!
      my_area=0.0_r8
      my_flux=0.0_r8
!
# ifdef WEST_VOLCONS
      if (WESTERN_EDGE) then
        do j=Jstr,Jend
          cff=0.5_r8*(zeta(Istr-1,j,knew)+h(Istr-1,j)+
     &                zeta(Istr  ,j,knew)+h(Istr  ,j))*on_u(Istr,j)
#  ifdef MASKING
     &       *umask(Istr,j)
#  endif
          my_area=my_area+cff
          my_flux=my_flux+cff*ubar(Istr,j,knew)
        enddo
      endif
# endif
# ifdef EAST_VOLCONS
      if (EASTERN_EDGE) then
        do j=Jstr,Jend
          cff=0.5_r8*(zeta(Iend  ,j,knew)+h(Iend  ,j)+
     &                zeta(Iend+1,j,knew)+h(Iend+1,j))*on_u(Iend+1,j)
#  ifdef MASKING
     &       *umask(Iend+1,j)
#  endif
          my_area=my_area+cff
          my_flux=my_flux-cff*ubar(Iend+1,j,knew)
        enddo
      endif
# endif
# ifdef SOUTH_VOLCONS
      if (SOUTHERN_EDGE) then
        do i=Istr,Iend
          cff=0.5_r8*(zeta(i,Jstr-1,knew)+h(i,Jstr-1)+
     &                zeta(i,Jstr  ,knew)+h(i,Jstr  ))*om_v(i,Jstr)
#  ifdef MASKING
     &       *vmask(i,Jstr)
#  endif
          my_area=my_area+cff
          my_flux=my_flux+cff*vbar(i,JstrV-1,knew)
        enddo
      endif
# endif
# ifdef NORTH_VOLCONS
      if (NORTHERN_EDGE) then
        do i=Istr,Iend
          cff=0.5_r8*(zeta(i,Jend  ,knew)+h(i,Jend  )+
     &                zeta(i,Jend+1,knew)+h(i,Jend+1))*om_v(i,Jend+1)
#  ifdef MASKING
     &       *vmask(i,Jend+1)
#  endif
          my_area=my_area+cff
          my_flux=my_flux-cff*vbar(i,Jend+1,knew)
        enddo
      endif
# endif
# if defined WEST_VOLCONS  || defined EAST_VOLCONS  || \
     defined SOUTH_VOLCONS || defined NORTH_VOLCONS
!
!---------------------------------------------------------------------
!  Perform global summation and compute correction velocity.
!---------------------------------------------------------------------
!
!  It is assumed that initial value of "bc_count" is set to 0.5,
!  while initial values of "bc_area" and "bc_flux" are set to
!  zero.
!
      if (WESTERN_EDGE  .and. EASTERN_EDGE .and.
     &    SOUTHERN_EDGE .and. NORTHERN_EDGE) then
        NSUB=0.5_r8
      else
        NSUB=FLOAT(NSUB_X*NSUB_E)-0.5_r8
      endif
      call my_setlock (lock)
      if (bc_count.lt.0.5_r8) then
        bc_flux=0.0_r8
        bc_area=0.0_r8
      endif
      bc_count=bc_count+1.0_r8
      bc_area=bc_area+my_area
      bc_flux=bc_flux+my_flux
      if (bc_count.gt.NSUB) then
        bc_count=0.0_r8
        ubar_xs=bc_flux/bc_area
      endif
      call my_unsetlock (lock)
# endif
      return
      end
!
!*********************************************************************
      subroutine set_DUV_bc_tile (Istr,Iend,Jstr,Jend,Drhs,DUon,DVom)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "grid.h"
# include "mask.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
      REAL_TYPE
     &        DUon(PRIVATE_2D_SCRATCH_ARRAY),
     &        DVom(PRIVATE_2D_SCRATCH_ARRAY),
     &        Drhs(PRIVATE_2D_SCRATCH_ARRAY)
!
# include "set_bounds.h"
!
!---------------------------------------------------------------------
!  Set vertically integrated mass fluxes "DUon" and "DVom" along
!  the open boundaries in such a way that the integral volume is
!  conserved.  This is done by applying "ubar_xs" correction to
!  the velocities.
!---------------------------------------------------------------------
!
# ifdef WEST_VOLCONS
      if (WESTERN_EDGE) then
        do j=Jstr-1,JendR
          DUon(Istr,j)=0.5_r8*(Drhs(Istr,j)+Drhs(Istr-1,j))*
     &                 (ubar(Istr,j,krhs)-ubar_xs)*on_u(Istr,j)
#  ifdef MASKING
     &                *umask(Istr,j)
#  endif
        enddo
      endif
# endif
# ifdef EAST_VOLCONS
      if (EASTERN_EDGE) then
        do j=Jstr-1,JendR
          DUon(Iend+1,j)=0.5_r8*(Drhs(Iend+1,j)+Drhs(Iend,j))*
     &                   (ubar(Iend+1,j,krhs)+ubar_xs)*on_u(Iend+1,j)
#  ifdef MASKING
     &                  *umask(Iend+1,j)
#  endif
        enddo
      endif
# endif
# ifdef SOUTH_VOLCONS
      if (SOUTHERN_EDGE) then
        do i=Istr-1,IendR
          DVom(i,Jstr)=0.5_r8*(Drhs(i,Jstr)+Drhs(i,Jstr-1))*
     &                 (vbar(i,Jstr,krhs)-ubar_xs)*om_v(i,Jstr)
#  ifdef MASKING
     &                *vmask(i,Jstr)
#  endif
        enddo
      endif
# endif
# ifdef NORTH_VOLCONS
      if (NORTHERN_EDGE) then
        do i=Istr-1,IendR
          DVom(i,Jend+1)=0.5_r8*(Drhs(i,Jend+1)+Drhs(i,Jend))*
     &                   (vbar(i,Jend+1,krhs)+ubar_xs)*om_v(i,Jend+1)
#  ifdef MASKING
     &                  *vmask(i,Jend+1)
#  endif
        enddo
      endif
# endif
      return
      end
!
!*********************************************************************
      subroutine conserve_mass_tile (Istr,Iend,Jstr,Jend)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "ocean.h"
# include "mask.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j
!
!---------------------------------------------------------------------
!  Corrects velocities across the open boundaries to enforce global
!  mass conservation constraint.
!---------------------------------------------------------------------
!
# ifdef WEST_VOLCONS
      if (WESTERN_EDGE) then
        do j=Jstr,Jend
          ubar(Istr,j,knew)=(ubar(Istr,j,knew)-ubar_xs)
#  ifdef MASKING
     &                     *umask(Istr,j)
#  endif
        enddo
      endif
# endif
# ifdef EAST_VOLCONS
      if (EASTERN_EDGE) then
        do j=Jstr,Jend
          ubar(Iend+1,j,knew)=(ubar(Iend+1,j,knew)+ubar_xs)
#  ifdef MASKING
     &                       *umask(Iend+1,j)
#  endif
        enddo
      endif
# endif
# ifdef SOUTH_VOLCONS
      if (SOUTHERN_EDGE) then
        do i=Istr,Iend
          vbar(i,Jstr,knew)=(vbar(i,Jstr,knew)-ubar_xs)
#  ifdef MASKING
     &                     *vmask(i,Jstr)
#  endif
        enddo
      endif
# endif
# ifdef NORTH_VOLCONS
      if (NORTHERN_EDGE) then
        do i=Istr,Iend
          vbar(i,Jend+1,knew)=(vbar(i,Jend+1,knew)+ubar_xs)
#  ifdef MASKING
     &                       *vmask(i,Jend+1)
#  endif
        enddo
      endif
# endif
#else
      subroutine obc_volcons
#endif
      return
      end
