#include "cppdefs.h"
      function nf_fwrite (A,Ascl,ncid,ncvarid,tindex,gtype)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This function writes out a generic floating point array into an   !
!  output NetCDF file.                                               !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     A          Field to write out (real).                          !
!     Ascl       Factor to scale field before writing (real).        !
!     ncid       NetCDF file ID (integer).                           !
!     ncvarid    NetCDF variable ID (integer).                       !
!     tindex     NetCDF time record index to write (integer).        !
!     gtype      Grid type. If negative, only write water points.    !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     nf_fwrite  Error flag (integer).                               !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "mask.h"
#include "ncparam.h"
#include "netcdf.inc"
!
      INTEGER_TYPE
     &        gtype, i, ii, j, jj, k, kk, ncid, ncvarid, tindex,
     &        status
      INTEGER_TYPE
     &        count(4), start(4)
      INTEGER_TYPE
     &        nf_fwrite
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,*)
      REAL_TYPE
     &        Ascl, wrk(Lp*Mp*Np)
!
      ii=0
!
!---------------------------------------------------------------------
!  Write out a 2D variable at RHO-points.
!---------------------------------------------------------------------
!
      if (gtype.eq.r2dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=Mp
        start(3)=tindex
        count(3)=1
        do j=0,M
          jj=1+j*Lp
          do i=0,L
            wrk(i+jj)=A(i,j,1)*Ascl
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)!
#ifdef MASKING

!---------------------------------------------------------------------
!  Write out a 2D variable at water RHO-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-r2dvar) then
        ii=0
        do j=0,M
          do i=0,L
            if (rmask(i,j).gt.0.0_r8) then
              ii=ii+1
              wrk(ii)=A(i,j,1)*Ascl
            endif
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 2D variable at PSI-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.p2dvar) then
        start(1)=1
        count(1)=L
        start(2)=1
        count(2)=M
        start(3)=tindex
        count(3)=1
        do j=1,M
          jj=(j-1)*L
          do i=1,L
            wrk(i+jj)=A(i,j,1)*Ascl
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 2D variable at water PSI-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-p2dvar) then
        ii=0
        do j=1,M
          do i=1,L
            if (pmask(i,j).gt.0.0_r8) then
              ii=ii+1
              wrk(ii)=A(i,j,1)*Ascl
            endif
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 2D variable at U-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.u2dvar) then
        start(1)=1
        count(1)=L
        start(2)=1
        count(2)=Mp
        start(3)=tindex
        count(3)=1
        do j=0,M
          jj=j*L
          do i=1,L
            wrk(i+jj)=A(i,j,1)*Ascl
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 2D variable at water U-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-u2dvar) then
        ii=0
        do j=0,M
          do i=1,L
            if (umask(i,j).gt.0.0_r8) then
              ii=ii+1
              wrk(ii)=A(i,j,1)*Ascl
            endif
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 2D variable at V-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.v2dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=M
        start(3)=tindex
        count(3)=1
        do j=1,M
          jj=1+(j-1)*Lp
          do i=0,L
            wrk(i+jj)=A(i,j,1)*Ascl
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 2D variable at water V-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-v2dvar) then
        ii=0
        do j=1,M
          do i=0,L
            if (vmask(i,j).gt.0.0_r8) then
              ii=ii+1
              wrk(ii)=A(i,j,1)*Ascl
            endif
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 3D variable at RHO-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.r3dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=N
        start(4)=tindex
        count(4)=1
        do k=1,N
          kk=(k-1)*Lp*Mp
          do j=0,M
            jj=1+j*Lp+kk
            do i=0,L
              wrk(i+jj)=A(i,j,k)*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D variable at water RHO-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-r3dvar) then
        ii=0
        do k=1,N
          do j=0,M
            do i=0,L
              if (rmask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,k)*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 3D variable at PSI-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.p3dvar) then
        start(1)=1
        count(1)=L
        start(2)=1
        count(2)=M
        start(3)=1
        count(3)=N
        start(4)=tindex
        count(4)=1
        do k=1,N
          kk=(k-1)*L*M
          do j=1,M
            jj=(j-1)*L+kk
            do i=1,L
              wrk(i+jj)=A(i,j,k)*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D variable at water PSI-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-p3dvar) then
        ii=0
        do k=1,N
          do j=1,M
            do i=1,L
              if (pmask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,k)*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 3D variable at U-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.u3dvar) then
        start(1)=1
        count(1)=L
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=N
        start(4)=tindex
        count(4)=1
        do k=1,N
          kk=(k-1)*L*Mp
          do j=0,M
            jj=j*L+kk
            do i=1,L
              wrk(i+jj)=A(i,j,k)*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D variable at water U-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-u3dvar) then
        ii=0
        do k=1,N
          do j=0,M
            do i=1,L
              if (umask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,k)*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 3D variable at V-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.v3dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=M
        start(3)=1
        count(3)=N
        start(4)=tindex
        count(4)=1
        do k=1,N
          kk=(k-1)*Lp*M
          do j=1,M
            jj=1+(j-1)*Lp+kk
            do i=0,L
              wrk(i+jj)=A(i,j,k)*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D variable at water V-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-v3dvar) then
        ii=0
        do k=1,N
          do j=1,M
            do i=0,L
              if (vmask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,k)*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 3D variable at W-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.w3dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=Np
        start(4)=tindex
        count(4)=1
        do k=1,Np
          kk=(k-1)*Lp*Mp
          do j=0,M
            jj=1+j*Lp+kk
            do i=0,L
              wrk(i+jj)=A(i,j,k)*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D variable at water W-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-w3dvar) then
        ii=0
        do k=1,Np
          do j=0,M
            do i=0,L
              if (rmask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,k)*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 3D history variable at RHO-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.r3hvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=Nlev
        start(4)=tindex
        count(4)=1
        do k=1,Nlev
          kk=(k-1)*Lp*Mp
          do j=0,M
            jj=1+j*Lp+kk
            do i=0,L
              wrk(i+jj)=A(i,j,Lev(k))*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D history variable at water RHO-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-r3hvar) then
        ii=0
        do k=1,Nlev
          do j=0,M
            do i=0,L
              if (rmask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,Lev(k))*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 3D history variable at PSI-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.p3hvar) then
        start(1)=1
        count(1)=L
        start(2)=1
        count(2)=M
        start(3)=1
        count(3)=Nlev
        start(4)=tindex
        count(4)=1
        do k=1,Nlev
          kk=(k-1)*L*M
          do j=1,M
            jj=(j-1)*L+kk
            do i=1,L
              wrk(i+jj)=A(i,j,Lev(k))*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D history variable at water PSI-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-p3hvar) then
        ii=0
        do k=1,Nlev
          do j=1,M
            do i=1,L
              if (pmask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,Lev(k))*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 3D history variable at U-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.u3hvar) then
        start(1)=1
        count(1)=L
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=Nlev
        start(4)=tindex
        count(4)=1
        do k=1,Nlev
          kk=(k-1)*L*Mp
          do j=0,M
            jj=j*L+kk
            do i=1,L
              wrk(i+jj)=A(i,j,Lev(k))*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D history variable at water U-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-u3hvar) then
        ii=0
        do k=1,Nlev
          do j=0,M
            do i=1,L
              if (umask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,Lev(k))*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 3D history variable at V-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.v3hvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=M
        start(3)=1
        count(3)=Nlev
        start(4)=tindex
        count(4)=1
        do k=1,Nlev
          kk=(k-1)*Lp*M
          do j=1,M
            jj=1+(j-1)*Lp+kk
            do i=0,L
              wrk(i+jj)=A(i,j,Lev(k))*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D history variable a water V-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-v3hvar) then
        ii=0
        do k=1,Nlev
          do j=1,M
            do i=0,L
              if (vmask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,Lev(k))*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
!
!---------------------------------------------------------------------
!  Write out a 3D history variable at W-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.w3hvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=Nlev
        start(4)=tindex
        count(4)=1
        do k=1,Nlev
          kk=(k-1)*Lp*Mp
          do j=0,M
            jj=1+j*Lp+kk
            do i=0,L
              wrk(i+jj)=A(i,j,Lev(k))*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D history variable at water W-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-w3hvar) then
        ii=0
        do k=1,Nlev
          do j=0,M
            do i=0,L
              if (rmask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,Lev(k))*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
#endif
#ifdef SEDIMENT
!
!---------------------------------------------------------------------
!  Write out a 3D bed sediment variable at RHO-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.b3dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=Nbed
        start(4)=tindex
        count(4)=1
        do k=1,Nbed
          kk=(k-1)*Lp*Mp
          do j=0,M
            jj=1+j*Lp+kk
            do i=0,L
              wrk(i+jj)=A(i,j,k)*Ascl
            enddo
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
# ifdef MASKING
!
!---------------------------------------------------------------------
!  Write out a 3D bed sediment variable at water RHO-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-b3dvar) then
        ii=0
        do k=1,Nbed
          do j=0,M
            do i=0,L
              if (rmask(i,j).gt.0.0_r8) then
                ii=ii+1
                wrk(ii)=A(i,j,k)*Ascl
              endif
            enddo
          enddo
        enddo
        start(1)=1
        count(1)=ii
        start(2)=tindex
        count(2)=1
        status=nf_put_vara_FTYPE(ncid,ncvarid,start,count,wrk)
# endif
#endif
      endif
      nf_fwrite=status
      return
      end
