#include "cppdefs.h"
      function nf_fread (A,Amin,Amax,Ascl,ncid,ncvarid,tindex,gtype)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This function reads in a generic floating point array from an     !
!  input NetCDF file.                                                !
!                                                                    !
!  On Input:                                                         !
!                                                                    !
!     Ascl       Factor to scale field after reading (real).         !
!     ncid       NetCDF file ID (integer).                           !
!     ncvarid    NetCDF variable ID (integer).                       !
!     tindex     NetCDF time record index to read (integer).         !
!     gtype      Grid type.                                          !
!                                                                    !
!  On Output:                                                        !
!                                                                    !
!     A          Field to read in (real).                            !
!     Amin       Field minimum value (real).                         !
!     Amin       Field maximum value (real).                         !
!     nf_fread   Error flag (integer).                               !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "mask.h"
#include "ncparam.h"
#include "netcdf.inc"
#include "scratch.h"
!
      INTEGER_TYPE
     &        gtype, i, ii, j, jj, k, kk, ncid, ncvarid, tindex,
     &        status
      INTEGER_TYPE
     &        count(4), start(4)
      INTEGER_TYPE
     &        nf_fread
      REAL_TYPE
     &        Amax, Amin, Ascl, Aval
      REAL_TYPE
     &        A(GLOBAL_2D_ARRAY,*)
      REAL_TYPE
     &        wrk(Lp*Mp*Np)
      equivalence (wrk,B3d)
!
      ii=0
      Amin=0.0_r8
      Amax=0.0_r8
!
!---------------------------------------------------------------------
!  Read in a 2D variable at RHO-points.
!---------------------------------------------------------------------
!
      if (gtype.eq.r2dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=Mp
        start(3)=tindex
        count(3)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          do j=0,M
            jj=1+j*Lp
            do i=0,L
              Aval=wrk(i+jj)*Ascl
              Amin=MIN(Amin,Aval)
              Amax=MAX(Amax,Aval)
              A(i,j,1)=Aval
            enddo
          enddo
        endif
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Read in a 2D variable at water RHO-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-r2dvar) then
        start(1)=1
        count(1)=Nxyr
        start(2)=tindex
        count(2)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          ii=0
          do j=0,M
            do i=0,L
              if (rmask(i,j).gt.0.0_r8) then
                ii=ii+1
                Aval=wrk(ii)*Ascl
                Amin=MIN(Amin,Aval)
                Amax=MAX(Amax,Aval)
                A(i,j,1)=Aval
              else
                A(i,j,1)=0.0_r8
              endif
            enddo
          enddo
        endif
#endif
!
!---------------------------------------------------------------------
!  Read in a 2D variable at PSI-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.p2dvar) then
        start(1)=1
        count(1)=L
        start(2)=1
        count(2)=M
        start(3)=tindex
        count(3)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          do j=1,M
            jj=(j-1)*L
            do i=1,L
              Aval=wrk(i+jj)*Ascl
              Amin=MIN(Amin,Aval)
              Amax=MAX(Amax,Aval)
              A(i,j,1)=Aval
            enddo
          enddo
        endif
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Read in a 2D variable at water PSI-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-p2dvar) then
        start(1)=1
        count(1)=Nxyp
        start(2)=tindex
        count(2)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          ii=0
          do j=1,M
            do i=1,L
              if (pmask(i,j).gt.0.0_r8) then
                ii=ii+1
                Aval=wrk(ii)*Ascl
                Amin=MIN(Amin,Aval)
                Amax=MAX(Amax,Aval)
                A(i,j,1)=Aval
              else
                A(i,j,1)=0.0_r8
              endif
            enddo
          enddo
        endif
#endif
!
!---------------------------------------------------------------------
!  Read in a 2D variable at U-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.u2dvar) then
        start(1)=1
        count(1)=L
        start(2)=1
        count(2)=Mp
        start(3)=tindex
        count(3)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          do j=0,M
            jj=j*L
            do i=1,L
              Aval=wrk(i+jj)*Ascl
              Amin=MIN(Amin,Aval)
              Amax=MAX(Amax,Aval)
              A(i,j,1)=Aval
            enddo
          enddo
        endif
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Read in a 2D variable at water U-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-u2dvar) then
        start(1)=1
        count(1)=Nxyu
        start(2)=tindex
        count(2)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          ii=0
          do j=0,M
            do i=1,L
              if (umask(i,j).gt.0.0_r8) then
                ii=ii+1
                Aval=wrk(ii)*Ascl
                Amin=MIN(Amin,Aval)
                Amax=MAX(Amax,Aval)
                A(i,j,1)=Aval
              else
                A(i,j,1)=0.0_r8
              endif
            enddo
          enddo
        endif
#endif
!
!---------------------------------------------------------------------
!  Read in a 2D variable at V-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.v2dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=M
        start(3)=tindex
        count(3)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          do j=1,M
            jj=1+(j-1)*Lp
            do i=0,L
              Aval=wrk(i+jj)*Ascl
              Amin=MIN(Amin,Aval)
              Amax=MAX(Amax,Aval)
              A(i,j,1)=Aval
            enddo
          enddo
        endif
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Read in a 2D variable at water V-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-v2dvar) then
        start(1)=1
        count(1)=Nxyv
        start(2)=tindex
        count(2)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          ii=0
          do j=1,M
            do i=0,L
              if (vmask(i,j).gt.0.0_r8) then
                ii=ii+1
                Aval=wrk(ii)*Ascl
                Amin=MIN(Amin,Aval)
                Amax=MAX(Amax,Aval)
                A(i,j,1)=Aval
              else
                A(i,j,1)=0.0_r8
              endif
            enddo
          enddo
        endif
#endif
!
!---------------------------------------------------------------------
!  Read in a 3D variable at RHO-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.r3dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=N
        start(4)=tindex
        count(4)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          do k=1,N
            kk=(k-1)*Lp*Mp
            do j=0,M
              jj=1+j*Lp+kk
              do i=0,L
                Aval=wrk(i+jj)*Ascl
                Amin=MIN(Amin,Aval)
                Amax=MAX(Amax,Aval)
                A(i,j,k)=Aval
              enddo
            enddo
          enddo
        endif
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Read in a 3D variable at water RHO-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-r3dvar) then
        start(1)=1
        count(1)=Nxyr*N
        start(2)=tindex
        count(2)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          ii=0
          do k=1,N
            do j=0,M
              do i=0,L
                if (rmask(i,j).gt.0.0_r8) then
                  ii=ii+1
                  Aval=wrk(ii)*Ascl
                  Amin=MIN(Amin,Aval)
                  Amax=MAX(Amax,Aval)
                  A(i,j,k)=Aval
                else
                  A(i,j,k)=0.0_r8
                endif
              enddo
            enddo
          enddo
        endif
#endif
!
!---------------------------------------------------------------------
!  Read in a 3D variable at PSI-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.p3dvar) then
        start(1)=1
        count(1)=L
        start(2)=1
        count(2)=M
        start(3)=1
        count(3)=N
        start(4)=tindex
        count(4)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          do k=1,N
            kk=(k-1)*L*M
            do j=1,M
              jj=(j-1)*L+kk
              do i=1,L
                Aval=wrk(i+jj)*Ascl
                Amin=MIN(Amin,Aval)
                Amax=MAX(Amax,Aval)
                A(i,j,k)=Aval
              enddo
            enddo
          enddo
        endif
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Read in a 3D variable at water PSI-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-p3dvar) then
        start(1)=1
        count(1)=Nxyp*N
        start(2)=tindex
        count(2)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          ii=0
          do k=1,N
            do j=1,M
              do i=1,L
                if (pmask(i,j).gt.0.0_r8) then
                  ii=ii+1
                  Aval=wrk(ii)*Ascl
                  Amin=MIN(Amin,Aval)
                  Amax=MAX(Amax,Aval)
                  A(i,j,k)=Aval
                else
                  A(i,j,k)=0.0_r8
                endif
              enddo
            enddo
          enddo
        endif
#endif
!
!---------------------------------------------------------------------
!  Read in a 3D variable at U-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.u3dvar) then
        start(1)=1
        count(1)=L
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=N
        start(4)=tindex
        count(4)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          do k=1,N
            kk=(k-1)*L*Mp
            do j=0,M
              jj=j*L+kk
              do i=1,L
                Aval=wrk(i+jj)*Ascl
                Amin=MIN(Amin,Aval)
                Amax=MAX(Amax,Aval)
                A(i,j,k)=Aval
              enddo
            enddo
          enddo
        endif
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Read in a 3D variable at water U-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-u3dvar) then
        start(1)=1
        count(1)=Nxyu*N
        start(2)=tindex
        count(2)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          ii=0
          do k=1,N
            do j=0,M
              do i=1,L
                if (umask(i,j).gt.0.0_r8) then
                  ii=ii+1
                  Aval=wrk(ii)*Ascl
                  Amin=MIN(Amin,Aval)
                  Amax=MAX(Amax,Aval)
                  A(i,j,k)=Aval
                else
                  A(i,j,k)=0.0_r8
                endif
              enddo
            enddo
          enddo
        endif
#endif
!
!---------------------------------------------------------------------
!  Read in a 3D variable at V-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.v3dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=M
        start(3)=1
        count(3)=N
        start(4)=tindex
        count(4)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          do k=1,N
            kk=(k-1)*Lp*M
            do j=1,M
              jj=1+(j-1)*Lp+kk
              do i=0,L
                Aval=wrk(i+jj)*Ascl
                Amin=MIN(Amin,Aval)
                Amax=MAX(Amax,Aval)
                A(i,j,k)=Aval
              enddo
            enddo
          enddo
        endif
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Read in a 3D variable at water V-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-v3dvar) then
        start(1)=1
        count(1)=Nxyv*N
        start(2)=tindex
        count(2)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          ii=0
          do k=1,N
            do j=1,M
              do i=0,L
                if (vmask(i,j).gt.0.0_r8) then
                  ii=ii+1
                  Aval=wrk(ii)*Ascl
                  Amin=MIN(Amin,Aval)
                  Amax=MAX(Amax,Aval)
                  A(i,j,k)=Aval
                else
                  A(i,j,k)=0.0_r8
                endif
              enddo
            enddo
          enddo
        endif
#endif
!
!---------------------------------------------------------------------
!  Read in a 3D variable at W-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.w3dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=Np
        start(4)=tindex
        count(4)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          do k=1,Np
            kk=(k-1)*Lp*Mp
            do j=0,M
              jj=1+j*Lp+kk
              do i=0,L
                Aval=wrk(i+jj)*Ascl
                Amin=MIN(Amin,Aval)
                Amax=MAX(Amax,Aval)
                A(i,j,k)=Aval
              enddo
            enddo
          enddo
        endif
#ifdef MASKING
!
!---------------------------------------------------------------------
!  Read in a 3D variable at water W-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-w3dvar) then
        start(1)=1
        count(1)=Nxyr*Np
        start(2)=tindex
        count(2)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          ii=0
          do k=1,Np
            do j=0,M
              do i=0,L
                if (rmask(i,j).gt.0.0_r8) then
                  ii=ii+1
                  Aval=wrk(ii)*Ascl
                  Amin=MIN(Amin,Aval)
                  Amax=MAX(Amax,Aval)
                  A(i,j,k)=Aval
                else
                  A(i,j,k)=Aval
                endif
              enddo
            enddo
          enddo
        endif
#endif
#ifdef SEDIMENT
!
!---------------------------------------------------------------------
!  Read in a 3D bed sediment variable at RHO-points.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.b3dvar) then
        start(1)=1
        count(1)=Lp
        start(2)=1
        count(2)=Mp
        start(3)=1
        count(3)=Nbed
        start(4)=tindex
        count(4)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          do k=1,Nbed
            kk=(k-1)*Lp*Mp
            do j=0,M
              jj=1+j*Lp+kk
              do i=0,L
                Aval=wrk(i+jj)*Ascl
                Amin=MIN(Amin,Aval)
                Amax=MAX(Amax,Aval)
                A(i,j,k)=Aval
              enddo
            enddo
          enddo
        endif
# ifdef MASKING
!
!---------------------------------------------------------------------
!  Read in a 3D bed sediment variable at water RHO-points only.
!---------------------------------------------------------------------
!
      elseif (gtype.eq.-b3dvar) then
        start(1)=1
        count(1)=Nxyr*Nbed
        start(2)=tindex
        count(2)=1
        status=nf_get_vara_FTYPE(ncid,ncvarid,start,count,wrk)
        if (status.eq.nf_noerr) then
          Amin=wrk(1)*Ascl
          Amax=wrk(1)*Ascl
          ii=0
          do k=1,Nbed
            do j=0,M
              do i=0,L
                if (rmask(i,j).gt.0.0_r8) then
                  ii=ii+1
                  Aval=wrk(ii)*Ascl
                  Amin=MIN(Amin,Aval)
                  Amax=MAX(Amax,Aval)
                  A(i,j,k)=Aval
                else
                  A(i,j,k)=0.0_r8
                endif
              enddo
            enddo
          enddo
        endif
# endif
#endif
      endif
      nf_fread=status
      return
      end
