/*
** Include file "ncparam.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** Variables identification index:                                  **
**                                                                  **
** idAbed     Index for wind-induced, bed wave excursion amplitude. **
** idAice     Index for fraction of cell covered by ice.            **
** idCfra     Index for cloud fraction.                             **
** idDano     Index for density anomaly.                            **
** iddQdT     Index for heat flux sensitivity to SST.               **
** idevap     Index for evaporation rate.                           **
** idFsur     Index for free-surface.                               **
** idHbbl     Index for depth of bottom boundary layer.             **
** idHice     Index for depth of ice cover.                         **
** idHrip     Index for bed ripple height.                          **
** idHsbl     Index for depth of surface boundary layer.            **
** idHsno     Index for depth of snow cover.                        **
** idLhea     index for net latent heat flux.                       **
** idLrad     Index for net longwave radiation flux.                **
** idLrip     Index for bed ripple length.                          **
** idMtke     Index for Mellor-Yamada turbulent kinetic energy.     **
** idMtls     Index for Mellor-Yamada turbulent kinetic energy      **
**              times turbulent length scale.                       **
** idOvel     Index for omega vertical velocity.                    **
** idQair     Index for surface air humidity.                       **
** idPair     Index for surface air pressure.                       **
** idPbar     Index for vertically integrated streamfunction.       **
** idRdir     Index for river runoff direction.                     **
** idRepo     Index for river runoff ETA-positions.                 **
** idRflg     Index for river runoff flag.                          **
** idRtra     Index for river runoff mass transport.                **
** idRtrc     Index for river runoff for tracer type variables.     **
** idRu2d     Index for RHS of vertically integrated U-momentum.    **
** idRv2d     Index for RHS of vertically integrated V-momentum.    **
** idRzet     Index for RHS of free-surface.                        **
** idRvsh     Index for river runoff mass transport vertical        **
**              profile.                                            **
** idRxpo     Index for river runoff XI-positions.                  **
** idRu2d     Index for RHS of free-surface equation.               **
** idrain     Index for rainfall rate.                              **
** idSden     Index for bottom sediment grain density.              **
** idSdif     Index for vertical Salinity-diffusion coefficient.    **
** idSrad     Index for net shortwave radiation flux.               **
** idSSHc     Index for sea surface height climatology.             **
** idSSHe     Index for sea surface height error variance.          **
** idSSHo     Index for sea surface height observations.            **
** idSSSc     Index for sea surface salinity climatology.           **
** idSSTc     Index for sea surface temperature climatology.        **
** idSSTe     Index for sea surface temperature error variance.     **
** idSSTo     Index for sea surface temperature observations.       **
** idShea     index for net sensible heat flux.                     **
** idSsiz     Index for bottom sediment grain size.                 **
** idTair     Index for surface air temperature.                    **
** idTbot     Index for bottom flux of tracer variables.            **
** idTbry     Index for tracer variables boundary conditions.       **
** idTclm     Index for climatology tracer type variables.          **
** idTdif     Index for vertical Temperature-diffusion coefficient. **
** idTerr     Index for tracer type error variance.                 **
** idTice     Index for temperature of ice surface.                 **
** idtime     Index for ocean time.                                 **
** idTobs     index for tracer type observations.                   **
** idTper     Index for tidal period.                               **
** idTsur     Index for surface flux of tracer variables.           **
** idTvan     Index for tidal current angle.                        **
** idTvar     Index for tracer type variables.                      **
** idTvma     Index for maximum tidal current, ellipse major axis.  **
** idTvmi     Index for minimum tidal current, ellipse minor axis.  **
** idTvph     Index for tidal current phase.                        **
** idTzam     Index for tidal elevation amplitude.                  **
** idTzph     Index for tidal elevation phase.                      **
** idUair     Index for surface U-wind.                             **
** idUbar     Index for vertically integrated U-velocity.           **
** idUbed     Index for wind-induced, bed wave orbital U-velocity.  **
** idUbms     Index for bottom U-momentum stress.                   **
** idUbot     Index for bottom U-momentum above bed.                **
** idUbws     Index for wind-induced, bottom U-wave stress.         **
** idUice     Index for ice U-velocity.                             **
** idUobs     Index for U-velocity observations.                    **
** idUsms     Index for surface U-momentum stress.                  **
** idUsur     Index for surface U-velocity observations.            **
** idUVer     Index for velocity error variance.                    **
** idUVse     Index for surface velocity error variance.            **
** idUvel     Index for U-velocity.                                 **
** idU2bc     Index for 2D u-momentum boundary coditions.           **
** idU3bc     Index for 3D u-momentum boundary coditions.           **
** idVair     Index for surface V-wind.                             **
** idVbar     Index for vertically integrated V-velocity.           **
** idVbed     Index for wind-induced, bed wave orbital V-velocity.  **
** idVbms     Index for bottom V-momentum stress.                   **
** idUbot     Index for bottom V-momentum above bed.                **
** idVbws     Index for wind-induced, bottom V-wave stress.         **
** idVice     Index for ice V-velocity.                             **
** idVobs     Index for V-velocity observations.                    **
** idVsms     Index for surface V-momentum stress.                  **
** idVsur     Index for surface V-velocity observations.            **
** idVvel     Index for V-velocity.                                 **
** idVvis     Index for vertical viscosity coeffcient.              **
** idV2bc     Index for 2D v-momentum boundary coditions.           **
** idV3bc     Index for 3D v-momentum boundary coditions.           **
** idWamp     Index for wind induced wave amplitude.                **
** idWdir     Index for wind induced wave direction.                **
** idWper     Index for wind induced wave period.                   **
** idWvel     Index for W-velocity.                                 **
** idZbry     Index for free-surface boundary conditions.           **
** idZapp     Index for apparent hydraulic bottom roughness.        **
** idZnot     Index for hydraulic bottom roughness.                 **
**                                                                  **
** idSvar     Indices for model assimilation state variables.       **
** isFsur     Index for state free-surface.                         **
** isTvar     Indices for state tracer type variables.              **
** isUbar     Index for state vertically integrated U-velocity.     **
** isUvel     Index for state U-velocity.                           **
** isVbar     Index for state vertically integrated V-velocity.     **
** isVvel     Index for state V-velocity.                           **
**                                                                  **
** Nxyp       Number of horizontal water PSI-points.                **
** Nxyr       Number of horizontal water RHO-points.                **
** Nxyu       Number of horizontal water U-points.                  **
** Nxyv       Number of horizontal water V-points.                  **
**                                                                  **
** Vname      Input/ouput variables names and attributes:           **
**              Vname(1,*)  => field variable name.                 **
**              Vname(2,*)  => long-name attribute.                 **
**              Vname(3,*)  => units attribute.                     **
**              Vname(4,*)  => field type attribute.                **
**              Vname(5,*)  => associated time variable name.       **
** Tname      Input/ouput associated time variables names.          **
**                                                                  **
** Linfo      Input/output fields logical information:              **
**              Linfo(1,*)  => switch indicating grided data.       **
**              Linfo(2,*)  => switch indicating time cycling.      **
**              Linfo(3,*)  => switch indicating only one-time      **
**                             record available.                    **
**                                                                  **
** Iinfo      Input/output fields integer information:              **
**              Iinfo(1,*)  => variable grid type.                  **
**              Iinfo(2,*)  => field variable NetCDF ID.            **
**              Iinfo(3,*)  => associated time variable NetCDF ID.  **
**              Iinfo(4,*)  => number of time records.              **
**              Iinfo(5,*)  => rolling two-time levels index.       **
**              Iinfo(6,*)  => latest processed time record .       **
**                                                                  **
** Finfo      Input/output field floating-point information:        **
**              Finfo(1,*)  => starting time (days) of data.        **
**              Finfo(2,*)  => Ending time (days) of data.          **
**              Finfo(3,*)  => length (days) of time cycling.       **
**              Finfo(4,*)  => minimum value for current data.      **
**              Finfo(5,*)  => maximum value for current data.      **
**              Finfo(6,*)  => Scale to convert time to day units.  **
** Fscale     Scale to convert input data to model units.           **
** Fpoint     Latest two-time records of input point data.          **
** Hout       Switches indicating which variables are written to    **
**              output HISTORY file (T/F).                          **
** Sout       Switches indicating which variables are written to    **
**              output STATION file (T/F).                          **
** Tintrp     Time (sec) of latest field snapshots used for         **
**              interpolation.                                      **
** Tmono      Latest monotonic time (sec) of processed fields.      **
** Vtime      Latest two-time values of processed input data.       **
**                                                                  **
** idefavg    Counter to activate creation of new average files.    **
** idefhis    Counter to activate creation of new history files.    **
**                                                                  **
** ncSSHid    NetCDF ID for SSH observations file.                  **
** ncSSTid    NetCDF ID for SST observations file.                  **
** ncTOBSid   NetCDF ID for tracers observations file.              **
** ncVOBSid   NetCDF ID for horizontal currents observations file.  **
** ncVSURid   NetCDF ID for surface currents observations.          **
** ncassid    NetCDF ID for assimilation file.                      **
** ncavgid    NetCDF ID for averages file.                          **
** ncbryid    NetCDF IF for boundary file.                          **
** ncclmid    NetCDF ID for climatology file.                       **
** ncesid     NetCDF ID for error subspace file.                    **
** ncfltid    NetCDF ID for floats file.                            **
** ncfrcid    NetCDF ID for forcing file.                           **
** ncfwdid    NetCDF ID for forward solution file.                  **
** ncgrdid    NetCDF ID for grid file.                              **
** nchisid    NetCDF ID for history file.                           **
** ncrstid    NetCDF ID for restart file.                           **
** ncstaid    NetCDF ID for station data file.                      **
**                                                                  **
** avgTid     Average file, NetCDF IDs for tracer variables.        **
** avgVid     Average file, NetCDF IDs for variables.               **
** fltTid     Floats file, NetCDF IDs for tracer variables.         **
** fltVid     Floats file, NetCDF IDs for variables.                **
** hisTid     History file, NetCDF IDs for tracer variables.        **
** hisVid     History file, NetCDF IDs for variables.               **
** rstTid     Restart file, NetCDF IDs for tracer variables.        **
** rstVid     Restart file, NetCDF IDs for variables.               **
** staTid     Station file, NetCDF IDs for tracer variables.        **
** staVid     Station file, NetCDF IDs for variables.               **
**                                                                  **
** tavgindx   Time record index in output average NetCDF file.      **
** tfltindx   Time record index in output floats NetCDF file.       **
** thisindx   Time record index in output history NetCDF file.      **
** trstindx   Time record index in output restart NetCDF file.      **
** tstaindx   Time record index in output station NetCDF file.      **
**                                                                  **
** MV         Maximum number of variables in a generic NetCDF file. **
** NV         Number of variables in information arrays.            **
** nvars      Number of variables defined in current input NetCDF   **
**              file.                                               **
** nvdims     Number of dimensions for each variables in current    **
**              input NetCDF file.                                  **
** tsize      Size of unlimited time record dimension in current    **
**              input NetCDF file.                                  **
** type       Global NetCDF attribute "type" in current input       **
**              NetCDF file.                                        **
** varnam     Names of all variables in current input NetCDF file.  **
** vflag      Flag indicating type of field available at input:     **
**              vflag(:)=1  => full field.                          **
**              vflag(:)=-1 => water points only.                   **
** vdims      Dimension IDs for each of the variables in current    **
**              input NetCDF file.                                  **
**                                                                  **
**********************************************************************
*/

      INTEGER_TYPE
     &        MV,                NV,
     &        p2dvar,            p3dvar,            p3hvar,
     &        r2dvar,            r3dvar,            r3hvar,
     &        u2dvar,            u3dvar,            u3hvar,
     &        v2dvar,            v3dvar,            v3hvar,
     &        w3dvar,            w3hvar,            b3dvar
      parameter
     &       (MV=250,            NV=250,
     &        p2dvar=1,          r2dvar=2,          u2dvar=3,
     &        v2dvar=4,          p3dvar=5,          r3dvar=6,
     &        u3dvar=7,          v3dvar=8,          w3dvar=9,
     &        p3hvar=10,         r3hvar=11,         u3hvar=12,
     &        v3hvar=13,         w3hvar=14,         b3dvar=15)

      common /water_points/
     &        Nxyp,              Nxyr,              Nxyu,
     &        Nxyv
      INTEGER_TYPE
     &        Nxyp,              Nxyr,              Nxyu,
     &        Nxyv

      common /indices1/
     &        idAbed,            idAice,            idCfra,
     &        idDano,            iddpth,            iddQdT,
     &        idevap,            idFsur,            idglat,
     &        idglon,            idHbbl,            idHice,
     &        idHrip,            idHsbl,            idHsno,
     &        idLhea,            idLrad,            idLrip,
     &        idMtke,            idMtls,            idOvel,
     &        idQair,            idPair,            idPbar,
     &        idRdir,            idRepo,            idRflg,
     &        idRtra,            idRtrc,            idRu2d,
     &        idRv2d,            idRxpo,            idRvsh,
     &        idRzet,            idrain,            idSden,
     &        idSdif,            idSrad,            idSSHc,
     &        idSSHe,            idSSSc,            idSSHo,
     &        idSSTc,            idSSTe,            idSSTo,
     &        idShea,            idSsiz,            idTair,
     &        idTbot,            idTbry,            idTclm,
     &        idTdif,            idTerr,            idTice,
     &        idtime,            idTobs
      INTEGER_TYPE
     &        idAbed,            idAice,            idCfra,
     &        idDano,            iddpth,            iddQdT,
     &        idevap,            idFsur,            idglat,
     &        idglon,            idHbbl,            idHice,
     &        idHrip,            idHsbl,            idHsno,
     &        idLhea,            idLrad,            idLrip,
     &        idMtke,            idMtls,            idOvel,
     &        idQair,            idPair,            idPbar,
     &        idRdir,            idRepo,            idRflg,
     &        idRtra,            idRtrc(NT+1),      idRu2d,
     &        idRv2d,            idRxpo,            idRvsh,
     &        idRzet,            idrain,            idSden,
     &        idSdif,            idSrad,            idSSHc,
     &        idSSHe,            idSSSc,            idSSHo,
     &        idSSTc,            idSSTe,            idSSTo,
     &        idShea,            idSsiz,            idTair,
     &        idTbot(NT+1),      idTbry(4,NT+1),    idTclm(NT+1),
     &        idTdif,            idTerr(NT+1),      idTice,
     &        idtime,            idTobs(NT+1)

      common /indices2/
     &        idTper,            idTsur,            idTvan,
     &        idTvar,            idTvma,            idTvmi,
     &        idTvph,            idTzam,            idTzph,
     &        idUair,            idUbar,            idUbcl,
     &        idUbed,            idUbms,            idUbot,
     &        idUbws,            idUclm,            idUice,
     &        idUobs,            idUsms,            idUsur,
     &        idUVer,            idUVse,            idUvel,
     &        idU2bc,            idU3bc,            idVair,
     &        idVbar,            idVbcl,            idVbed,
     &        idVbot,            idVbms,            idVbws,
     &        idVclm,            idVice,            idVobs,
     &        idVsms,            idVsur,            idVvel,
     &        idVvis,            idV2bc,            idV3bc,
     &        idWamp,            idWdir,            idWper,
     &        idWvel,            idXgrd,            idYgrd,
     &        idZapp,            idZbry,            idZgrd,
     &        idZnot
      INTEGER_TYPE
     &        idTper,            idTsur(NT+1),      idTvan,
     &        idTvar(NT+1),      idTvma,            idTvmi,
     &        idTvph,            idTzam,            idTzph,
     &        idUair,            idUbar,            idUbcl,
     &        idUbed,            idUbms,            idUbot,
     &        idUbws,            idUclm,            idUice,
     &        idUobs,            idUsms,            idUsur,
     &        idUVer,            idUVse,            idUvel,
     &        idU2bc(4),         idU3bc(4),         idVair,
     &        idVbar,            idVbcl,            idVbed,
     &        idVbot,            idVbms,            idVbws,
     &        idVclm,            idVice,            idVobs,
     &        idVsms,            idVsur,            idVvel,
     &        idVvis,            idV2bc(4),         idV3bc(4),
     &        idWamp,            idWdir,            idWper,
     &        idWvel,            idXgrd,            idYgrd,
     &        idZapp,            idZbry(4),         idZgrd,
     &        idZnot

      common /indices3/
     &        idSvar,            isFsur,            isTvar,
     &        isUbar,            isUvel,            isVbar,
     &        isVvel
      INTEGER_TYPE
     &        idSvar(NSV+1),     isFsur,            isTvar(NT+1),
     &        isUbar,            isUvel,            isVbar,
     &        isVvel

      common /nc_ids/
     &        ncSSHid,           ncSSTid,           ncTOBSid,
     &        ncVOBSid,          ncVSURid,          ncassid,
     &        ncbryid,           ncclmid,           ncesid,
     &        ncfrcid,           ncfwdid,           ncgrdid,
     &        ncavgid,           avgTid,            avgVid,
     &        ncfltid,           fltTid,            fltVid,
     &        nchisid,           hisTid,            hisVid,
     &        ncrstid,           rstTid,            rstVid,
     &        ncstaid,           staTid,            staVid
      INTEGER_TYPE
     &        ncSSHid,           ncSSTid,           ncTOBSid,
     &        ncVOBSid,          ncVSURid,          ncassid,
     &        ncbryid,           ncclmid,           ncesid,
     &        ncfrcid,           ncfwdid,           ncgrdid
      INTEGER_TYPE
     &        ncavgid,           avgTid(NT+1),      avgVid(NV),
     &        ncfltid,           fltTid(NT+1),      fltVid(-6:NV),
     &        nchisid,           hisTid(NT+1),      hisVid(NV),
     &        ncrstid,           rstTid(NT+1),      rstVid(NV),
     &        ncstaid,           staTid(NT+1),      staVid(NV)

      common /nc_Ldata/
     &        Hout,              Linfo,             Sout
      logical
     &        Hout(NV),          Linfo(3,NV),       Sout(NV)

      common /nc_Idata/
     &        Iinfo,             idefavg,           idefhis,
     &        tavgindx,          tfltindx,          thisindx,
     &        trstindx,          tstaindx
      INTEGER_TYPE
     &        Iinfo(6,NV),       idefavg,           idefhis,
     &        tavgindx,          tfltindx,          thisindx,
     &        trstindx,          tstaindx

      common /nc_Fdata/
     &        Finfo,             Fpoint,            Fscale,
     &        Tintrp,            Tmono,             Vtime
      REAL_TYPE
     &        Finfo(6,NV),       Fpoint(2,NV),      Fscale(NV),
     &        Tintrp(2,NV),      Tmono(NV),         Vtime(2,NV)

      common /generic/
     &        nvars,             nvdims,            tsize,
     &        vdims,             vflag
      INTEGER_TYPE
     &        nvars,             nvdims(MV),        tsize,
     &        vdims(5,MV),       vflag(MV)

      common /nc_text/
     &        date_str,          history,           type,
     &        version,           varnam,            Vname,
     &        Tname
      character*5   version
      character*15  varnam(MV)
      character*44  date_str
      character*80  type
      character*46  Vname(5,0:NV), Tname(0:NV)
      character*120 history
